/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.systemlink.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TextValue;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemLinkBuilder {
    public static Logger log = Logger.getLogger(SystemLinkBuilder.class);
    private static final String SYSTEM_LINK_LABEL = "pwe.documentation.systemlink.label";
    private static final String LOGIN_PAGE_IMAGE_LOCATION = "/images/documentation/login_page.png";
    private static final long LOGIN_PAGE_SPACING_BEFORE = 1000L;
    private static final long LOGIN_PAGE_SPACING_AFTER = 20L;
    private static final Integer LOGIN_PAGE_WIDTH = 630;
    private static final Integer LOGIN_PAGE_HEIGHT = 314;
    @Autowired
    private TranslatorService translatorService;

    public void build(Documentation documentation, String systemLink) {
        documentation.addNewPage();
        documentation.addParagraph(this.buildLabelPContents());
        documentation.addNewLine();
        documentation.addParagraph(this.buildSystemLinkContents(systemLink));
        try {
            documentation.addImage(LOGIN_PAGE_IMAGE_LOCATION, LOGIN_PAGE_SPACING_BEFORE, LOGIN_PAGE_SPACING_AFTER, LOGIN_PAGE_WIDTH, LOGIN_PAGE_HEIGHT);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private ParagraphContents buildLabelPContents() {
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(this.buildLabelContent());
        return contents;
    }

    private ParagraphContent buildLabelContent() {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildLabelTextValue());
        return content;
    }

    private TextValue buildLabelTextValue() {
        return this.buildTextValue(this.translatorService.translateMessage(SYSTEM_LINK_LABEL) + ":");
    }

    private ParagraphContents buildSystemLinkContents(String systemLink) {
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(this.buildSystemLinkContent(systemLink));
        return contents;
    }

    private ParagraphContent buildSystemLinkContent(String systemLink) {
        ParagraphContent content = new ParagraphContent();
        content.setBold(true);
        content.setTextValue(this.buildTextValue(systemLink));
        return content;
    }

    private TextValue buildTextValue(String text) {
        return TextValueUtils.build(text);
    }
}

