/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.object.FormAction;
import com.suncode.plugin.pwe.documentation.object.IntegrationComponentParameter;
import com.suncode.plugin.pwe.documentation.object.builder.IntegrationComponentParameterBuilder;
import com.suncode.pwfl.component.ParameterDefinition;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.component.WorkflowComponentRegistry;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclaration;
import com.suncode.pwfl.workflow.form.action.ActionDefinition;
import com.suncode.pwfl.workflow.form.action.declaration.ActionDeclaration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntegrationComponentBuilder {
    @Autowired
    private IntegrationComponentParameterBuilder integrationComponentParameterBuilder;

    public List<FormAction> buildFormActions(List<ActionDeclaration> actionDeclarations) {
        ArrayList<FormAction> formActions = new ArrayList<FormAction>();
        if (CollectionUtils.isNotEmpty(actionDeclarations)) {
            WorkflowComponentRegistry workflowComponentRegistry = (WorkflowComponentRegistry)SpringContext.getBean(WorkflowComponentRegistry.class);
            for (ActionDeclaration actionDeclaration : actionDeclarations) {
                ActionDefinition actionDefinition = workflowComponentRegistry.getAction(actionDeclaration.getId());
                if (actionDefinition == null) continue;
                formActions.add(this.buildFormAction(actionDefinition, actionDeclaration));
            }
        }
        return formActions;
    }

    public FormAction buildFormAction(ActionDefinition actionDefinition, ActionDeclaration actionDeclaration) {
        FormAction integrationComponent = new FormAction();
        integrationComponent.setName(actionDefinition.getName());
        integrationComponent.setCondition(actionDeclaration.getCondition());
        integrationComponent.setTarget(actionDeclaration.getTarget());
        integrationComponent.setParameters(this.buildParameters(actionDefinition.getParameters(), actionDeclaration.getParameters()));
        integrationComponent.setContextVariables(actionDefinition.getContextVariables());
        return integrationComponent;
    }

    private List<IntegrationComponentParameter> buildParameters(List<ParameterDefinition<?>> parameterDefinitions, Map<String, ParameterDeclaration> parameterDeclarations) {
        return this.integrationComponentParameterBuilder.build(parameterDefinitions, parameterDeclarations);
    }
}

