/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.enumeration.ActivityExtendedAttributeName;
import com.suncode.plugin.pwe.documentation.object.AcceptButton;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.AddFileButton;
import com.suncode.plugin.pwe.documentation.object.AutoUpdate;
import com.suncode.plugin.pwe.documentation.object.BarcodePrintButton;
import com.suncode.plugin.pwe.documentation.object.Button;
import com.suncode.plugin.pwe.documentation.object.DtButton;
import com.suncode.plugin.pwe.documentation.object.FormAction;
import com.suncode.plugin.pwe.documentation.object.FormButton;
import com.suncode.plugin.pwe.documentation.object.FormVariable;
import com.suncode.plugin.pwe.documentation.object.GeneratePdfButton;
import com.suncode.plugin.pwe.documentation.object.VariableSet;
import com.suncode.plugin.pwe.documentation.object.builder.AcceptButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.AddFileButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.AutoUpdateBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.BarcodePrintButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.DtButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.FormButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.FormVariableBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.GeneratePdfButtonBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.IntegrationComponentBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.VariableSetBuilder;
import com.suncode.plugin.pwe.util.MapOfLists;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.form.action.ActionTarget;
import com.suncode.pwfl.workflow.form.action.declaration.ActionDeclaration;
import com.suncode.pwfl.workflow.form.action.declaration.ActionReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityFormBuilder {
    @Autowired
    private FormVariableBuilder formVariableBuilder;
    @Autowired
    private AutoUpdateBuilder autoUpdateBuilder;
    @Autowired
    private VariableSetBuilder variableSetBuilder;
    @Autowired
    private DtButtonBuilder dtButtonBuilder;
    @Autowired
    private FormButtonBuilder formButtonBuilder;
    @Autowired
    private AcceptButtonBuilder acceptButtonBuilder;
    @Autowired
    private GeneratePdfButtonBuilder generatePdfButtonBuilder;
    @Autowired
    private AddFileButtonBuilder addFileButtonBuilder;
    @Autowired
    private BarcodePrintButtonBuilder barcodePrintButtonBuilder;
    @Autowired
    private IntegrationComponentBuilder integrationComponentBuilder;

    public ActivityForm build(WorkflowProcess process, Activity activity) {
        ActivityForm activityForm = new ActivityForm();
        ArrayList<FormVariable> formVariables = new ArrayList<FormVariable>();
        ArrayList<AutoUpdate> autoUpdates = new ArrayList<AutoUpdate>();
        ArrayList<VariableSet> variableSets = new ArrayList<VariableSet>();
        ArrayList<DtButton> dtButtons = new ArrayList<DtButton>();
        ArrayList<FormButton> formButtons = new ArrayList<FormButton>();
        ArrayList<AcceptButton> acceptButtons = new ArrayList<AcceptButton>();
        ArrayList<GeneratePdfButton> generatePdfButtons = new ArrayList<GeneratePdfButton>();
        ArrayList<AddFileButton> addFileButtons = new ArrayList<AddFileButton>();
        ArrayList<BarcodePrintButton> barcodePrintButtons = new ArrayList<BarcodePrintButton>();
        MapOfLists<ActionTarget, FormAction> formActionsMap = new MapOfLists<ActionTarget, FormAction>();
        ExtendedAttributes extAttrs = activity.getExtendedAttributes();
        if (!extAttrs.isEmpty()) {
            String[][] actionsExtendedAttribute = this.initializeActionsExtendedAttribute();
            block15: for (int i = 0; i < extAttrs.size(); ++i) {
                ExtendedAttribute extAttr = (ExtendedAttribute)extAttrs.get(i);
                String extAttrName = extAttr.getName();
                String extAttrValue = extAttr.getVValue();
                switch (ActivityExtendedAttributeName.getByName(extAttrName)) {
                    case VariableToProcess_VIEW: {
                        formVariables.add(this.buildVariableToProcessViewDefinition(process, extAttrValue));
                        continue block15;
                    }
                    case VariableToProcess_UPDATE: {
                        formVariables.add(this.buildVariableToProcessUpdateDefinition(process, extAttrValue));
                        continue block15;
                    }
                    case VariableToProcess_HIDDEN: {
                        formVariables.add(this.buildVariableToProcessHiddenDefinition(process, extAttrValue));
                        continue block15;
                    }
                    case AUTO_UPDATE: {
                        autoUpdates.addAll(this.buildAutoUpdatesList(extAttrValue));
                        continue block15;
                    }
                    case VARIABLE_SET_VIEW: {
                        variableSets.add(this.buildVariableSetToView(process, extAttrValue));
                        continue block15;
                    }
                    case VARIABLE_SET: {
                        variableSets.add(this.buildVariableSetToUpdate(process, extAttrValue));
                        continue block15;
                    }
                    case DT_BUTTON: {
                        dtButtons.add(this.buildDtButton(extAttrValue));
                        continue block15;
                    }
                    case HTTP_LINK: 
                    case ACTIONBUTTON: {
                        formButtons.add(this.buildFormButton(extAttrValue));
                        continue block15;
                    }
                    case ACTION_ACCEPT_BUTTON: {
                        acceptButtons.add(this.buildAcceptButton(extAttrValue));
                        continue block15;
                    }
                    case GENERATE_PDF_BUTTON: {
                        generatePdfButtons.add(this.buildGeneratePdfButton(extAttrValue));
                        continue block15;
                    }
                    case ADD_FILE_BUTTON: {
                        addFileButtons.add(this.buildAddFileButton(extAttrValue));
                        continue block15;
                    }
                    case BARCODE_PRINT: {
                        barcodePrintButtons.add(this.buildBarcodePrintButton(extAttrValue));
                        continue block15;
                    }
                    case ACTIONS: {
                        actionsExtendedAttribute[0] = new String[]{extAttrName, extAttrValue};
                        continue block15;
                    }
                }
            }
            formActionsMap = this.buildFormActionsMap(actionsExtendedAttribute);
        }
        if (CollectionUtils.isEmpty(acceptButtons)) {
            acceptButtons.add(this.buildDefaultAcceptButton());
        }
        this.joinAutoUpdatesAndFormVariables(formVariables, autoUpdates);
        this.joinFormActionsAndFormVariables(formVariables, formActionsMap);
        this.joinDtButtonsAndVariableSets(variableSets, dtButtons);
        this.joinFormActionsAndVariableSets(variableSets, formActionsMap);
        this.joinFormActionsAndButtons(formButtons, formActionsMap);
        this.joinFormActionsAndButtons(acceptButtons, formActionsMap);
        this.joinFormActionsAndButtons(generatePdfButtons, formActionsMap);
        this.joinFormActionsAndButtons(addFileButtons, formActionsMap);
        this.joinFormActionsAndButtons(barcodePrintButtons, formActionsMap);
        activityForm.setFormVariables(formVariables);
        activityForm.setVariableSets(variableSets);
        activityForm.setFormButtons(formButtons);
        activityForm.setAcceptButtons(acceptButtons);
        activityForm.setGeneratePdfButtons(generatePdfButtons);
        activityForm.setAddFileButtons(addFileButtons);
        activityForm.setBarcodePrintButtons(barcodePrintButtons);
        activityForm.setFormActions(this.buildFormFormActions(formActionsMap));
        return activityForm;
    }

    private String[][] initializeActionsExtendedAttribute() {
        String[][] table = new String[1][2];
        table[0] = new String[]{"", ""};
        return table;
    }

    private FormVariable buildVariableToProcessViewDefinition(WorkflowProcess process, String extAttrValue) {
        return this.formVariableBuilder.buildVariableToProcessView(process, extAttrValue);
    }

    private FormVariable buildVariableToProcessUpdateDefinition(WorkflowProcess process, String extAttrValue) {
        return this.formVariableBuilder.buildVariableToProcessUpdate(process, extAttrValue);
    }

    private FormVariable buildVariableToProcessHiddenDefinition(WorkflowProcess process, String extAttrValue) {
        return this.formVariableBuilder.buildVariableToProcessHidden(process, extAttrValue);
    }

    private List<AutoUpdate> buildAutoUpdatesList(String extAttrValue) {
        return this.autoUpdateBuilder.build(extAttrValue);
    }

    private VariableSet buildVariableSetToView(WorkflowProcess process, String extAttrValue) {
        return this.variableSetBuilder.buildToView(process, extAttrValue);
    }

    private VariableSet buildVariableSetToUpdate(WorkflowProcess process, String extAttrValue) {
        return this.variableSetBuilder.buildToUpdate(process, extAttrValue);
    }

    private DtButton buildDtButton(String extAttrValue) {
        return this.dtButtonBuilder.build(extAttrValue);
    }

    private FormButton buildFormButton(String extAttrValue) {
        return this.formButtonBuilder.build(extAttrValue);
    }

    private AcceptButton buildAcceptButton(String extAttrValue) {
        return this.acceptButtonBuilder.build(extAttrValue);
    }

    private GeneratePdfButton buildGeneratePdfButton(String extAttrValue) {
        return this.generatePdfButtonBuilder.build(extAttrValue);
    }

    private AddFileButton buildAddFileButton(String extAttrValue) {
        return this.addFileButtonBuilder.build(extAttrValue);
    }

    private BarcodePrintButton buildBarcodePrintButton(String extAttrValue) {
        return this.barcodePrintButtonBuilder.build(extAttrValue);
    }

    private MapOfLists<ActionTarget, FormAction> buildFormActionsMap(String[][] extAttrs) {
        MapOfLists<ActionTarget, FormAction> formActionsMap = new MapOfLists<ActionTarget, FormAction>();
        ActionReader actionReader = (ActionReader)SpringContext.getBean(ActionReader.class);
        List actionDeclarations = actionReader.readFromExtendedAttributes(extAttrs);
        List<FormAction> formActions = this.buildFormActions(actionDeclarations);
        for (FormAction formAction : formActions) {
            formActionsMap.addValueToList(formAction.getTarget(), formAction);
        }
        return formActionsMap;
    }

    private List<FormAction> buildFormActions(List<ActionDeclaration> actionDeclarations) {
        return this.integrationComponentBuilder.buildFormActions(actionDeclarations);
    }

    private AcceptButton buildDefaultAcceptButton() {
        return this.acceptButtonBuilder.buildDefault();
    }

    private void joinAutoUpdatesAndFormVariables(List<FormVariable> formVariables, List<AutoUpdate> autoUpdates) {
        block0: for (AutoUpdate autoUpdate : autoUpdates) {
            for (FormVariable formVariable : formVariables) {
                if (!StringUtils.equals((CharSequence)autoUpdate.getActionSource(), (CharSequence)formVariable.getId())) continue;
                this.addAutoUpdateToFormVariable(formVariable, autoUpdate);
                continue block0;
            }
        }
    }

    private void addAutoUpdateToFormVariable(FormVariable formVariable, AutoUpdate autoUpdate) {
        if (CollectionUtils.isNotEmpty(formVariable.getAutoUpdates())) {
            formVariable.getAutoUpdates().add(autoUpdate);
        } else {
            formVariable.setAutoUpdates(this.initAutoUpdates(autoUpdate));
        }
    }

    private List<AutoUpdate> initAutoUpdates(AutoUpdate autoUpdate) {
        ArrayList<AutoUpdate> autoUpdates = new ArrayList<AutoUpdate>();
        autoUpdates.add(autoUpdate);
        return autoUpdates;
    }

    private void joinFormActionsAndFormVariables(List<FormVariable> formVariables, MapOfLists<ActionTarget, FormAction> formActionsMap) {
        for (FormVariable formVariable : formVariables) {
            ActionTarget actionTarget = ActionTarget.variable((String)formVariable.getId());
            formVariable.setFormActions((List)formActionsMap.get(actionTarget));
        }
    }

    private void joinDtButtonsAndVariableSets(List<VariableSet> variableSets, List<DtButton> dtButtons) {
        block0: for (DtButton dtButton : dtButtons) {
            for (VariableSet variableSet : variableSets) {
                if (!StringUtils.equals((CharSequence)dtButton.getVariableSetId(), (CharSequence)variableSet.getColumnsId())) continue;
                this.addDtButtonToVariableSet(variableSet, dtButton);
                continue block0;
            }
        }
    }

    private void addDtButtonToVariableSet(VariableSet variableSet, DtButton dtButton) {
        if (CollectionUtils.isNotEmpty(variableSet.getDtButtons())) {
            variableSet.getDtButtons().add(dtButton);
        } else {
            variableSet.setDtButtons(this.initDtButtons(dtButton));
        }
    }

    private List<DtButton> initDtButtons(DtButton dtButton) {
        ArrayList<DtButton> dtButtons = new ArrayList<DtButton>();
        dtButtons.add(dtButton);
        return dtButtons;
    }

    private void joinFormActionsAndVariableSets(List<VariableSet> variableSets, MapOfLists<ActionTarget, FormAction> formActionsMap) {
        for (VariableSet variableSet : variableSets) {
            ActionTarget actionTarget = ActionTarget.variableSet((String)variableSet.getId());
            variableSet.setFormActions((List)formActionsMap.get(actionTarget));
        }
    }

    private void joinFormActionsAndButtons(List<? extends Button> buttons, MapOfLists<ActionTarget, FormAction> formActionsMap) {
        for (Button button : buttons) {
            ActionTarget actionTarget = ActionTarget.button((String)button.getActionName());
            button.setFormActions((List)formActionsMap.get(actionTarget));
        }
    }

    private List<FormAction> buildFormFormActions(MapOfLists<ActionTarget, FormAction> formActionsMap) {
        ActionTarget actionTarget = ActionTarget.form();
        return (List)formActionsMap.get(actionTarget);
    }
}

