/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.enumeration.ActionAcceptButtonConfig;
import com.suncode.plugin.pwe.documentation.object.AcceptButton;
import com.suncode.plugin.pwe.documentation.object.AcceptButtonAction;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AcceptButtonBuilder {
    private static final String ACTIONS_SPLIT_SIGN = ",";
    private static final String ONE_ACTION_SPLIT_SIGN = "=";
    private static final String DEFAULT_ACTION_NAME = "zatwierdz";
    private static final String CONFIRM = "pwe.documentation.text.confirm";
    @Autowired
    private TranslatorService translatorService;

    public AcceptButton build(String extAttrValue) {
        AcceptButton button = new AcceptButton();
        ArrayList<AcceptButtonAction> actions = new ArrayList<AcceptButtonAction>();
        block6: for (String oneExtAttr : extAttrValue.split("\n")) {
            String[] oneExtAttrSplit = oneExtAttr.split(ONE_ACTION_SPLIT_SIGN, 2);
            String oneExtAttrName = oneExtAttrSplit[0];
            String oneExtAttrValue = oneExtAttrSplit[1];
            switch (ActionAcceptButtonConfig.getByName(oneExtAttrName)) {
                case actionName: {
                    button.setActionName(oneExtAttrValue);
                    continue block6;
                }
                case buttonName: {
                    button.setButtonName(oneExtAttrValue);
                    continue block6;
                }
                case checkForm: {
                    button.setCheckForm(this.buildCheckForm(oneExtAttrValue));
                    continue block6;
                }
                case action: {
                    actions.addAll(this.buildActions(oneExtAttrValue));
                    continue block6;
                }
            }
        }
        button.setActions(actions);
        return button;
    }

    private boolean buildCheckForm(String oneExtAttrValue) {
        return Boolean.parseBoolean(oneExtAttrValue);
    }

    private List<AcceptButtonAction> buildActions(String oneExtAttrValue) {
        ArrayList<AcceptButtonAction> actions = new ArrayList<AcceptButtonAction>();
        for (String oneAction : oneExtAttrValue.split(ACTIONS_SPLIT_SIGN)) {
            actions.add(this.buildAction(oneAction));
        }
        return actions;
    }

    private AcceptButtonAction buildAction(String oneAction) {
        String[] oneActionConfig = oneAction.split(ONE_ACTION_SPLIT_SIGN, 2);
        AcceptButtonAction action = new AcceptButtonAction();
        action.setId(oneActionConfig[0]);
        action.setValue(oneActionConfig[1]);
        return action;
    }

    public AcceptButton buildDefault() {
        AcceptButton button = new AcceptButton();
        button.setActionName(DEFAULT_ACTION_NAME);
        button.setButtonName(this.translatorService.translateMessage(CONFIRM));
        button.setCheckForm(false);
        button.setActions(new ArrayList<AcceptButtonAction>());
        return button;
    }
}

