/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.glossaryofterms.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.ParagraphSpacing;
import com.suncode.plugin.pwe.documentation.TextValue;
import com.suncode.plugin.pwe.documentation.comparator.TermComparator;
import com.suncode.plugin.pwe.documentation.object.Term;
import com.suncode.plugin.pwe.documentation.object.builder.TermBuilder;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.ParagraphSpacingUtils;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GlossaryOfTermsBuilder {
    private static final String GLOSSARY_OF_TERMS_TITLE = "pwe.documentation.glossaryofterms.title";
    private static final String DOCUMENT_CLASS_TERM_NAME = "pwe.documentation.glossaryofterms.term.documentclass.name";
    private static final String DOCUMENT_CLASS_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.documentclass.gloss";
    private static final String PROCESS_PARTICIPANT_TERM_NAME = "pwe.documentation.glossaryofterms.term.processparticipant.name";
    private static final String PROCESS_PARTICIPANT_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.processparticipant.gloss";
    private static final String BUSINESS_PROCESS_TERM_NAME = "pwe.documentation.glossaryofterms.term.businessprocess.name";
    private static final String BUSINESS_PROCESS_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.businessprocess.gloss";
    private static final String PROCESS_MAP_TERM_NAME = "pwe.documentation.glossaryofterms.term.processmap.name";
    private static final String PROCESS_MAP_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.processmap.gloss";
    private static final String ACTIVITY_TERM_NAME = "pwe.documentation.glossaryofterms.term.activity.name";
    private static final String ACTIVITY_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.activity.gloss";
    private static final String PROCESS_FORM_FIELD_TERM_NAME = "pwe.documentation.glossaryofterms.term.processformfield.name";
    private static final String PROCESS_FORM_FIELD_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.processformfield.gloss";
    private static final String TEXT_AREA_TERM_NAME = "pwe.documentation.glossaryofterms.term.textarea.name";
    private static final String TEXT_AREA_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.textarea.gloss";
    private static final String RADIOBUTTON_TERM_NAME = "pwe.documentation.glossaryofterms.term.radiobutton.name";
    private static final String RADIOBUTTON_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.radiobutton.gloss";
    private static final String CHECKBOX_TERM_NAME = "pwe.documentation.glossaryofterms.term.checkbox.name";
    private static final String CHECKBOX_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.checkbox.gloss";
    private static final String FILTERED_LISTBOX_TERM_NAME = "pwe.documentation.glossaryofterms.term.filteredlistbox.name";
    private static final String FILTERED_LISTBOX_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.filteredlistbox.gloss";
    private static final String EDITABLE_FILTERED_LISTBOX_TERM_NAME = "pwe.documentation.glossaryofterms.term.editablefilteredlistbox.name";
    private static final String EDITABLE_FILTERED_LISTBOX_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.editablefilteredlistbox.gloss";
    private static final String LISTBOX_TERM_NAME = "pwe.documentation.glossaryofterms.term.listbox.name";
    private static final String LISTBOX_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.listbox.gloss";
    private static final String EDITABLE_LISTBOX_TERM_NAME = "pwe.documentation.glossaryofterms.term.editablelistbox.name";
    private static final String EDITABLE_LISTBOX_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.editablelistbox.gloss";
    private static final String INITIALIZED_FILTERED_LISTBOX_TERM_NAME = "pwe.documentation.glossaryofterms.term.initializedfilteredlistbox.name";
    private static final String INITIALIZED_FILTERED_LISTBOX_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.initializedfilteredlistbox.gloss";
    private static final String INITIALIZED_LISTBOX_TERM_NAME = "pwe.documentation.glossaryofterms.term.initializedlistbox.name";
    private static final String INITIALIZED_LISTBOX_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.initializedlistbox.gloss";
    private static final String SYSTEM_USERS_TABLE_TERM_NAME = "pwe.documentation.glossaryofterms.term.systemuserstable.name";
    private static final String SYSTEM_USERS_TABLE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.systemuserstable.gloss";
    private static final String DATA_CHOOSER_TERM_NAME = "pwe.documentation.glossaryofterms.term.datachooser.name";
    private static final String DATA_CHOOSER_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.datachooser.gloss";
    private static final String SYSTEM_USERS_LIST_TERM_NAME = "pwe.documentation.glossaryofterms.term.systemuserslist.name";
    private static final String SYSTEM_USERS_LIST_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.systemuserslist.gloss";
    private static final String FILTERED_USERS_LIST_WITH_ROLE_TERM_NAME = "pwe.documentation.glossaryofterms.term.filtereduserslistwithrole.name";
    private static final String FILTERED_USERS_LIST_WITH_ROLE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.filtereduserslistwithrole.gloss";
    private static final String USERS_LIST_WITH_ROLE_TERM_NAME = "pwe.documentation.glossaryofterms.term.userslistwithrole.name";
    private static final String USERS_LIST_WITH_ROLE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.userslistwithrole.gloss";
    private static final String REQUIREMENT_TERM_NAME = "pwe.documentation.glossaryofterms.term.requirement.name";
    private static final String REQUIREMENT_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.requirement.gloss";
    private static final String READ_ONLY_TERM_NAME = "pwe.documentation.glossaryofterms.term.readonly.name";
    private static final String READ_ONLY_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.readonly.gloss";
    private static final String INITIAL_VALUE_TERM_NAME = "pwe.documentation.glossaryofterms.term.initialvalue.name";
    private static final String INITIAL_VALUE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.initialvalue.gloss";
    private static final String PROCESS_INITIATOR_TERM_NAME = "pwe.documentation.glossaryofterms.term.processinitiator.name";
    private static final String PROCESS_INITIATOR_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.processinitiator.gloss";
    private static final String ACTIVITY_ASSIGNMENT_TERM_NAME = "pwe.documentation.glossaryofterms.term.activityassignment.name";
    private static final String ACTIVITY_ASSIGNMENT_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.activityassignment.gloss";
    private static final String SEQUENCER_TERM_NAME = "pwe.documentation.glossaryofterms.term.sequencer.name";
    private static final String SEQUENCER_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.sequencer.gloss";
    private static final String FORCE_SELECTION_TERM_NAME = "pwe.documentation.glossaryofterms.term.forceselection.name";
    private static final String FORCE_SELECTION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.forceselection.gloss";
    private static final String FORM_CRITERIA_TERM_NAME = "pwe.documentation.glossaryofterms.term.formcriteria.name";
    private static final String FORM_CRITERIA_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.formcriteria.gloss";
    private static final String SHARK_ENGINE_TRANSACTION_TERM_NAME = "pwe.documentation.glossaryofterms.term.sharkenginetransaction.name";
    private static final String SHARK_ENGINE_TRANSACTION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.sharkenginetransaction.gloss";
    private static final String ROUTE_TERM_NAME = "pwe.documentation.glossaryofterms.term.route.name";
    private static final String ROUTE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.route.gloss";
    private static final String SUBFLOW_TERM_NAME = "pwe.documentation.glossaryofterms.term.subflow.name";
    private static final String SUBFLOW_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.subflow.gloss";
    private static final String ACTIVITY_ASSIGNMENT_BY_ROLE_TERM_NAME = "pwe.documentation.glossaryofterms.term.activityassignmentbyrole.name";
    private static final String ACTIVITY_ASSIGNMENT_BY_ROLE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.activityassignmentbyrole.gloss";
    private static final String ACTIVITY_FORM_TERM_NAME = "pwe.documentation.glossaryofterms.term.activityform.name";
    private static final String ACTIVITY_FORM_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.activityform.gloss";
    private static final String FORM_FIELD_TERM_NAME = "pwe.documentation.glossaryofterms.term.formfield.name";
    private static final String FORM_FIELD_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.formfield.gloss";
    private static final String NONEDITABLE_FORM_FIELD_TERM_NAME = "pwe.documentation.glossaryofterms.term.noneditableformfield.name";
    private static final String NONEDITABLE_FORM_FIELD_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.noneditableformfield.gloss";
    private static final String EDITABLE_FORM_FIELD_TERM_NAME = "pwe.documentation.glossaryofterms.term.editableformfield.name";
    private static final String EDITABLE_FORM_FIELD_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.editableformfield.gloss";
    private static final String HIDDEN_FORM_FIELD_TERM_NAME = "pwe.documentation.glossaryofterms.term.hiddenformfield.name";
    private static final String HIDDEN_FORM_FIELD_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.hiddenformfield.gloss";
    private static final String FORM_FIELD_AUTO_UPDATE_TERM_NAME = "pwe.documentation.glossaryofterms.term.formfieldautoupdate.name";
    private static final String FORM_FIELD_AUTO_UPDATE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.formfieldautoupdate.gloss";
    private static final String APPLET_TERM_NAME = "pwe.documentation.glossaryofterms.term.applet.name";
    private static final String APPLET_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.applet.gloss";
    private static final String ACTION_TERM_NAME = "pwe.documentation.glossaryofterms.term.action.name";
    private static final String ACTION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.action.gloss";
    private static final String DATA_SOURCES_TERM_NAME = "pwe.documentation.glossaryofterms.term.datasources.name";
    private static final String DATA_SOURCES_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.datasources.gloss";
    private static final String DESTINATION_VARIABLES_TERM_NAME = "pwe.documentation.glossaryofterms.term.destinationvariables.name";
    private static final String DESTINATION_VARIABLES_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.destinationvariables.gloss";
    private static final String VARIABLE_SET_TERM_NAME = "pwe.documentation.glossaryofterms.term.variableset.name";
    private static final String VARIABLE_SET_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.variableset.gloss";
    private static final String FORM_BUTTON_TERM_NAME = "pwe.documentation.glossaryofterms.term.formbutton.name";
    private static final String FORM_BUTTON_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.formbutton.gloss";
    private static final String ACCEPT_BUTTON_TERM_NAME = "pwe.documentation.glossaryofterms.term.acceptbutton.name";
    private static final String ACCEPT_BUTTON_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.acceptbutton.gloss";
    private static final String CHECK_FORM_TERM_NAME = "pwe.documentation.glossaryofterms.term.checkform.name";
    private static final String CHECK_FORM_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.checkform.gloss";
    private static final String GENERATE_PDF_BUTTON_TERM_NAME = "pwe.documentation.glossaryofterms.term.generatepdfbutton.name";
    private static final String GENERATE_PDF_BUTTON_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.generatepdfbutton.gloss";
    private static final String ADD_FILE_BUTTON_TERM_NAME = "pwe.documentation.glossaryofterms.term.addfilebutton.name";
    private static final String ADD_FILE_BUTTON_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.addfilebutton.gloss";
    private static final String BARCODE_PRINT_BUTTON_TERM_NAME = "pwe.documentation.glossaryofterms.term.barcodeprintbutton.name";
    private static final String BARCODE_PRINT_BUTTON_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.barcodeprintbutton.gloss";
    private static final String PROCESS_DOCUMENT_TERM_NAME = "pwe.documentation.glossaryofterms.term.processdocument.name";
    private static final String PROCESS_DOCUMENT_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.processdocument.gloss";
    private static final String AUTOMATIC_TRANSITIONS_TERM_NAME = "pwe.documentation.glossaryofterms.term.automatictransitions.name";
    private static final String AUTOMATIC_TRANSITIONS_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.automatictransitions.gloss";
    private static final String CONCURRENT_ACCEPTANCE_TERM_NAME = "pwe.documentation.glossaryofterms.term.concurrentacceptance.name";
    private static final String CONCURRENT_ACCEPTANCE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.concurrentacceptance.gloss";
    private static final String NEW_DOCUMENT_ACCEPTANCE_TERM_NAME = "pwe.documentation.glossaryofterms.term.newdocumentacceptance.name";
    private static final String NEW_DOCUMENT_ACCEPTANCE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.newdocumentacceptance.gloss";
    private static final String VIEW_DOCUMENT_CLASS_TERM_NAME = "pwe.documentation.glossaryofterms.term.viewdocumentclass.name";
    private static final String VIEW_DOCUMENT_CLASS_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.viewdocumentclass.gloss";
    private static final String DEADLINE_TERM_NAME = "pwe.documentation.glossaryofterms.term.deadline.name";
    private static final String DEADLINE_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.deadline.gloss";
    private static final String EXCEPTIONAL_TRANSITION_TERM_NAME = "pwe.documentation.glossaryofterms.term.exceptionaltransition.name";
    private static final String EXCEPTIONAL_TRANSITION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.exceptionaltransition.gloss";
    private static final String TRANSITION_TERM_NAME = "pwe.documentation.glossaryofterms.term.transition.name";
    private static final String TRANSITION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.transition.gloss";
    private static final String EMAIL_NOTIFICATION_TERM_NAME = "pwe.documentation.glossaryofterms.term.emailnotification.name";
    private static final String EMAIL_NOTIFICATION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.emailnotification.gloss";
    private static final String AUTOMATIC_TASK_TERM_NAME = "pwe.documentation.glossaryofterms.term.automatictask.name";
    private static final String AUTOMATIC_TASK_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.automatictask.gloss";
    private static final String PROCESS_APPLICATION_TERM_NAME = "pwe.documentation.glossaryofterms.term.processapplication.name";
    private static final String PROCESS_APPLICATION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.processapplication.gloss";
    private static final String INTEGRATION_TERM_NAME = "pwe.documentation.glossaryofterms.term.integration.name";
    private static final String INTEGRATION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.integration.gloss";
    private static final String PROGRAMMING_TASK_TERM_NAME = "pwe.documentation.glossaryofterms.term.programmingtask.name";
    private static final String PROGRAMMING_TASK_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.programmingtask.gloss";
    private static final String SERVLET_TERM_NAME = "pwe.documentation.glossaryofterms.term.servlet.name";
    private static final String SERVLET_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.servlet.gloss";
    private static final String JAVA_CLASS_TERM_NAME = "pwe.documentation.glossaryofterms.term.javaclass.name";
    private static final String JAVA_CLASS_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.javaclass.gloss";
    private static final String JAVA_SCRIPT_TERM_NAME = "pwe.documentation.glossaryofterms.term.javascript.name";
    private static final String JAVA_SCRIPT_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.javascript.gloss";
    private static final String DOCUMENT_CLASS_INDEX_TERM_NAME = "pwe.documentation.glossaryofterms.term.documentclassindex.name";
    private static final String DOCUMENT_CLASS_INDEX_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.documentclassindex.gloss";
    private static final String SCRIPT_URL_ADDRESS_TERM_NAME = "pwe.documentation.glossaryofterms.term.scripturladdress.name";
    private static final String SCRIPT_URL_ADDRESS_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.scripturladdress.gloss";
    private static final String DOCUMENT_LINK_TERM_NAME = "pwe.documentation.glossaryofterms.term.documentlink.name";
    private static final String DOCUMENT_LINK_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.documentlink.gloss";
    private static final String INDEXES_CONNECTION_TERM_NAME = "pwe.documentation.glossaryofterms.term.indexesconnection.name";
    private static final String INDEXES_CONNECTION_TERM_GLOSS = "pwe.documentation.glossaryofterms.term.indexesconnection.gloss";
    private static final int BEFORE_SPACING = 0;
    private static final int AFTER_SPACING = 10;
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private TermBuilder termBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    public void build(Documentation documentation) {
        documentation.addChapter(this.buildTitle());
        this.buildTermPoints(documentation);
    }

    private String buildTitle() {
        return this.translatorService.translateMessage(GLOSSARY_OF_TERMS_TITLE);
    }

    private void buildTermPoints(Documentation documentation) {
        List<Term> terms = this.buildTerms();
        for (Term term : terms) {
            this.buildTermPoint(documentation, term);
        }
    }

    private List<Term> buildTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.buildTerm(DOCUMENT_CLASS_TERM_NAME, DOCUMENT_CLASS_TERM_GLOSS));
        terms.add(this.buildTerm(PROCESS_PARTICIPANT_TERM_NAME, PROCESS_PARTICIPANT_TERM_GLOSS));
        terms.add(this.buildTerm(BUSINESS_PROCESS_TERM_NAME, BUSINESS_PROCESS_TERM_GLOSS));
        terms.add(this.buildTerm(PROCESS_MAP_TERM_NAME, PROCESS_MAP_TERM_GLOSS));
        terms.add(this.buildTerm(ACTIVITY_TERM_NAME, ACTIVITY_TERM_GLOSS));
        terms.add(this.buildTerm(PROCESS_FORM_FIELD_TERM_NAME, PROCESS_FORM_FIELD_TERM_GLOSS));
        terms.add(this.buildTerm(TEXT_AREA_TERM_NAME, TEXT_AREA_TERM_GLOSS));
        terms.add(this.buildTerm(RADIOBUTTON_TERM_NAME, RADIOBUTTON_TERM_GLOSS));
        terms.add(this.buildTerm(CHECKBOX_TERM_NAME, CHECKBOX_TERM_GLOSS));
        terms.add(this.buildTerm(FILTERED_LISTBOX_TERM_NAME, FILTERED_LISTBOX_TERM_GLOSS));
        terms.add(this.buildTerm(EDITABLE_FILTERED_LISTBOX_TERM_NAME, EDITABLE_FILTERED_LISTBOX_TERM_GLOSS));
        terms.add(this.buildTerm(LISTBOX_TERM_NAME, LISTBOX_TERM_GLOSS));
        terms.add(this.buildTerm(EDITABLE_LISTBOX_TERM_NAME, EDITABLE_LISTBOX_TERM_GLOSS));
        terms.add(this.buildTerm(INITIALIZED_FILTERED_LISTBOX_TERM_NAME, INITIALIZED_FILTERED_LISTBOX_TERM_GLOSS));
        terms.add(this.buildTerm(INITIALIZED_LISTBOX_TERM_NAME, INITIALIZED_LISTBOX_TERM_GLOSS));
        terms.add(this.buildTerm(SYSTEM_USERS_TABLE_TERM_NAME, SYSTEM_USERS_TABLE_TERM_GLOSS));
        terms.add(this.buildTerm(DATA_CHOOSER_TERM_NAME, DATA_CHOOSER_TERM_GLOSS));
        terms.add(this.buildTerm(SYSTEM_USERS_LIST_TERM_NAME, SYSTEM_USERS_LIST_TERM_GLOSS));
        terms.add(this.buildTerm(FILTERED_USERS_LIST_WITH_ROLE_TERM_NAME, FILTERED_USERS_LIST_WITH_ROLE_TERM_GLOSS));
        terms.add(this.buildTerm(USERS_LIST_WITH_ROLE_TERM_NAME, USERS_LIST_WITH_ROLE_TERM_GLOSS));
        terms.add(this.buildTerm(REQUIREMENT_TERM_NAME, REQUIREMENT_TERM_GLOSS));
        terms.add(this.buildTerm(READ_ONLY_TERM_NAME, READ_ONLY_TERM_GLOSS));
        terms.add(this.buildTerm(INITIAL_VALUE_TERM_NAME, INITIAL_VALUE_TERM_GLOSS));
        terms.add(this.buildTerm(PROCESS_INITIATOR_TERM_NAME, PROCESS_INITIATOR_TERM_GLOSS));
        terms.add(this.buildTerm(ACTIVITY_ASSIGNMENT_TERM_NAME, ACTIVITY_ASSIGNMENT_TERM_GLOSS));
        terms.add(this.buildTerm(SEQUENCER_TERM_NAME, SEQUENCER_TERM_GLOSS));
        terms.add(this.buildTerm(FORCE_SELECTION_TERM_NAME, FORCE_SELECTION_TERM_GLOSS));
        terms.add(this.buildTerm(FORM_CRITERIA_TERM_NAME, FORM_CRITERIA_TERM_GLOSS));
        terms.add(this.buildTerm(SHARK_ENGINE_TRANSACTION_TERM_NAME, SHARK_ENGINE_TRANSACTION_TERM_GLOSS));
        terms.add(this.buildTerm(ROUTE_TERM_NAME, ROUTE_TERM_GLOSS));
        terms.add(this.buildTerm(SUBFLOW_TERM_NAME, SUBFLOW_TERM_GLOSS));
        terms.add(this.buildTerm(ACTIVITY_ASSIGNMENT_BY_ROLE_TERM_NAME, ACTIVITY_ASSIGNMENT_BY_ROLE_TERM_GLOSS));
        terms.add(this.buildTerm(ACTIVITY_FORM_TERM_NAME, ACTIVITY_FORM_TERM_GLOSS));
        terms.add(this.buildTerm(FORM_FIELD_TERM_NAME, FORM_FIELD_TERM_GLOSS));
        terms.add(this.buildTerm(NONEDITABLE_FORM_FIELD_TERM_NAME, NONEDITABLE_FORM_FIELD_TERM_GLOSS));
        terms.add(this.buildTerm(EDITABLE_FORM_FIELD_TERM_NAME, EDITABLE_FORM_FIELD_TERM_GLOSS));
        terms.add(this.buildTerm(HIDDEN_FORM_FIELD_TERM_NAME, HIDDEN_FORM_FIELD_TERM_GLOSS));
        terms.add(this.buildTerm(FORM_FIELD_AUTO_UPDATE_TERM_NAME, FORM_FIELD_AUTO_UPDATE_TERM_GLOSS));
        terms.add(this.buildTerm(APPLET_TERM_NAME, APPLET_TERM_GLOSS));
        terms.add(this.buildTerm(ACTION_TERM_NAME, ACTION_TERM_GLOSS));
        terms.add(this.buildTerm(DATA_SOURCES_TERM_NAME, DATA_SOURCES_TERM_GLOSS));
        terms.add(this.buildTerm(DESTINATION_VARIABLES_TERM_NAME, DESTINATION_VARIABLES_TERM_GLOSS));
        terms.add(this.buildTerm(VARIABLE_SET_TERM_NAME, VARIABLE_SET_TERM_GLOSS));
        terms.add(this.buildTerm(FORM_BUTTON_TERM_NAME, FORM_BUTTON_TERM_GLOSS));
        terms.add(this.buildTerm(ACCEPT_BUTTON_TERM_NAME, ACCEPT_BUTTON_TERM_GLOSS));
        terms.add(this.buildTerm(CHECK_FORM_TERM_NAME, CHECK_FORM_TERM_GLOSS));
        terms.add(this.buildTerm(GENERATE_PDF_BUTTON_TERM_NAME, GENERATE_PDF_BUTTON_TERM_GLOSS));
        terms.add(this.buildTerm(ADD_FILE_BUTTON_TERM_NAME, ADD_FILE_BUTTON_TERM_GLOSS));
        terms.add(this.buildTerm(BARCODE_PRINT_BUTTON_TERM_NAME, BARCODE_PRINT_BUTTON_TERM_GLOSS));
        terms.add(this.buildTerm(PROCESS_DOCUMENT_TERM_NAME, PROCESS_DOCUMENT_TERM_GLOSS));
        terms.add(this.buildTerm(AUTOMATIC_TRANSITIONS_TERM_NAME, AUTOMATIC_TRANSITIONS_TERM_GLOSS));
        terms.add(this.buildTerm(CONCURRENT_ACCEPTANCE_TERM_NAME, CONCURRENT_ACCEPTANCE_TERM_GLOSS));
        terms.add(this.buildTerm(NEW_DOCUMENT_ACCEPTANCE_TERM_NAME, NEW_DOCUMENT_ACCEPTANCE_TERM_GLOSS));
        terms.add(this.buildTerm(VIEW_DOCUMENT_CLASS_TERM_NAME, VIEW_DOCUMENT_CLASS_TERM_GLOSS));
        terms.add(this.buildTerm(DEADLINE_TERM_NAME, DEADLINE_TERM_GLOSS));
        terms.add(this.buildTerm(EXCEPTIONAL_TRANSITION_TERM_NAME, EXCEPTIONAL_TRANSITION_TERM_GLOSS));
        terms.add(this.buildTerm(TRANSITION_TERM_NAME, TRANSITION_TERM_GLOSS));
        terms.add(this.buildTerm(EMAIL_NOTIFICATION_TERM_NAME, EMAIL_NOTIFICATION_TERM_GLOSS));
        terms.add(this.buildTerm(AUTOMATIC_TASK_TERM_NAME, AUTOMATIC_TASK_TERM_GLOSS));
        terms.add(this.buildTerm(PROCESS_APPLICATION_TERM_NAME, PROCESS_APPLICATION_TERM_GLOSS));
        terms.add(this.buildTerm(INTEGRATION_TERM_NAME, INTEGRATION_TERM_GLOSS));
        terms.add(this.buildTerm(PROGRAMMING_TASK_TERM_NAME, PROGRAMMING_TASK_TERM_GLOSS));
        terms.add(this.buildTerm(SERVLET_TERM_NAME, SERVLET_TERM_GLOSS));
        terms.add(this.buildTerm(JAVA_CLASS_TERM_NAME, JAVA_CLASS_TERM_GLOSS));
        terms.add(this.buildTerm(JAVA_SCRIPT_TERM_NAME, JAVA_SCRIPT_TERM_GLOSS));
        terms.add(this.buildTerm(DOCUMENT_CLASS_INDEX_TERM_NAME, DOCUMENT_CLASS_INDEX_TERM_GLOSS));
        terms.add(this.buildTerm(SCRIPT_URL_ADDRESS_TERM_NAME, SCRIPT_URL_ADDRESS_TERM_GLOSS));
        terms.add(this.buildTerm(DOCUMENT_LINK_TERM_NAME, DOCUMENT_LINK_TERM_GLOSS));
        terms.add(this.buildTerm(INDEXES_CONNECTION_TERM_NAME, INDEXES_CONNECTION_TERM_GLOSS));
        Collections.sort(terms, new TermComparator());
        return terms;
    }

    private Term buildTerm(String nameKey, String glossKey) {
        return this.termBuilder.build(nameKey, glossKey);
    }

    private void buildTermPoint(Documentation documentation, Term term) {
        ParagraphContents contents = this.buildTermPointParagraphContents(term);
        this.buildPoint(documentation, contents);
    }

    private ParagraphContents buildTermPointParagraphContents(Term term) {
        ParagraphContents contents = new ParagraphContents();
        contents.setSpacing(this.buildSpacing());
        contents.addContent(this.buildNameContent(term));
        contents.addContent(this.buildGlossContent(term));
        return contents;
    }

    private ParagraphSpacing buildSpacing() {
        return ParagraphSpacingUtils.build(BEFORE_SPACING, AFTER_SPACING);
    }

    private ParagraphContent buildNameContent(Term term) {
        ParagraphContent content = new ParagraphContent();
        content.setBold(true);
        content.setTextValue(this.buildNameTextValue(term));
        return content;
    }

    private TextValue buildNameTextValue(Term term) {
        String text = term.getName();
        return this.buildTextValue(text);
    }

    private TextValue buildTextValue(String text) {
        return TextValueUtils.build(text);
    }

    private ParagraphContent buildGlossContent(Term term) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildGlossTextValue(term));
        return content;
    }

    private TextValue buildGlossTextValue(Term term) {
        String text = this.buildGlossText(term);
        return this.buildTextValue(text);
    }

    private String buildGlossText(Term term) {
        StringBuilder text = new StringBuilder();
        text.append(" - ");
        text.append(term.getGloss());
        return text.toString();
    }

    private void buildPoint(Documentation documentation, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, contents);
    }
}

