/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.specification.DocumentClassSpecification;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="documentClassSpecificationsSubcomparator")
public class DocumentClassSpecificationsSubcomparatorImpl
implements ProcessSpecificationSubcomparator<List<DocumentClassSpecification>> {
    private static final String DESCRIPTION_MODIFIED = "pwe.documentation.changecard.modified.documentclassdescription";
    private static final String DOCUMENT_CLASS_ADDED = "pwe.documentation.changecard.added.documentclass";
    private static final String DOCUMENT_CLASS_DELETED = "pwe.documentation.changecard.deleted.documentclass";
    @Autowired
    private DifferenceBuilder differenceBuilder;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, List<DocumentClassSpecification> base, WorkflowProcess comparedProcess, List<DocumentClassSpecification> compared, TranslationInfo translationInfo) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, DocumentClassSpecification> baseMap = this.convertToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (DocumentClassSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getName())) {
                    DocumentClassSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                    differences.addAll(this.compare(comparedSpecification.getName(), baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(DOCUMENT_CLASS_ADDED, comparedSpecification.getName()));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (DocumentClassSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(DOCUMENT_CLASS_DELETED, baseSpecification.getName()));
            }
        }
        return differences;
    }

    private Map<String, DocumentClassSpecification> convertToMap(List<DocumentClassSpecification> list) {
        HashMap<String, DocumentClassSpecification> map = new HashMap<String, DocumentClassSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (DocumentClassSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compare(String name, DocumentClassSpecification base, DocumentClassSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDescription(), (CharSequence)compared.getDescription())) {
            differences.add(this.differenceBuilder.build(DESCRIPTION_MODIFIED, name, base.getDescription(), compared.getDescription()));
        }
        return differences;
    }
}

