/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.SpecificationDescriptionPartBuilder;
import com.suncode.plugin.pwe.documentation.specification.DescriptionSpecification;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DescriptionSpecificationsSubcomparator {
    @Autowired
    private SpecificationDescriptionPartBuilder specificationDescriptionPartBuilder;
    @Autowired
    private DifferenceBuilder differenceBuilder;

    public List<Difference> compare(WorkflowProcess baseProcess, Map<String, ? extends DescriptionSpecification> base, WorkflowProcess comparedProcess, Map<String, ? extends DescriptionSpecification> compared, String addedKey, String deletedKey, String modifiedKey, TranslationInfo translationInfo) {
        return this.compare(null, baseProcess, base, comparedProcess, compared, addedKey, deletedKey, modifiedKey, translationInfo);
    }

    public List<Difference> compare(String containerId, WorkflowProcess baseProcess, Map<String, ? extends DescriptionSpecification> base, WorkflowProcess comparedProcess, Map<String, ? extends DescriptionSpecification> compared, String addedKey, String deletedKey, String modifiedKey, TranslationInfo translationInfo) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (MapUtils.isNotEmpty(base)) {
            for (String id : base.keySet()) {
                DescriptionSpecification baseSpecification = base.get(id);
                if (compared.containsKey(id) || !StringUtils.isNotBlank((CharSequence)baseSpecification.getDescription())) continue;
                differences.add(this.buildDeletedDifference(baseProcess, baseSpecification, deletedKey, containerId, id, translationInfo));
            }
        }
        if (MapUtils.isNotEmpty(compared)) {
            for (String id : compared.keySet()) {
                DescriptionSpecification comparedSpecification = compared.get(id);
                if (base.containsKey(id)) {
                    DescriptionSpecification baseSpecification = base.get(id);
                    if (StringUtils.isBlank((CharSequence)baseSpecification.getDescription()) && StringUtils.isNotBlank((CharSequence)comparedSpecification.getDescription())) {
                        differences.add(this.buildAddedDifference(comparedProcess, comparedSpecification, addedKey, containerId, id, translationInfo));
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)baseSpecification.getDescription()) && StringUtils.isBlank((CharSequence)comparedSpecification.getDescription())) {
                        differences.add(this.buildDeletedDifference(baseProcess, baseSpecification, deletedKey, containerId, id, translationInfo));
                        continue;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)baseSpecification.getDescription(), (CharSequence)comparedSpecification.getDescription())) continue;
                    differences.add(this.buildModifiedDifference(baseProcess, baseSpecification, comparedProcess, comparedSpecification, modifiedKey, containerId, id, translationInfo));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)comparedSpecification.getDescription())) continue;
                differences.add(this.buildAddedDifference(comparedProcess, comparedSpecification, addedKey, containerId, id, translationInfo));
            }
        }
        return differences;
    }

    private Difference buildAddedDifference(WorkflowProcess baseProcess, DescriptionSpecification baseSpecification, String addedKey, String containerId, String id, TranslationInfo translationInfo) {
        String baseDescription = this.buildDescription(baseProcess, translationInfo, baseSpecification);
        if (StringUtils.isNotBlank((CharSequence)containerId)) {
            return this.buildDifference(addedKey, baseDescription, id, containerId);
        }
        return this.buildDifference(addedKey, baseDescription, id);
    }

    private Difference buildDeletedDifference(WorkflowProcess comparedProcess, DescriptionSpecification comparedSpecification, String deletedKey, String containerId, String id, TranslationInfo translationInfo) {
        String comparedDescription = this.buildDescription(comparedProcess, translationInfo, comparedSpecification);
        if (StringUtils.isNotBlank((CharSequence)containerId)) {
            return this.buildDifference(deletedKey, comparedDescription, id, containerId);
        }
        return this.buildDifference(deletedKey, comparedDescription, id);
    }

    private Difference buildModifiedDifference(WorkflowProcess baseProcess, DescriptionSpecification baseSpecification, WorkflowProcess comparedProcess, DescriptionSpecification comparedSpecification, String modifiedKey, String containerId, String id, TranslationInfo translationInfo) {
        String baseDescription = this.buildDescription(baseProcess, translationInfo, baseSpecification);
        String comparedDescription = this.buildDescription(comparedProcess, translationInfo, comparedSpecification);
        if (StringUtils.isNotBlank((CharSequence)containerId)) {
            return this.buildDifference(modifiedKey, id, containerId, baseDescription, comparedDescription);
        }
        return this.buildDifference(modifiedKey, id, baseDescription, comparedDescription);
    }

    private Difference buildDifference(String key, Object ... arguments) {
        return this.differenceBuilder.build(key, arguments);
    }

    private String buildDescription(WorkflowProcess process, TranslationInfo translationInfo, DescriptionSpecification descriptionSpecification) {
        return this.specificationDescriptionPartBuilder.buildAsString(process, translationInfo, descriptionSpecification.getDescription());
    }
}

