/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Table;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.object.VariableSet;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VariableSetColumnsPointBuilder {
    private static final String NON_EDITABLE = "pwe.documentation.text.noneditable";
    private static final String EDITABLE = "pwe.documentation.text.editable";
    private static final String HIDDEN = "pwe.documentation.text.hidden";
    private static final String VARIABLE_NAME_TABLE_COLUMN_ID = "name";
    private static final String VARIABLE_NAME_TABLE_HEADER = "pwe.documentation.table.header.variablename";
    private static final String VARIABLE_STATUS_TABLE_COLUMN_ID = "status";
    private static final String VARIABLE_STATUS_TABLE_HEADER = "pwe.documentation.table.header.status";
    private static final String READONLY_EXT_ATTR_NAME = "READONLY";
    private static final String READONLY_EXT_ATTR_VALUE = "TRUE";
    @Autowired
    private TranslatorService translatorService;

    public Table build(WorkflowProcess process, VariableSet variableSet) {
        TableHeaders headers = this.buildTableHeaders();
        TableRecords records = new TableRecords();
        String noneditableStatus = this.translatorService.translateMessage(NON_EDITABLE);
        String editableStatus = this.translatorService.translateMessage(EDITABLE);
        String hiddenStatus = this.translatorService.translateMessage(HIDDEN);
        if (CollectionUtils.isNotEmpty(variableSet.getColumns())) {
            for (String column : variableSet.getColumns()) {
                DataField dataField = process.getDataField(column);
                if (this.isColumnHidden(variableSet, dataField)) {
                    records.add(this.buildTableRecord(dataField, hiddenStatus));
                    continue;
                }
                if (this.isColumnNoneditable(variableSet, dataField)) {
                    records.add(this.buildTableRecord(dataField, noneditableStatus));
                    continue;
                }
                records.add(this.buildTableRecord(dataField, editableStatus));
            }
        }
        Table table = new Table();
        table.setHeaders(headers);
        table.setRecords(records);
        return table;
    }

    private TableHeaders buildTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildTableVariableNameHeader());
        headers.add(this.buildTableStatusHeader());
        return headers;
    }

    private TableHeader buildTableVariableNameHeader() {
        return TableUtils.buildTableHeader(VARIABLE_NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(VARIABLE_NAME_TABLE_HEADER));
    }

    private TableHeader buildTableStatusHeader() {
        return TableUtils.buildTableHeader(VARIABLE_STATUS_TABLE_COLUMN_ID, this.translatorService.translateMessage(VARIABLE_STATUS_TABLE_HEADER));
    }

    private boolean isColumnHidden(VariableSet variableSet, DataField dataField) {
        return variableSet.getHiddenColumns().contains(dataField.getId());
    }

    private boolean isColumnNoneditable(VariableSet variableSet, DataField dataField) {
        return !variableSet.isEditable() || this.isVariableReadOnly(dataField) || variableSet.getReadOnlyColumns().contains(dataField.getId());
    }

    private boolean isVariableReadOnly(DataField dataField) {
        return ExtAttrUtils.hasExtAttr(dataField.getExtendedAttributes(), READONLY_EXT_ATTR_NAME, READONLY_EXT_ATTR_VALUE);
    }

    private TableRecord buildTableRecord(DataField dataField, String status) {
        TableRecord record = new TableRecord();
        record.addCell(VARIABLE_NAME_TABLE_COLUMN_ID, this.buildTableRecordVariableNameCell(dataField));
        record.addCell(VARIABLE_STATUS_TABLE_COLUMN_ID, this.buildTableRecordVariableStatusCell(status));
        return record;
    }

    private TableCell buildTableRecordVariableNameCell(DataField dataField) {
        String text = dataField.getName();
        String bookmarkName = this.buildBookmarkName(dataField);
        return TableUtils.buildTableCell(text, bookmarkName);
    }

    private String buildBookmarkName(DataField dataField) {
        return BookmarkNameUtils.getNameForProcessVariable(dataField.getId());
    }

    private TableCell buildTableRecordVariableStatusCell(String status) {
        return TableUtils.buildTableCell(status);
    }
}

