/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.NumberedPoint;
import com.suncode.plugin.pwe.documentation.NumberedPoints;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ViewDocumentClassSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import java.util.ArrayList;
import java.util.List;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityViewDocumentClassesPointBuilder")
public class ActivityViewDocumentClassesPointBuilderImpl
implements ActivityPointBuilder {
    private static final String POINT_TITLE = "pwe.documentation.point.title.viewdocumentclasses";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        NumberedPoints points = this.buildViewDocumentClassesNumberedPoints(activitySpecification);
        this.buildPoint(documentation, points);
    }

    private NumberedPoints buildViewDocumentClassesNumberedPoints(ActivitySpecification activitySpecification) {
        NumberedPoints points = new NumberedPoints();
        points.addPoint(this.buildNumberedPoint(this.buildViewDocumentClasses(activitySpecification.getViewDocumentClasses())));
        return points;
    }

    private List<String> buildViewDocumentClasses(List<ViewDocumentClassSpecification> viewDocumentClassSpecifications) {
        ArrayList<String> viewDocumentClasses = new ArrayList<String>();
        for (ViewDocumentClassSpecification viewDocumentClassSpecification : viewDocumentClassSpecifications) {
            viewDocumentClasses.add(viewDocumentClassSpecification.getName());
        }
        return viewDocumentClasses;
    }

    private NumberedPoint buildNumberedPoint(List<String> viewDocumentClasses) {
        NumberedPoint point = new NumberedPoint();
        point.setTitle(this.translatorService.translateMessage(POINT_TITLE));
        point.setSubPoints(this.buildSubPoints(viewDocumentClasses));
        return point;
    }

    private List<ParagraphContents> buildSubPoints(List<String> viewDocumentClasses) {
        ArrayList<ParagraphContents> subPoints = new ArrayList<ParagraphContents>();
        for (String viewDocumentClass : viewDocumentClasses) {
            subPoints.add(this.buildSubPoint(viewDocumentClass));
        }
        return subPoints;
    }

    private ParagraphContents buildSubPoint(String viewDocumentClass) {
        String bookmarkName = this.buildBookmarkName(viewDocumentClass);
        return ParagraphContentsUtils.build(viewDocumentClass, bookmarkName);
    }

    private String buildBookmarkName(String viewDocumentClass) {
        return BookmarkNameUtils.getNameForDocumentClass(viewDocumentClass);
    }

    private void buildPoint(Documentation documentation, NumberedPoints points) {
        this.subchapterBuilder.build(documentation, points);
    }
}

