/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.NumberedPoint;
import com.suncode.plugin.pwe.documentation.NumberedPoints;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.AssumptionsAndScopeSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.specification.TeamMemberSpecification;
import com.suncode.plugin.pwe.documentation.specification.TeamSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.DocumentationType;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="assumptionsAndScopeChapterBuilder")
public class AssumptionsAndScopeChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.assumptionsandscope";
    private static final String CLIENT_NAME_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.clientname";
    private static final String PROCESS_NAME_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.processname";
    private static final String ANALYSIS_TEAM_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.analysisteam";
    private static final String PROJECT_TEAM_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.projectteam";
    private static final String COMPANY_SIDE_POINT_TITLE = "pwe.documentation.point.title.companyside";
    private static final String CLIENT_SIDE_POINT_TITLE = "pwe.documentation.point.title.clientside";
    private static final String PROCESSES_PER_MONTH_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.processespermonth";
    private static final String USERS_IN_PROCESS_SUBCHAPTER_TITLE = "pwe.documentation.subchapter.title.usersinprocess";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, process, processSpecification, translationInfo, documentationConfig);
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        AssumptionsAndScopeSpecification assumptionsAndScope = processSpecification.getAssumptionsAndScope();
        Counter subchapterNo = new Counter(1);
        this.buildClientNameSubchapter(documentation, assumptionsAndScope, subchapterNo.getCountAndIncrement());
        this.buildProcessNameSubchapter(documentation, process, translationInfo, subchapterNo.getCountAndIncrement());
        this.buildAnalysisTeamSubchapter(documentation, assumptionsAndScope, subchapterNo.getCountAndIncrement());
        this.buildProjectTeamSubchapter(documentation, assumptionsAndScope, subchapterNo.getCountAndIncrement());
        if (this.isTechnicalDocumentation(documentationConfig)) {
            this.buildProcessesPerMonthSubchapter(documentation, assumptionsAndScope, subchapterNo.getCountAndIncrement());
            this.buildUsersInProcessSubchapter(documentation, assumptionsAndScope, subchapterNo.getCountAndIncrement());
        }
    }

    private void buildClientNameSubchapter(Documentation documentation, AssumptionsAndScopeSpecification assumptionsAndScope, int subchapterNo) {
        this.buildSubchapter(documentation, CLIENT_NAME_SUBCHAPTER_TITLE, assumptionsAndScope.getClientName(), subchapterNo);
    }

    private void buildProcessNameSubchapter(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, int subchapterNo) {
        String processName = this.translatorService.translateProcessName(translationInfo, process);
        this.buildSubchapter(documentation, PROCESS_NAME_SUBCHAPTER_TITLE, processName, subchapterNo);
    }

    private void buildAnalysisTeamSubchapter(Documentation documentation, AssumptionsAndScopeSpecification assumptionsAndScope, int subchapterNo) {
        NumberedPoints points = this.buildTeamNumberedPoints(assumptionsAndScope.getAnalysisTeam());
        this.buildSubchapter(documentation, ANALYSIS_TEAM_SUBCHAPTER_TITLE, points, subchapterNo);
    }

    private void buildProjectTeamSubchapter(Documentation documentation, AssumptionsAndScopeSpecification assumptionsAndScope, int subchapterNo) {
        NumberedPoints points = this.buildTeamNumberedPoints(assumptionsAndScope.getProjectTeam());
        this.buildSubchapter(documentation, PROJECT_TEAM_SUBCHAPTER_TITLE, points, subchapterNo);
    }

    private NumberedPoints buildTeamNumberedPoints(TeamSpecification teamSpecification) {
        NumberedPoints points = new NumberedPoints();
        points.addPoint(this.buildNumberedPoint(COMPANY_SIDE_POINT_TITLE, this.buildTeamMembers(teamSpecification.getCompanySideMembers())));
        points.addPoint(this.buildNumberedPoint(CLIENT_SIDE_POINT_TITLE, this.buildTeamMembers(teamSpecification.getClientSideMembers())));
        return points;
    }

    private List<String> buildTeamMembers(List<TeamMemberSpecification> teamMemberSpecifications) {
        ArrayList<String> teamMembers = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(teamMemberSpecifications)) {
            for (TeamMemberSpecification teamMemberSpecification : teamMemberSpecifications) {
                teamMembers.add(teamMemberSpecification.getName());
            }
        }
        return teamMembers;
    }

    private NumberedPoint buildNumberedPoint(String titleKey, List<String> list) {
        NumberedPoint point = new NumberedPoint();
        point.setTitle(this.translatorService.translateMessage(titleKey));
        point.setSubPoints(this.buildSubPoints(list));
        return point;
    }

    private List<ParagraphContents> buildSubPoints(List<String> list) {
        return ParagraphContentsUtils.build(list);
    }

    private boolean isTechnicalDocumentation(DocumentationConfigDto documentationConfig) {
        return DocumentationType.getByName(documentationConfig.getDocumentationType()) == DocumentationType.TECHNICAL;
    }

    private void buildProcessesPerMonthSubchapter(Documentation documentation, AssumptionsAndScopeSpecification assumptionsAndScope, int subchapterNo) {
        this.buildSubchapter(documentation, PROCESSES_PER_MONTH_SUBCHAPTER_TITLE, String.valueOf(assumptionsAndScope.getProcessesPerMonth()), subchapterNo);
    }

    private void buildUsersInProcessSubchapter(Documentation documentation, AssumptionsAndScopeSpecification assumptionsAndScope, int subchapterNo) {
        this.buildSubchapter(documentation, USERS_IN_PROCESS_SUBCHAPTER_TITLE, String.valueOf(assumptionsAndScope.getUsersInProcess()), subchapterNo);
    }

    private void buildSubchapter(Documentation documentation, String titleKey, String text, int subchapterNo) {
        this.subchapterBuilder.build(documentation, titleKey, text, subchapterNo);
    }

    private void buildSubchapter(Documentation documentation, String titleKey, NumberedPoints points, int subchapterNo) {
        this.subchapterBuilder.build(documentation, titleKey, points, subchapterNo);
    }
}

