/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.object.AcceptButton;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.AddFileButton;
import com.suncode.plugin.pwe.documentation.object.Button;
import com.suncode.plugin.pwe.documentation.object.FormButton;
import com.suncode.plugin.pwe.documentation.object.GeneratePdfButton;
import com.suncode.plugin.pwe.documentation.object.builder.ActivityFormBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.ActivityFormImageAdder;
import com.suncode.plugin.pwe.documentation.object.builder.ActivityListBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.ActivityPerformerParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.ActivityTypeBuilder;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ButtonSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.util.ActivityUtils;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.DocumentationType;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="activitiesDetailedDescriptionChapterBuilder")
public class ActivitiesDetailedDescriptionChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.activitiesdetaileddescription";
    private static final String TYPE_POINT_TITLE = "pwe.documentation.point.title.activitytype";
    private static final String PERFORMER_POINT_TITLE = "pwe.documentation.point.title.performer";
    private static final String FORM_POINT_TITLE = "pwe.documentation.point.title.form";
    private static final String FORM_BUTTONS_POINT_TITLE = "pwe.documentation.point.title.formbuttons";
    private static final String PRINT_BARCODE = "pwe.documentation.point.title.printbarcode";
    private static final String NEXT_ACTIVITY_EXT_ATTR_NAME = "NEXT_ACTIVITY";
    @Autowired
    private ActivityListBuilder activityListBuilder;
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private ActivityFormBuilder activityFormBuilder;
    @Autowired
    @Qualifier(value="activityTypePointBuilder")
    private ActivityPointBuilder activityTypePointBuilder;
    @Autowired
    @Qualifier(value="activityGeneralDescriptionPointBuilder")
    private ActivityPointBuilder activityGeneralDescriptionPointBuilder;
    @Autowired
    @Qualifier(value="activityPerformerPointBuilder")
    private ActivityPointBuilder activityPerformerPointBuilder;
    @Autowired
    @Qualifier(value="activityFormVariablesPointBuilder")
    private ActivityPointBuilder activityFormVariablesPointBuilder;
    @Autowired
    @Qualifier(value="activityVariableSetsPointBuilder")
    private ActivityPointBuilder activityVariableSetsPointBuilder;
    @Autowired
    @Qualifier(value="activityButtonsPointBuilder")
    private ActivityPointBuilder activityButtonsPointBuilder;
    @Autowired
    @Qualifier(value="activityFormActionsPointBuilder")
    private ActivityPointBuilder activityFormActionsPointBuilder;
    @Autowired
    @Qualifier(value="activityGeneratedDocumentsPointBuilder")
    private ActivityPointBuilder activityGeneratedDocumentsPointBuilder;
    @Autowired
    @Qualifier(value="activityAutomaticTransitionsPointBuilder")
    private ActivityPointBuilder activityAutomaticTransitionsPointBuilder;
    @Autowired
    @Qualifier(value="activityConcurrentAcceptancePointBuilder")
    private ActivityPointBuilder activityConcurrentAcceptancePointBuilder;
    @Autowired
    @Qualifier(value="activityNewDocumentAcceptancePointBuilder")
    private ActivityPointBuilder activityNewDocumentAcceptancePointBuilder;
    @Autowired
    @Qualifier(value="activityViewDocumentClassesPointBuilder")
    private ActivityPointBuilder activityViewDocumentClassesPointBuilder;
    @Autowired
    @Qualifier(value="activityTransitionsPointBuilder")
    private ActivityPointBuilder activityTransitionsPointBuilder;
    @Autowired
    @Qualifier(value="activityEmailNotificationsDescrptionPointBuilder")
    private ActivityPointBuilder activityEmailNotificationsDescrptionPointBuilder;
    @Autowired
    @Qualifier(value="activityFormPointBuilder")
    private ActivityPointBuilder activityFormPointBuilder;
    @Autowired
    private ActivityTypeBuilder activityTypeBuilder;
    @Autowired
    private ActivityPerformerParagraphContentsBuilder activityPerformerParagraphContentsBuilder;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private ActivityFormImageAdder activityFormImageAdder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, process, processSpecification, translationInfo, documentationConfig);
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        List<Activity> activities = this.buildActivitiesList(process, processSpecification, documentationConfig);
        if (CollectionUtils.isNotEmpty(activities)) {
            Counter subchapterNo = new Counter(1);
            boolean isBusinessDocumentationType = this.isBusinessDocumentationType(documentationConfig);
            for (Activity activity : activities) {
                String title = this.buildSubchapterTitle(process, translationInfo, activity, subchapterNo.getCountAndIncrement());
                String bookmarkName = this.buildBookmarkName(activity);
                documentation.addBookmarkedSubchapter(title, bookmarkName);
                if (isBusinessDocumentationType) {
                    this.buildBusinessSubchapterPart(documentation, process, processSpecification, translationInfo, activity);
                } else {
                    this.buildTechnicalSubchapterPart(documentation, process, processSpecification, translationInfo, activity);
                }
                documentation.addNewLine();
            }
        }
    }

    private List<Activity> buildActivitiesList(WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        return this.activityListBuilder.build(process, processSpecification, documentationConfig);
    }

    private boolean isBusinessDocumentationType(DocumentationConfigDto documentationConfig) {
        return DocumentationType.getByName(documentationConfig.getDocumentationType()) == DocumentationType.BUSINESS;
    }

    private void buildBusinessSubchapterPart(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, Activity activity) {
        ActivitySpecification activitySpecification = this.getActivitySpecification(processSpecification, activity);
        ActivityForm activityForm = this.buildActivityForm(process, activity);
        boolean isActivity = ActivityUtils.isActivity(process, activity);
        if (StringUtils.isNotBlank((CharSequence)activitySpecification.getGeneralActivityDescription())) {
            this.buildActivityDescriptionPoint(documentation, process, translationInfo, activitySpecification);
        }
        this.buildActivityTypePoint(documentation, activity);
        this.buildActivityPerformerPoint(documentation, process, translationInfo, activity);
        if (isActivity && StringUtils.isNotBlank((CharSequence)activitySpecification.getFormImage())) {
            this.buildActivityFormPoint(documentation, activity, activitySpecification);
        }
        if (isActivity && CollectionUtils.isNotEmpty(activityForm.getFormVariables())) {
            this.activityFormVariablesPointBuilder.build(documentation, process, translationInfo, activity, activitySpecification, activityForm);
        }
        if (isActivity && (CollectionUtils.isNotEmpty(activityForm.getFormButtons()) || CollectionUtils.isNotEmpty(activityForm.getAcceptButtons()) || CollectionUtils.isNotEmpty(activityForm.getGeneratePdfButtons()) || CollectionUtils.isNotEmpty(activityForm.getAddFileButtons()) || CollectionUtils.isNotEmpty(activityForm.getBarcodePrintButtons()))) {
            this.buildActivityFormButtonsPoint(documentation, process, translationInfo, activity, activitySpecification, activityForm);
        }
    }

    private void buildActivityDescriptionPoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, ActivitySpecification activitySpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, translationInfo, activitySpecification.getGeneralActivityDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(0));
        documentation.addParagraph(contents);
        documentation.addNewLine();
    }

    private void buildActivityTypePoint(Documentation documentation, Activity activity) {
        ParagraphContent labelContent = new ParagraphContent();
        labelContent.setTextValue(TextValueUtils.build(this.translatorService.translateMessage(TYPE_POINT_TITLE) + ": "));
        labelContent.setBold(true);
        String activityType = this.activityTypeBuilder.build(activity);
        ParagraphContent typeContent = new ParagraphContent();
        typeContent.setTextValue(TextValueUtils.build(activityType));
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(labelContent);
        contents.addContent(typeContent);
        documentation.addParagraph(contents);
        documentation.addNewLine();
    }

    private void buildActivityPerformerPoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity) {
        ParagraphContent labelContent = new ParagraphContent();
        labelContent.setTextValue(TextValueUtils.build(this.translatorService.translateMessage(PERFORMER_POINT_TITLE) + ": "));
        labelContent.setBold(true);
        ParagraphContents performerContents = this.activityPerformerParagraphContentsBuilder.build(process, translationInfo, activity);
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(labelContent);
        contents.addContents(performerContents);
        documentation.addParagraph(contents);
        documentation.addNewLine();
    }

    private void buildActivityFormPoint(Documentation documentation, Activity activity, ActivitySpecification activitySpecification) {
        this.addPointTitleContents(documentation, FORM_POINT_TITLE);
        this.activityFormImageAdder.add(documentation, activity, activitySpecification);
        documentation.addNewLine();
    }

    private void buildActivityFormButtonsPoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        this.addPointTitleContents(documentation, FORM_BUTTONS_POINT_TITLE);
        activityForm.getFormButtons().forEach(formButton -> {
            String translatedButtonName = this.translatorService.translateFormButtonName(translationInfo, process, activity, (FormButton)formButton);
            this.buildActivityFormButtonPoint(documentation, process, translationInfo, activitySpecification, (Button)formButton, translatedButtonName);
        });
        activityForm.getAcceptButtons().forEach(acceptButton -> {
            String translatedButtonName = this.translatorService.translateAcceptButtonButtonName(translationInfo, process, activity, (AcceptButton)acceptButton);
            this.buildActivityFormButtonPoint(documentation, process, translationInfo, activitySpecification, (Button)acceptButton, translatedButtonName);
        });
        activityForm.getAddFileButtons().forEach(addFileButton -> {
            String translatedButtonName = this.translatorService.translateAddFileButtonButtonName(translationInfo, process, activity, (AddFileButton)addFileButton);
            this.buildActivityFormButtonPoint(documentation, process, translationInfo, activitySpecification, (Button)addFileButton, translatedButtonName);
        });
        activityForm.getGeneratePdfButtons().forEach(generatePdfButton -> {
            String translatedButtonName = this.translatorService.translateGeneratePdfButtonButtonName(translationInfo, process, activity, (GeneratePdfButton)generatePdfButton);
            this.buildActivityFormButtonPoint(documentation, process, translationInfo, activitySpecification, (Button)generatePdfButton, translatedButtonName);
        });
        String printBarcodeButtonName = this.translatorService.translateMessage(PRINT_BARCODE);
        activityForm.getBarcodePrintButtons().forEach(barcodePrintButton -> this.buildActivityFormButtonPoint(documentation, process, translationInfo, activitySpecification, (Button)barcodePrintButton, printBarcodeButtonName));
    }

    private void buildActivityFormButtonPoint(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, ActivitySpecification activitySpecification, Button button, String translatedButtonName) {
        ButtonSpecification buttonSpecification = this.getButtonSpecification(activitySpecification, button);
        ParagraphContent buttonNameContent = new ParagraphContent();
        buttonNameContent.setTextValue(TextValueUtils.build(translatedButtonName));
        buttonNameContent.setUnderline(true);
        ParagraphContents buttonContents = new ParagraphContents();
        buttonContents.addContent(buttonNameContent);
        buttonContents.setIndents(ParagraphIndentsUtils.buildLeft(1));
        documentation.addParagraph(buttonContents);
        documentation.addNewLine();
        if (StringUtils.isNotBlank((CharSequence)buttonSpecification.getDescription())) {
            ParagraphContents descriptionContents = this.buildSpecificationDescriptionParagraphContents(process, translationInfo, buttonSpecification.getDescription());
            documentation.addParagraph(descriptionContents);
            documentation.addNewLine();
        }
    }

    private ButtonSpecification getButtonSpecification(ActivitySpecification activitySpecification, Button button) {
        String id = button.getActionName();
        if (MapUtils.isNotEmpty(activitySpecification.getButtonSpecifications()) && activitySpecification.getButtonSpecifications().containsKey(id)) {
            return activitySpecification.getButtonSpecifications().get(id);
        }
        return new ButtonSpecification();
    }

    private void addPointTitleContents(Documentation documentation, String pointTitleKey) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(TextValueUtils.build(this.translatorService.translateMessage(pointTitleKey) + ": "));
        content.setBold(true);
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(content);
        documentation.addParagraph(contents);
        documentation.addNewLine();
    }

    private void buildTechnicalSubchapterPart(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, Activity activity) {
        ActivitySpecification activitySpecification = this.getActivitySpecification(processSpecification, activity);
        ActivityForm activityForm = this.buildActivityForm(process, activity);
        List<ActivityPointBuilder> pointBuilders = this.buildPointBuilders(process, activity, activitySpecification, activityForm);
        this.buildPoints(documentation, process, translationInfo, activity, activitySpecification, activityForm, pointBuilders);
    }

    private String buildSubchapterTitle(WorkflowProcess process, TranslationInfo translationInfo, Activity activity, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(this.translatorService.translateActivityName(translationInfo, process, activity));
        return title.toString();
    }

    private String buildBookmarkName(Activity activity) {
        return BookmarkNameUtils.getNameForActivity(activity.getId());
    }

    private ActivitySpecification getActivitySpecification(ProcessSpecification processSpecification, Activity activity) {
        String id = activity.getId();
        if (MapUtils.isNotEmpty(processSpecification.getActivitySpecifications()) && processSpecification.getActivitySpecifications().containsKey(id)) {
            return processSpecification.getActivitySpecifications().get(id);
        }
        return new ActivitySpecification();
    }

    private ActivityForm buildActivityForm(WorkflowProcess process, Activity activity) {
        return this.activityFormBuilder.build(process, activity);
    }

    private List<ActivityPointBuilder> buildPointBuilders(WorkflowProcess process, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        boolean isActivity = ActivityUtils.isActivity(process, activity);
        ArrayList<ActivityPointBuilder> builders = new ArrayList<ActivityPointBuilder>();
        builders.add(this.activityTypePointBuilder);
        if (StringUtils.isNotBlank((CharSequence)activitySpecification.getGeneralActivityDescription())) {
            builders.add(this.activityGeneralDescriptionPointBuilder);
        }
        builders.add(this.activityPerformerPointBuilder);
        if (isActivity && CollectionUtils.isNotEmpty(activityForm.getFormVariables())) {
            builders.add(this.activityFormVariablesPointBuilder);
        }
        if (isActivity && CollectionUtils.isNotEmpty(activityForm.getVariableSets())) {
            builders.add(this.activityVariableSetsPointBuilder);
        }
        if (isActivity && (CollectionUtils.isNotEmpty(activityForm.getFormButtons()) || CollectionUtils.isNotEmpty(activityForm.getAcceptButtons()) || CollectionUtils.isNotEmpty(activityForm.getGeneratePdfButtons()) || CollectionUtils.isNotEmpty(activityForm.getAddFileButtons()) || CollectionUtils.isNotEmpty(activityForm.getBarcodePrintButtons()))) {
            builders.add(this.activityButtonsPointBuilder);
        }
        if (isActivity && CollectionUtils.isNotEmpty(activityForm.getFormActions())) {
            builders.add(this.activityFormActionsPointBuilder);
        }
        if (isActivity && CollectionUtils.isNotEmpty(activitySpecification.getGeneratedDocuments())) {
            builders.add(this.activityGeneratedDocumentsPointBuilder);
        }
        if (isActivity && this.hasAutomaticTransactions(activity)) {
            builders.add(this.activityAutomaticTransitionsPointBuilder);
        }
        if (isActivity) {
            builders.add(this.activityConcurrentAcceptancePointBuilder);
            builders.add(this.activityNewDocumentAcceptancePointBuilder);
        }
        if (isActivity && CollectionUtils.isNotEmpty(activitySpecification.getViewDocumentClasses())) {
            builders.add(this.activityViewDocumentClassesPointBuilder);
        }
        if (this.hasTransitions(process, activity)) {
            builders.add(this.activityTransitionsPointBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)activitySpecification.getEmailNotificationsDescription())) {
            builders.add(this.activityEmailNotificationsDescrptionPointBuilder);
        }
        if (isActivity && StringUtils.isNotBlank((CharSequence)activitySpecification.getFormImage())) {
            builders.add(this.activityFormPointBuilder);
        }
        return builders;
    }

    private boolean hasAutomaticTransactions(Activity activity) {
        ExtendedAttributes extAttrs = activity.getExtendedAttributes();
        return ExtAttrUtils.hasExtAttr(extAttrs, NEXT_ACTIVITY_EXT_ATTR_NAME);
    }

    private boolean hasTransitions(WorkflowProcess process, Activity activity) {
        ArrayList transitions = activity.getOutgoingTransitions();
        ArrayList endingActivities = process.getEndingActivities();
        if (CollectionUtils.isEmpty((Collection)transitions)) {
            if (CollectionUtils.isNotEmpty((Collection)endingActivities)) {
                for (Activity endingActivity : endingActivities) {
                    if (!endingActivity.equals((Object)activity)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private void buildPoints(Documentation documentation, WorkflowProcess process, TranslationInfo translationInfo, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm, List<ActivityPointBuilder> pointBuilders) {
        for (ActivityPointBuilder pointBuilder : pointBuilders) {
            pointBuilder.build(documentation, process, translationInfo, activity, activitySpecification, activityForm);
        }
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, TranslationInfo translationInfo, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, translationInfo, description);
    }
}

