/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.glossaryofterms.builder.GlossaryOfTermsBuilder;
import com.suncode.plugin.pwe.documentation.object.AttachmentSpecificationsHolder;
import com.suncode.plugin.pwe.documentation.object.UserIdHolder;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.systemlink.builder.SystemLinkBuilder;
import com.suncode.plugin.pwe.documentation.util.ActivityUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.DocumentationType;
import com.suncode.plugin.pwe.util.translation.TranslationInfo;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DocumentationBuilder {
    private static final String TITLE = "pwe.documentation.title";
    private static final String BUSINESS_SPECIFICATION = "pwe.documentation.businessspecification";
    private static final String TECHNICAL_SPECIFICATION = "pwe.documentation.technicalspecification";
    private static final String SPECIFICATION = "pwe.documentation.specification";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private GlossaryOfTermsBuilder glossaryOfTermsBuilder;
    @Autowired
    private SystemLinkBuilder systemLinkBuilder;
    @Autowired
    @Qualifier(value="assumptionsAndScopeChapterBuilder")
    private ChapterBuilder assumptionsAndScopeChapterBuilder;
    @Autowired
    @Qualifier(value="documentClassesListChapterBuilder")
    private ChapterBuilder documentClassesListChapterBuilder;
    @Autowired
    @Qualifier(value="documentLinksListChapterBuilder")
    private ChapterBuilder documentLinksListChapterBuilder;
    @Autowired
    @Qualifier(value="processParticipantsListChapterBuilder")
    private ChapterBuilder processParticipantsListChapterBuilder;
    @Autowired
    @Qualifier(value="processMapAndActivitiesListChapterBuilder")
    private ChapterBuilder processMapAndActivitiesListChapterBuilder;
    @Autowired
    @Qualifier(value="processVariablesListChapterBuilder")
    private ChapterBuilder processVariablesListChapterBuilder;
    @Autowired
    @Qualifier(value="activitiesDetailedDescriptionChapterBuilder")
    private ChapterBuilder activitiesDetailedDescriptionChapterBuilder;
    @Autowired
    @Qualifier(value="automaticTasksChapterBuilder")
    private ChapterBuilder automaticTasksChapterBuilder;
    @Autowired
    @Qualifier(value="databasesTablesChapterBuilder")
    private ChapterBuilder databasesTablesChapterBuilder;
    @Autowired
    @Qualifier(value="integrationsChapterBuilder")
    private ChapterBuilder integrationsChapterBuilder;
    @Autowired
    @Qualifier(value="projectExclusionsChapterBuilder")
    private ChapterBuilder projectExclusionsChapterBuilder;
    @Autowired
    @Qualifier(value="programmingTasksChapterBuilder")
    private ChapterBuilder programmingTasksChapterBuilder;
    @Autowired
    @Qualifier(value="scheduledTasksChapterBuilder")
    private ChapterBuilder scheduledTasksChapterBuilder;
    @Autowired
    @Qualifier(value="attachmentsChapterBuilder")
    private ChapterBuilder attachmentsChapterBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Documentation build(String userId, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) throws TransformerException {
        try {
            String systemLink;
            UserIdHolder.set(userId);
            AttachmentSpecificationsHolder.set(processSpecification.getAttachmentSpecifications());
            Documentation documentation = this.buildDocumentation(process, translationInfo, documentationConfig);
            if (this.shouldBuildGlossaryOfTerms(documentationConfig)) {
                this.buildGlossaryOfTerms(documentation);
            }
            if (this.shouldBuildSystemLink(documentationConfig, systemLink = processSpecification.getAssumptionsAndScope().getSystemLink())) {
                this.buildSystemLink(documentation, systemLink);
            }
            this.buildChapters(documentation, process, processSpecification, translationInfo, documentationConfig);
            Documentation documentation2 = documentation;
            return documentation2;
        }
        finally {
            UserIdHolder.reset();
            AttachmentSpecificationsHolder.reset();
        }
    }

    private Documentation buildDocumentation(WorkflowProcess process, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        String title = this.getTitle();
        String subtitle = this.getSubtitle(process, translationInfo, documentationConfig);
        return new Documentation(title, subtitle);
    }

    private String getTitle() {
        return this.translatorService.translateMessage(TITLE);
    }

    private String getSubtitle(WorkflowProcess process, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        StringBuilder subtitle = new StringBuilder();
        switch (DocumentationType.getByName(documentationConfig.getDocumentationType())) {
            case BUSINESS: {
                subtitle.append(this.translatorService.translateMessage(BUSINESS_SPECIFICATION));
                break;
            }
            case TECHNICAL: {
                subtitle.append(this.translatorService.translateMessage(TECHNICAL_SPECIFICATION));
                break;
            }
            default: {
                subtitle.append(this.translatorService.translateMessage(SPECIFICATION));
            }
        }
        subtitle.append(" - ");
        subtitle.append(this.translatorService.translateProcessName(translationInfo, process));
        return subtitle.toString();
    }

    private boolean shouldBuildGlossaryOfTerms(DocumentationConfigDto documentationConfig) {
        return DocumentationType.getByName(documentationConfig.getDocumentationType()) == DocumentationType.TECHNICAL;
    }

    private void buildGlossaryOfTerms(Documentation documentation) {
        this.glossaryOfTermsBuilder.build(documentation);
    }

    private boolean shouldBuildSystemLink(DocumentationConfigDto documentationConfig, String systemLink) {
        return BooleanUtils.isTrue((Boolean)documentationConfig.getSystemLink()) && StringUtils.isNotBlank((CharSequence)systemLink);
    }

    private void buildSystemLink(Documentation documentation, String systemLink) {
        this.systemLinkBuilder.build(documentation, systemLink);
    }

    private void buildChapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, TranslationInfo translationInfo, DocumentationConfigDto documentationConfig) {
        List<ChapterBuilder> builders = this.getChapterBuilders(process, processSpecification, documentationConfig);
        for (ChapterBuilder builder : builders) {
            builder.build(documentation, process, processSpecification, translationInfo, documentationConfig);
        }
    }

    private List<ChapterBuilder> getChapterBuilders(WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        ArrayList<ChapterBuilder> builders = new ArrayList<ChapterBuilder>();
        builders.add(this.assumptionsAndScopeChapterBuilder);
        if (BooleanUtils.isTrue((Boolean)documentationConfig.getRolesList())) {
            builders.add(this.processParticipantsListChapterBuilder);
        }
        builders.add(this.processMapAndActivitiesListChapterBuilder);
        if (!process.getDataFields().isEmpty()) {
            builders.add(this.processVariablesListChapterBuilder);
        }
        builders.add(this.activitiesDetailedDescriptionChapterBuilder);
        if (this.shouldBuildAutomaticTasksChapter(process, documentationConfig)) {
            builders.add(this.automaticTasksChapterBuilder);
        }
        if (BooleanUtils.isTrue((Boolean)documentationConfig.getDatabaseTables()) && CollectionUtils.isNotEmpty(processSpecification.getDatabaseTableSpecifications())) {
            builders.add(this.databasesTablesChapterBuilder);
        }
        if (BooleanUtils.isTrue((Boolean)documentationConfig.getIntegrations()) && CollectionUtils.isNotEmpty(processSpecification.getIntegrationSpecifications())) {
            builders.add(this.integrationsChapterBuilder);
        }
        if (CollectionUtils.isNotEmpty(processSpecification.getProgrammingTaskSpecifications())) {
            builders.add(this.programmingTasksChapterBuilder);
        }
        if (BooleanUtils.isTrue((Boolean)documentationConfig.getScheduledTasks()) && CollectionUtils.isNotEmpty(processSpecification.getScheduledTaskSpecifications())) {
            builders.add(this.scheduledTasksChapterBuilder);
        }
        if (CollectionUtils.isNotEmpty(processSpecification.getDocumentClassSpecifications())) {
            builders.add(this.documentClassesListChapterBuilder);
        }
        if (CollectionUtils.isNotEmpty(processSpecification.getDocumentLinkSpecifications())) {
            builders.add(this.documentLinksListChapterBuilder);
        }
        if (BooleanUtils.isTrue((Boolean)documentationConfig.getProjectExclusions()) && CollectionUtils.isNotEmpty(processSpecification.getProjectExclusionSpecifications())) {
            builders.add(this.projectExclusionsChapterBuilder);
        }
        if (BooleanUtils.isTrue((Boolean)documentationConfig.getAttachments()) && CollectionUtils.isNotEmpty(processSpecification.getAttachmentSpecifications())) {
            builders.add(this.attachmentsChapterBuilder);
        }
        return builders;
    }

    private boolean shouldBuildAutomaticTasksChapter(WorkflowProcess process, DocumentationConfigDto documentationConfig) {
        return this.hasAnyAutomaticTask(process) && BooleanUtils.isTrue((Boolean)documentationConfig.getShowSystemTasks());
    }

    private boolean hasAnyAutomaticTask(WorkflowProcess process) {
        Activities activities = process.getActivities();
        if (!activities.isEmpty()) {
            for (int i = 0; i < activities.size(); ++i) {
                Activity activity = (Activity)activities.get(i);
                if (!ActivityUtils.isTool(process, activity)) continue;
                return true;
            }
        }
        return false;
    }
}

