/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.dao.permission;

import com.suncode.plugin.pwe.dao.permission.PermissionDao;
import com.suncode.plugin.pwe.model.permission.Permission;
import com.suncode.plugin.pwe.util.PermissionFilter;
import com.suncode.plugin.pwe.util.PermissionScope;
import com.suncode.plugin.pwe.util.SortDirection;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class PermissionDaoImpl
extends HibernateEditableDao<Permission, Long>
implements PermissionDao {
    @Override
    public List<Permission> get(PermissionFilter filter, int offset, int limit, String sortColumnName, SortDirection direction) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Permission.class);
        criteria = this.applyFilter(filter, criteria);
        criteria.addOrder(this.buildOrder(sortColumnName, direction));
        return this.findByCriteria(criteria, offset, limit);
    }

    private DetachedCriteria applyFilter(PermissionFilter filter, DetachedCriteria criteria) {
        if (StringUtils.isNotBlank((CharSequence)filter.getScope())) {
            criteria.add((Criterion)Restrictions.eq((String)"scope", (Object)filter.getScope()));
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getValue())) {
            criteria.add(Restrictions.ilike((String)"value", (Object)("%" + filter.getValue() + "%")));
        }
        return criteria;
    }

    private Order buildOrder(String sortColumnName, SortDirection direction) {
        switch (direction) {
            case DESC: {
                return Order.desc((String)sortColumnName);
            }
        }
        return Order.asc((String)sortColumnName);
    }

    @Override
    public long count(PermissionFilter filter) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Permission.class);
        criteria = this.applyFilter(filter, criteria);
        return this.countByCriteria(criteria);
    }

    @Override
    public Permission get(String scope, String value) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Permission.class);
        criteria.add((Criterion)Restrictions.eq((String)"scope", (Object)scope));
        criteria.add((Criterion)Restrictions.eq((String)"value", (Object)value));
        return (Permission)this.findOne(criteria);
    }

    @Override
    public List<Permission> get(String userId, List<String> userGroupNames) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Permission.class);
        Disjunction disjunction = Restrictions.disjunction();
        disjunction.add(this.buildUserIdCriterion(userId));
        if (CollectionUtils.isNotEmpty(userGroupNames)) {
            for (String userGroupName : userGroupNames) {
                disjunction.add(this.buildUserGroupNameCriterion(userGroupName));
            }
        }
        criteria.add((Criterion)disjunction);
        return this.findByCriteria(criteria);
    }

    private Criterion buildUserIdCriterion(String userId) {
        return Restrictions.and((Criterion)Restrictions.eq((String)"scope", (Object)PermissionScope.USER.getName()), (Criterion)Restrictions.eq((String)"value", (Object)userId));
    }

    private Criterion buildUserGroupNameCriterion(String userGroupName) {
        return Restrictions.and((Criterion)Restrictions.eq((String)"scope", (Object)PermissionScope.GROUP.getName()), (Criterion)Restrictions.eq((String)"value", (Object)userGroupName));
    }
}

