/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.dao.jscode;

import com.suncode.plugin.pwe.dao.jscode.JsCodeDao;
import com.suncode.plugin.pwe.model.jscode.JsCode;
import com.suncode.pwfl.support.HibernateEditableDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.ReturningWork;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JsCodeDaoImpl
extends HibernateEditableDao<JsCode, Long>
implements JsCodeDao {
    private static final String GET_BY_FUNCTION_NAME_QUERY = "select id, function_name, code_author, source_code from pm_pwe_js_code where function_name = ?";
    private static final String GET_ALL_BY_FUNCTION_NAME_QUERY = "select id, function_name, code_author, source_code from pm_pwe_js_code where function_name in (?)";

    @Override
    @Transactional
    public JsCode getByFunctionName(String functionName) {
        try {
            return (JsCode)this.findOneByProperty("functionName", functionName, new String[0]);
        }
        catch (Exception exception) {
            return this.getByFunctionNameWithSql(functionName);
        }
    }

    @Override
    @Transactional
    public List<JsCode> getAllByFunctionName(List<String> functionNames) {
        try {
            DetachedCriteria criteria = DetachedCriteria.forClass(JsCode.class);
            criteria.add(Restrictions.in((String)"functionName", functionNames));
            return this.findByCriteria(criteria);
        }
        catch (Exception exception) {
            return this.getAllByFunctionNameWithSql(functionNames);
        }
    }

    private JsCode getByFunctionNameWithSql(final String functionName) {
        return (JsCode)this.getSession().doReturningWork((ReturningWork)new ReturningWork<JsCode>(){

            public JsCode execute(Connection connection) throws SQLException {
                ResultSet resultSet = JsCodeDaoImpl.this.getResultSet(connection, JsCodeDaoImpl.GET_BY_FUNCTION_NAME_QUERY, functionName);
                if (resultSet.next()) {
                    return JsCodeDaoImpl.this.buildJsCode(resultSet);
                }
                return null;
            }
        });
    }

    private List<JsCode> getAllByFunctionNameWithSql(final List<String> functionNames) {
        return (List)this.getSession().doReturningWork((ReturningWork)new ReturningWork<List<JsCode>>(){

            public List<JsCode> execute(Connection connection) throws SQLException {
                ResultSet resultSet = JsCodeDaoImpl.this.getResultSet(connection, JsCodeDaoImpl.GET_ALL_BY_FUNCTION_NAME_QUERY, StringUtils.join((Collection)functionNames, (String)", "));
                ArrayList<JsCode> jsCodes = new ArrayList<JsCode>();
                while (resultSet.next()) {
                    jsCodes.add(JsCodeDaoImpl.this.buildJsCode(resultSet));
                }
                return jsCodes;
            }
        });
    }

    private ResultSet getResultSet(Connection connection, String query, String parameter) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(query);
        statement.setString(1, parameter);
        return statement.executeQuery();
    }

    private JsCode buildJsCode(ResultSet resultSet) throws SQLException {
        JsCode jsCode = new JsCode();
        jsCode.setId(resultSet.getLong(1));
        jsCode.setFunctionName(resultSet.getString(2));
        jsCode.setCodeAuthor(resultSet.getString(3));
        jsCode.setSourceCode(resultSet.getString(4));
        return jsCode;
    }
}

