function startPlusWorkflowEditor( config, autoSaved ) {
    IEWorkarounds();
    initQuickTips();
    initPrototypeFunctions();
    ExtOverrides();
    Ext.ux.suncode.I18NService.initI18N( config.language, config.supportedLanguages, config.currentActivityMapMode );

    Ext.Ajax.request( {
        url: 'api/userconfig/get',
        method: 'GET',
        params: {
        	canUseDefaultUserConfig: config.canUseDefaultUserConfig
        },
        success: function( response, opts ) {
            if ( !Ext.isEmpty( response.responseText ) ) {
                var userConfig = Ext.util.JSON.decode( response.responseText );
                Ext.ux.suncode.I18NService.setXpdlTranslationLanguage( userConfig.xpdlTranslationLanguage );

                var win = new Ext.ux.suncode.LoadingWindow( {
                    userConfig: userConfig,
                    startConfig: config,
                    autoSaved: autoSaved
                } );
                win.show();
            } else {
                var win = new Ext.ux.suncode.InitWindow( {
                    startConfig: config,
                    autoSaved: autoSaved
                } );
                win.show();
            }
        },
        failure: function( response, opts ) {
            Ext.Msg.show( {
                title: '<font weight="bold">Error</font>',
                msg: 'Plus Workflow Editor cannot be started.',
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.ERROR
            } );
        }
    } );
}

Ext.ux.suncode.LoadingWindow = function( config ) {
    config = Ext.apply( {
        autoWidth: true,
        autoHeight: true,
        frame: false,
        closable: false,
        modal: true,
        constrain: true,
        shadow: false,
        resizable: false,
        border: false,
        cls: 'x-Module-window-header-hidden',
        id: 'loading_window',
        items: [ new Ext.ux.suncode.LogoPanel(), new Ext.ux.suncode.ProgressBarPanel() ]
    }, config );

    Ext.ux.suncode.LoadingWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.LoadingWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.LoadingWindow.superclass.initComponent.call( this );

        this.on( 'afterrender', this.createMainPanel, this );
    },
    createMainPanel: function() {
        this.loadingPanel.progressBar.updateProgress( 0.1, getTranslation( 'Tworzenie środowiska pracy...' ), true );

        var mainPanel = new Ext.ux.suncode.MainPanel( {
            userConfig: this.initialConfig.userConfig,
            editionMode: this.initialConfig.startConfig.editionMode,
            currentActivityMapMode: this.initialConfig.startConfig.currentActivityMapMode,
            simulationMode: this.initialConfig.startConfig.simulationMode,
            processPreviewMode: this.initialConfig.startConfig.processPreviewMode,
            systemType: this.initialConfig.startConfig.systemType,
            version: this.initialConfig.startConfig.version
        } );

        if ( this.initialConfig.startConfig.currentActivityMapMode ) {
            Raphael.fn.bpmn.activateCurrentActivityMapMode();
            mainPanel.setCurrentActivityMapMode( this.initialConfig.startConfig.simulation );
            this.beforeStartWork();
        } else if ( this.initialConfig.startConfig.simulationMode ) {
            Raphael.fn.bpmn.activateSimulationMode();
            mainPanel.setSimulationMode( this.initialConfig.startConfig.simulation );
            this.beforeStartWork();
        } else if ( this.initialConfig.startConfig.processPreviewMode ) {
            Raphael.fn.bpmn.activateProcessPreviewMode();
            mainPanel.setProcessPreviewMode();
            this.beforeStartWork();
        } else {
            var ctrlKeys = [ Ext.EventObject.N, Ext.EventObject.S, Ext.EventObject.P, Ext.EventObject.G, Ext.EventObject.E, Ext.EventObject.W,
                            Ext.EventObject.B, Ext.EventObject.T, Ext.EventObject.O, Ext.EventObject.R, Ext.EventObject.F5 ];
            var nonCtrlKeys = [ Ext.EventObject.F1, Ext.EventObject.F2, Ext.EventObject.F5 ];
            document.onkeydown = function( e ) {
                var ev = null;
                var keyCode = '';

                if ( e == null ) {
                    ev = event;
                    keyCode = event.keyCode;
                } else {
                    ev = e;
                    keyCode = e.which;
                }

                if ( ( ev.ctrlKey && !ev.altKey && ctrlKeys.indexOf( keyCode ) != -1 ) || nonCtrlKeys.indexOf( keyCode ) != -1 ) {
                    return false;
                }
            };
            document.onclick = function( e ) {
                var ev = null;

                if ( e == null ) {
                    ev = event;
                } else {
                    ev = e;
                }

                if ( ev.ctrlKey ) {
                    return false;
                }
            };
            document.oncontextmenu = function() {
                return false;
            };
            window.onbeforeunload = function( e ) {
            	var mainPanel = Ext.getCmp( 'main_panel' );

            	if ( mainPanel.shouldCheckSavedOnUnload() ) {
                logPluginCloseAudit();

                if ( !mainPanel.isSaved() ) {
                  autoSave();
                  e.returnValue = 'Page not saved';

                  return 'Page not saved';
                }
            	}

              return;
            };

            if ( parent.window.addEventListener ) {
                parent.window.addEventListener( 'DOMMouseScroll', wheel, false );
            } else {
                parent.window.onmousewheel = parent.document.onmousewheel = wheel;
            }

            addHotkeys();
            setDistinctionColorCssRules( this.initialConfig.userConfig.distinctionColor );

            var me = this;
            var standardDataChoosersPromise = new Promise( function ( resolve ) {
                me.getStandardDataChoosers( function() {
                    resolve();
                } );
            } );

            var standardAutoUpdatesPromise = new Promise( function ( resolve ) {
                me.getStandardAutoUpdates( function() {
                    resolve();
                } );
            } );

            var acceptValidatorsPromise = new Promise( function ( resolve ) {
                me.getAcceptValidators( function() {
                    resolve();
                } );
            } );

            var variableSettersPromise = new Promise( function ( resolve ) {
                me.getVariablesSetters( function() {
                    resolve();
                } );
            } );

            var systemFunctions = new Promise( function ( resolve ) {
                me.getSystemFunctions( function() {
                    resolve();
                } );
            } );

            Promise.all( [ standardDataChoosersPromise,
                           standardAutoUpdatesPromise,
                           acceptValidatorsPromise,
                           variableSettersPromise,
                           systemFunctions ] )
                   .then( function() {
                	   me.getIntegrationComponents();
                	   } );
        }
    },
    getStandardDataChoosers: function( callback ) {
        this.loadingPanel.progressBar.updateProgress( 0.2, getTranslation( 'Pobieranie systemowych dynamicznych list...' ), true );

        Ext.Ajax.request( {
            url: 'api/standarddatachooser/get',
            method: 'GET',
            scope: this,
            success: function( response, opts ) {
                var dataChoosers = Ext.util.JSON.decode( response.responseText );
                Ext.getCmp( 'main_panel' ).setStandardDataChoosers( dataChoosers );
                callback();
            },
            failure: function( response, opts ) {
                callback();
            }
        } );
    },
    getStandardAutoUpdates: function( callback ) {
        this.loadingPanel.progressBar.updateProgress( 0.3, getTranslation( 'Pobieranie systemowych akcji formularza...' ), true );

        Ext.Ajax.request( {
            url: 'api/standardautoupdate/get',
            method: 'GET',
            scope: this,
            success: function( response, opts ) {
                var autoUpdates = Ext.util.JSON.decode( response.responseText );
                Ext.getCmp( 'main_panel' ).setStandardAutoUpdates( autoUpdates );
                callback();
            },
            failure: function( response, opts ) {
                callback();
            }
        } );
    },
    getAcceptValidators: function( callback ) {
    	this.loadingPanel.progressBar.updateProgress( 0.4, getTranslation( 'Pobieranie mechanizmów sprawdzających formularz...' ), true );
    	
        Ext.Ajax.request( {
            url: 'api/acceptvalidator/get',
            method: 'GET',
            scope: this,
            success: function( response, opts ) {
                var validators = Ext.util.JSON.decode( response.responseText );
                Ext.getCmp( 'main_panel' ).setAcceptValidators( validators );
                callback();
            },
            failure: function( response, opts ) {
                callback();
            }
        } );
    },
    getVariablesSetters: function( callback ) {
        this.loadingPanel.progressBar.updateProgress( 0.5, getTranslation( 'Pobieranie mechanizmów uruchamianych po akceptacji...' ), true );

        Ext.Ajax.request( {
            url: 'api/variablessetter/get',
            method: 'GET',
            scope: this,
            success: function( response, opts ) {
                var variablesSetters = Ext.util.JSON.decode( response.responseText );
                Ext.getCmp( 'main_panel' ).setVariablesSetters( variablesSetters );
                callback();
            },
            failure: function( response, opts ) {
                callback();
            }
        } );
    },
    getSystemFunctions: function( callback ) {
        this.loadingPanel.progressBar.updateProgress( 0.6, getTranslation( 'Pobieranie funkcji systemowych...' ), true );
        
        Ext.Ajax.request( {
            url: Suncode.context( 'pwe' ).contextPath + '/api/functions',
            method: 'GET',
            scope: this,
            success: function( response, opts ) {
                var systemFunctions = Ext.util.JSON.decode( response.responseText );
                Ext.getCmp( 'main_panel' ).setSystemFunctions( systemFunctions );
                callback();
            },
            failure: function( response, opts ) {
            	callback();
            }
        } );
    },
    getIntegrationComponents: function() {
        this.loadingPanel.progressBar.updateProgress( 0.7, getTranslation( 'Pobieranie komponentów integracyjnych...' ), true );
        Ext.getCmp( 'main_panel' ).loadIntegrationComponents( new Ext.ux.suncode.RunnableTask( {
            handler: this.getEvents,
            scope: this,
            args: []
        } ) );
    },
    getEvents: function() {
      Ext.Ajax.request({
        url: Suncode.context('pwe').contextPath + '/api/workflow/form/events',
        method: 'GET',
        scope: this,
        success: function (response, opts) {
          var events = Ext.util.JSON.decode(response.responseText);
          var categories = new Object();

          if (!Ext.isEmpty(events.actions)) {
            Ext.each(events.actions, function (event, eventIndex, allEvents) {
              var eventCategories = event.categories;

              if (!Ext.isEmpty(eventCategories)) {
                Ext.each(eventCategories,
                    function (eventCategory, eventCategoryIndex,
                        allEventCategories) {
                      if (!Ext.isDefined(categories[eventCategory])) {
                        categories[eventCategory] = new Array();
                      }

                      categories[eventCategory].push(event);
                    });
              }
            });
          }

          Ext.getCmp('main_panel').setEventTypes(events.elements);
          Ext.getCmp('main_panel').setEventActionsCategories(categories);
          this.getSystemColors();
        },
        failure: function (response, opts) {
          this.getSystemColors();
        }
      });
    },
    getSystemColors: function() {
      this.loadingPanel.progressBar.updateProgress( 0.85, getTranslation( 'Pobieranie kolorów systemowych...' ), true );
      Ext.Ajax.request( {
        url: Suncode.context( 'pwe' ).contextPath + '/api/ui/colors',
        method: 'GET',
        scope: this,
        success: function( response, opts ) {
          var systemColors = Ext.util.JSON.decode( response.responseText );
          Ext.getCmp( 'main_panel' ).setSystemColors( systemColors );
          this.getGlobalConfig();
        },
        failure: function( response, opts ) {
          this.getGlobalConfig();
        }
      } );
    },
    getGlobalConfig: function() {
        this.loadingPanel.progressBar.updateProgress( 0.8, getTranslation( 'Pobieranie ustawień globalnych...' ), true );

        Ext.Ajax.request( {
            url: 'api/globalconfig/get',
            method: 'GET',
            scope: this,
            success: function( response, opts ) {
                var globalConfig = Ext.util.JSON.decode( response.responseText );
                Ext.getCmp( 'main_panel' ).setGlobalConfig( globalConfig );
                Ext.getCmp( 'package_panel' ).getRootNode().setPackageAuthor( globalConfig.userName );
                this.beforeStartWork();
            },
            failure: function( response, opts ) {
                this.beforeStartWork();
            }
        } );
    },
    beforeStartWork: function() {
        this.loadingPanel.progressBar.updateProgress( 1.0, '', true );

        if ( this.initialConfig.userConfig.animationsOn ) {
            this.getEl().ghost( 't', {
                easing: 'easeOut',
                duration: 0.5,
                remove: false,
                useDisplay: false,
                scope: this,
                callback: this.startWork
            } );
        } else {
            this.startWork();
        }
    },
    startWork: function( openFileAfterStart ) {
    	this.close();
        var currentActivityMapMode = this.initialConfig.startConfig.currentActivityMapMode;
        var simulationMode = this.initialConfig.startConfig.simulationMode;
        var processPreviewMode = this.initialConfig.startConfig.processPreviewMode;
        var processDefId = '';

        if ( currentActivityMapMode || simulationMode ) {
            processDefId = this.initialConfig.startConfig.simulation.processDefId;
        } else if ( processPreviewMode ) {
            processDefId = this.initialConfig.startConfig.processPreview.processDefId;
        }

        if ( currentActivityMapMode || simulationMode || processPreviewMode ) {
            var formPanel = new Ext.FormPanel( {
                renderTo: document.body,
                hidden: true,
                items: [ {
                    xtype: 'textfield',
                    name: 'processDefId',
                    value: processDefId
                } ]
            } );
            var form = formPanel.getForm();
            form.submit( {
                url: 'api/xpdl/openProcess',
                waitMsg: getTranslation( 'Trwa przetwarzanie pliku...' ),
                waitTitle: getTranslation( 'Proszę czekać' ),
                method: 'POST',
                success: function( form, action ) {
                    if ( action.result.success ) {
                        if ( !Ext.isEmpty( action.result.xpdlTranslations ) ) {
                          Ext.ux.suncode.I18NService.loadAllPackageTranslations(
                              Ext.util.JSON.decode( decodeXpdlTranslations( action.result.xpdlTranslations ) ) );
                        }
                        readXpdl( Ext.util.JSON.decode( action.result.xpdl ), processDefId );
                        initMissingFormTemplates();

                        Ext.Ajax.request( {
                            url: 'api/simulationconfig/get',
                            method: 'GET',
                            success: function( response, opts ) {
                                var simulationConfig = Ext.util.JSON.decode( response.responseText ).data;

                                if ( simulationConfig.fitMap ) {
                                    var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
                                    paper.bpmn.fitProcessMapSize( paper );
                                }

                                if ( currentActivityMapMode ) {
                                    var simulInfo = Ext.getCmp( 'main_panel' ).getSimulationInfo();
                                    simulationConfig = Ext.apply( simulInfo, simulationConfig );
                                    simulationConfig = Ext.apply( {
                                        fastFlow: true
                                    }, simulationConfig );
                                    var paper = Ext.getCmp( 'paper_panel' ).getActiveTab().paper;
                                    paper.simul.markCurrentActivity( simulationConfig );
                                }
                            },
                            failure: function( response, opts ) {
                            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
                            }
                        } );
                    } else {
                        showWarn( getTranslation( 'Wystąpił błąd.' ) );
                    }
                },
                failure: function( form, action ) {
                	showServerFailure( action.response );
                }
            } );

            var task = new Ext.util.DelayedTask( function() {
                formPanel.destroy();
            }, this );
            task.delay( 3000 );
        } else {
        	var autoSaved = this.initialConfig.autoSaved;
        	
        	if ( !Ext.isEmpty( autoSaved ) ) {
            	var win = new Ext.ux.suncode.AutoSavedWindow( {
            		files: autoSaved
            	} );
            	win.show();
            }
        }
    }
} );

Ext.ux.suncode.LogoPanel = function() {
    var config = new Object();

    config = Ext.apply( {
        width: 320,
        height: 300,
        border: false,
        items: [ {
            xtype: 'component',
            autoEl: {
                tag: 'img',
                src: getPluginImgPath( 'suncode_logo' )
            }
        } ]
    }, config );

    Ext.ux.suncode.LogoPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.LogoPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.LogoPanel.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ProgressBarPanel = function() {
    var config = new Object();

    config = Ext.apply( {
        ref: 'loadingPanel',
        items: [ {
            xtype: 'progress',
            ref: 'progressBar',
            text: '<center>' + getTranslation( 'Trwa uruchamianie programu...' ) + '</center>'
        } ]
    }, config );

    Ext.ux.suncode.ProgressBarPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProgressBarPanel, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.ProgressBarPanel.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.InitWindow = function( config ) {
    var xpdlTranslationLanguages = this.buildXpdlTranslationLanguages();

    config = Ext.apply( {
        modal: false,
        width: 400,
        autoHeight: true,
        title: getTranslation( 'Konfiguracja' ),
        closable: false,
        iconCls: 'x-Module-initWindow',
        initializing: false,
        items: [ {
            xtype: 'panel',
            frame: false,
            border: false,
            bodyCssClass: 'x-Module-container-padding',
            layout: 'form',
            layoutConfig: {
                trackLabels: true
            },
            labelWidth: 150,
            buttonAlign: 'center',
            ref: 'initPanel',
            items: [ {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Widok zaawansowany' ),
                anchor: '100%',
                ref: 'advancedViewItem',
                checked: false,
                inputValue: 'true'
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Widok eksperymentalny' ),
                anchor: '100%',
                ref: 'experimentalViewItem',
                checked: false,
                inputValue: 'true'
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Pokaż podpowiedzi' ),
                anchor: '100%',
                ref: 'showTooltipsItem',
                checked: true,
                inputValue: 'true'
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Animacje' ),
                anchor: '100%',
                ref: 'animationsOnItem',
                checked: false,
                inputValue: 'true',
                listeners: {
                    scope: this,
                    check: this.onAnimationsChange
                }
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Widok dokumentacji' ),
                anchor: '100%',
                ref: 'documentationViewItem',
                checked: false,
                inputValue: 'true'
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Pokaż przestarzałe komponenty' ),
                anchor: '100%',
                ref: 'showDeprecatedComponentsItem',
                checked: false,
                inputValue: 'true'
            }, {
              xtype: 'checkbox',
              fieldLabel: getTranslation( 'Użyj zewnętrznego schowka' ),
              anchor: '100%',
              ref: 'useExternalClipboardItem',
              checked: false,
              inputValue: 'true'
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Przyciąganie do siatki' ),
                anchor: '100%',
                ref: 'snapToGridItem',
                checked: false,
                inputValue: 'true',
                listeners: {
                	scope: this,
                	check: this.onSnapToGridGridCheck
                }
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Pokaż siatkę' ),
                anchor: '100%',
                ref: 'showGridItem',
                checked: false,
                inputValue: 'true'
            }, {
            	xtype: 'numberfield',
            	fieldLabel: getTranslation( 'Rozmiar siatki' ),
            	anchor: '100%',
            	ref: 'gridSizeItem',
            	allowBlank: false,
            	allowDecimals: false,
            	allowNegative: false,
            	maxValue: 20,
            	value: this.DEFAULT_GRID_SIZE,
            	hidden: true
            }, {
              xtype: 'combo',
              fieldLabel: getTranslation( 'Język tłumaczenia pakietu' ),
              anchor: '100%',
              ref: 'xpdlTranslationLanguageItem',
              triggerAction : 'all',
              mode : 'local',
              value: 'none',
              store: new Ext.data.Store( {
                data: this.buildXpdlTranslationLanguages(),
                reader: new Ext.data.JsonReader( {
                  fields: Ext.data.Record.create( [ {
                    name: 'language',
                    type: 'string'
                  }, {
                    name: 'languageName',
                    type: 'string'
                  } ] )
                } )
              } ),
              valueField : 'language',
              displayField : 'languageName',
              forceSelection : true
            }, {
                xtype: 'panel',
                layout: 'form',
                frame: false,
                border: false,
                bodyCssClass: 'x-Module-container-padding',
                title: getTranslation( 'Kolory' ),
                iconCls: 'x-Module-colorsPanel',
                collapsible: true,
                collapsed: true,
                titleCollapse: true,
                animCollapse: false,
                ref: 'colorsPanel',
                labelWidth: 150,
                items: [ {
                    xtype: 'compositefield',
                    anchor: '100%',
                    ref: 'hoverColorContainer',
                    fieldLabel: getTranslation( 'Kolor podświetlenia' ),
                    items: [ {
                        xtype: 'textfield',
                        inputType: 'text',
                        anchor: '95%',
                        color: '#f99b0c',
                        readOnly: true,
                        flex: 1,
                        style: 'background: #f99b0c;'
                    }, {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'color_wheel' ),
                        tooltip: getTranslation( 'Wybierz kolor podświetlenia' ),
                        flex: 0,
                        handler: this.chooseHoverColor,
                        scope: this
                    } ]
                }, {
                    xtype: 'compositefield',
                    anchor: '100%',
                    ref: 'distinctionColorContainer',
                    fieldLabel: getTranslation( 'Kolor wyróżnienia' ),
                    items: [ {
                        xtype: 'textfield',
                        inputType: 'text',
                        anchor: '95%',
                        color: '#f99b0c',
                        readOnly: true,
                        flex: 1,
                        style: 'background: #f99b0c;'
                    }, {
                        xtype: 'button',
                        cls: 'x-btn-icon',
                        icon: getPluginImgPath( 'color_wheel' ),
                        tooltip: getTranslation( 'Wybierz kolor wyróżnienia' ),
                        flex: 0,
                        handler: this.chooseDistinctionColor,
                        scope: this
                    } ]
                }, {
                  xtype: 'compositefield',
                  anchor: '100%',
                  ref: 'incomingTransitionColorContainer',
                  fieldLabel: getTranslation( 'Kolor połączeń wchodzących' ),
                  items: [ {
                    xtype: 'textfield',
                    inputType: 'text',
                    anchor: '95%',
                    color: '#f99b0c',
                    readOnly: true,
                    flex: 1,
                    style: 'background: #f99b0c;'
                  }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'color_wheel' ),
                    tooltip: getTranslation( 'Wybierz kolor połączeń wchodzących' ),
                    flex: 0,
                    handler: this.chooseIncomingTransitionColor,
                    scope: this
                  } ]
                }, {
                  xtype: 'compositefield',
                  anchor: '100%',
                  ref: 'outgoingTransitionColorContainer',
                  fieldLabel: getTranslation( 'Kolor połączeń wychodzących' ),
                  items: [ {
                    xtype: 'textfield',
                    inputType: 'text',
                    anchor: '95%',
                    color: '#f99b0c',
                    readOnly: true,
                    flex: 1,
                    style: 'background: #f99b0c;'
                  }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'color_wheel' ),
                    tooltip: getTranslation( 'Wybierz kolor połączeń wychodzących' ),
                    flex: 0,
                    handler: this.chooseOutgoingTransitionColor,
                    scope: this
                  } ]
                } ],
                listeners: {
                    scope: this,
                    expand: this.onColorsPanelExpand,
                    collapse: this.onColorsPanelCollapse
                }
            } ],
            buttons: [ {
                text: getTranslation( 'Uruchom' ),
                tooltip: getTranslation( 'Uruchom z wybraną konfiguracją' ),
                cls: 'x-btn-text',
                handler: this.onInit,
                scope: this
            } ]
        } ]
    }, config );

    Ext.ux.suncode.InitWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.InitWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.InitWindow.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    DEFAULT_GRID_SIZE: 10,
    onAfterRender: function() {
        new Ext.KeyMap( this.getId(), {
            key: Ext.EventObject.ENTER,
            handler: function() {
                if ( !this.initializing ) {
                    this.onInit();
                }
            },
            scope: this
        } );
    },
    buildXpdlTranslationLanguages: function() {
      var languages = new Array();
      languages.push( {
        language: 'none',
        languageName: getTranslation( 'Brak' )
      } );

      var supportedLanguages = Ext.ux.suncode.I18NService.getSupportedLanguages();

      for ( var i = 0; i < supportedLanguages.length; i++ ) {
        var supportedLanguage = supportedLanguages[i];
        languages.push( {
          language: supportedLanguage,
          languageName: supportedLanguage.toUpperCase()
        } );
      }

      return languages;
    },
    onAnimationsChange: function( box, checked ) {
        var colorsPanel = this.initPanel.colorsPanel;

        if ( checked ) {
            colorsPanel.animCollapse = true;
        } else {
            colorsPanel.animCollapse = false;
        }
    },
    onColorsPanelExpand: function( p ) {
        this.syncShadow();
    },
    onColorsPanelCollapse: function( p ) {
        this.syncShadow();
    },
    chooseHoverColor: function( button, e ) {
        closeColorChooser();

        var hoverColorField = this.initPanel.colorsPanel.hoverColorContainer.items.first();
        var colorChooser = new Ext.ux.suncode.ColorChooser( {
            title: getTranslation( 'Kolor podświetlenia' ),
            e: e,
            color: hoverColorField.color,
            saveFunction: function( choosenColor ) {
                hoverColorField.getEl().setStyle( 'background', choosenColor );
                hoverColorField.color = choosenColor;
            }
        } );
        colorChooser.show();
    },
    chooseDistinctionColor: function( button, e ) {
        closeColorChooser();

        var distinctionColorField = this.initPanel.colorsPanel.distinctionColorContainer.items.first();
        var colorChooser = new Ext.ux.suncode.ColorChooser( {
            title: getTranslation( 'Kolor wyróżnienia' ),
            e: e,
            color: distinctionColorField.color,
            saveFunction: function( choosenColor ) {
                distinctionColorField.getEl().setStyle( 'background', choosenColor );
                distinctionColorField.color = choosenColor;
                setDistinctionColorCssRules( choosenColor );
            }
        } );
        colorChooser.show();
    },
    chooseIncomingTransitionColor: function( button, e ) {
      closeColorChooser();

      var incomingTransitionColorField = this.initPanel.colorsPanel.incomingTransitionColorContainer.items.first();
      var colorChooser = new Ext.ux.suncode.ColorChooser( {
        title: getTranslation( 'Kolor połączeń wchodzących' ),
        e: e,
        color: incomingTransitionColorField.color,
        saveFunction: function( choosenColor ) {
          incomingTransitionColorField.getEl().setStyle( 'background', choosenColor );
          incomingTransitionColorField.color = choosenColor;
        }
      } );
      colorChooser.show();
    },
    chooseOutgoingTransitionColor: function( button, e ) {
      closeColorChooser();

      var outgoingTransitionColorField = this.initPanel.colorsPanel.outgoingTransitionColorContainer.items.first();
      var colorChooser = new Ext.ux.suncode.ColorChooser( {
        title: getTranslation( 'Kolor połączeń wychodzących' ),
        e: e,
        color: outgoingTransitionColorField.color,
        saveFunction: function( choosenColor ) {
          outgoingTransitionColorField.getEl().setStyle( 'background', choosenColor );
          outgoingTransitionColorField.color = choosenColor;
        }
      } );
      colorChooser.show();
    },
    onSnapToGridGridCheck: function( field, checked ) {
    	var gridSizeItem = this.initPanel.gridSizeItem;
    	var showGridItem = this.initPanel.showGridItem;
    	
    	if ( checked ) {
    		showGridItem.show();
    		gridSizeItem.show();
        } else {
        	showGridItem.hide();
        	gridSizeItem.hide();
        }
    },
    onInit: function() {
    	var gridSizeItem = this.initPanel.gridSizeItem;
      var xpdlTranslationLanguage = this.initPanel.xpdlTranslationLanguageItem.getValue();
    	
    	if ( !gridSizeItem.isValid() ) {
    		return;
    	}
    	
        this.initializing = true;
        closeColorChooser();

        var userConfig = new Object();
        userConfig = Ext.apply( {
            advancedView: this.initPanel.advancedViewItem.getValue(),
            experimentalView: this.initPanel.experimentalViewItem.getValue(),
            showTooltips: this.initPanel.showTooltipsItem.getValue(),
            animationsOn: this.initPanel.animationsOnItem.getValue(),
            exportJs: false,
            exportJavaCode: false,
            documentationView: this.initPanel.documentationViewItem.getValue(),
            showDeprecatedComponents: this.initPanel.showDeprecatedComponentsItem.getValue(),
            useExternalClipboard: this.initPanel.useExternalClipboardItem.getValue(),
            snapToGrid: this.initPanel.snapToGridItem.getValue(),
            showGrid: this.initPanel.showGridItem.getValue(),
            gridSize: gridSizeItem.getValue(),
            xpdlTranslationLanguage: xpdlTranslationLanguage,
            compatibilityMode: Ext.ux.suncode.CompatibilityModeService.getDefaultModeId(),
            hoverColor: this.initPanel.colorsPanel.hoverColorContainer.items.first().color,
            distinctionColor: this.initPanel.colorsPanel.distinctionColorContainer.items.first().color,
            incomingTransitionColor: this.initPanel.colorsPanel.incomingTransitionColorContainer.items.first().color,
            outgoingTransitionColor: this.initPanel.colorsPanel.outgoingTransitionColorContainer.items.first().color
        }, userConfig );
        Ext.ux.suncode.I18NService.setXpdlTranslationLanguage( xpdlTranslationLanguage );

        Ext.Ajax.request( {
            url: 'api/userconfig/set',
            method: 'POST',
            params: userConfig,
            scope: this,
            success: function( response, opts ) {
                if ( parseBoolean( response.responseText ) && userConfig.animationsOn ) {
                    var winEl = this.getEl();
                    winEl.shadow.hide();
                    winEl.ghost( 'b', {
                        easing: 'easeOut',
                        duration: 0.5,
                        remove: false,
                        useDisplay: false,
                        scope: this,
                        callback: function() {
                            this.closeInitWindow( userConfig );
                        }
                    } );
                } else {
                    this.closeInitWindow( userConfig );
                }
            },
            failure: function( response, opts ) {
            	showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    },
    closeInitWindow: function( userConfig ) {
        this.close();
        var loadingWindow = new Ext.ux.suncode.LoadingWindow( {
            userConfig: userConfig,
            startConfig: this.initialConfig.startConfig,
            autoSaved: this.initialConfig.autoSaved
        } );
        loadingWindow.show();
    }
} );
