function deleteProcess( processNode ) {
    Ext.Msg.show( {
        title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
        msg: getTranslation( 'Usunąć proces z pakietu?' ),
        buttons: {
            yes: getTranslation( 'Tak' ),
            no: getTranslation( 'Nie' )
        },
        fn: function( buttonId ) {
            if ( buttonId == 'yes' ) {
                executeDeleteProcess( processNode );
            }
        },
        icon: Ext.Msg.QUESTION
    } );
}

function executeDeleteProcess( processNode ) {
    var processDefId = processNode.attributes.processDefId;
    var paperPanel = Ext.getCmp( 'paper_panel' );
    paperPanel.removeProcess( processDefId );
    processNode.updateSubflowsIds( processDefId, '' );
    processNode.remove( true );

    var packagePanel = Ext.getCmp( 'package_panel' );
    var rootNode = packagePanel.getRootNode();

    if ( !rootNode.hasChildNodes() ) {
        var paperToolbar = paperPanel.getTopToolbar();
        paperToolbar.disableAllButtons();
    }
    
    Ext.ux.suncode.I18NService.onProcessRemove( processDefId );
    
    Ext.getCmp( 'main_panel' ).setSaved( false );
}

function editProcessSpecification( processNode ) {
    var win = new Ext.ux.suncode.ProcessSpecificationWindow( {
        processNode: processNode
    } );
    win.show();
}

function showVariablesCollation( processNode ) {
    if ( !processNode.hasChildNodes() ) {
        showWarn( getTranslation( 'Brak zadań w procesie' ) + '.' );
    } else if ( Ext.isEmpty( processNode.attributes.variables ) ) {
        showWarn( getTranslation( 'Brak zmiennych w procesie.' ) );
    } else {
        var win = new Ext.ux.suncode.VariablesCollationWindow( {
            processNode: processNode
        } );
        win.show();
    }
}

function setFormVariableLabelGlobalSettings( processNode ) {
	if ( !processNode.hasChildNodes() ) {
        showWarn( getTranslation( 'Brak zadań w procesie' ) + '.' );
    } else {
    	var win = new Ext.ux.suncode.FormVariableLabelGlobalSettingsWindow( {
            processNode: processNode
        } );
        win.show();
    }
}

function setLabelGlobalSettings( processNode ) {
  if ( !processNode.hasChildNodes() ) {
    showWarn( getTranslation( 'Brak zadań w procesie' ) + '.' );
  } else {
    var win = new Ext.ux.suncode.LabelGlobalSettingsWindow( {
      processNode: processNode
    } );
    win.show();
  }
}

function setVariableSetFontGlobalSettings( processNode ) {
	if ( !processNode.hasChildNodes() ) {
        showWarn( getTranslation( 'Brak zadań w procesie' ) + '.' );
    } else {
    	var win = new Ext.ux.suncode.VariableSetFontGlobalSettingsWindow( {
            processNode: processNode
        } );
        win.show();
    }
}

function showValidatorsTemplates( processNode ) {
	var mainPanel = Ext.getCmp( 'main_panel' );
	var win = new Ext.ux.suncode.IntegrationComponentTemplateWindow( {
        title: getTranslation( 'Szablony mechanizmów sprawdzających formularz' ),
        editionMode: true,
        processNode: processNode,
        enableCopyPasteMenu: true,
        conditionalExecutionEnabled: true,
        inactiveEnabled: true,
        componentsTableTitle: getTranslation( 'Mechanizmy sprawdzające formularz' ),
        categories: mainPanel.getValidatorsIntegrationComponentCategories(),
        parametersWindowTitlePrefix: getTranslation( 'Parametry mechanizmu sprawdzającego formularz' ),
        noComponentsMessage: getTranslation( 'Brak mechanizmów sprawdzających formularz.' ),
        systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
        getTemplatesFunction: function() {
        	return this.getValidatorsTemplates();
        },
        getTemplatesScope: processNode,
        getTemplateFunction: function( templateId ) {
        	return this.findValidatorsTemplate( templateId );
        },
        getTemplateScope: processNode,
        addTemplateFunction: function( template ) {
        	this.addValidatorsTemplate( template );
        },
        addTemplateScope: processNode,
        editTemplateFunction: function( templateId, template ) {
        	this.updateValidatorsTemplate( templateId, template );
        },
        editTemplateScope: processNode,
        removeTemplateFunction: function( templateId ) {
        	this.removeValidatorsTemplate( templateId );
        },
        removeTemplateScope: processNode,
        getTemplateUtilizationFieldsFunction: function() {
        	return [ {
                name: 'activityName',
                type: 'string'
            }, {
                name: 'buttonName',
                type: 'string'
            } ];
        },
        getTemplateUtilizationFunction: function( templateId ) {
          return this.findValidatorsTemplateUtilization( templateId );
        },
        getTemplateUtilizationScope: processNode,
        getTemplateUtilizationColumnsFunction: function() {
        	return [ {
                id: 'activityName',
                header: getTranslation( 'Nazwa zadania' ),
                dataIndex: 'activityName',
                align: 'left'
            }, {
                id: 'buttonName',
                header: getTranslation( 'Nazwa przycisku' ),
                dataIndex: 'buttonName',
                align: 'left'
            } ];
        },
        getComponentRegistrationFunction: function( id ) {
        	return Ext.ux.suncode.IntegrationComponentService.getValidatorRegistration( id );
        },
        getComponentRegistrationScope: this,
        copyComponentsFunction: function( components ) {
        	Ext.ux.suncode.Clipboard.setIntegrationComponentValidators( components );
        },
        copyComponentsScope: this,
        handleCopiedComponentsFunction: function( func, scope ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentValidators( function( validators ) {
            if ( Ext.isFunction( func ) ) {
              scope = !Ext.isEmpty( scope ) ? scope : window;
              func.apply( scope, [ validators ] );
            }
          }, this );
        },
        handleCopiedComponentsScope: this,
        pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentValidatorsMessageType
    } );
    win.show();
}

function showVariablesSettersTemplates( processNode ) {
	var mainPanel = Ext.getCmp( 'main_panel' );
	var win = new Ext.ux.suncode.IntegrationComponentTemplateWindow( {
        title: getTranslation( 'Szablony mechanizmów uruchamianych po akceptacji' ),
        editionMode: true,
        processNode: processNode,
        enableCopyPasteMenu: true,
        conditionalExecutionEnabled: true,
        inactiveEnabled: true,
        componentsTableTitle: getTranslation( 'Mechanizmy uruchamiane po akceptacji' ),
        categories: mainPanel.getVariablesSettersIntegrationComponentCategories(),
        parametersWindowTitlePrefix: getTranslation( 'Parametry mechanizmu uruchamianego po akceptacji' ),
        noComponentsMessage: getTranslation( 'Brak mechanizmów uruchamianych po akceptacji.' ),
        systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.SERVER_ACCESSIBILITY,
        getTemplatesFunction: function() {
        	return this.getVariablesSettersTemplates();
        },
        getTemplatesScope: processNode,
        getTemplateFunction: function( templateId ) {
        	return this.findVariablesSettersTemplate( templateId );
        },
        getTemplateScope: processNode,
        addTemplateFunction: function( template ) {
        	this.addVariablesSettersTemplate( template );
        },
        addTemplateScope: processNode,
        editTemplateFunction: function( templateId, template ) {
        	this.updateVariablesSettersTemplate( templateId, template );
        },
        editTemplateScope: processNode,
        removeTemplateFunction: function( templateId ) {
        	this.removeVariablesSettersTemplate( templateId );
        },
        removeTemplateScope: processNode,
        getTemplateUtilizationFieldsFunction: function() {
        	return [ {
                name: 'activityName',
                type: 'string'
            }, {
                name: 'buttonName',
                type: 'string'
            } ];
        },
    	  getTemplateUtilizationFunction: function( templateId ) {
    		  return this.findVariablesSettersTemplateUtilization( templateId );
        },
        getTemplateUtilizationScope: processNode,
		    getTemplateUtilizationColumnsFunction: function() {
        	return [ {
                id: 'activityName',
                header: getTranslation( 'Nazwa zadania' ),
                dataIndex: 'activityName',
                align: 'left'
            }, {
                id: 'buttonName',
                header: getTranslation( 'Nazwa przycisku' ),
                dataIndex: 'buttonName',
                align: 'left'
            } ];
        },
        getComponentRegistrationFunction: function( id ) {
        	return Ext.ux.suncode.IntegrationComponentService.getVariablesSetterRegistration( id );
        },
        getComponentRegistrationScope: this,
        copyComponentsFunction: function( components ) {
        	Ext.ux.suncode.Clipboard.setIntegrationComponentVariablesSetters( components );
        },
        copyComponentsScope: this,
        handleCopiedComponentsFunction: function( func, scope ) {
          Ext.ux.suncode.Clipboard.getIntegrationComponentVariablesSetters( function( variablesSetters ) {
            if ( Ext.isFunction( func ) ) {
              scope = !Ext.isEmpty( scope ) ? scope : window;
              func.apply( scope, [ variablesSetters ] );
            }
          }, this );
        },
        handleCopiedComponentsScope: this,
        pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentVariablesSettersMessageType
    } );
    win.show();
}

function showProcessProperties( processNode ) {
    var processPropertiesWindow = new Ext.ux.suncode.ProcessPropertiesWindow( {
        processNode: processNode,
        AV: Ext.getCmp( 'main_panel' ).getAdvancedView()
    } );
    processPropertiesWindow.show();
}

Ext.ux.suncode.ProcessPropertiesWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.5;
    var processNode = config.processNode;
    var processDefId = processNode.attributes.processDefId
    var processName = processNode.attributes.processName;
    var processNameTranslation = getXpdlProcessNameTranslation( processDefId, processName );
    var itemsConfig = new Object();

    itemsConfig = Ext.apply( {
        processNode: processNode,
        windowWidth: windowWidth,
        AV: config.AV,
        win: this
    }, itemsConfig );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        autoHeight: true,
        title: getTranslation( 'Właściwości procesu' ) + ' ' + processNameTranslation,
        items: new Ext.ux.suncode.ProcessPropertiesTabPanel( itemsConfig ),
        closable: true,
        tbar: new Ext.ux.suncode.ProcessPropertiesTopToolbar( itemsConfig )
    }, config );

    Ext.ux.suncode.ProcessPropertiesWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessPropertiesWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ProcessPropertiesWindow.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
        this.on( 'beforeshow', lockHotkeys );
        this.on( 'beforeclose', unlockHotkeys );
        this.on( 'close', this.onClose, this );
    },
    onAfterRender: function() {
        if ( this.initialConfig.activateTab ) {
            this.ProcessPropertiesTabPanel.activate( this.initialConfig.activateTab );
        }
    },
    onClose: function() {
        closeColorChooser();
    }
} );

Ext.ux.suncode.ProcessPropertiesTabPanel = function( config ) {
    var panelHeight = Ext.getBody().getViewSize().height * 0.8;

    config = Ext.apply( {
        panelHeight: panelHeight
    }, config );

    var items = new Array();
    items.push( new Ext.ux.suncode.ProcessDefinitionPanel( config ) );
    if ( config.AV ) {
        items.push( new Ext.ux.suncode.ProcessFormalParamsPanel( config ) );
    }
    items.push( new Ext.ux.suncode.ProcessParticipantsPanel( config ) );
    items.push( new Ext.ux.suncode.ProcessActivitiesPanel( config ) );
    items.push( new Ext.ux.suncode.ProcessVariablesPanel( config ) );
    items.push( new Ext.ux.suncode.ProcessTablesPanel( config ) );
    items.push( new Ext.ux.suncode.ProcessLabelsPanel( config ) );
    config = Ext.apply( {
        nodeName: 'process',
        node: config.processNode
    }, config );
    items.push( new Ext.ux.suncode.ApplicationsPanel( config ) );

    config = Ext.apply( {
        items: items,
        activeTab: 0,
        autoHeight: true,
        enableTabScroll: true,
        border: false,
        ref: 'ProcessPropertiesTabPanel',
        listeners: {
            tabchange: function( panel, tab ) {
                closeColorChooser();
            }
        }
    }, config );

    Ext.ux.suncode.ProcessPropertiesTabPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessPropertiesTabPanel, Ext.TabPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessPropertiesTabPanel.superclass.initComponent.call( this );
    }
} );

Ext.ux.suncode.ProcessDefinitionPanel = function( config ) {
	var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	var packageId = packageNode.attributes.packageId;
	var processNode = config.processNode;
    var colorLabel = addTooltipToField( getTranslation( 'Kolor' ), getTranslation( 'Określa kolor wyróżnienia procesu w kalendarzu systemowym' ) );
    var items = new Array();

    var processDefIdItem = new Ext.ux.suncode.IdField( {
        anchor: '100%',
        fieldLabel: getTranslation( 'Identyfikator definicji procesu' ),
        value: processNode.attributes.processDefId,
        ref: '../../idItem',
        hidden: !config.AV,
        idMaxLength: Ext.ux.suncode.Constants.PROCESS_DEF_ID_MAX_LENGTH,
        idChanged: processNode.attributes.idChanged
    } );
    items.push( processDefIdItem );
    var processNameItem = new Ext.ux.suncode.I18NTranslatedField( {
    	fieldLabel: getTranslation( 'Nazwa procesu' ),
    	ref: '../../nameItem',
    	field: {
            xtype: 'textfield',
            maxLength: 255,
            maxLengthText: getTranslation( 'Nazwa procesu nie może przekroczyć 255 znaków.' ),
            value: processNode.attributes.processName,
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            stripCharsRe: /\_/g,
            listeners: {
                scope: this,
                blur: function( field ) {
                    var win = this.ownerCt.ownerCt;
                    var processName = field.getValue();

                    if ( !processNode.attributes.idChanged ) {
                        var procDefId = generateId( processName, Ext.ux.suncode.Constants.PROCESS_DEF_ID_MAX_LENGTH );
                        win.idItem.setValue( procDefId );
                    }

                    var descrItem = win.descrItem;
                    var processDescr = descrItem.getValue();
                    if ( Ext.isEmpty( processDescr ) || processDescr == field.startValue ) {
                        descrItem.setValue( processName );
                    }
                }
            }
        },
        getIdFieldFunction: function() {
        	return this.ownerCt.ownerCt.idItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj identyfikator i nazwę procesu.' ),
        windowTitle: getTranslation( 'Tłumaczenia nazwy procesu' ),
        keyPrefix: 'PACK(' + packageId + ')_PROC(',
        keyPostfix: ')',
        saveToCache: false,
        initialId: processNode.attributes.processDefId
    } );
    items.push( processNameItem );
    var processCreationTimeItem = new Ext.form.TextField( {
        inputType: 'text',
        fieldLabel: getTranslation( 'Czas utworzenia' ),
        anchor: '100%',
        value: processNode.attributes.processCreationTime,
        readOnly: true
    } );
    items.push( processCreationTimeItem );
    var processColorItem = new Ext.form.CompositeField( {
        anchor: '100%',
        ref: '../../colorItem',
        fieldLabel: colorLabel,
        items: [ {
            xtype: 'textfield',
            inputType: 'text',
            flex: 1,
            isFormField: true,
            style: processNode.attributes.processColor ? 'background: ' + processNode.attributes.processColor + ';' : '',
            color: processNode.attributes.processColor,
            readOnly: true
        }, {
            xtype: 'button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'color_wheel' ),
            tooltip: getTranslation( 'Wybierz kolor' ),
            flex: 0,
            handler: this.chooseProcessColor,
            scope: this
        }, {
            xtype: 'button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'clear' ),
            tooltip: getTranslation( 'Wyczyść' ),
            flex: 0,
            handler: this.clearProcessColor,
            scope: this
        } ]
    } );
    items.push( processColorItem );
    var processNameMaskItem = new Ext.ux.suncode.I18NTranslatedField( {
    	ref: '../../processNameMaskItem',
    	field: new Ext.ux.suncode.ProcessNameMasksChooser( {
            value: processNode.attributes.processNameMask
        } ),
        getIdFieldFunction: function() {
        	return this.ownerCt.ownerCt.idItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj identyfikator i nazwę procesu.' ),
        windowTitle: getTranslation( 'Tłumaczenia maski nazwy procesu' ),
        keyPrefix: 'PACK(' + packageId + ')_PROC(',
        keyPostfix: ')_PROCESS_NAME_MASK',
        saveToCache: false,
        initialId: processNode.attributes.processDefId
    } );
    items.push( processNameMaskItem );
    var processDescrItem = new Ext.form.FieldSet( {
        title: getTranslation( 'Opis' ),
        layout: 'fit',
        anchor: '100%'
    } );
    var processDescrArea = new Ext.ux.suncode.I18NTranslatedField( {
    	ref: '../../../descrItem',
    	field: {
            xtype: 'textarea',
            height: 150,
            value: processNode.attributes.processDescr
        },
        getIdFieldFunction: function() {
        	return this.ownerCt.ownerCt.idItem;
        },
        getIdFieldScope: this,
        emptyIdMessage: getTranslation( 'Podaj identyfikator i nazwę procesu.' ),
        windowTitle: getTranslation( 'Tłumaczenia opisu procesu' ),
        keyPrefix: 'PACK(' + packageId + ')_PROC(',
        keyPostfix: ')_DESC',
        saveToCache: false,
        initialId: processNode.attributes.processDefId,
        multilineTranslationFields: true
    } );
    processDescrItem.add( processDescrArea );
    items.push( processDescrItem );

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        items: items,
        title: getTranslation( 'Definicja' ),
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: config.windowWidth * 0.4,
        boxMinHeight: config.panelHeight,
        boxMaxHeight: config.panelHeight,
        autoScroll: true,
        ref: '../defPanel'
    }, config );

    Ext.ux.suncode.ProcessDefinitionPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessDefinitionPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessDefinitionPanel.superclass.initComponent.call( this );
    },
    chooseProcessColor: function( button, e ) {
        closeColorChooser();

        var me = this;
        var processColorField = this.ownerCt.ownerCt.colorItem.items.first();
        var colorChooser = new Ext.ux.suncode.ColorChooser( {
            title: getTranslation( 'Kolor procesu' ),
            e: e,
            color: processColorField.color,
            saveFunction: function( choosenColor ) {
                processColorField.getEl().setStyle( 'background', choosenColor );
                processColorField.color = choosenColor;
                me.storeParentWindowAsUnsaved();
            }
        } );
        colorChooser.show();
    },
    clearProcessColor: function( button, e ) {
        var processColorField = this.ownerCt.ownerCt.colorItem.items.first();
        processColorField.getEl().setStyle( 'background', '#FFFFFF' );
        processColorField.color = '';
    }
} );

Ext.ux.suncode.ProcessFormalParamsPanel = function( config ) {
    var processNode = config.processNode;

    var formalParamsStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'mode',
                type: 'string'
            }, {
                name: 'type',
                type: 'string'
            }, {
                name: 'status',
                type: 'string'
            } ] )
        } )
    } );

    if ( processNode.attributes.formalParameters.length > 0 ) {
        formalParamsStore.loadData( processNode.attributes.formalParameters );
        formalParamsStore.commitChanges();
    }

    var modesChooser = new Ext.ux.suncode.ModesChooser( {} );
    var typesChooser = new Ext.ux.suncode.TypesChooser( {
        utilization: 'simple'
    } );

    config = Ext.apply( {
        title: getTranslation( 'Parametry formalne' ),
        height: config.panelHeight,
        store: formalParamsStore,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        layout: 'fit',
        ref: 'fpGrid',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'mode',
                header: getTranslation( 'Tryb' ),
                dataIndex: 'mode',
                align: 'left',
                editor: modesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( modesChooser )
            }, {
                id: 'type',
                header: getTranslation( 'Typ' ),
                dataIndex: 'type',
                align: 'left',
                editor: typesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( typesChooser )
            }, {
                id: 'status',
                header: 'status',
                dataIndex: 'status',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak parametrów formalnych w procesie' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'utilization' ),
                tooltip: getTranslation( 'Pokaż wykorzystanie' ),
                handler: this.showUtilization,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj parametr formalny' ),
                handler: this.addFormalParam,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj parametr formalny' ),
                handler: this.editFormalParam,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń parametr formalny' ),
                handler: this.removeFormalParam,
                scope: this
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.editFormalParam();
            }
        }
    }, config );

    Ext.ux.suncode.ProcessFormalParamsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessFormalParamsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessFormalParamsPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var tbar = this.getTopToolbar();
        var txt = '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość paramertów formalnych' )
        	+ ': ' + this.getStore().getCount() + '</b></font>';
        tbar.insert( 0, txt );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość paramertów formalnych' )
        		+ ': ' + this.getStore().getCount() + '</b></font>' );
    },
    showUtilization: function() {
      var fp = this.getSelectedFormalParam();
      if ( !fp ) {
        return;
      }

      var processNode = this.initialConfig.processNode;
      var fpName = fp.get( 'name' );
      var win = new Ext.ux.suncode.VariableUtilizationWindow( {
        windowTitle: getTranslation( 'Komponenty wykorzystujące parametr formalny' ) + ': ' + fpName,
        showCustomDescription: true,
        showVariableUtilizationActions: true,
        enableRemoveAll: false,
        processNode: processNode,
        variableId: fpName
      } );
      win.show();
    },
    addFormalParam: function() {
        var win = new Ext.ux.suncode.FormalParamDefWindow( {
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: this.getStore().recordType
        } );
        win.show();
    },
    editFormalParam: function() {
        var fp = this.getSelectedFormalParam();
        if ( !fp ) {
            return;
        }

        if ( fp.get( 'status' ) == 'static' ) {
            showWarn( getTranslation( 'Parametr formalny nie może być edytowany.' ) );
            return;
        }

        var win = new Ext.ux.suncode.FormalParamDefWindow( {
            fp: this.initialConfig.processNode.findFormalParam( fp.get( 'name' ) ),
            processNode: this.initialConfig.processNode,
            saveTo: this,
            varRecord: fp
        } );
        win.show();
    },
    removeFormalParam: function() {
        var fp = this.getSelectedFormalParam();
        if ( !fp ) {
            return;
        }

        if ( fp.get( 'status' ) == 'static' ) {
            showWarn( getTranslation( 'Parametr formalny nie może być usunięty.' ) );
            return;
        }

        this.initialConfig.processNode.removeFormalParam( fp, this );
    },
    getSelectedFormalParam: function() {
        var fp = this.getSelectionModel().getSelected();
        if ( !fp ) {
            showWarn( getTranslation( 'Wybierz parametr formalny.' ) );
            return null;
        }
        return fp;
    }
} );

Ext.ux.suncode.ProcessParticipantsPanel = function( config ) {
    var processNode = config.processNode;
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId;
    var processDefId = processNode.attributes.processDefId;

    var record = Ext.data.Record.create( [ {
        name: 'roleName',
        type: 'string'
    }, {
        name: 'roleType',
        type: 'string'
    }, {
        name: 'roleId',
        type: 'string'
    } ] );

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: record
        } )
    } );

    var participants = processNode.attributes.participants;
    if ( participants && participants.length > 0 ) {
        for ( var i = 0; i < participants.length; i++ ) {
            var participant = participants[i];

            if ( !participant.isGlobal ) {
                var participantId = participant.roleId;
                var participantName = participant.roleName;
                var participantNameTranslation = getXpdlProcessParticipantNameTranslation( packageId, processDefId, participantId, participantName );

                var p = new record( {
                    roleName: participantNameTranslation,
                    roleType: participant.roleType,
                    roleId: participant.roleId
                } );
                store.add( p );
            }
        }

        store.commitChanges();
    }

    var roleTypesChooser = new Ext.ux.suncode.RoleTypesChooser( {} );

    config = Ext.apply( {
        id: 'process_participants_panel',
        title: getTranslation( 'Uczestnicy' ),
        store: store,
        height: config.panelHeight,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'roleName',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'roleName',
                align: 'left'
            }, {
                id: 'roleType',
                header: getTranslation( 'Typ' ),
                dataIndex: 'roleType',
                align: 'left',
                editor: roleTypesChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( roleTypesChooser )
            }, {
                id: 'roleId',
                header: 'roleId',
                dataIndex: 'roleId',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak uczestników procesu' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ {
                xtype: 'tbtext',
                text: '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość uczestników' ) + ': ' + store.getCount() + '</b></font>'
            }, '->', {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'role' ),
                tooltip: getTranslation( 'Wstaw rolę' ),
                scope: this,
                handler: this.addRole
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'system' ),
                tooltip: getTranslation( 'Wstaw system' ),
                scope: this,
                handler: this.addSystem
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'buffer' ),
                tooltip: getTranslation( 'Wstaw bufor' ),
                scope: this,
                handler: this.addBufor
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'participant' ),
                tooltip: getTranslation( 'Wstaw uczestnika' ),
                menu: new Ext.ux.suncode.Menu( [] ),
                listeners: {
                    beforerender: function( button ) {
                        button.menu.on( 'beforeshow', loadGlobalParticipants );
                    }
                }
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj uczestnika' ),
                scope: this,
                handler: this.editParticipant
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń uczestnika' ),
                scope: this,
                handler: this.removeParticipant
            } ]
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
                this.editParticipant();
            }
        }
    }, config );

    Ext.ux.suncode.ProcessParticipantsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessParticipantsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessParticipantsPanel.superclass.initComponent.call( this );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        var amount = this.getStore().getCount();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość uczestników' ) + ': ' + amount + '</b></font>' );
    },
    addRole: function() {
        var role = Ext.getCmp( 'paper_panel' ).getActiveTab().drawRole( 1, 1 );
        this.addParticipant( role );
    },
    addSystem: function() {
        var system = Ext.getCmp( 'paper_panel' ).getActiveTab().drawSystem( 1, 1 );
        this.addParticipant( system );
    },
    addBufor: function() {
        var bufor = Ext.getCmp( 'paper_panel' ).getActiveTab().drawBufor( 1, 1 );
        this.addParticipant( bufor );
    },
    addParticipant: function( participant ) {
        var store = this.getStore();
        var rec = store.recordType;
        var r = participant[0];
        var p = new rec( {
            roleName: r.data( 'roleName' ),
            roleType: r.data( 'roleType' ),
            roleId: r.data( 'roleId' )
        } );
        store.add( p );
        store.commitChanges();
        this.updateTitle();
    },
    editParticipant: function() {
        var participant = this.getSelectedParticipant();
        if ( !participant ) {
            return;
        }

        var store = this.getStore();
        var roleId = participant.get( 'roleId' );
        var processNode = this.initialConfig.processNode;
        showRoleProperties( {
          processNode: processNode,
          roleId: roleId,
          varRecord: participant
        } );
    },
    removeParticipant: function() {
        var participant = this.getSelectedParticipant();
        if ( !participant ) {
            return;
        }

        var processNode = this.initialConfig.processNode;
        deleteRole( {
            paper: Ext.getCmp( 'paper_panel' ).getActiveTab().paper,
            processNode: processNode,
            roleId: participant.get( 'roleId' )
        } );
        removeRowAndMarkNext( this, participant );
        this.getView().refresh();
        this.updateTitle();
        var processActivitiesPanel = Ext.getCmp( 'process_activities_panel' );
        processActivitiesPanel.reloadActivities();
    },
    getSelectedParticipant: function() {
        var participant = this.getSelectionModel().getSelected();
        if ( !participant ) {
            showWarn( getTranslation( 'Wybierz uczestnika.' ) );
            return null;
        }

        return participant;
    }
} );

Ext.ux.suncode.ProcessActivitiesPanel = function( config ) {
    var processNode = config.processNode;
    var processDefId = processNode.attributes.processDefId;
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId;

    var record = Ext.data.Record.create( [ {
        name: 'activityName',
        type: 'string'
    }, {
        name: 'activityPerformer',
        type: 'string'
    }, {
        name: 'activityType',
        type: 'string'
    }, {
        name: 'activityDefId',
        type: 'string'
    } ] );

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: record
        } ),
        fields: record
    } );

    var activities = processNode.childNodes;
    if ( !Ext.isEmpty( activities ) ) {
      Ext.each( activities, function( activity, index, allActivities ) {
        var activityDefId = activity.attributes.activityDefId;
        var activityName = activity.attributes.activityName;
        var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );

        var p = new record( {
          activityDefId: activityDefId,
          activityName: activityNameTranslation,
          activityType: activity.attributes.activityType,
          activityPerformer: activity.attributes.activityPerformer
        } );
        store.add( p );
      } );

      store.commitChanges();
    }

    config = Ext.apply( {
        id: 'process_activities_panel',
        title: getTranslation( 'Zadania' ),
        store: store,
        height: config.panelHeight,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false,
                css: 'vertical-align:middle;'
            },
            columns: [ {
                id: 'activityName',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'activityName',
                align: 'left'
            }, {
                id: 'activityPerformer',
                header: getTranslation( 'Wykonawca' ),
                dataIndex: 'activityPerformer',
                align: 'left'
            }, {
                id: 'activityType',
                header: getTranslation( 'Typ' ),
                dataIndex: 'activityType',
                align: 'left',
                renderer: activityTypeRenderer
            }, {
                id: 'activityDefId',
                header: 'activityDefId',
                dataIndex: 'activityDefId',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak zadań w procesie' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ {
                xtype: 'tbtext',
                text: '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość zadań' ) + ': ' + store.getCount() + '</b></font>'
            }, '->', {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'activity_small' ),
                tooltip: getTranslation( 'Wstaw zadanie' ),
                scope: this,
                handler: this.addActivity
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'route_small' ),
                tooltip: getTranslation( 'Wstaw przekierowanie' ),
                scope: this,
                handler: this.addRoute
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'tool_small' ),
                tooltip: getTranslation( 'Wstaw narzędzie systemowe' ),
                scope: this,
                handler: this.addTool
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'subflow_small' ),
                tooltip: getTranslation( 'Wstaw podproces' ),
                hidden: !config.AV,
                scope: this,
                handler: this.addSubflow
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj obiekt' ),
                scope: this,
                handler: this.editTask
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń obiekt' ),
                scope: this,
                handler: this.removeTask
            } ]
        } ),
        listeners: {
            rowclick: function( grid, rowIndex, e ) {
                var store = grid.getStore();
                var rec = store.getAt( rowIndex );
                var actDefId = rec.get( 'activityDefId' );
                var packagePanel = Ext.getCmp( 'package_panel' );
                packagePanel.selectActivity( processNode, actDefId );
            },
            rowdblclick: function( grid, rowIndex, e ) {
                var store = grid.getStore();
                var rec = store.getAt( rowIndex );
                var actDefId = rec.get( 'activityDefId' );
                var activityNode = processNode.findChild( 'activityDefId', actDefId );
                showActivityProperties( {
                  activityNode: activityNode,
                  varRecord: rec
                } );
            }
        }
    }, config );

    Ext.ux.suncode.ProcessActivitiesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessActivitiesPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessActivitiesPanel.superclass.initComponent.call( this );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        var amount = this.getStore().getCount();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość zadań' ) + ': ' + amount + '</b></font>' );
    },
    addActivity: function() {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var paper = processPanel.paper;
        var activity = paper.bpmn.addTaskToLastRole( paper, processPanel, 'activity' );

        if ( activity ) {
            this.addTask( activity );
        }
    },
    addRoute: function() {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var paper = processPanel.paper;
        var route = paper.bpmn.addTaskToLastRole( paper, processPanel, 'route' );

        if ( route ) {
            this.addTask( route );
        }
    },
    addTool: function() {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var paper = processPanel.paper;
        var tool = paper.bpmn.addTaskToLastRole( paper, processPanel, 'tool' );

        if ( tool ) {
            this.addTask( tool );
        }
    },
    addSubflow: function() {
        var processPanel = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var paper = processPanel.paper;
        var subflow = paper.bpmn.addTaskToLastRole( paper, processPanel, 'subflow' );

        if ( subflow ) {
            this.addTask( subflow );
        }
    },
    addTask: function( task ) {
        var store = this.getStore();
        var rec = store.recordType;
        var t = task[0];
        var newTask = new rec( {
            activityName: t.data( 'activityName' ),
            activityPerformer: t.data( 'roleName' ),
            activityType: t.data( 'activityType' ),
            activityDefId: t.data( 'activityDefId' )
        } );
        store.add( newTask );
        store.commitChanges();
        this.updateTitle();
    },
    editTask: function() {
        var task = this.getSelectedTask();
        if ( !task ) {
            return;
        }

        var rowIndex = this.getStore().indexOf( task );
        this.fireEvent( 'rowdblclick', this, rowIndex );
    },
    removeTask: function() {
        var task = this.getSelectedTask();
        if ( !task ) {
            return;
        }

        var processDefId = this.initialConfig.processNode.attributes.processDefId;
        var activityNode = Ext.getCmp( 'package_panel' ).findActivity( processDefId, task.get( 'activityDefId' ) );

        var deleteQuestionText = '';

        switch ( activityNode.attributes.activityType ) {
            case Ext.ux.suncode.Constants.ROUTE:
                deleteQuestionText = getTranslation( 'Usunąć przekierowanie wraz z połączeniami?' );
                break;
            case Ext.ux.suncode.Constants.ACTIVITY:
                deleteQuestionText = getTranslation( 'Usunąć zadanie wraz z połączeniami?' );
                break;
            case Ext.ux.suncode.Constants.TOOL:
                deleteQuestionText = getTranslation( 'Usunąć narzędzie wraz z połączeniami?' );
                break;
            case Ext.ux.suncode.Constants.SUBFLOW:
                deleteQuestionText = getTranslation( 'Usunąć podproces wraz z połączeniami?' );
                break;
            default:
                break;
        }

        Ext.Msg.show( {
            title: getTranslation( 'Uwaga' ),
            msg: deleteQuestionText,
            buttons: {
                yes: getTranslation( 'Tak' ),
                no: getTranslation( 'Nie' )
            },
            scope: this,
            fn: function( buttonId ) {
                if ( buttonId == 'yes' ) {
                    executeDeleteActivity( activityNode );
                    removeRowAndMarkNext( this, task );
                    this.getView().refresh();
                    this.updateTitle();
                }
            },
            icon: Ext.Msg.QUESTION
        } );
    },
    getSelectedTask: function() {
        var task = this.getSelectionModel().getSelected();
        if ( !task ) {
            showWarn( getTranslation( 'Wybierz zadanie.' ) );
            return null;
        }

        return task;
    },
    reloadActivities: function() {
        var store = this.getStore();
        store.removeAll();
        store.commitChanges();
        var activities = this.initialConfig.processNode.childNodes;
        if ( !Ext.isEmpty( activities ) ) {
            Ext.each( activities, function( activity, index, allActivities ) {
                store.add( new record( activity.attributes ) );
            } );
            store.commitChanges();
        }
        this.updateTitle();
    }
} );

Ext.ux.suncode.ProcessVariablesPanel = function( config ) {
    var processNode = config.processNode;
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId;
    var processDefId = processNode.attributes.processDefId;

    var record = Ext.data.Record.create( [ {
        name: 'id',
        type: 'string'
    }, {
        name: 'name',
        type: 'string'
    }, {
        name: 'type',
        type: 'string'
    }, {
        name: 'placement',
        type: 'string'
    }, {
        name: 'creationDate',
        type: 'string'
    }, {
        name: 'modificationDate',
        type: 'string'
    } ] );

    var variablesStore = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: record
        } )
    } );

    var variables = processNode.attributes.variables;
    if ( variables && variables.length > 0 ) {
      for ( var i = 0; i < variables.length; i++ ) {
        var variable = variables[i];

        var variableId = variable.id;
        var variableName = variable.name;
        var variableNameTranslation = getXpdlVariableNameTranslation( packageId, processDefId, variableId, variableName );

        var p = new record( {
          id: variableId,
          name: variableNameTranslation,
          type: variable.type,
          placement: variable.placement,
          creationDate: variable.creationDate,
          modificationDate: variable.modificationDate
        } );
        variablesStore.add( p );
      }

      variablesStore.commitChanges();
    }

    var toolbarInfo = new Ext.Toolbar( {
        cls: 'x-Module-toolbarVerticalAlignTop'
    });
    toolbarInfo.add( {
      xtype: 'panel',
      layout: 'form',
      border: false,
      width: 300,
      labelWidth: 100,
      items: [ {
          xtype: 'label',
              cls: 'x-Module-total',
              style: {
              display: 'block',
                  marginBottom: '5px'
              },
              ref: 'totalItem',
              text: getTranslation( 'Ilość zmiennych procesu' ) + ': ' + variablesStore.getCount()
          }, {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Nazwa' ),
            ref: 'nameFilter',
            getFilterValue: function() {
              return this.items.first().getValue();
            },
            setFilterValue: function( value ) {
              var filter = this.items.first();
              filter.setValue( value );
            },
            items: [ {
                xtype: 'textfield',
                emptyText: getTranslation( 'Szukaj' ) + '...',
                flex: 1,
                cls: 'x-Module-field-leftAlign',
                listeners: {
                  scope: this,
                  afterrender: this.onNameFilterAfterRender
                }
            }, {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść filtr' ),
                flex: 0,
                handler: this.clearNameFilter,
                scope: this
            } ]
      }, {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Typ' ),
            ref: 'typeFilter',
            getFilterValue: function() {
              return this.items.first().getValue();
            },
            setFilterValue: function( value ) {
              var filter = this.items.first();
              filter.setValue( value );
            },
            items: [ new Ext.ux.suncode.TypesChooser( {
            utilization: 'extended',
            emptyText: getTranslation( 'Szukaj' ) + '...',
            cls: 'x-Module-field-leftAlign',
            flex: 1,
            listeners: {
              scope: this,
              select: this.applyTypeFilter
            }
          } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść filtr' ),
                flex: 0,
                handler: this.clearTypeFilter,
                scope: this
            } ]
      }, {
            xtype: 'compositefield',
            fieldLabel: getTranslation( 'Umieszczenie' ),
            ref: 'placementFilter',
            getFilterValue: function() {
              return this.items.first().getValue();
            },
            setFilterValue: function( value ) {
              var filter = this.items.first();
              filter.setValue( value );
            },
            items: [ new Ext.ux.suncode.VariablePlacements( {
            emptyText: getTranslation( 'Szukaj' ) + '...',
            cls: 'x-Module-field-leftAlign',
            flex: 1,
            value: '',
            listeners: {
              scope: this,
              select: this.applyPlacementFilter
            }
          } ), {
                xtype: 'button',
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść filtr' ),
                flex: 0,
                handler: this.clearPlacementFilter,
                scope: this
            } ]
      } ]
	  } );
    toolbarInfo.addFill();

    var showUtilizationButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'utilization' ),
        tooltip: getTranslation( 'Pokaż wykorzystanie' ),
        scope: this,
        handler: function() {
          var rows = this.getChoosenVariables();
          if ( Ext.isEmpty( rows ) ) {
            showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return;
          }
          if ( rows.length > 1 ) {
            showWarn( getTranslation( 'Wybierz tylko jedną zmienną procesu.' ) );
            return;
          }

          var row = rows[0];
          var win = new Ext.ux.suncode.VariableUtilizationWindow( {
            windowTitle: getTranslation( 'Komponenty wykorzystujące zmienną' ) + ': ' + row.get( 'name' ),
            showCustomDescription: true,
            showVariableUtilizationActions: true,
            enableRemoveAll: false,
            processNode: processNode,
            variableId: row.get( 'id' )
          } );
          win.show();
        }
    } );
    var copyButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'copy' ),
        tooltip: getTranslation( 'Kopiuj zmienne procesu' ),
        scope: this,
        handler: function() {
            var rows = this.getChoosenVariables();
            if ( Ext.isEmpty( rows ) ) {
            	showWarn( getTranslation( 'Wybierz zmienne procesu.' ) );
                return;
            }

            var store = this.getStore();
            var varRecord = store.recordType;

            Ext.each( rows, function( row, index, allRows ) {
                var varId = row.get( 'id' );
                var varCopy = processNode.copyVariable( varId );

                if ( Ext.isEmpty( varCopy ) ) {
                    showWarn( getTranslation( 'Zmienna procesu nie może zostać skopiowana. Zmień jej identyfikator.' ) );
                    return false;
                }

                store.add( new varRecord( {
                    id: varCopy.id,
                    name: varCopy.name,
                    type: varCopy.type,
                    placement: varCopy.placement,
                    creationDate: varCopy.creationDate,
                    modificationDate: varCopy.modificationDate
                } ) );
            } );

            store.commitChanges();
            this.updateTitle();
        }
    } );
    var addButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj zmienną procesu' ),
        scope: this,
        handler: function() {
            var variableDefWin = new Ext.ux.suncode.VariableDefWindow( {
                processNode: processNode,
                saveTo: this,
                varRecord: record
            } );
            variableDefWin.show();
        }
    } );
    var editButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj zmienną procesu' ),
        scope: this,
        handler: this.onEditVariable
    } );
    var deleteButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń zmienne procesu' ),
        scope: this,
        handler: function() {
        	var rows = this.getChoosenVariables();
            if ( Ext.isEmpty( rows ) ) {
            	showWarn( getTranslation( 'Wybierz zmienne procesu.' ) );
                return;
            }

            processNode.removeVariable( rows, this );
        }
    } );

    toolbarInfo.addButton( showUtilizationButton );
    toolbarInfo.addButton( copyButton );
    toolbarInfo.addButton( addButton );
    toolbarInfo.addButton( editButton );
    toolbarInfo.addButton( deleteButton );

    var typesChooser = new Ext.ux.suncode.TypesChooser( {
        utilization: 'extended'
    } );
    var placementsChooser = new Ext.ux.suncode.VariablePlacements( {} );

    config = Ext.apply( {
        title: getTranslation( 'Zmienne procesu' ),
        store: variablesStore,
        height: config.panelHeight,
        enableDragDrop: true,
        ddGroup: 'dd_process_variable',
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'id',
                header: getTranslation( 'Identyfikator' ),
                dataIndex: 'id',
                align: 'left',
                hidden: !config.AV,
                hideable: config.AV
            }, {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'type',
                header: getTranslation( 'Typ' ),
                dataIndex: 'type',
                align: 'left',
                editor: typesChooser,
                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                	switch ( value ) {
                		case 'LISTBOX':
                		case 'LISTBOX_EDIT':
                		case 'LISTBOX_NO_FILTER':
                		case 'LISTBOX_EDIT_NO_FILTER':
                		case 'LISTBOX_NO_LAZY':
                		case 'LISTBOX_NO_FILTER_NO_LAZY':
                			return getTranslation('Lista wartości');
                		default:
                			return Ext.util.Format.ComboBoxRenderer( typesChooser ).apply( typesChooser, [ value ] );
                	}
                }
            }, {
              id: 'placement',
              header: getTranslation( 'Umieszczenie' ),
              dataIndex: 'placement',
              align: 'left',
              renderer: Ext.util.Format.ComboBoxRenderer( placementsChooser )
            }, {
              id: 'creationDate',
              header: getTranslation( 'Data utworzenia' ),
              dataIndex: 'creationDate',
              align: 'center'
            }, {
              id: 'modificationDate',
              header: getTranslation( 'Data modyfikacji' ),
              dataIndex: 'modificationDate',
              align: 'center'
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak zmiennych procesu' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                    sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'name' ) + '</b>';
                }
            }
        } ),
        tbar: toolbarInfo,
        listeners: {
            scope: this,
            render: function( grid ) {
                new Ext.dd.DropTarget( grid.container, {
                    ddGroup: 'dd_process_variable',
                    copy: false,
                    grid: grid,
                    notifyOver: notifyOverGrid,
                    notifyDrop: function( dd, e, data ) {
                      notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                        dd.grid.onMoveVariable( sindex, dindex );
                      } );
                    }
                } );
            },
            rowdblclick: function( grid, rowIndex, e ) {
                this.onEditVariable();
            },
            containercontextmenu: this.onContainerContextMenu,
            rowcontextmenu: this.onRowContextMenu
        }
    }, config );

    Ext.ux.suncode.ProcessVariablesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessVariablesPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessVariablesPanel.superclass.initComponent.call( this );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var totalItem = tbar.items.first().totalItem;
        totalItem.setText(  getTranslation( 'Ilość zmiennych procesu' ) + ': ' + this.getStore().getCount() );
    },
    onEditVariable: function() {
    	  var rows = this.getChoosenVariables();
        if ( Ext.isEmpty( rows ) ) {
        	  showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return;
        }
        if ( rows.length > 1 ) {
        	showWarn( getTranslation( 'Wybierz tylko jedną zmienną procesu.' ) );
        	return;
        }

        var processNode = this.initialConfig.processNode;
        var row = rows[0];
        var varId = row.get( 'id' );
        var variable = processNode.findVariable( varId );

        if ( !Ext.ux.suncode.IntegrationComponentService.validateVariableEdit( variable ) ) {
          showWarn( getTranslation( 'Komponent dynamicznej listy o identyfikatorze' )
              + ' ' + variable.definition.id + ' ' + getTranslation( 'nie istnieje' ) + '.' );
          return;
        }

        var variableDefWin = new Ext.ux.suncode.VariableDefWindow( {
            variable: variable,
            processNode: processNode,
            saveTo: this,
            varRecord: row
        } );
        variableDefWin.show();
    },
    getChoosenVariables: function() {
        var selModel = this.getSelectionModel();
        
        return selModel.getSelections();
    },
    buildVariableCopyId: function( variable, counter ) {
        var newId = variable.id + counter;

        if ( newId.length > Ext.ux.suncode.Constants.VARIABLE_ID_MAX_LENGTH ) {
            return variable.id.substring( 0, variable.id.length - new String( counter ).length ) + counter;
        } else {
            return newId;
        }
    },
    onMoveVariable: function( sindex, dindex ) {
        if ( sindex != dindex ) {
            this.initialConfig.processNode.moveVariable( sindex, dindex );
        }
    },
    onNameFilterAfterRender: function( filter ) {
    	filter.getEl().on( 'keyup', function() {
    		this.applyNameFilter( filter.getValue() );
        }, this, {
            buffer: 500
        } );
    },
    applyNameFilter: function( value ) {
    	  var filtersPanel = this.getFiltersPanel();
        var typeFilter = filtersPanel.typeFilter;
        var placementFilter = filtersPanel.placementFilter;
        this.doFilterVariables( value, typeFilter.getFilterValue(), placementFilter.getFilterValue() );
    },
    clearNameFilter: function() {
    	  var filtersPanel = this.getFiltersPanel();
        var nameFilter = filtersPanel.nameFilter;
        var typeFilter = filtersPanel.typeFilter;
        var placementFilter = filtersPanel.placementFilter;
        nameFilter.setFilterValue( '' );
        this.doFilterVariables( '', typeFilter.getFilterValue(), placementFilter.getFilterValue() );
    },
    applyTypeFilter: function( combo, record, index ) {
    	var value = combo.getValue();
    	var filtersPanel = this.getFiltersPanel();
        var nameFilter = filtersPanel.nameFilter;
        var placementFilter = filtersPanel.placementFilter;
        this.doFilterVariables( nameFilter.getFilterValue(), value, placementFilter.getFilterValue() );
    },
    clearTypeFilter: function() {
    	var filtersPanel = this.getFiltersPanel();
        var nameFilter = filtersPanel.nameFilter;
        var typeFilter = filtersPanel.typeFilter;
        var placementFilter = filtersPanel.placementFilter;
        typeFilter.setFilterValue( '' );
        this.doFilterVariables( nameFilter.getFilterValue(), '', placementFilter.getFilterValue() );
    },
    applyPlacementFilter: function( combo, record, index ) {
    	var value = combo.getValue();
    	var filtersPanel = this.getFiltersPanel();
        var nameFilter = filtersPanel.nameFilter;
        var typeFilter = filtersPanel.typeFilter;
        this.doFilterVariables( nameFilter.getFilterValue(), typeFilter.getFilterValue(), value );
    },
    clearPlacementFilter: function() {
    	var filtersPanel = this.getFiltersPanel();
        var nameFilter = filtersPanel.nameFilter;
        var typeFilter = filtersPanel.typeFilter;
        var placementFilter = filtersPanel.placementFilter;
        placementFilter.setFilterValue( '' );
        this.doFilterVariables( nameFilter.getFilterValue(), typeFilter.getFilterValue(), '' );
    },
    getFiltersPanel: function() {
    	var tbar = this.getTopToolbar();
    	
        return tbar.items.first();
    },
    doFilterVariables: function( name, type, placement ) {
    	var nameRegex = new RegExp( Ext.escapeRe( name ), 'i' );
    	var typeRegex = new RegExp( Ext.escapeRe( type ), 'i' );
    	var placementRegex = new RegExp( Ext.escapeRe( placement ), 'i' );
    	var store = this.getStore();
    	
    	store.filterBy( function( record, id ) {
    		  var variableId = record.get( 'id' );
        	var variableName  = record.get( 'name' );
        	var variableType = record.get( 'type' );
        	var variablePlacement = record.get( 'placement' );
        	
        	return ( nameRegex.test( variableId ) || nameRegex.test( variableName ) )
        		&& typeRegex.test( variableType ) && placementRegex.test( variablePlacement );
    	} );
    	
    	this.updateTitle();
    },
    onContainerContextMenu: function( grid, e ) {
      this.showCopyPasteContextMenu( e );
    },
    onRowContextMenu: function( grid, rowIndex, e ) {
      var selModel = this.getSelectionModel();
      selModel.selectRow( rowIndex, true );

      this.showCopyPasteContextMenu( e );
    },
    showCopyPasteContextMenu: function( e ) {
      Ext.ux.suncode.Clipboard.getProcessVariables( function( variables ) {
        var menu = this.buildCopyPasteContextMenu( variables );
        showMenu( menu, e );
      }, this );
    },
    buildCopyPasteContextMenu: function( clipboardVariables ) {
      return new Ext.menu.Menu( {
        style: {
          zIndex: '30000'
        },
        items: [ this.buildCopyContextMenuItem(),
          this.buildPasteContextMenuItem( clipboardVariables ),
          this.buildPasteSpecialContextMenuItem() ]
      } );
    },
    buildCopyContextMenuItem: function() {
      var selModel = this.getSelectionModel();
      var rows = selModel.getSelections();

      return {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'copy' ),
        text: getTranslation( 'Kopiuj zmienne procesu' ),
        disabled: Ext.isEmpty( rows ),
        listeners: {
          scope: this,
          click: this.onCopyVariables
        }
      };
    },
    buildPasteContextMenuItem: function( clipboardVariables ) {
      return {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'paste' ),
        text: getTranslation( 'Wklej zmienne procesu' ),
        disabled: Ext.isEmpty( clipboardVariables ),
        clipboardVariables: clipboardVariables,
        listeners: {
          scope: this,
          click: this.onPasteVariables
        }
      };
    },
    buildPasteSpecialContextMenuItem: function() {
      return {
        xtype: 'menuitem',
        cls: 'x-btn-text-icon',
        icon: getPluginImgPath( 'paste' ),
        text: getTranslation( 'Wklej specjalnie' ),
        listeners: {
          scope: this,
          click: this.onPasteSpecial
        }
      };
    },
    onCopyVariables: function( menuItem, e ) {
      var processNode = this.initialConfig.processNode;
      var packageNode = processNode.parentNode;
      var packageId = packageNode.attributes.packageId;
      var processDefId = processNode.attributes.processDefId;
      var selModel = this.getSelectionModel();
      var rows = selModel.getSelections();
      var variables = new Array();

      Ext.each( rows, function( record, index, records ) {
        var variableId = record.get( 'id' );
        var variable = processNode.findVariable( variableId );
        var variableNameTranslationsKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATAFIELD(' + variable.id + ')';
        var variableDescrTranslationsKey = variableNameTranslationsKey + '_DESC';

        variables.push( {
          definition: variable,
          specification: Ext.ux.suncode.DocumentationService.getVariableSpecification( processNode, variable.id ),
          translations: {
            nameTranslations: Ext.ux.suncode.I18NService.getPackageTranslations( variableNameTranslationsKey ),
            descriptionTranslations: Ext.ux.suncode.I18NService.getPackageTranslations( variableDescrTranslationsKey )
          }
        } );
      }, this );

      Ext.ux.suncode.Clipboard.setProcessVariables( variables );
    },
    onPasteVariables: function( menuItem, e ) {
      var clipboardVariables = menuItem.clipboardVariables;

      this.executePasteVariables( clipboardVariables );
    },
    executePasteVariables: function( clipboardVariables ) {
      var processNode = this.initialConfig.processNode;
      var packageNode = processNode.parentNode;
      var packageId = packageNode.attributes.packageId;
      var processDefId = processNode.attributes.processDefId;
      var currentDate = new Date().format( 'Y-m-d H:i:s' );
      var store = this.getStore();
      var v = store.recordType;
      var exclusions = new Array();
      var duplicates = new Array();
      var anyPasted = false;

      Ext.each( clipboardVariables, function( clipboardVariable, idx, allClipboardVariables ) {
        var shouldPaste = true;
        var variable = clipboardVariable.definition;
        var variableCopy = deepObjectCopy( variable );
        variableCopy = Ext.apply( variableCopy, {
          creationDate: currentDate,
          modificationDate: currentDate
        } );
        var variableId = variableCopy.id;
        var variableName = variableCopy.name;

        if ( !Ext.isEmpty( variable.formActions ) ) {
          var categories = Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories();
          var validationResult = Ext.ux.suncode.IntegrationComponentService.validateComponentsPaste(
              categories, variable.formActions, processNode );

          if ( validationResult.isAnyInvalid() ) {
            shouldPaste = false;

            exclusions.push( {
              id: variableId,
              name: variableName,
              reason: validationResult.getInvalidMessage()
            } );
          }
        }

        if ( !Ext.isEmpty( variable.eventActions ) ) {
          var categories = Ext.getCmp( 'main_panel' ).getEventActionsCategories();
          var validationResult = Ext.ux.suncode.IntegrationComponentService.validateComponentsPaste(
              categories, variable.eventActions, processNode );

          if ( validationResult.isAnyInvalid() ) {
            shouldPaste = false;

            exclusions.push( {
              id: variableId,
              name: variableName,
              reason: validationResult.getInvalidMessage()
            } );
          }
        }

        if ( variable.type === 'DATA_CHOOSER' ) {
          if ( !Ext.isEmpty( variable.definition.id ) ) {
            var categories = Ext.getCmp( 'main_panel' ).getDataChoosersIntegrationComponentCategories();
            var validationResult = Ext.ux.suncode.IntegrationComponentService.validateComponentsPaste(
                categories, [ variable.definition ], processNode );

            if ( validationResult.isAnyInvalid() ) {
              shouldPaste = false;

              exclusions.push( {
                id: variableId,
                name: variableName,
                reason: validationResult.getInvalidMessage()
              } );
            }
          } else if ( !Ext.isEmpty( variable.mappings ) ) {
            Ext.each( variable.mappings, function( mapping, index, allMappings ) {
              if ( mapping.varId != variableId ) {
                var mappingVariable = processNode.findVariable( mapping.varId );

                exclusions.push( {
                  id: variableId,
                  name: variableName,
                  reason: getTranslation( 'Zmienna procesu' ) + ' <b>' + mapping.varId + '</b> ' +
                      getTranslation( 'użyta w mapowaniu nie istnieje w procesie' )
                } );
              }
            } );
          } else if ( !Ext.isEmpty( variable.definition.mappings ) ) {
            Ext.each( variable.definition.mappings, function( mapping, index, allMappings ) {
              if ( mapping.varId != variableId ) {
                var mappingVariable = processNode.findVariable(
                    mapping.variable);

                exclusions.push( {
                  id: variableId,
                  name: variableName,
                  reason: getTranslation( 'Zmienna procesu' ) + ' <b>' + mapping.varId + '</b> ' +
                      getTranslation( 'użyta w mapowaniu nie istnieje w procesie' )
                } );
              }
            } );
          }
        }

        if ( Ext.isEmpty( exclusions ) ) {
          var currentVariable = processNode.findVariable( variableId );

          if ( !Ext.isEmpty( currentVariable ) ) {
            shouldPaste = false;

            duplicates.push( {
              id: variableId,
              name: variableName,
              clipboardVariable: clipboardVariable
            } );
          }
        }

        if ( shouldPaste ) {
          processNode.addVariable( variableCopy );

          Ext.ux.suncode.DocumentationService.addVariableSpecification( processNode, variableId, clipboardVariable.specification );

          var variableNameTranslationsKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATAFIELD(' + variableId + ')';
          var variableDescrTranslationsKey = variableNameTranslationsKey + '_DESC';
          Ext.ux.suncode.I18NService.savePackageTranslations( variableNameTranslationsKey, clipboardVariable.translations.nameTranslations );
          Ext.ux.suncode.I18NService.savePackageTranslations( variableDescrTranslationsKey, clipboardVariable.translations.descriptionTranslations );

          var variableNameTranslation = getXpdlVariableNameTranslation(
              packageId, processDefId, variableId, variableName );

          var rec = new v({
            id: variableId,
            name: variableNameTranslation,
            type: variableCopy.type,
            placement: variableCopy.placement,
            creationDate: currentDate,
            modificationDate: currentDate
          });
          store.add( rec );

          anyPasted = true;
        }
      }, this );

      if ( anyPasted ) {
        store.commitChanges();
      }

      if ( !( Ext.isEmpty( exclusions ) && Ext.isEmpty( duplicates ) ) ) {
        var warnMsg = '';

        if ( !Ext.isEmpty( exclusions ) ) {
          warnMsg += this.buildPasteVariablesWarningMessage(
              getTranslation( 'Zmienne procesu wykluczone podczas wklejania' ), exclusions );

          if ( !Ext.isEmpty( duplicates ) ) {
            warnMsg += '<br><br>';
          }
        }

        if ( !Ext.isEmpty( duplicates ) ) {
          warnMsg += this.buildPasteVariablesWarningMessage(
              getTranslation( 'Duplikaty pominięte podczas wklejania' ), duplicates );
          warnMsg += '<br><br>';
          warnMsg += getTranslation('Czy chcesz stworzyć kopie duplikatów?');
        }

        if ( Ext.isEmpty( duplicates ) ) {
          showWarn( warnMsg );
        } else {
          Ext.Msg.show( {
            title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
            msg: warnMsg,
            buttons: {
              yes: getTranslation( 'Tak' ),
              no: getTranslation( 'Nie' )
            },
            fn: function( buttonId ) {
              if ( buttonId == 'yes' ) {
                this.createAndPasteDuplicates( duplicates );
              }
            },
            icon: Ext.Msg.QUESTION,
            scope: this
          } );
        }
      }
    },
    buildPasteVariablesWarningMessage: function( description, variableIssues ) {
      var msg = '';
      msg += description;
      msg += ':';

      Ext.each( variableIssues, function( variableIssue, index, allVariableIssues ) {
        msg += '<br>- ';
        msg += variableIssue.name;

        if ( !Ext.isEmpty( variableIssue.reason ) ) {
          msg += ' (';
          msg += getTranslation( 'powód' );
          msg += ': ';
          msg += lowerFirstLetter( variableIssue.reason );
          msg += ')';
        }
      } );

      return msg;
    },
    createAndPasteDuplicates: function( duplicates ) {
      var currentDate = new Date().format( 'Y-m-d H:i:s' );
      var processNode = this.initialConfig.processNode;
      var packageNode = processNode.parentNode;
      var packageId = packageNode.attributes.packageId;
      var processDefId = processNode.attributes.processDefId;
      var store = this.getStore();
      var v = store.recordType;

      Ext.each( duplicates, function( duplicate, index, allDuplicates ) {
        var variable = duplicate.clipboardVariable.definition;
        var variableId = processNode.generateVariableCopyId( variable );

        variable = Ext.apply( variable, {
          id: variableId
        } );

        if ( variable.type == 'DATA_CHOOSER' ) {
          if ( !Ext.isEmpty( variable.mappings ) ) {
            for ( var i = 0; i < variable.mappings.length; i++ ) {
              var mapping = variable.mappings[i];

              if ( mapping.varId == varId ) {
                mapping.varId = variableId;
              }
            }
          } else if ( !Ext.isEmpty( variable.definition.mappings ) ) {
            Ext.iterate( variable.definition.mappings, function( key, mapping, allMappings ) {
              if ( mapping.variable === varId ) {
                mapping.variable = variableId;
              }
            } );
          }
        }

        processNode.addVariable( variable );

        Ext.ux.suncode.DocumentationService.addVariableSpecification( processNode, variableId, duplicate.clipboardVariable.specification );

        var variableNameTranslationsKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_DATAFIELD(' + variableId + ')';
        var variableDescrTranslationsKey = variableNameTranslationsKey + '_DESC';
        Ext.ux.suncode.I18NService.savePackageTranslations(
            variableNameTranslationsKey, duplicate.clipboardVariable.translations.nameTranslations );
        Ext.ux.suncode.I18NService.savePackageTranslations(
            variableDescrTranslationsKey, duplicate.clipboardVariable.translations.descriptionTranslations );

        var variableName = variable.name;
        var variableNameTranslation = getXpdlVariableNameTranslation(
            packageId, processDefId, variableId, variableName );

        var rec = new v({
          id: variableId,
          name: variableNameTranslation,
          type: variable.type,
          placement: variable.placement,
          creationDate: currentDate,
          modificationDate: currentDate
        });
        store.add( rec );
      }, this );

      store.commitChanges();
    },
    onPasteSpecial: function() {
      var win = new Ext.ux.suncode.PasteSpecialWindow( {
        pasteSpecialFunction: function( variables ) {
          this.executePasteVariables( variables );
        },
        pasteSpecialScope: this,
        messageType: Ext.ux.suncode.Clipboard.processVariablesMessageType
      } );
      win.show();
    }
} );

Ext.ux.suncode.ProcessTablesPanel = function( config ) {
  var processNode = config.processNode;

  var record = Ext.data.Record.create( [ {
    name: 'id',
    type: 'string'
  }, {
    name: 'name',
    type: 'string'
  }, {
    name: 'creationDate',
    type: 'string'
  }, {
    name: 'modificationDate',
    type: 'string'
  } ] );

  var store = new Ext.data.Store( {
    reader: new Ext.data.JsonReader( {
      fields: record
    } )
  } );

  var tables = processNode.attributes.tables;
  if ( !Ext.isEmpty( tables ) ) {
    store.loadData( tables );
    store.commitChanges();
  }

  config = Ext.apply( {
    title: getTranslation( 'Tabele' ),
    store: store,
    height: config.panelHeight,
    enableDragDrop: true,
    ddGroup: 'dd_process_table',
    enableColumnResize: true,
    columnLines: true,
    autoScroll: true,
    border: false,
    colModel: new Ext.grid.ColumnModel( {
      defaults: {
        sortable: true,
        menuDisabled: false
      },
      columns: [ {
        id: 'id',
        header: getTranslation( 'Identyfikator' ),
        dataIndex: 'id',
        align: 'left',
        hidden: !config.AV,
        hideable: config.AV
      }, {
        id: 'name',
        header: getTranslation( 'Tytuł' ),
        dataIndex: 'name',
        align: 'left'
      }, {
        id: 'creationDate',
        header: getTranslation( 'Data utworzenia' ),
        dataIndex: 'creationDate',
        align: 'center'
      }, {
        id: 'modificationDate',
        header: getTranslation( 'Data modyfikacji' ),
        dataIndex: 'modificationDate',
        align: 'center'
      } ]
    } ),
    viewConfig: new Ext.ux.suncode.StandardGridView( {
      emptyText: getTranslation( 'Brak tabel' )
    } ),
    sm: new Ext.grid.RowSelectionModel( {
      singleSelect: true,
      listeners: {
        beforerowselect: function( sm, i, ke, row ) {
          sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'name' ) + '</b>';
        }
      }
    } ),
    tbar: new Ext.Toolbar( {
      items: [ {
        xtype: 'panel',
        layout: 'form',
        border: false,
        width: 300,
        labelWidth: 100,
        items: [ {
          xtype: 'label',
          cls: 'x-Module-total',
          style: {
            display: 'block',
            marginBottom: '5px'
          },
          ref: 'totalItem',
          text: getTranslation( 'Ilość tabel' ) + ': ' + store.getCount()
        }, {
          xtype: 'compositefield',
          fieldLabel: getTranslation( 'Tytuł' ),
          ref: 'titleFilter',
          getFilterValue: function() {
            return this.items.first().getValue();
          },
          setFilterValue: function( value ) {
            var filter = this.items.first();
            filter.setValue( value );
          },
          items: [ {
            xtype: 'textfield',
            emptyText: getTranslation( 'Szukaj' ) + '...',
            flex: 1,
            cls: 'x-Module-field-leftAlign',
            listeners: {
              scope: this,
              afterrender: this.onTitleFilterAfterRender
            }
          }, {
            xtype: 'button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'clear' ),
            tooltip: getTranslation( 'Wyczyść filtr' ),
            flex: 0,
            handler: this.clearTitleFilter,
            scope: this
          } ]
        } ]
      }, {
        xtype: 'tbfill',
      }, {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj tabelę' ),
        handler: this.addTable,
        scope: this
      }, {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj tabelę' ),
        handler: this.editTable,
        scope: this
      }, {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń tabelę' ),
        handler: this.removeTable,
        scope: this
      } ]
    } ),
    listeners: {
      scope: this,
      render: function( grid ) {
        new Ext.dd.DropTarget( grid.container, {
          ddGroup: 'dd_process_table',
          copy: false,
          grid: grid,
          notifyDrop: function( dd, e, data ) {
            var store = dd.grid.store;
            var sm = dd.grid.getSelectionModel();
            var rows = sm.getSelections();
            var dragData = dd.getDragData( e );
            if ( dragData ) {
              var sindex = dd.dragData.rowIndex;
              var dindex = dragData.rowIndex;
              if ( typeof ( dindex ) != 'undefined' ) {
                store.remove( store.getById( rows[0].id ) );
                store.insert( dindex, data.selections );
                sm.clearSelections();
                dd.grid.onMoveTable( sindex, dindex );
              }
            }
          }
        } );
      },
      rowdblclick: function( grid, rowIndex, e ) {
        this.editTable();
      }
    }
  }, config );

  Ext.ux.suncode.ProcessTablesPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessTablesPanel, Ext.grid.GridPanel, {
  initComponent: function() {
    Ext.ux.suncode.ProcessTablesPanel.superclass.initComponent.call( this );
  },
  updateTitle: function() {
    var tbar = this.getTopToolbar();
    var totalItem = tbar.items.first().totalItem;
    totalItem.setText(  getTranslation( 'Ilość tabel' ) + ': ' + this.getStore().getCount() );
  },
  addTable: function() {
    var processNode = this.initialConfig.processNode;
    var varRecord = this.getStore().recordType;
    var tableDefWin = new Ext.ux.suncode.GlobalGridDefWindow( {
      globalDefinition: true,
      processNode: processNode,
      saveTo: this,
      varRecord: varRecord
    } );
    tableDefWin.show();
  },
  editTable: function() {
    var row = this.getChoosenTable();
    if ( !row ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    var tableId = row.get( 'id' );
    var table = processNode.findTable( tableId );
    var tableDefWin = new Ext.ux.suncode.GlobalGridDefWindow( {
      globalDefinition: true,
      processNode: processNode,
      saveTo: this,
      varRecord: row,
      table: table
    } );
    tableDefWin.show();
  },
  removeTable: function() {
    var row = this.getChoosenTable();
    if ( !row ) {
      return;
    }

    var processNode = this.initialConfig.processNode;
    processNode.removeTable( row, this );
  },
  getChoosenTable: function() {
    var selModel = this.getSelectionModel();
    var row = selModel.getSelected();
    if ( !row ) {
      showWarn( getTranslation( 'Wybierz tabelę.' ) );
      return null;
    }
    return row;
  },
  onMoveTable: function( sindex, dindex ) {
    if ( sindex != dindex ) {
      this.initialConfig.processNode.moveTable( sindex, dindex );
    }
  },
  onTitleFilterAfterRender: function( filter ) {
    filter.getEl().on( 'keyup', function() {
      this.applyTitleFilter( filter.getValue() );
    }, this, {
      buffer: 500
    } );
  },
  applyTitleFilter: function( value ) {
    this.doFilterTables( value );
  },
  clearTitleFilter: function() {
    var filtersPanel = this.getFiltersPanel();
    var titleFilter = filtersPanel.titleFilter;
    titleFilter.setFilterValue( '' );
    this.doFilterTables( '' );
  },
  getFiltersPanel: function() {
    var tbar = this.getTopToolbar();

    return tbar.items.first();
  },
  doFilterTables: function( title ) {
    var titleRegex = new RegExp( Ext.escapeRe( title ), 'i' );
    var store = this.getStore();

    store.filterBy( function( record, id ) {
      var tableId = record.get( 'id' );
      var tableTitle  = record.get( 'name' );

      return ( titleRegex.test( tableId ) || titleRegex.test( tableTitle ) );
    } );

    this.updateTitle();
  }
} );

Ext.ux.suncode.ProcessLabelsPanel = function( config ) {
    var processNode = config.processNode;

    var record = Ext.data.Record.create( [ {
        name: 'id',
        type: 'string'
    }, {
        name: 'name',
        type: 'string'
    } ] );

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: record
        } )
    } );

    var labels = processNode.attributes.labels;
    if ( !Ext.isEmpty( labels ) ) {
    	store.loadData( labels );
    	store.commitChanges();
    }

    var toolbarInfo = new Ext.Toolbar( {
        labelChoosen: function() {
            var grid = this.ownerCt;
            var selModel = grid.getSelectionModel();
            var v = selModel.getSelected();
            if ( !v ) {
                showWarn( getTranslation( 'Wybierz etykietę.' ) );
                return null;
            }
            return v;
        }
    } );
    toolbarInfo.add( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość etykiet' ) + ': ' + store.getCount()
                    + '</b></font>' );
    toolbarInfo.addFill();

    var addButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'add' ),
        tooltip: getTranslation( 'Dodaj etykietę' ),
        handler: function() {
            var labelDefWin = new Ext.ux.suncode.LabelDefWindow( {
                processNode: processNode,
                saveTo: this,
                labelRecord: record
            } );
            labelDefWin.show();
        },
        scope: this
    } );
    var editButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj etykietę' ),
        handler: function() {
            var row = this.ownerCt.labelChoosen();
            if ( !row ) {
                return;
            }

            var labelId = row.get( 'id' );
            var label = processNode.findLabel( labelId );
            var labelDefWin = new Ext.ux.suncode.LabelDefWindow( {
            	label: label,
                processNode: processNode,
                saveTo: this.ownerCt.ownerCt,
                labelRecord: row
            } );
            labelDefWin.show();
        }
    } );
    var deleteButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'delete' ),
        tooltip: getTranslation( 'Usuń etykietę' ),
        handler: function() {
            var v = this.ownerCt.labelChoosen();
            if ( !v ) {
                return;
            }

            var grid = this.ownerCt.ownerCt;
            processNode.removeLabel( v, grid );
        }
    } );

    toolbarInfo.addButton( addButton );
    toolbarInfo.addButton( editButton );
    toolbarInfo.addButton( deleteButton );

    config = Ext.apply( {
        title: getTranslation( 'Etykiety' ),
        store: store,
        height: config.panelHeight,
        enableDragDrop: true,
        ddGroup: 'dd_process_label',
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'id',
                header: getTranslation( 'Identyfikator' ),
                dataIndex: 'id',
                align: 'left',
                hidden: !config.AV,
                hideable: config.AV
            }, {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak etykiet' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true,
            listeners: {
                beforerowselect: function( sm, i, ke, row ) {
                    sm.grid.ddText = '<b style="font-size: 12px;">' + row.get( 'name' ) + '</b>';
                }
            }
        } ),
        tbar: toolbarInfo,
        listeners: {
            scope: this,
            render: function( grid ) {
                new Ext.dd.DropTarget( grid.container, {
                    ddGroup: 'dd_process_label',
                    copy: false,
                    grid: grid,
                    notifyOver: notifyOverGrid,
                    notifyDrop: function( dd, e, data ) {
                        notifyDropGrid( dd, e, data, function( sindex, dindex ) {
                          dd.grid.onMoveLabel( sindex, dindex );
                        } );
                    }
                } );
            },
            rowdblclick: function( grid, rowIndex, e ) {
                editButton.handler.call( editButton, e );
            }
        }
    }, config );

    Ext.ux.suncode.ProcessLabelsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessLabelsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ProcessLabelsPanel.superclass.initComponent.call( this );
    },
    updateTitle: function() {
        var tbar = this.getTopToolbar();
        var txtInfo = tbar.items.first();
        txtInfo.setText( '<font ' + getTotalStyle() + '><b>' + getTranslation( 'Ilość etykiet' ) + ': ' + this.getStore().getCount()
                        + '</b></font>' );
    },
    onMoveLabel: function( sindex, dindex ) {
        if ( sindex != dindex ) {
            this.initialConfig.processNode.moveLabel( sindex, dindex );
        }
    }
} );

Ext.ux.suncode.ProcessPropertiesTopToolbar = function( config ) {
    var mainPanel = Ext.getCmp( 'main_panel' );
    var processNode = config.processNode;
    var win = config.win;
    var items = new Array();

    var savePropertiesButton = new Ext.Button( {
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'save' ),
        tooltip: getTranslation( 'Zapisz' ),
        handler: function() {
            var win = this.ownerCt.ownerCt;
            var oldProcessDefId = processNode.attributes.processDefId;
            var newProcessDefId = win.idItem.getValue();
            var newProcessName = win.nameItem.getValue();
            var processDescr = win.descrItem.getValue();
            var packageNode = processNode.parentNode;

            if ( Ext.isEmpty( newProcessDefId ) || Ext.isEmpty( newProcessName ) ) {
                showWarn( getTranslation( 'Podaj identyfikator i nazwę procesu.' ) );
                return;
            } else if ( newProcessName.length > 255 ) {
                showWarn( getTranslation( 'Nazwa procesu nie może przekroczyć 255 znaków.' ) );
                return;
            } else if ( processDescr.length > Ext.ux.suncode.Constants.PROCESS_DEF_DESCRIPTION_MAX_LENGTH ) {
                showWarn( getTranslation( 'Opis procesu nie może przekroczyć 255 znaków.' ) );
                return;
            } else if ( oldProcessDefId != newProcessDefId && !packageNode.isIdUnique( newProcessDefId ) ) {
                showWarn( getTranslation( 'Wygenerowany identyfikator definicji procesu nie jest unikalny.' ) );
                return;
            }

            if ( oldProcessDefId != newProcessDefId ) {
              Ext.ux.suncode.I18NService.onProcessDefIdChange( oldProcessDefId, newProcessDefId );
              Ext.ux.suncode.I18NService.updatePackageTranslationsFromCaches( [ win.nameItem, win.descrItem ] );
            }

            var processColor = win.colorItem.items.first().color;

            processNode.updateProcessDef( {
                processDefId: newProcessDefId,
                processName: newProcessName,
                processColor: processColor,
                processNameMask: win.processNameMaskItem.getValue(),
                processDescr: processDescr
            } );
            processNode.updateSubflowsIds( oldProcessDefId, newProcessDefId );

            var paperPanel = Ext.getCmp( 'paper_panel' );
            paperPanel.updateProcessTab( oldProcessDefId, newProcessDefId, newProcessName, processColor );
            updateProcessTabTip();

            packageNode.sortProcesses();

            mainPanel.setSaved( false );
            win.close();
        }
    } );
    items.push( savePropertiesButton );

    if ( mainPanel.getDocumentationView() ) {
        var editSpecificationButton = new Ext.Button( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'specification' ),
            tooltip: getTranslation( 'Specyfikacja' ),
            handler: function() {
                editProcessSpecification( processNode );
            }
        } );
        items.push( editSpecificationButton );
    }

    var closeWindowButton = new Ext.ux.suncode.CloseWindowButton( {
    	win: win
    } );
    items.push( closeWindowButton );

    config = Ext.apply( {
        items: items
    }, config );

    Ext.ux.suncode.ProcessPropertiesTopToolbar.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ProcessPropertiesTopToolbar, Ext.Toolbar, {
    initComponent: function() {
        Ext.ux.suncode.ProcessPropertiesTopToolbar.superclass.initComponent.call( this );
    }
} );