Ext.ux.suncode.StandardDataChoosersWindow = function( config ) {
    config = Ext.apply( {
        modal: true,
        width: Ext.getBody().getViewSize().width * 0.8,
        autoHeight: true,
        resizable: false,
        title: getTranslation( 'Systemowe dynamiczne listy' ),
        items: new Ext.ux.suncode.StandardDataChoosersGrid( config ),
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Wybierz' ),
                handler: this.chooseDC,
                scope: this,
                ref: 'saveBtn'
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                cancel: false,
                handler: this.closeWindow,
                scope: this,
                ref: 'closeBtn'
            } ]
        } )
    }, config );

    Ext.ux.suncode.StandardDataChoosersWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.StandardDataChoosersWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.StandardDataChoosersWindow.superclass.initComponent.call( this );
    },
    chooseDC: function() {
        this.dcGrid.onChooseDC();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.StandardDataChoosersGrid = function( config ) {
    var dcs = Ext.getCmp( 'main_panel' ).getStandardDataChoosers();

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'name',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            }, {
                name: 'classpath',
                type: 'string'
            }, {
                name: 'id',
                type: 'int'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( dcs ) ) {
        Ext.each( dcs, function( dc, index, allDcs ) {
            store.loadData( dc.definition, true );
            store.commitChanges();
        } );
        store.sort( 'name', 'ASC' );
    }

    config = Ext.apply( {
        height: Ext.getBody().getViewSize().height * 0.8,
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        ref: 'dcGrid',
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                id: 'classpath',
                header: getTranslation( 'Ścieżka do klasy' ),
                dataIndex: 'classpath',
                align: 'left'
            }, {
                id: 'id',
                header: 'id',
                dataIndex: 'id',
                align: 'left',
                hidden: true,
                hideable: false
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: ''
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        listeners: {
            scope: this,
            rowdblclick: function() {
                this.onChooseDC();
            }
        }
    }, config );

    Ext.ux.suncode.StandardDataChoosersGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.StandardDataChoosersGrid, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.StandardDataChoosersGrid.superclass.initComponent.call( this );
    },
    onChooseDC: function() {
        var rec = this.getSelectionModel().getSelected();
        if ( !rec ) {
            showWarn( getTranslation( 'Wskaż systemową dynamiczną listę.' ) );
            return;
        }

        this.ownerCt.closeWindow();
        this.initialConfig.saveTo.onChooseDC( rec.get( 'id' ) );
    }
} );