Raphael.fn.simul = {
    simulConfig: null,
    simulFlow: null,
    historyIndex: 0,
    process: null,
    activitySplitters: [],
    splittedActivities: [],
    routeColor: '#A7CB59',
    activityColor: '#D6ECF7',
    toolColor: '#CFCFCF',
    subflowColor: '#F39804',
    dotR: 6,
    pathsInProgress: 0,
    markElTasks: [],
    resizeFactor: 1.2,
    elsBasket: null,
    framesBaskat: null,
    linesBasket: null,
    pieMargin: 10,
    legendOffset: 32,
    legendCircleR: 6,
    timeout: null,
    currentActivityMarked: false,
    currentActivityEl: null,
    markCurrentActivity: function( config ) {
        this.simulateProcess( config );
        var activityDefId = config.activityDefId;
        var process = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var paper = process.paper;
        var currentActivityEl = null;

        paper.forEach( function( el ) {
            if ( el.data( 'connector' ) && el.data( 'activityDefId' ) == activityDefId ) {
                currentActivityEl = el;
                return false;
            }
        } );

        if ( currentActivityEl ) {
            var box = currentActivityEl.getBBox();
            scrollToProcessObject( process, {
                x: box.x,
                x2: box.x2,
                y: box.y,
                y2: box.y2
            } );

            if ( currentActivityEl.frame ) {
                currentActivityEl.frame.remove();
            }

            this.currentActivityEl = currentActivityEl;
            var mainPanel = Ext.getCmp( 'main_panel' );
            var hoverColor = mainPanel.getHoverColor();
            var animationsOn = mainPanel.getAnimationsOn();

            this.enableActivityOutgoingConditions( paper, currentActivityEl );
            this.markActivityWithPaths( paper, currentActivityEl, hoverColor, animationsOn );
        }
    },
    enableActivityOutgoingConditions: function( paper, activityEl ) {
        for ( var i = 0; i < activityEl.outCondConnections.length; i++ ) {
            var conn = activityEl.outCondConnections[i];
            conn.pathSet.hover( paper.simul.hoverBoxIn, paper.simul.hoverBoxOut, conn.box, conn.box );
        }
    },
    disableActivityOutgoingConditions: function( paper, activityEl ) {
        for ( var i = 0; i < activityEl.outCondConnections.length; i++ ) {
            var conn = activityEl.outCondConnections[i];
            conn.pathSet.unhover( paper.simul.hoverBoxIn, paper.simul.hoverBoxOut );
        }
    },
    markActivityWithPaths: function( paper, activityEl, hoverColor, animationsOn ) {
        var timeoutTime = 1000;

        if ( this.currentActivityMarked ) {
            timeoutTime = 2000;
        }

        this.timeout = window.setTimeout( function() {
            if ( !Raphael.fn.simul.currentActivityMarked ) {
                var color = Ext.getCmp( 'main_panel' ).getHoverColor();
                var frame = paper.bpmn.highlightTask( paper, activityEl, color );
                activityEl.frame = frame;
                paper.simul.markAllActivityTransitions( activityEl, hoverColor, animationsOn );

                Raphael.fn.simul.currentActivityMarked = true;
            } else {
                activityEl.frame.remove();
                paper.simul.unmarkAllActivityTransitions( activityEl );

                Raphael.fn.simul.currentActivityMarked = false;
            }

            paper.simul.markActivityWithPaths( paper, activityEl, hoverColor, animationsOn );
        }, timeoutTime );
    },
    markAllActivityTransitions: function( activityEl, hoverColor, animationsOn ) {
        for ( var i = 0; i < activityEl.outConnections.length; i++ ) {
            var conn = activityEl.outConnections[i];
            this.changeLineAttrs( conn.pathSet, hoverColor, 3, 3, animationsOn );
        }

        for ( var i = 0; i < activityEl.outCondConnections.length; i++ ) {
            var conn = activityEl.outCondConnections[i];
            this.changeLineAttrs( conn.pathSet, hoverColor, 3, 3, animationsOn );

            var connections = conn.connections;

            for ( var j = 0; j < connections.length; j++ ) {
                var inConn = connections[j];
                this.changeLineAttrs( inConn.pathSet, hoverColor, 3, 3, animationsOn );
            }
        }

        for ( var i = 0; i < activityEl.outOtherwises.length; i++ ) {
            var conn = activityEl.outOtherwises[i];
            this.changeLineAttrs( conn.pathSet, hoverColor, 3, 3, animationsOn );
        }

        for ( var i = 0; i < activityEl.outExceptions.length; i++ ) {
            var conn = activityEl.outExceptions[i];
            this.changeLineAttrs( conn.pathSet, hoverColor, 3, 3, animationsOn );
        }

        for ( var i = 0; i < activityEl.deadlineClocks.length; i++ ) {
            activityEl.deadlineClocks[i].clock.toFront();
        }
    },
    unmarkAllActivityTransitions: function( activityEl ) {
        for ( var i = 0; i < activityEl.outConnections.length; i++ ) {
            var conn = activityEl.outConnections[i];
            this.changeLineAttrs( conn.pathSet, '#444444', 1, 0, false );
        }

        for ( var i = 0; i < activityEl.outCondConnections.length; i++ ) {
            var conn = activityEl.outCondConnections[i];
            this.changeLineAttrs( conn.pathSet, '#444444', 1, 0, false );

            var connections = conn.connections;

            for ( var j = 0; j < connections.length; j++ ) {
                var inConn = connections[j];
                this.changeLineAttrs( inConn.pathSet, '#444444', 1, 0, false );
            }
        }

        for ( var i = 0; i < activityEl.outOtherwises.length; i++ ) {
            var conn = activityEl.outOtherwises[i];
            this.changeLineAttrs( conn.pathSet, '#444444', 1, 0, false );
        }

        for ( var i = 0; i < activityEl.outExceptions.length; i++ ) {
            var conn = activityEl.outExceptions[i];
            this.changeLineAttrs( conn.pathSet, '#444444', 1, 0, false );
        }
    },
    simulateProcess: function( config ) {
        this.simulConfig = config;
        var process = Ext.getCmp( 'paper_panel' ).getActiveTab();
        var paper = process.paper;

        if ( config.skipFlow ) {
            this.enableToolbarButtons();
            this.showSimulationSummary();
            return;
        }

        this.activitySplitters = [];
        this.splittedActivities = [];
        this.simulFlow = [].concat( config.simulationHistory.processHistory );
        this.historyIndex = 0;
        this.process = process;
        this.clearMarkingCurrentActivity( paper );
        this.clearSimulation( paper );
        var processStart = this.findProcessStart( paper );

        if ( !processStart ) {
            this.enableToolbarButtons();
            showWarn( 'Brak rozpoczęcia procesu.' );
            return;
        }

        if ( !config.fastFlow ) {
            scrollToProcessObject( process, processStart.getBBox() );
        }

        this.markEl( paper, processStart );
    },
    findProcessStart: function( paper ) {
        var processStart = null;

        paper.forEach( function( el ) {
            var setType = el.data( 'setType' );

            if ( setType == 'start' ) {
                processStart = el;
                return false;
            }
        } );

        return processStart;
    },
    clearSimulation: function( paper ) {
        if ( this.elsBasket ) {
            for ( var i = 0; i < this.elsBasket.length; i++ ) {
                var el = this.elsBasket[i];
                delete el.frame;
            }
        }
        this.elsBasket = new Array();

        if ( this.framesBaskat ) {
            this.framesBaskat.remove();
        }
        this.framesBaskat = paper.set();

        if ( this.linesBasket ) {
            this.linesBasket.forEach( function( set ) {
                paper.simul.changeLineAttrs( set, '#444444', 1, 0, false );
            } );
        }
        this.linesBasket = paper.set();
    },
    clearMarkingCurrentActivity: function( paper ) {
        window.clearTimeout( this.timeout );
        this.currentActivityMarked = false;

        if ( this.currentActivityEl ) {
            if ( this.currentActivityEl.frame ) {
                this.currentActivityEl.frame.remove();
                delete this.currentActivityEl.frame;
            }

            this.disableActivityOutgoingConditions( paper, this.currentActivityEl );
            this.unmarkAllActivityTransitions( this.currentActivityEl );
        }

        this.currentActivityEl = null;
    },
    addToElsBasket: function( el ) {
        this.elsBasket.push( el );
    },
    addToFramesBasket: function( el ) {
        this.framesBaskat.push( el );
    },
    addToLinesBasket: function( el ) {
        this.linesBasket.push( el );
    },
    setDistinctionColor: function( paper, color ) {
        if ( this.framesBaskat ) {
            this.framesBaskat.forEach( function( el ) {
                if ( el.canChangeColor ) {
                    el.attr( {
                        stroke: color
                    } );
                }
            } );
        }

        if ( this.linesBasket ) {
            this.linesBasket.forEach( function( set ) {
                paper.simul.changeLineAttrs( set, color, 3, 3, false );
            } );
        }
    },
    markEl: function( paper, el ) {
        var fastFlow = this.simulConfig.fastFlow;
        var setType = el.data( 'setType' );

        if ( setType == 'conditionalLineBox' ) {
            if ( el.data( 'conditionType' ) == 'AND' ) {
                this.activitySplitters.push( el.pathData );
            }

            this.handleNextConnection( el.pathData );
            return;
        }

        this.addToElsBasket( el );
        var box = el.getBBox();
        var oldWidth = box.width;
        var oldHeight = box.height;
        var newWidth = Math.floor( oldWidth * this.resizeFactor );
        var newHeight = Math.floor( oldHeight * this.resizeFactor );
        var frame = el.frame;
        var hoverColor = '';
        var speed = this.simulConfig.speedValue;

        if ( setType == 'start' || setType == 'stop' ) {
            if ( setType == 'start' ) {
                hoverColor = '#308E11';
            } else if ( setType == 'stop' ) {
                hoverColor = '#E16E6E';
            }

            var r = paper.bpmn.startStopDiameter / 2;

            if ( !frame ) {
                frame = paper.circle( box.x + r, box.y + r, r );
                frame.canChangeColor = false;

                this.addToFramesBasket( frame );
                el.frame = frame;
            }

            if ( fastFlow ) {
                frame.attr( {
                    stroke: hoverColor,
                    'stroke-width': 3
                } );
            } else {
                var newR = parseInt( r + r * ( this.resizeFactor - 1 ) / 2 );
                frame.animate( {
                    stroke: hoverColor,
                    'stroke-width': 3,
                    r: newR
                }, parseInt( 40 / speed ), 'elastic' );
            }
        } else {
            hoverColor = this.simulConfig.distinctionColor;

            if ( !frame ) {
                frame = paper.rect( box.x, box.y, paper.bpmn.activityWidth, paper.bpmn.activityHeight, 10 );
                frame.canChangeColor = true;

                this.addToFramesBasket( frame );
                el.frame = frame;
            }

            if ( fastFlow ) {
                frame.attr( {
                    stroke: hoverColor,
                    'stroke-width': 3
                } );
            } else {
                frame.animate( {
                    stroke: hoverColor,
                    'stroke-width': 3,
                    x: frame.attr( 'x' ) - ( newWidth - oldWidth ) / 2,
                    y: frame.attr( 'y' ) - ( newHeight - oldHeight ) / 2,
                    width: newWidth,
                    height: newHeight
                }, parseInt( 40 / speed ), 'elastic' );
            }
        }

        if ( !fastFlow ) {
            el.toFront();
        }

        for ( var i = 0; i < el.deadlineClocks.length; i++ ) {
            el.deadlineClocks[i].clock.toFront();
        }

        if ( fastFlow ) {
            this.executeFindNextConnection( paper, el );
        } else {
            var taskNameEl = el.data( 'taskNameElement' );
            if ( taskNameEl ) {
                taskNameEl.toFront();
                taskNameEl.animate( {
                    'font-size': 13
                }, parseInt( 40 / speed ), 'linear' );
            }

            el.animate( {
                x: el.attr( 'x' ) - ( newWidth - oldWidth ) / 2,
                y: el.attr( 'y' ) - ( newHeight - oldHeight ) / 2,
                width: newWidth,
                height: newHeight
            }, parseInt( 40 / speed ), 'elastic', this.showActivityForm );
        }
    },
    showActivityForm: function( e ) {
        var el = this;
        var setType = el.data( 'setType' );
        var paper = el.paper;
        var delay = 0;
        var activityHistoryWindow = null;

        if ( paper.simul.simulConfig.showForms && !( setType == 'start' || setType == 'stop' ) ) {
            delay = paper.simul.simulConfig.formDisplayTimeValue;

            var activityHistory = paper.simul.simulConfig.simulationHistory.processHistory[paper.simul.historyIndex];
            paper.simul.historyIndex++;

            activityHistoryWindow = new Ext.ux.suncode.ActivityHistoryWindow( {
                processId: activityHistory.processId,
                activityId: activityHistory.activityId
            } );
            activityHistoryWindow.show();
        }

        window.setTimeout( function() {
            if ( activityHistoryWindow ) {
                activityHistoryWindow.close();
            }

            paper.simul.restoreSize( el );
        }, 1000 * delay );
    },
    restoreSize: function( el ) {
        var box = el.getBBox();
        var oldWidth = box.width;
        var oldHeight = box.height;
        var newWidth = Math.ceil( oldWidth / this.resizeFactor );
        var newHeight = Math.ceil( oldHeight / this.resizeFactor );
        var setType = el.data( 'setType' );
        var frame = el.frame;
        var speed = this.simulConfig.speedValue;

        if ( setType == 'start' ) {
            var r = frame.attr( 'r' );
            var newR = parseInt( r - r * ( this.resizeFactor - 1 ) / 2 );
            frame.animate( {
                r: newR
            }, parseInt( 40 / speed ), 'elastic' );
        } else if ( setType == 'stop' ) {
            var r = frame.attr( 'r' );
            var newR = parseInt( r - r * ( this.resizeFactor - 1 ) / 2 );
            frame.animate( {
                r: newR
            }, parseInt( 40 / speed ), 'elastic' );
        } else {
            frame.animate( {
                x: frame.attr( 'x' ) + ( oldWidth - newWidth ) / 2,
                y: frame.attr( 'y' ) + ( oldHeight - newHeight ) / 2,
                width: newWidth,
                height: newHeight
            }, parseInt( 40 / speed ), 'elastic' );
        }

        var taskNameEl = el.data( 'taskNameElement' );
        if ( taskNameEl ) {
            taskNameEl.animate( {
                'font-size': 10
            }, parseInt( 40 / speed ), 'linear' );
        }

        el.animate( {
            x: el.attr( 'x' ) + ( oldWidth - newWidth ) / 2,
            y: el.attr( 'y' ) + ( oldHeight - newHeight ) / 2,
            width: newWidth,
            height: newHeight
        }, parseInt( 40 / speed ), 'elastic', this.findNextConnection );
    },
    findNextConnection: function( e ) {
        var paper = this.paper;
        paper.simul.executeFindNextConnection( paper, this );
    },
    executeFindNextConnection: function( paper, el ) {
        if ( !Ext.isEmpty( this.simulFlow ) ) {
            if ( this.lookForConnectionWithStop( paper, el ) ) {
                return;
            }

            var nextActivity = this.simulFlow.shift();
            var nextActivityDefId = nextActivity.activityDefId;

            this.analyzeJoiningActivities( paper, nextActivityDefId );

            if ( this.analyzeElConnections( paper, el, nextActivityDefId ) ) {
                return;
            }

            this.splittedActivities.push( el );

            if ( this.analyzeActivitySplitters( paper, nextActivityDefId ) ) {
                return;
            }

            if ( this.analyzeSplittedActivities( paper, nextActivityDefId ) ) {
                return;
            }
        } else {
            if ( this.lookForConnectionWithStop( paper, el ) ) {
                return;
            }
        }

        this.finishSimulation();
    },
    handleNextConnection: function( pathData ) {
        if ( this.simulConfig.fastFlow ) {
            var hoverColor = this.simulConfig.distinctionColor;
            var pathSet = pathData.pathSet;
            this.addToLinesBasket( pathSet );
            this.changeLineAttrs( pathSet, hoverColor, 3, 3, false );
            this.markEl( pathData.paper, pathData.connectedWith );
        } else {
            this.pathsInProgress++;
            this.followPath( pathData );
        }
    },
    analyzeElConnections: function( paper, el, nextActivityDefId, preventBubbling ) {
        for ( var i = 0; i < el.outConnections.length; i++ ) {
            var conn = el.outConnections[i];
            var connectedWith = conn.connectedWith;
            var activityDefId = connectedWith.data( 'activityDefId' );

            if ( activityDefId == nextActivityDefId ) {
                this.handleNextConnection( {
                    paper: paper,
                    pathSet: conn.pathSet,
                    connectedWith: connectedWith,
                    preventBubbling: preventBubbling
                } );
                return true;
            }
        }

        for ( var i = 0; i < el.outCondConnections.length; i++ ) {
            var conn = el.outCondConnections[i];
            var box = conn.box;
            var connectFrom = box.data( 'connectFrom' );
            var connections = conn.connections;
            var pathData = null;

            for ( var j = 0; j < connections.length; j++ ) {
                var inConn = connections[j];
                var connectedWith = inConn.connectedWith;
                var activityDefId = connectedWith.data( 'activityDefId' );

                if ( activityDefId == nextActivityDefId ) {
                    pathData = {
                        paper: paper,
                        pathSet: inConn.pathSet,
                        connectedWith: connectedWith,
                        connections: connections,
                        connectFrom: connectFrom
                    };
                    break;
                }
            }

            if ( pathData ) {
                box = Ext.apply( {
                    pathData: pathData
                }, box );

                this.handleNextConnection( {
                    paper: paper,
                    pathSet: conn.pathSet,
                    connectedWith: box,
                    preventBubbling: preventBubbling
                } );
                return true;
            }
        }

        for ( var i = 0; i < el.outOtherwises.length; i++ ) {
            var conn = el.outOtherwises[i];
            var connectedWith = conn.connectedWith;
            var activityDefId = connectedWith.data( 'activityDefId' );

            if ( activityDefId == nextActivityDefId ) {
                this.handleNextConnection( {
                    paper: paper,
                    pathSet: conn.pathSet,
                    connectedWith: connectedWith,
                    preventBubbling: preventBubbling
                } );
                return true;
            }
        }

        for ( var i = 0; i < el.outExceptions.length; i++ ) {
            var conn = el.outExceptions[i];
            var connectedWith = conn.connectedWith;
            var activityDefId = connectedWith.data( 'activityDefId' );

            if ( activityDefId == nextActivityDefId ) {
                this.handleNextConnection( {
                    paper: paper,
                    pathSet: conn.pathSet,
                    connectedWith: connectedWith,
                    preventBubbling: preventBubbling
                } );
                return true;
            }
        }

        return false;
    },
    analyzeActivitySplitters: function( paper, nextActivityDefId ) {
        for ( var i = 0; i < this.activitySplitters.length; i++ ) {
            var activitySplitter = this.activitySplitters[i];
            var connections = activitySplitter.connections;

            for ( var j = 0; j < connections.length; j++ ) {
                var inConn = connections[j];
                var connectedWith = inConn.connectedWith;
                var activityDefId = connectedWith.data( 'activityDefId' );

                if ( activityDefId == nextActivityDefId ) {
                    this.handleNextConnection( {
                        paper: paper,
                        pathSet: inConn.pathSet,
                        connectedWith: connectedWith
                    } );
                    return true;
                }
            }

            var connectFrom = activitySplitter.connectFrom;

            if ( this.analyzeElConnections( paper, connectFrom, nextActivityDefId ) ) {
                return true;
            }
        }

        return false;
    },
    analyzeSplittedActivities: function( paper, nextActivityDefId ) {
        for ( var i = 0; i < this.splittedActivities.length; i++ ) {
            var splittedActivity = this.splittedActivities[i];

            if ( this.analyzeElConnections( paper, splittedActivity, nextActivityDefId ) ) {
                return true;
            }
        }

        return false;
    },
    analyzeJoiningActivities: function( paper, nextActivityDefId ) {
        var activities = new Array();

        for ( var i = 0; i < this.splittedActivities.length; i++ ) {
            var splittedActivity = this.splittedActivities[i];

            if ( !this.analyzeElConnections( paper, splittedActivity, nextActivityDefId, true ) ) {
                activities.push( splittedActivity );
            }
        }

        this.splittedActivities = [].concat( activities );
    },
    lookForConnectionWithStop: function( paper, el ) {
        for ( var i = 0; i < el.outConnections.length; i++ ) {
            var conn = el.outConnections[i];
            var connectedWith = conn.connectedWith;
            var setType = connectedWith.data( 'setType' );

            if ( setType == 'stop' ) {
                this.handleNextConnection( {
                    paper: paper,
                    pathSet: conn.pathSet,
                    connectedWith: connectedWith
                } );
                return true;
            }
        }

        return false;
    },
    followPath: function( pathData ) {
        var hoverColor = this.simulConfig.distinctionColor;
        var paper = pathData.paper;
        var pathSet = pathData.pathSet;
        var pathLine = pathSet[0];
        var pathAttr = pathLine.attr( 'path' );
        pathAttr = handlePathAttrType( pathAttr );

        this.addToLinesBasket( pathSet );
        this.changeLineAttrs( pathSet, hoverColor, 3, 3, false );

        var seg = pathAttr[0];
        var x = seg[1];
        var y = seg[2];
        var xOffset = paper.bpmn.activityWidth;
        var yOffset = paper.bpmn.activityHeight;

        scrollToProcessObject( this.process, {
            x: x - xOffset,
            x2: x + xOffset,
            y: y - yOffset,
            y2: y + yOffset
        } );

        var dot = paper.circle( x, y, this.dotR );
        dot.data( 'pathAttr', pathAttr ).data( 'connectedWith', pathData.connectedWith ).data( 'pathSegCounter', 1 ).data( 'preventBubbling',
                        pathData.preventBubbling );
        dot.animate( {
            fill: hoverColor,
            'stroke-width': 0
        }, 1, 'linear', this.moveOnPath );
    },
    changeLineAttrs: function( set, color, lineStrokeWidth, arrowStrokeWidth, animate ) {
        set.toFront();

        set.forEach( function( el ) {
            if ( el.data( 'isArrow' ) ) {
                if ( animate ) {
                    el.animate( {
                        fill: color,
                        stroke: color,
                        'stroke-width': arrowStrokeWidth
                    }, 500 );
                } else {
                    el.attr( {
                        fill: color,
                        stroke: color,
                        'stroke-width': arrowStrokeWidth
                    } );
                }
            } else if ( el.data( 'conditionSign' ) ) {
                el.toFront();
            } else {
                if ( animate ) {
                    el.animate( {
                        stroke: color,
                        'stroke-width': lineStrokeWidth
                    }, 500 );
                } else {
                    el.attr( {
                        stroke: color,
                        'stroke-width': lineStrokeWidth
                    } );
                }
            }
        } );
    },
    moveOnPath: function( e ) {
        var dot = this;
        var paper = dot.paper;
        var pathAttr = dot.data( 'pathAttr' );
        var pathSegCounter = dot.data( 'pathSegCounter' );
        var seg = pathAttr[pathSegCounter];

        if ( seg ) {
            var x1 = dot.attr( 'cx' );
            var y1 = dot.attr( 'cy' );
            var x2 = seg[1];
            var y2 = seg[2];
            var xOffset = paper.bpmn.activityWidth;
            var yOffset = paper.bpmn.activityHeight;
            var speed = paper.simul.simulConfig.speedValue;
            var animDuration = parseInt( paper.simul.sectionLength( x1, x2, y1, y2 ) / speed );

            scrollToProcessObject( paper.simul.process, {
                x: x2 - xOffset,
                x2: x2 + xOffset,
                y: y2 - yOffset,
                y2: y2 + yOffset
            } );

            dot.data( 'pathSegCounter', pathSegCounter + 1 );
            dot.animate( {
                cx: parseInt( seg[1] ),
                cy: parseInt( seg[2] )
            }, animDuration, 'linear', paper.simul.moveOnPath );
        } else {
            paper.simul.pathsInProgress--;
            var preventBubbling = dot.data( 'preventBubbling' );
            var connectedWith = dot.data( 'connectedWith' );
            dot.remove();

            if ( !preventBubbling ) {
                paper.simul.markElTasks.push( {
                    run: function( paper, connectedWith ) {
                        this.markEl( paper, connectedWith );

                        return false;
                    },
                    scope: paper.simul,
                    args: [ paper, connectedWith ],
                    interval: 1
                } );
            }

            paper.simul.startMarkElTask();
        }
    },
    startMarkElTask: function() {
        if ( this.shouldStartMarkElTask() ) {
            Ext.TaskMgr.start( this.markElTasks.pop() );
        }
    },
    shouldStartMarkElTask: function() {
        return ( this.pathsInProgress == 0 && !Ext.isEmpty( this.markElTasks ) );
    },
    sectionLength: function( x1, x2, y1, y2 ) {
        return Math.sqrt( Math.pow( x2 - x1, 2 ) + Math.pow( y2 - y1, 2 ) );
    },
    finishSimulation: function() {
        this.enableToolbarButtons();

        if ( !this.simulConfig.fastFlow && this.simulConfig.showSummary ) {
            this.showSimulationSummary();
        }
    },
    enableToolbarButtons: function() {
        Ext.getCmp( 'paper_panel' ).getTopToolbar().enableAllButtons();
    },
    showSimulationSummary: function() {
        var win = new Ext.ux.suncode.ProcessSimulationResultsWindow( {
            processHistory: this.simulConfig.simulationHistory.processHistory
        } );
        win.show();
    },
    drawParticipantsStatPie: function( piePanel ) {
        var hoverTrash = new Array();
        var dataSet = new Array();
        var colorFactor = 0;
        var simulationInfo = Ext.getCmp( 'main_panel' ).getSimulationInfo();
        var simulationHistory = simulationInfo.simulationHistory.processHistory;
        var participantsActivity = 0;
        var participants = new Object();

        for ( var i = 0; i < simulationHistory.length; i++ ) {
            var activityHistory = simulationHistory[i];
            var userId = activityHistory.activityUserId;

            if ( userId ) {
                var activityDuration = activityHistory.activityDuration;

                if ( participants.hasOwnProperty( userId ) ) {
                    participants[userId].participantActivity += activityDuration;
                } else {
                    participants[userId] = {
                        participantId: userId,
                        participantName: activityHistory.activityPerformer,
                        participantActivity: activityDuration
                    };
                }

                participantsActivity += activityDuration;
            }
        }

        for ( var userId in participants ) {
            var p = participants[userId];
            var percent = countAsPercent( participantsActivity, p.participantActivity, 2 );
            percent = formatPercentAsText( percent, 2 );

            dataSet.push( {
                legendLabel: p.participantName + ' (' + percent + ')\n' + millisToText( p.participantActivity ),
                magnitude: p.participantActivity,
                label: percent,
                color: Raphael.hsb( colorFactor, 1, 1 ),
                data: {
                    id: Ext.id(),
                    name: p.participantName,
                    time: p.participantActivity
                }
            } );

            colorFactor += 0.1;
        }

        var customMouseOver = function( e ) {
            var pGroup = this.data( 'data' );
            var tooltipText = '<table border="0"><tr><td width="25"><img src="' + getPluginImgPath( 'timing' ) + '"></td>';
            tooltipText += '<td><b>' + getTranslation( 'Uczestnik' ) + ':</b> ' + pGroup.name + '<br>';
            tooltipText += '<b>' + getTranslation( 'Aktywność' ) + ':</b> ' + millisToText( pGroup.time );
            tooltipText += '</td></tr></table>';

            var tooltip = new Ext.ux.suncode.TooltipInfo( {
                info: tooltipText,
                maxWidth: 400
            } );
            tooltip.showAt( getEventXY( e, 5 ) );
            hoverTrash.push( tooltip );
        };

        var customMouseOut = function( e ) {
            Ext.each( hoverTrash, function( el, index, els ) {
                el.remove();
            } );

            hoverTrash = new Array();
        };

        this.drawPieWithLegend( piePanel, dataSet, {
            animate: this.simulConfig.animationsOn,
            sectorOverColor: this.simulConfig.distinctionColor,
            sectorMouseover: customMouseOver,
            sectorMouseout: customMouseOut
        }, {
            legendTitle: getTranslation( 'Procentowy udział aktywności uczestników' ) + ':',
            textMouseover: customMouseOver,
            textMouseout: customMouseOut
        } );
    },
    drawTasksStatPie: function( piePanel ) {
        var hoverTrash = new Array();
        var dataSet = new Array();
        var simulationInfo = Ext.getCmp( 'main_panel' ).getSimulationInfo();
        var simulationHistory = simulationInfo.simulationHistory.processHistory;
        var packagePanel = Ext.getCmp( 'package_panel' );
        var allTasks = simulationHistory.length;
        var tasks = {
            routes: {
                genre: 'route',
                amount: 0,
                names: [],
                label: getTranslation( 'Przekierowania' ),
                color: this.routeColor
            },
            activities: {
                genre: 'activity',
                amount: 0,
                names: [],
                label: getTranslation( 'Zadania' ),
                color: this.activityColor
            },
            tools: {
                genre: 'tool',
                amount: 0,
                names: [],
                label: getTranslation( 'Narzędzia' ),
                color: this.toolColor
            },
            subflows: {
                genre: 'subflow',
                amount: 0,
                names: [],
                label: getTranslation( 'Podprocesy' ),
                color: this.subflowColor
            }
        };

        for ( var i = 0; i < simulationHistory.length; i++ ) {
            var activityHistory = simulationHistory[i];
            var activityNode = packagePanel.findActivity( activityHistory.processDefId, activityHistory.activityDefId );

            switch ( activityNode.attributes.activityType ) {
                case Ext.ux.suncode.Constants.ROUTE:
                    tasks.routes.amount++;
                    tasks.routes.names.push( activityNode.attributes.activityName );
                    break;
                case Ext.ux.suncode.Constants.ACTIVITY:
                    tasks.activities.amount++;
                    tasks.activities.names.push( activityNode.attributes.activityName );
                    break;
                case Ext.ux.suncode.Constants.TOOL:
                    tasks.tools.amount++;
                    tasks.tools.names.push( activityNode.attributes.activityName );
                    break;
                case Ext.ux.suncode.Constants.SUBFLOW:
                    tasks.subflows.amount++;
                    tasks.subflows.names.push( activityNode.attributes.activityName );
                    break;
                default:
                    break;
            }
        }

        for ( var taskType in tasks ) {
            var task = tasks[taskType];

            if ( task.amount > 0 ) {
                var percent = countAsPercent( allTasks, task.amount, 2 );
                percent = formatPercentAsText( percent, 2 );

                dataSet.push( {
                    legendLabel: task.label + ' - ' + task.amount + ' / ' + allTasks + ' (' + percent + ')',
                    magnitude: task.amount,
                    label: percent,
                    color: task.color,
                    data: {
                        id: Ext.id(),
                        names: task.names,
                        genre: task.genre
                    }
                } );
            }
        }

        var customMouseOver = function( e ) {
            var taskGroup = this.data( 'data' );
            var tooltipStart = '';
            var imgSrc = '';

            switch ( taskGroup.genre ) {
                case 'route':
                    tooltipStart = getTranslation( 'Przekierowania' );
                    imgSrc = getPluginImgPath( 'route_small' );
                    break;
                case 'activity':
                    tooltipStart = getTranslation( 'Zadania' );
                    imgSrc = getPluginImgPath( 'activity_small' );
                    break;
                case 'tool':
                    tooltipStart = getTranslation( 'Narzędzia' );
                    imgSrc = getPluginImgPath( 'tool_small' );
                    break;
                case 'subflow':
                    tooltipStart = getTranslation( 'Podprocesy' );
                    imgSrc = getPluginImgPath( 'subflow_small' );
                    break;
                default:
                    return;
            }

            var tooltipText = '<table border="0"><tr><td width="25"><img src="' + imgSrc + '"></td>';
            tooltipText += '<td><b>' + tooltipStart + ' ' + getTranslation( 'wykonane podczas symulacji procesu' ) + ':</b><br>';

            var taskNames = taskGroup.names;
            var taskNamesLength = taskNames.length;
            for ( var i = 0; i < taskNamesLength; i++ ) {
                tooltipText += ( i + 1 ) + '. ' + taskNames[i];

                if ( i != taskNamesLength - 1 ) {
                    tooltipText += '<br>';
                }
            }

            tooltipText += '</td></tr></table>';

            var tooltip = new Ext.ux.suncode.TooltipInfo( {
                info: tooltipText,
                maxWidth: 400
            } );
            tooltip.showAt( getEventXY( e, 5 ) );
            hoverTrash.push( tooltip );
        };

        var customMouseOut = function( e ) {
            Ext.each( hoverTrash, function( el, index, els ) {
                el.remove();
            } );

            hoverTrash = new Array();
        };

        this.drawPieWithLegend( piePanel, dataSet, {
            animate: this.simulConfig.animationsOn,
            sectorOverColor: this.simulConfig.distinctionColor,
            sectorMouseover: customMouseOver,
            sectorMouseout: customMouseOut
        }, {
            legendTitle: getTranslation( 'Procentowy udział ilości zadań' ) + ':',
            textMouseover: customMouseOver,
            textMouseout: customMouseOut
        } );
    },
    drawPieWithLegend: function( piePanel, dataSet, pieConfig, legendConfig ) {
        var piePaper = Raphael( piePanel.body.id, piePanel.getWidth(), piePanel.getHeight() );
        var distinctionColor = this.simulConfig.distinctionColor;
        var outerRadius = parseInt( ( piePanel.getHeight() - 2 * this.pieMargin ) / 2 );
        var innerRadius = parseInt( outerRadius / 1.1 );
        piePaper.pieChart( outerRadius + this.pieMargin, outerRadius + this.pieMargin, innerRadius, dataSet, pieConfig );

        var legendPosX = 2 * ( outerRadius + this.pieMargin ) + this.legendOffset;
        var legendPosY = 2 * this.pieMargin;
        var circleTextSpace = 2 * this.legendCircleR + 10;
        piePaper.text( legendPosX, legendPosY, legendConfig.legendTitle ).attr( {
            'text-anchor': 'start',
            fill: '#000000',
            stroke: 'none',
            'font-size': 14,
            'font-family': 'Tahoma,Helvetica,sans-serif',
            'font-weight': 'bold'
        } );

        for ( var i = 0; i < dataSet.length; i++ ) {
            var legendLabel = dataSet[i].legendLabel;

            if ( legendLabel.indexOf( '\n' ) != -1 ) {
                legendPosY += 3 * this.pieMargin;
            } else {
                legendPosY += 2 * this.pieMargin;
            }

            piePaper.circle( legendPosX + this.legendCircleR, legendPosY, this.legendCircleR ).attr( {
                fill: dataSet[i].color,
                stroke: 'none'
            } );

            var legendText = piePaper.text( legendPosX + circleTextSpace, legendPosY, legendLabel ).attr( {
                'text-anchor': 'start',
                fill: '#000000',
                stroke: 'none',
                'font-size': 12,
                'font-family': 'Tahoma,Helvetica,sans-serif',
                'font-weight': 'bold'
            } ).data( 'data', dataSet[i].data );
            legendText.mouseover( function( e ) {
                this.attr( {
                    fill: distinctionColor
                } );
                eve( 'piechart.mouseover.' + this.data( 'data' ).id );
            } ).mouseout( function( e ) {
                this.attr( {
                    fill: '#000000'
                } );
                eve( 'piechart.mouseout.' + this.data( 'data' ).id );
            } );
            if ( Ext.isFunction( legendConfig.textMouseover ) ) {
                legendText.mouseover( legendConfig.textMouseover );
            }
            if ( Ext.isFunction( legendConfig.textMouseout ) ) {
                legendText.mouseout( legendConfig.textMouseout );
            }
        }
    },
    hoverTaskIn: function( e ) {
        var paper = this.paper;

        if ( paper.touchpad && paper.touchpad.touchConfig.active ) {
            return;
        }

        var actDefId = this.data( 'activityDefId' );
        var setType = this.data( 'setType' );

        var simulationInfo = Ext.getCmp( 'main_panel' ).getSimulationInfo();
        var simulationHistory = simulationInfo.simulationHistory.processHistory;
        var activitiesTab = new Array();

        for ( var i = 0; i < simulationHistory.length; i++ ) {
            var activityHistory = simulationHistory[i];

            if ( activityHistory.activityDefId == actDefId ) {
                activitiesTab.push( activityHistory );
            }
        }

        var img = '';
        var noExecutionText = '';
        switch ( setType ) {
            case 'route':
                img = getPluginImgPath( 'route_small' );
                noExecutionText = getTranslation( 'Przekierowanie nie zostało wykonane' );
                break;
            case 'activity':
                img = getPluginImgPath( 'activity_small' );
                noExecutionText = getTranslation( 'Zadanie nie zostało wykonane' );
                break;
            case 'tool':
                img = getPluginImgPath( 'tool_small' );
                noExecutionText = getTranslation( 'Narzędzie nie zostało wykonane' );
                break;
            case 'subflow':
                img = getPluginImgPath( 'subflow_small' );
                noExecutionText = getTranslation( 'Podproces nie został wykonany' );
                break;
            default:
                break;
        }

        var tooltipText = '<table border="0"><tr><td width="25"><img src="' + img + '"></td>';

        if ( Ext.isEmpty( activitiesTab ) ) {
            tooltipText += '<td><b>' + getTranslation( noExecutionText ) + '</b></td></tr></table>';
        } else {
            tooltipText += '<td>';

            for ( var i = 0; i < activitiesTab.length; i++ ) {
                var activityHistory = activitiesTab[i];

                tooltipText += '<b>' + getTranslation( 'Status' ) + ':</b> ' + activityHistory.activityState + '<br>';
                tooltipText += '<b>' + getTranslation( 'Wykonawca' ) + ':</b> ' + activityHistory.activityPerformer + '<br>';
                tooltipText += '<b>' + getTranslation( 'Czas utworzenia' ) + ':</b> ' + activityHistory.activityCreated + '<br>';
                tooltipText += '<b>' + getTranslation( 'Czas uruchomienia' ) + ':</b> ' + activityHistory.activityStarted + '<br>';
                tooltipText += '<b>' + getTranslation( 'Czas zakończenia' ) + ':</b> ' + activityHistory.activityFinished;

                if ( i != activitiesTab.length - 1 ) {
                    tooltipText += '<hr ' + getHRLineStyle() + '>';
                }
            }

            tooltipText += '</td>';
        }

        tooltipText += '</tr></table>';

        var activityTooltip = new Ext.ux.suncode.TooltipInfo( {
            info: tooltipText,
            maxWidth: 400
        } );
        activityTooltip.showAt( getEventXY( e, 5 ) );
        paper.hoverTrash.push( activityTooltip );
    },
    hoverTaskOut: function( e ) {
        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.hoverTrash );
    },
    hoverBoxIn: function( e ) {
        if ( this.hovered ) {
            return;
        }

        this.hovered = true;
        var paper = this.paper;
        var actDefId = this.data( 'connectFrom' ).data( 'activityDefId' );
        if ( !actDefId ) {
            return;
        }

        var packagePanel = Ext.getCmp( 'package_panel' );
        var packageNode = packagePanel.getRootNode();
        var packageId = packageNode.attributes.packageId;
        var processDefId = Ext.getCmp( 'paper_panel' ).getActiveTab().processDefId;
        var activityNode = packagePanel.findActivity( processDefId, actDefId );
        var tooltipText = '<table border="0"><tr><td width="25">';
        tooltipText += '<img src="' + getPluginImgPath( 'condition' ) + '"></td>';
        tooltipText += '<td><b><u>' + getTranslation( 'Warunki' ) + ':</u></b><br>';

        Ext.each( activityNode.attributes.transitions.cond, function( t, idx, ts ) {
            var toActivityNode = packagePanel.findActivity( processDefId, t.to );
            var toActivityName = toActivityNode.attributes.activityName;
            var toActivityDefId = toActivityNode.attributes.activityDefId;
            var toActivityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, toActivityDefId, toActivityName );

            var cond = t.condition;
            cond = cond.replaceAll( '&&', getTranslation( 'i' ) ).replaceAll( '||', getTranslation( 'lub' ) );
            tooltipText += '<b>' + toActivityNameTranslation + ':</b> ' + cond + '<br>';
        } );

        tooltipText += '</td></tr></table>';

        var boxTooltip = new Ext.ux.suncode.TooltipInfo( {
            info: tooltipText,
            maxWidth: 400
        } );
        boxTooltip.showAt( getEventXY( e, 5 ) );
        paper.hoverTrash.push( boxTooltip );
    },
    hoverBoxOut: function( e ) {
        delete this.hovered;
        var paper = this.paper;
        paper.bpmn.eraseTrash( paper.hoverTrash );
    },
    showActivityDetails: function( e ) {
        var activityDefId = this.data( 'activityDefId' );
        var simulationInfo = Ext.getCmp( 'main_panel' ).getSimulationInfo();
        var simulationHistory = simulationInfo.simulationHistory.processHistory;

        for ( var i = 0; i < simulationHistory.length; i++ ) {
            var activityHistory = simulationHistory[i];

            if ( activityHistory.activityDefId == activityDefId ) {
                showActivityDetails( activityHistory.processId, activityHistory.activityId );
                return;
            }
        }
    }
};