Ext.ux.suncode.IntegrationComponentTemplateWindow = function( config ) {
	var viewSize = Ext.getBody().getViewSize();
	
    config = Ext.apply( {
        width: viewSize.width * 0.4,
        height: viewSize.height * 0.6,
        modal: true,
        frame: false,
        layout: 'fit',
        items: [ new Ext.ux.suncode.IntegrationComponentTemplateTable( {
        	editionMode: config.editionMode,
        	processNode: config.processNode,
          enableCopyPasteMenu: config.enableCopyPasteMenu,
        	conditionalExecutionEnabled: config.conditionalExecutionEnabled,
        	inactiveEnabled: config.inactiveEnabled,
        	componentsTableTitle: config.componentsTableTitle,
        	categories: config.categories,
        	parametersWindowTitlePrefix: config.parametersWindowTitlePrefix,
        	noComponentsMessage: config.noComponentsMessage,
        	systemFunctionsAccessibility: config.systemFunctionsAccessibility,        	
        	getTemplatesFunction: config.getTemplatesFunction,
        	getTemplatesScope: config.getTemplatesScope,
        	getTemplateFunction: config.getTemplateFunction,
        	getTemplateScope: config.getTemplateScope,
        	addTemplateFunction: config.addTemplateFunction,
        	addTemplateScope: config.addTemplateScope,
        	editTemplateFunction: config.editTemplateFunction,
        	editTemplateScope: config.editTemplateScope,
        	removeTemplateFunction: config.removeTemplateFunction,
        	removeTemplateScope: config.removeTemplateScope,
        	useTemplateFunction: config.useTemplateFunction,
        	useTemplateScope: config.useTemplateScope,
        	getTemplateUtilizationFieldsFunction: config.getTemplateUtilizationFieldsFunction,
        	getTemplateUtilizationFieldsScope: config.getTemplateUtilizationFieldsScope,
        	getTemplateUtilizationFunction: config.getTemplateUtilizationFunction,
        	getTemplateUtilizationScope: config.getTemplateUtilizationScope,
          getTemplateUtilizationColumnsFunction: config.getTemplateUtilizationColumnsFunction,
          getTemplateUtilizationColumnsScope: config.getTemplateUtilizationColumnsScope,
          getComponentRegistrationFunction: config.getComponentRegistrationFunction,
          getComponentRegistrationScope: config.getComponentRegistrationScope,
          copyComponentsFunction: config.copyComponentsFunction,
          copyComponentsScope: config.copyComponentsScope,
          handleCopiedComponentsFunction: config.handleCopiedComponentsFunction,
          handleCopiedComponentsScope: config.handleCopiedComponentsScope,
          pasteSpecialMessageType: config.pasteSpecialMessageType
        } ) ],
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.IntegrationComponentTemplateWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentTemplateWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentTemplateWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.IntegrationComponentTemplateTable = function( config ) {
	var templates = new Array();
	var getTemplatesFunc = config.getTemplatesFunction;
	var buttons = new Array();
	
	if ( Ext.isFunction( getTemplatesFunc ) ) {
		var getTemplatesScope = !Ext.isEmpty( config.getTemplatesScope ) ? config.getTemplatesScope : window;
		templates = getTemplatesFunc.apply( getTemplatesScope, [] );
	}

    var store = new Ext.data.Store( {
    	data: templates,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'id',
                type: 'string'
            }, {
                name: 'name',
                type: 'string'
            }, {
            	name: 'components',
            }, {
                name: 'noOfComponents',
                type: 'int',
                convert: function( v, record ) {
                	return record['components'].length;
                }
            } ] )
        } )
    } );
    
    buttons.push( '->' );
    if ( config.editionMode ) {
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'utilization' ),
            tooltip: getTranslation( 'Pokaż wykorzystanie szablonu' ),
            handler: this.showTemplateUtilization,
            scope: this
        } );
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'add' ),
            tooltip: getTranslation( 'Dodaj szablon' ),
            handler: this.addTemplate,
            scope: this
        } );
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'edit' ),
            tooltip: getTranslation( 'Edytuj szablon' ),
            handler: this.editTemplate,
            scope: this
        } );
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'delete' ),
            tooltip: getTranslation( 'Usuń szablon' ),
            handler: this.removeTemplate,
            scope: this
        } );
    } else {
    	buttons.push( {
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'template' ),
            tooltip: getTranslation( 'Wybierz szablon' ),
            handler: this.chooseTemplate,
            scope: this
        } );
    }

    config = Ext.apply( {
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'id',
                dataIndex: 'id',
                hidden: true,
                hideable: false
            }, {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left'
            }, {
                id: 'noOfComponents',
                header: getTranslation( 'Liczba komponentów' ),
                dataIndex: 'noOfComponents',
                align: 'center',
                width: 50
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            buttons: buttons
        } ),
        listeners: {
            scope: this,
            rowdblclick: function( grid, rowIndex, e ) {
            	if ( grid.editionMode ) {
            		this.editTemplate();
            	} else {
            		this.chooseTemplate();
            	}
            }
        }
    }, config );

    Ext.ux.suncode.IntegrationComponentTemplateTable.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentTemplateTable, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentTemplateTable.superclass.initComponent.call( this );
    },
    showTemplateUtilization: function() {
    	var selected = this.getSelectedTemplate();
        if ( !selected ) {
            return;
        }
        
        this.executeShowTemplateUtilization( selected );
    },
    executeShowTemplateUtilization: function( selected ) {
    	var getTemplateFunction = this.initialConfig.getTemplateFunction;
        
        if ( Ext.isFunction( getTemplateFunction ) ) {
			var templateId = selected.get( 'id' );
			var getTemplateScope = !Ext.isEmpty( this.initialConfig.getTemplateScope ) ?
					this.initialConfig.getTemplateScope : window;
			var savedTemplate = getTemplateFunction.apply( getTemplateScope, [ templateId ] );
			
	        var win = new Ext.ux.suncode.IntegrationComponentTemplateUtilizationWindow( {
	        	template: savedTemplate,
	        	getTemplateUtilizationFieldsFunction: this.initialConfig.getTemplateUtilizationFieldsFunction,
	        	getTemplateUtilizationFieldsScope: this.initialConfig.getTemplateUtilizationFieldsScope,
	        	getTemplateUtilizationFunction: this.initialConfig.getTemplateUtilizationFunction,
	        	getTemplateUtilizationScope: this.initialConfig.getTemplateUtilizationScope,
	    		getTemplateUtilizationColumnsFunction: this.initialConfig.getTemplateUtilizationColumnsFunction,
	    		getTemplateUtilizationColumnsScope: this.initialConfig.getTemplateUtilizationColumnsScope
	        } );
	        win.show();
        }
    },
    addTemplate: function() {
    	var win = new Ext.ux.suncode.IntegrationComponentTemplateEditorWindow( {
    		title: getTranslation( 'Kreator szablonu' ),
    		templateId: this.generateUniqueTemplateId(),
    		processNode: this.initialConfig.processNode,
    		conditionalExecutionEnabled: this.initialConfig.conditionalExecutionEnabled,
    		inactiveEnabled: this.initialConfig.inactiveEnabled,
    		componentsTableTitle: this.initialConfig.componentsTableTitle,
    		categories: this.initialConfig.categories,
    		parametersWindowTitlePrefix: this.initialConfig.parametersWindowTitlePrefix,
    		noComponentsMessage: this.initialConfig.noComponentsMessage,
    		systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
    		saveCallback: function( template ) {
    			var addTemplateFunction = this.initialConfig.addTemplateFunction;
    			
    			if ( Ext.isFunction( addTemplateFunction ) ) {
    				var addTemplateScope = !Ext.isEmpty( this.initialConfig.addTemplateScope ) ?
    						this.initialConfig.addTemplateScope : window;
    				addTemplateFunction.apply( addTemplateScope, [ template ] );
    				var components = template.components;
        			var store = this.getStore();
        			var r = store.recordType;
        			var data = {
        				noOfComponents: components.length
        			};
        			data = Ext.apply( data, template );
        			store.add( new r( data ) );
        			store.commitChanges();
        			win.close();
    			}
    		},
    		saveCallbackScope: this,
    		getComponentRegistrationFunction: this.initialConfig.getComponentRegistrationFunction,
        getComponentRegistrationScope: this.initialConfig.getComponentRegistrationScope,
        copyComponentsFunction: this.initialConfig.copyComponentsFunction,
        copyComponentsScope: this.initialConfig.copyComponentsScope,
        handleCopiedComponentsFunction: this.initialConfig.handleCopiedComponentsFunction,
        handleCopiedComponentsScope: this.initialConfig.handleCopiedComponentsScope,
        pasteSpecialMessageType: this.initialConfig.pasteSpecialMessageType
    	} );
    	win.show();
    },
    editTemplate: function() {
    	var selected = this.getSelectedTemplate();
        if ( !selected ) {
            return;
        }
        
        this.executeActionWithTemplateUtilizationCheck( selected, getTranslation( 'Edytuj' ), this.executeEditTemplate );
    },
    executeEditTemplate: function( selected ) {
    	var getTemplateFunction = this.initialConfig.getTemplateFunction;
		
		if ( Ext.isFunction( getTemplateFunction ) ) {
			var templateId = selected.get( 'id' );
			var getTemplateScope = !Ext.isEmpty( this.initialConfig.getTemplateScope ) ?
					this.initialConfig.getTemplateScope : window;
			var savedTemplate = getTemplateFunction.apply( getTemplateScope, [ templateId ] );
			
			if ( !Ext.isEmpty( savedTemplate ) ) {
				var win = new Ext.ux.suncode.IntegrationComponentTemplateEditorWindow( {
		    		title: getTranslation( 'Edytor szablonu' ),
		    		template: savedTemplate,
		    		templateId: templateId,
		    		processNode: this.initialConfig.processNode,
		    		conditionalExecutionEnabled: this.initialConfig.conditionalExecutionEnabled,
		    		inactiveEnabled: this.initialConfig.inactiveEnabled,
		    		componentsTableTitle: this.initialConfig.componentsTableTitle,
		    		categories: this.initialConfig.categories,
		    		parametersWindowTitlePrefix: this.initialConfig.parametersWindowTitlePrefix,
		    		noComponentsMessage: this.initialConfig.noComponentsMessage,
		    		systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
		    		saveCallback: function( template ) {
		    			var editTemplateFunction = this.initialConfig.editTemplateFunction;
		    			
		    			if ( Ext.isFunction( editTemplateFunction ) ) {
		    				var editTemplateScope = !Ext.isEmpty( this.initialConfig.editTemplateScope ) ?
		    						this.initialConfig.editTemplateScope : window;
		    				editTemplateFunction.apply( editTemplateScope, [ templateId, template ] );
		    				var components = template.components;
		    				selected.set( 'name', template.name );
		    				selected.set( 'components', components );
		    				selected.set( 'noOfComponents', components.length );
		    				selected.commit();
		        			win.close();
		    			}
		    		},
		    		saveCallbackScope: this,
		    		getComponentRegistrationFunction: this.initialConfig.getComponentRegistrationFunction,
            getComponentRegistrationScope: this.initialConfig.getComponentRegistrationScope,
            copyComponentsFunction: this.initialConfig.copyComponentsFunction,
            copyComponentsScope: this.initialConfig.copyComponentsScope,
            handleCopiedComponentsFunction: this.initialConfig.handleCopiedComponentsFunction,
            handleCopiedComponentsScope: this.initialConfig.handleCopiedComponentsScope,
            pasteSpecialMessageType: this.initialConfig.pasteSpecialMessageType
		    	} );
		    	win.show();
			}
		}
    },
    removeTemplate: function() {
    	var selected = this.getSelectedTemplate();
        if ( !selected ) {
            return;
        }
        
        this.executeActionWithTemplateUtilizationCheck( selected, getTranslation( 'Usuń' ), this.executeRemoveTemplate );
    },
    executeRemoveTemplate: function( selected ) {
    	var removeTemplateFunction = this.initialConfig.removeTemplateFunction;
		
		if ( Ext.isFunction( removeTemplateFunction ) ) {
			var removeTemplateScope = !Ext.isEmpty( this.initialConfig.removeTemplateScope ) ?
					this.initialConfig.removeTemplateScope : window;
			var templateId = selected.get( 'id' );
			removeTemplateFunction.apply( removeTemplateScope, [ templateId ] );
			removeRowAndMarkNext( this, selected );
		}
    },
    executeActionWithTemplateUtilizationCheck: function( selected, acceptButtonText, action ) {
    	var utilization = new Array();
    	var getTemplateUtilizationFunction = this.initialConfig.getTemplateUtilizationFunction;
    	
    	if ( Ext.isFunction( getTemplateUtilizationFunction ) ) {
    		var getTemplateUtilizationScope = !Ext.isEmpty( this.initialConfig.getTemplateUtilizationScope )
    			? this.initialConfig.getTemplateUtilizationScope : window;
    		var templateId = selected.get( 'id' );
    		utilization = getTemplateUtilizationFunction.apply( getTemplateUtilizationScope, [ templateId ] );
    	}
        
        if ( !Ext.isEmpty( utilization ) ) {
        	Ext.Msg.show( {
                title: '<font weight="bold">' + getTranslation( 'Uwaga' ) + '</font>',
                msg: getTranslation( 'Szablon jest już w użyciu.' ),
                buttons: {
                    yes: acceptButtonText,
                    no: getTranslation( 'Pokaż wykorzystanie' ),
                    cancel: getTranslation( 'Anuluj' )
                },
                fn: function( buttonId ) {
                	switch ( buttonId ) {
                		case 'yes':
                			action.apply( this, [ selected ] );
                			break;
                		case 'no':
                			this.executeShowTemplateUtilization( selected );
                			break;
                		default:
                			break;
                	}
                },
                icon: Ext.Msg.QUESTION,
                scope: this
            } );
        } else {
        	action.apply( this, [ selected ] );
        }
    },
    chooseTemplate: function() {
    	var selected = this.getSelectedTemplate();
        if ( !selected ) {
            return;
        }
        
        var getTemplateFunction = this.initialConfig.getTemplateFunction;
        var useTemplateFunction = this.initialConfig.useTemplateFunction;
		
		if ( Ext.isFunction( getTemplateFunction ) && Ext.isFunction( useTemplateFunction ) ) {
			var templateId = selected.get( 'id' );
			var getTemplateScope = !Ext.isEmpty( this.initialConfig.getTemplateScope ) ?
					this.initialConfig.getTemplateScope : window;
			var template = getTemplateFunction.apply( getTemplateScope, [ templateId ] );
			
			if ( !Ext.isEmpty( template ) ) {
				this.ownerCt.closeWindow();
				var useTemplateScope = !Ext.isEmpty( this.initialConfig.useTemplateScope ) ?
						this.initialConfig.useTemplateScope : window;
				useTemplateFunction.apply( useTemplateScope, [ template ] );
			}
		}
    },
    getSelectedTemplate: function() {
        var template = this.getSelectionModel().getSelected();
        if ( !template ) {
            showWarn( getTranslation( 'Wybierz szablon.' ) );
            return null;
        }
        return template;
    },
    generateUniqueTemplateId: function() {
    	var store = this.getStore();
    	var counter = 1;
        var templateId = 'template' + counter;

        while ( store.find( 'id', templateId ) != -1 ) {
            counter++;
            templateId = 'template' + counter;

            if ( counter > 999 ) {
            	templateId = 'template' + Ext.id();
                break;
            }
        }
        
        return templateId;
    }
} );

Ext.ux.suncode.IntegrationComponentTemplateEditorWindow = function( config ) {
	var windowWidth = Ext.getBody().getViewSize().width * 0.4;
	
    config = Ext.apply( {
        width: windowWidth,
        modal: true,
        frame: false,
        layout: 'fit',
        items: [ new Ext.ux.suncode.IntegrationComponentTemplateEditorPanel( {
        	componentsTableTitle: config.componentsTableTitle,
        	template: config.template,
        	templateId: config.templateId,
        	categories: config.categories,
        	processNode: config.processNode,
        	conditionalExecutionEnabled: config.conditionalExecutionEnabled,
        	inactiveEnabled: config.inactiveEnabled,
        	parametersWindowTitlePrefix: config.parametersWindowTitlePrefix,
        	noComponentsMessage: config.noComponentsMessage,
        	systemFunctionsAccessibility: config.systemFunctionsAccessibility,
        	saveCallback: config.saveCallback,
        	saveCallbackScope: config.saveCallbackScope,
        	getComponentRegistrationFunction: config.getComponentRegistrationFunction,
          getComponentRegistrationScope: config.getComponentRegistrationScope,
          copyComponentsFunction: config.copyComponentsFunction,
          copyComponentsScope: config.copyComponentsScope,
          handleCopiedComponentsFunction: config.handleCopiedComponentsFunction,
          handleCopiedComponentsScope: config.handleCopiedComponentsScope,
          pasteSpecialMessageType: config.pasteSpecialMessageType
        } ) ],
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.IntegrationComponentTemplateEditorWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentTemplateEditorWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentTemplateEditorWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
    	this.editorPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.IntegrationComponentTemplateEditorPanel = function( config ) {
	var viewSize = Ext.getBody().getViewSize();
	var template = config.template;
	var categories = config.categories;
	
    config = Ext.apply( {
        labelWidth: 200,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'editorPanel',
        items: [ {
            xtype: 'fieldset',
            hidden: true,
            items: [ {
                xtype: 'textfield',
                name: 'id',
                value: config.templateId
            }, ]
        }, {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' )
        }, new Ext.ux.suncode.IntegrationComponentTable( {
        	  title: config.componentsTableTitle,
            ref: 'componentsTable',
            height: viewSize.height * 0.4,
            frame: false,
            components: !Ext.isEmpty( template ) ? template.components : new Array(),
            filteredCategories: categories,
            allCategories: categories,
            processNode: config.processNode,
            conditionalExecutionEnabled: config.conditionalExecutionEnabled,
            inactiveEnabled: config.inactiveEnabled,
            parametersWindowTitlePrefix: config.parametersWindowTitlePrefix,
            availableComponents: config.availableComponents,
            systemFunctionsAccessibility: config.systemFunctionsAccessibility,
            getComponentRegistrationFunction: config.getComponentRegistrationFunction,
            getComponentRegistrationScope: config.getComponentRegistrationScope,
            copyComponentsFunction: config.copyComponentsFunction,
            copyComponentsScope: config.copyComponentsScope,
            handleCopiedComponentsFunction: config.handleCopiedComponentsFunction,
            handleCopiedComponentsScope: config.handleCopiedComponentsScope,
            generateTemplateComponentIdFunction: this.generateUniqueTemplateComponentId,
            generateTemplateComponentIdScope: this
        } ) ]
    }, config );

    Ext.ux.suncode.IntegrationComponentTemplateEditorPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentTemplateEditorPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentTemplateEditorPanel.superclass.initComponent.call( this );
        
        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var template = this.initialConfig.template;

        if ( !Ext.isEmpty( template ) ) {
            this.getForm().setValues( template );
        }
    },
    saveForm: function() {
    	var form = this.getForm();
    	
    	if ( form.isValid() && this.isComponentsTableValid() ) {
    		var saveCallback = this.initialConfig.saveCallback;
    		
    		if ( Ext.isFunction( saveCallback ) ) {
    			var template = form.getValues();
    			template = Ext.apply( template, {
    				components: this.componentsTable.readComponents()
    			} );
    			var saveCallbackScope = !Ext.isEmpty( this.initialConfig.saveCallbackScope ) ?
    					this.initialConfig.saveCallbackScope : window;
    			saveCallback.apply( saveCallbackScope, [ template ] );
    		}
    	}
    },
    isComponentsTableValid: function() {
    	var componentsTable = this.componentsTable;
    	var store = componentsTable.getStore();
    	
    	if ( store.getCount() > 0 ) {
    		return true;
    	} else {
    		showWarn( this.initialConfig.noComponentsMessage );
    		return false;
    	}
    },
    generateUniqueTemplateComponentId: function() {
    	var store = this.componentsTable.getStore();
    	var counter = 1;
        var templateComponentId = 'templateComponent' + counter;

        while ( store.find( 'templateComponentId', templateComponentId ) != -1 ) {
            counter++;
            templateComponentId = 'templateComponent' + counter;

            if ( counter > 999 ) {
            	templateComponentId = 'templateComponent' + Ext.id();
                break;
            }
        }
        
        return templateComponentId;
    }
} );

Ext.ux.suncode.IntegrationComponentTemplateUtilizationWindow = function( config ) {
	var template = config.template;
	var viewSize = Ext.getBody().getViewSize();
	
    config = Ext.apply( {
        width: viewSize.width * 0.6,
        height: viewSize.height * 0.4,
        title: getTranslation( 'Zastosowanie szablonu' ) + ' ' + template.name,
        modal: true,
        frame: false,
        layout: 'fit',
        items: [ new Ext.ux.suncode.IntegrationComponentTemplateUtilizationTable( {
        	template: template,
        	getTemplateUtilizationFieldsFunction: config.getTemplateUtilizationFieldsFunction,
        	getTemplateUtilizationFieldsScope: config.getTemplateUtilizationFieldsScope,
        	getTemplateUtilizationFunction: config.getTemplateUtilizationFunction,
        	getTemplateUtilizationScope: config.getTemplateUtilizationScope,
    		getTemplateUtilizationColumnsFunction: config.getTemplateUtilizationColumnsFunction,
    		getTemplateUtilizationColumnsScope: config.getTemplateUtilizationColumnsScope
        } ) ],
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.IntegrationComponentTemplateUtilizationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentTemplateUtilizationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentTemplateUtilizationWindow.superclass.initComponent.call( this );
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.IntegrationComponentTemplateUtilizationTable = function( config ) {
	var template = config.template;
	var fields = new Array();
	var utilization = new Array();
	var columns = new Array();
	var getTemplateUtilizationFieldsFunction = config.getTemplateUtilizationFieldsFunction;
	var getTemplateUtilizationFunction = config.getTemplateUtilizationFunction;
	var getTemplateUtilizationColumnsFunction = config.getTemplateUtilizationColumnsFunction;
	
	if ( Ext.isFunction( getTemplateUtilizationFieldsFunction ) ) {
		var getTemplateUtilizationFieldsScope = !Ext.isEmpty( config.getTemplateUtilizationFieldsScope )
			? config.getTemplateUtilizationFieldsScope : window;
		fields = getTemplateUtilizationFieldsFunction.apply( getTemplateUtilizationFieldsScope, [] );
	}
	
	if ( Ext.isFunction( getTemplateUtilizationFunction ) ) {
		var getTemplateUtilizationScope = !Ext.isEmpty( config.getTemplateUtilizationScope )
			? config.getTemplateUtilizationScope : window;
		utilization = getTemplateUtilizationFunction.apply( getTemplateUtilizationScope, [ template.id ] );
	}
	
	if ( Ext.isFunction( getTemplateUtilizationColumnsFunction ) ) {
		var getTemplateUtilizationColumnsScope = !Ext.isEmpty( config.getTemplateUtilizationColumnsScope )
			? config.getTemplateUtilizationColumnsScope : window;
		columns = getTemplateUtilizationColumnsFunction.apply( getTemplateUtilizationColumnsScope, [] );
	}

    var store = new Ext.data.Store( {
    	data: utilization,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( fields )
        } )
    } );
    
    config = Ext.apply( {
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: columns
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } )
    }, config );

    Ext.ux.suncode.IntegrationComponentTemplateUtilizationTable.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.IntegrationComponentTemplateUtilizationTable, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.IntegrationComponentTemplateUtilizationTable.superclass.initComponent.call( this );
    }
} );