Ext.ux.suncode.FormTemplateWriter = {
  write: function( packageNode, processDefId ) {
    var templates = new Array();

    if ( packageNode.hasChildNodes() ) {
      packageNode.eachChild( function( processNode ) {
        if ( processNode.hasChildNodes() ) {
          var currentProcessDefId = processNode.attributes.processDefId;

          if ( Ext.isEmpty( processDefId ) || processDefId === currentProcessDefId ) {
            processNode.eachChild( function( activityNode ) {
              if ( !Ext.isEmpty( activityNode.attributes.form.template.rows ) ) {
                templates.push( this.writeActivityFormTemplate( currentProcessDefId,
                    activityNode.hasXpdlSubstitution() ? activityNode.getXpdlSubstitution() : activityNode ) );
              }
            }, this );
          }
        }
      }, this );
    }

    return templates;
  },
  writeActivityFormTemplate: function( processDefId, activityNode ) {
    var activityDefId = activityNode.attributes.activityDefId;
    var template = activityNode.attributes.form.template;
    var styles = this.writeFormStyles( activityNode );

    var formTemplate = new Array();
    formTemplate.push( {
      processDefId: processDefId
    } );
    formTemplate.push( {
      activityDefId: activityDefId
    } );
    if ( !Ext.isEmpty( styles ) ) {
      formTemplate.push( {
        Styles: styles
      } );
    }
    formTemplate.push( {
      Settings: this.writeFormSettings( activityNode )
    } );
    formTemplate.push( {
      Rows: this.writeFormTemplateRows( template.rows )
    } );

    return {
      ProcessDefId: processDefId,
      ActivityDefId: activityDefId,
      Template: {
        FormTemplate: formTemplate
      }
    };
  },
  writeFormStyles: function( activityNode ) {
    var formStyles = new Array();
    var showLines = activityNode.attributes.formStyles.showLines;
    if ( showLines === true || showLines === false ) {
      formStyles.push( {
        ShowLines: {
          value: showLines
        }
      } );
    }

    return formStyles;
  },
  writeFormSettings: function( activityNode ) {
    var formSettings = new Array();
    formSettings.push( {
      DocumentsViewLocation: {
        value: activityNode.attributes.formSettings.documentsViewLocation
      }
    } );
    formSettings.push( {
      ShowProcessAndActivityNames: {
        value: activityNode.attributes.formSettings.showProcessAndActivityNames
      }
    } );
    formSettings.push( {
      ShowComments: {
        value: activityNode.attributes.formSettings.showComments
      }
    } );

    return formSettings;
  },
  writeFormTemplateRows: function( rows ) {
    var formTemplateRows = new Array();

    for ( var i = 0; i < rows.length; i++ ) {
      formTemplateRows.push( {
        Row: this.writeFormTemplateRow( rows[i] )
      } );
    }

    return formTemplateRows;
  },
  writeFormTemplateRow: function( row ) {
    var formTemplateRow = new Array();
    formTemplateRow.push( {
      pack: row.layoutPack
    } );

    if ( !Ext.isEmpty( row.items ) ) {
      for ( var i = 0; i < row.items.length; i++ ) {
        formTemplateRow.push( {
          Item: this.writeFormTemplateRowItem( row.items[i] )
        } );
      }
    }

    return formTemplateRow;
  },
  writeFormTemplateRowItem: function( item ) {
    var formTemplateItem = new Array();
    formTemplateItem.push( {
      id: item.id
    } );
    formTemplateItem.push( {
      type: item.type
    } );

    var size = new Array();
    if ( !Ext.isEmpty( item.width ) ) {
      size.push( {
        Width: {
          value: item.width
        }
      } );
    }

    if ( !Ext.isEmpty( item.height ) ) {
      size.push( {
        Height: {
          value: item.height
        }
      } );
    }

    if ( !Ext.isEmpty( size ) ) {
      formTemplateItem.push( {
        Size: size
      } );
    }

    var label = new Array();

    if ( !Ext.isEmpty( item.labelAlign ) ) {
      label.push({
        Align: {
          value: item.labelAlign
        }
      });
    }
    if ( !Ext.isEmpty( item.labelWidth ) ) {
      label.push({
        Width: {
          value: item.labelWidth
        }
      });
    }
    if ( !Ext.isEmpty( item.labelSeparator ) ) {
      label.push({
        Separator: {
          value: item.labelSeparator
        }
      });
    }
    if ( !Ext.isEmpty( item.labelFontSize ) ) {
      label.push({
        FontSize: {
          value: item.labelFontSize
        }
      });
    }
    if ( !Ext.isEmpty( item.labelColor ) ) {
      label.push({
        Color: {
          value: item.labelColor
        }
      });
    }
    if ( !Ext.isEmpty( item.textDecoration ) ) {
      label.push({
        TextDecoration: {
          value: item.textDecoration
        }
      });
    }

    if ( !Ext.isEmpty( label ) ) {
      formTemplateItem.push({
        Label: label
      });
    }

    var styles = new Array();

    if ( item.type == 'LABEL' ) {
      formTemplateItem.push( {
        Text: {
          value: item.text
        }
      } );

      if ( !Ext.isEmpty( item.fontSize ) ) {
        styles.push( {
          FontSize: {
            value: item.fontSize
          }
        } );
      }
    }

    if ( !Ext.isEmpty( item.icon ) ) {
      styles.push( {
        Icon: {
          value: item.icon
        }
      } );
    }

    if ( !Ext.isEmpty( item.color ) ) {
      styles.push( {
        Color: {
          value: item.color
        }
      } );
    }

    if ( !Ext.isEmpty( styles ) ) {
      formTemplateItem.push( {
        Styles: styles
      } );
    }

    if ( item.type == 'VARIABLE_SET' ) {
      var font = new Array();

      if ( !Ext.isEmpty( item.headerFontSize ) ) {
        font.push({
          HeaderFontSize: {
            value: item.headerFontSize
          }
        });
      }

      if ( !Ext.isEmpty( item.cellFontSize ) ) {
        font.push({
          CellFontSize: {
            value: item.cellFontSize
          }
        });
      }

      if ( !Ext.isEmpty( font ) ) {
        formTemplateItem.push({
          Font: font
        });
      }
    }

    return formTemplateItem;
  }
};