Ext.ux.suncode.FormPreviewService = {
	setDataSets: function( processDataSets ) {
        var packagePanel = Ext.getCmp( 'package_panel' );

        Ext.each( processDataSets, function( dataSets, length, all ) {
            var processDefId = dataSets.id;
            var processNode = packagePanel.findProcess( processDefId );

            if ( !Ext.isEmpty( processNode ) ) {
            	processNode.loadFormPreviewDataSets( dataSets.dataSets );
            }
        }, this );
    },
    showPreview: function( activityNode, formElements, variablesValues, devMode ) {
    	var maskId = 'show_activity_form_preview_mask';
        showLoadingMask( maskId, getTranslation( 'Trwa generowanie podglądu formularza...' ) );
    	var mock = this.buildActivityNodeMock( activityNode, formElements );
    	activityNode.setXpdlSubstitution( mock );
        var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
        var packageId = packageNode.attributes.packageId;
        var xpdl = Ext.util.JSON.encode( writeXpdl( packageNode ) );
        activityNode.resetXpdlSubstitution();
        var processNode = activityNode.parentNode;
        var processDefId = processNode.attributes.processDefId;
        var activityDefId = activityNode.attributes.activityDefId;
        var formTemplate = Ext.util.JSON.encode( Ext.ux.suncode.FormTemplateWriter.writeActivityFormTemplate( processDefId, mock ) );
        var targetValue = Ext.id();
    	var win = window.open( '', targetValue );
    	
    	if ( Ext.isEmpty( win ) ) {
        	showWarn( getTranslation( 'Wyskakujące okna nie są dozwolone.' ) );
        	return;
        } else {
        	this.buildPreviewLoadingMessage( win );
        }
    	
        Ext.Ajax.request( {
            url: 'api/formpreview/prepare',
            method: 'POST',
            params: {
            	xpdl: LZString.compressToBase64( xpdl ),
            	formTemplate: LZString.compressToBase64( formTemplate ),
              packageId: packageId,
              processDefId: processDefId,
              activityDefId: activityDefId
            },
            scope: this,
            success: function( response, opts ) {
                removeLoadingMask( maskId );
                var result = Ext.util.JSON.decode( response.responseText );
                this.openActivityFormPreview(
                		activityNode, variablesValues, devMode, result.xpdl, result.formTemplate, targetValue, win );
            },
            failure: function( response, opts ) {
            	if ( !win.closed ) {
    				win.close();
    			}
            	
                removeLoadingMask( maskId );
                showWarn( getTranslation( 'Wystąpił błąd.' ) );
            }
        } );
    },
    buildActivityNodeMock: function( activityNode, formElements ) {
    	var mock = new Ext.ux.suncode.ActivityNode( activityNode.attributes );
      mock.setFormStyles( activityNode.attributes.formStyles );
      mock.setFormSettings( activityNode.attributes.formSettings );
    	mock.loadFormTemplate( formElements.formTemplate );
    	mock.loadFormVariables( formElements.formVariables );
    	mock.loadFormButtons( formElements.formButtons );
    	mock.loadHttpLinks( formElements.httpLinks );
    	mock.loadLabelActions( formElements.labelActions );
    	mock.loadFormFormActions( formElements.formFormActions );
      mock.loadFormEventActions( formElements.formEventActions );
    	mock.loadValidatorsTemplates( formElements.validatorsTemplates );
    	mock.loadVariablesSettersTemplates( formElements.variablesSettersTemplates );
        
      return mock;
    },
    buildPreviewLoadingMessage: function( win ) {
    	var doc = win.document;
    	var div = doc.createElement( 'div' );
    	var span = doc.createElement( 'span' );
    	span.innerHTML = getTranslation( 'Trwa ładowanie podglądu...' );
    	div.appendChild( span );
    	doc.body.appendChild( div );
    },
    openActivityFormPreview: function( activityNode, variablesValues, devMode, xpdl, formTemplate, targetValue, win ) {
    	var processNode = activityNode.parentNode;
    	Ext.ux.suncode.Clipboard.addActivityFormPreview( win );
    	var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
    	var formPanel = new Ext.FormPanel( {
            renderTo: document.body,
            hidden: true,
            url: Suncode.context( 'pwe' ).contextPath + '/ActivityFormPreview.do',
            items: [ {
                xtype: 'textfield',
                name: 'packageId',
                value: packageNode.attributes.packageId
            }, {
                xtype: 'textfield',
                name: 'processDefId',
                value: processNode.attributes.processDefId
            }, {
                xtype: 'textfield',
                name: 'activityDefId',
                value: activityNode.attributes.activityDefId
            }, {
                xtype: 'textfield',
                name: 'activityName',
                value: activityNode.attributes.activityName
            }, {
                xtype: 'textfield',
                name: 'xpdl',
                value: LZString.compressToBase64( xpdl )
            }, {
                xtype: 'textfield',
                name: 'formTemplate',
                value: LZString.compressToBase64( formTemplate )
            }, {
                xtype: 'checkbox',
                name: 'devMode',
                inputValue: 'true',
                checked: devMode
            }, {
            	xtype: 'textfield',
                name: 'contextMap',
                value: Ext.util.JSON.encode( variablesValues )
            }, {
                xtype: 'checkbox',
                name: 'compressed',
                inputValue: 'true',
                checked: true
            } ]
        } );
        var form = formPanel.getForm();
        var target = document.createAttribute( 'target' );
        target.nodeValue = targetValue;
        var dom = Ext.getDom( form.getEl() );
        dom.setAttributeNode( target );
        dom.action = form.url;
    	  dom.submit();
        
        var task = new Ext.util.DelayedTask( function() {
            formPanel.destroy();
            win = Ext.apply( win, {
              PweFormPreviewService: {
                addDataSet: function( dataSet ) {
                  var object = processNode.findFormPreviewDataSet( dataSet.name );

                  if ( !Ext.isEmpty( object ) ) {
                    return getTranslation( 'Zestaw danych o podanej nazwie już istnieje.' );
                  } else {
                    if ( dataSet.isDefault ) {
                      processNode.resetDefaultFormPreviewDataSet();
                    }

                    processNode.addFormPreviewDataSet( dataSet );
                    return true;
                  }
                }
              }
            } );
        } );
        task.delay( 1000 );
    }
};