Ext.ux.suncode.ActivityFormPreviewInitializationWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.8;
    var activityNode = config.activityNode;
    var activityName = activityNode.attributes.activityName;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId
    var packageNode = processNode.parentNode;
    var packageId = packageNode.attributes.packageId
    var activityNameTranslation = getXpdlActivityNameTranslation( packageId, processDefId, activityDefId, activityName );
    var winTitle = getTranslation( 'Inicjalizacja podglądu formularza zadania' ) + ': ' + activityNameTranslation;

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.ActivityFormPreviewInitializationPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'preview' ),
                tooltip: getTranslation( 'Pokaż podgląd' ),
                handler: this.showPreview,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'data_sets' ),
                tooltip: getTranslation( 'Zestawy danych' ),
                handler: this.showDataSets,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'clear' ),
                tooltip: getTranslation( 'Wyczyść formularz' ),
                handler: this.clearForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.ActivityFormPreviewInitializationWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormPreviewInitializationWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormPreviewInitializationWindow.superclass.initComponent.call( this );
    },
    showPreview: function() {
    	this.initializationPanel.showPreview();
    },
    showDataSets: function() {
    	this.initializationPanel.showDataSets();
    },
    clearForm: function() {
    	this.initializationPanel.clearForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ActivityFormPreviewInitializationPanel = function( config ) {
	var activityNode = config.activityNode;
	var formElements = config.formElements;
	this.USED_VARIABLES.clear();
	var items = new Array();
	items.push( {
        xtype: 'checkbox',
        fieldLabel: getTranslation( 'Tryb "debug"' ),
        ref: 'devModeItem',
        inputValue: 'true',
        submitValue: false
    } );
	items.push( {
        xtype: 'label',
        text: getTranslation( 'Uzupełnij dane w celu zainicjowania formularza' ),
        cls: 'x-Module-bold'
    } );
	items.push( {
        xtype: 'box',
        autoEl: {
            tag: 'div',
            html: '<hr ' + getHRLineStyle() + '>',
            style: 'padding-bottom: 10px'
        }
    } );
	items = items.concat( this.buildFormVariablesItems( activityNode, formElements ) );
	items = items.concat( this.buildProcessVariablesItems( activityNode ) );
	items = items.concat( this.buildFormalParametersItems( activityNode ) );
	
    config = Ext.apply( {
        labelWidth: Ext.ux.suncode.Constants.FIELD_DEFAULT_LABEL_WIDTH,
        height: Ext.getBody().getViewSize().height * 0.8,
        bodyStyle: 'overflowY: scroll;',
        bodyCssClass: 'x-Module-container-padding x-Module-form-preview-initialization',
        frame: false,
        border: false,
        ref: 'initializationPanel',
        items: items
    }, config );

    Ext.ux.suncode.ActivityFormPreviewInitializationPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormPreviewInitializationPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormPreviewInitializationPanel.superclass.initComponent.call( this );
        
        this.on( 'afterrender', this.onAfterRender, this );
    },
    AMOUNT_DECIMAL_PRECISION: 2,
    VARIABLE_SET_VALUE_SPLITTER: ';',
    USED_VARIABLES: new HashMap(),
    onAfterRender: function() {
    	var activityNode = this.initialConfig.activityNode;
    	var processNode = activityNode.parentNode;
    	var dataSet = processNode.getDefaultFormPreviewDataSet();
        
    	if ( !Ext.isEmpty( dataSet ) ) {
        	this.loadDataSet( dataSet );
        }
    },
    buildFormVariablesItems: function( activityNode, formElements ) {
    	var elements = new Array();
    	
    	if ( !Ext.isEmpty( formElements.formVariables ) ) {
    		Ext.each( formElements.formVariables, function( formVariable, index, formVariables ) {
    			elements.push( {
    				id: formVariable.varId,
    				name: formVariable.name,
    				type: formVariable.type,
    				definition: formVariable
    			} );
    		} );
    	}
    	
    	return this.buildItems( activityNode, elements );
    },
    buildProcessVariablesItems: function( activityNode ) {
    	var elements = new Array();
    	var processNode = activityNode.parentNode;
    	
    	if ( !Ext.isEmpty( processNode.attributes.variables ) ) {
    		Ext.each( processNode.attributes.variables, function( variable, index, variables ) {
    			elements.push( {
    	    		id: variable.id,
    	    		name: variable.name,
    	    		type: variable.type,
    	    		definition: variable
    	    	} );
    		} );
    	}
    	
    	return this.buildItems( activityNode, elements );
    },
    buildFormalParametersItems: function( activityNode ) {
    	var elements = new Array();
    	var processNode = activityNode.parentNode;
    	
    	if ( !Ext.isEmpty( processNode.attributes.formalParameters ) ) {
    		Ext.each( processNode.attributes.formalParameters, function( formalParameter, index, formalParameters ) {
    			var name = formalParameter.name;
    			
    			if ( Ext.ux.suncode.FormalParameterService.formPreviewHiddenParameters.indexOf( name.toLowerCase() ) == -1 ) {
    				elements.push( {
    	    			id: formalParameter.id,
    	    			name: name,
    	    			type: formalParameter.type,
    	    			definition: formalParameter
    	    		} );
    			}
    		} );
    	}
    	
    	return this.buildItems( activityNode, elements );
    },
    buildItems: function( activityNode, elements ) {
    	var items = new Array();
    	
    	if ( !Ext.isEmpty( elements ) ) {
    		Ext.each( elements, function( element, index, allElements ) {
    			var item = this.buildItem( activityNode, element );
    			
    			if ( !Ext.isEmpty( item ) ) {
    				items.push( item );
    			}
    		}, this );
    	}
    	
    	return items;
    },
    buildItem: function( activityNode, element ) {
    	var id = element.id;
    	
    	if ( !this.USED_VARIABLES.get( id ) ) {
    		this.USED_VARIABLES.put( id, true );
    		
    		switch( element.type ) {
				case 'STRING':
				case 'DATA_CHOOSER':
					return this.buildStringItem( element );
				case 'TEXTAREA':
					return this.buildTextAreaItem( element );
				case 'INTEGER':
					return this.buildIntegerItem( element );
				case 'FLOAT':
					return this.buildFloatItem( activityNode, element );
				case 'AMOUNT':
					return this.buildAmountItem( element );
				case 'DATE':
					return this.buildDateItem( element );
				case 'DATETIME':
					return this.buildDateTimeItem( element );
				case 'RADIOBUTTON':
					return this.buildRadioButtonItem( activityNode, element );
				case 'CHECKBOX':
					return this.buildCheckboxItem( activityNode, element );
				case 'BOOLEAN':
					return this.buildBooleanItem( element );
				case 'LISTBOX':
		        case 'LISTBOX_EDIT':
		        case 'LISTBOX_NO_FILTER':
		        case 'LISTBOX_EDIT_NO_FILTER':
		        case 'LISTBOX_NO_LAZY':
		        case 'LISTBOX_NO_FILTER_NO_LAZY':
		        	return this.buildListBoxItem( activityNode, element );
				case 'USERLIST':
				case 'USERLISTLISTBOX':
				case 'ROLEUSERS':
		        case 'ROLEUSERS_NO_FILTER':
		        	return this.buildUserListItem( element );
		        case 'VARIABLE_SET':
		        	return this.buildVariableSetItem( activityNode, element );
				default:
					return null;
	    	}
    	} else {
    		return null;
    	}
    },
    buildStringItem: function( element ) {
    	var baseConfig = this.buildItemBaseConfig( element );

        return new Ext.form.TextField( baseConfig );
    },
    buildTextAreaItem: function( element ) {
    	var baseConfig = this.buildItemBaseConfig( element );
    	baseConfig = Ext.apply( baseConfig, {
    		height: 100
    	} );

        return new Ext.form.TextArea( baseConfig );
    },
    buildIntegerItem: function( element ) {
    	var baseConfig = this.buildItemBaseConfig( element );
    	baseConfig = Ext.apply( baseConfig, {
    		allowDecimals: false
    	} );

        return new Ext.form.NumberField( baseConfig );
    },
    buildFloatItem: function( activityNode, element ) {
    	var variable = this.getVariable( activityNode, element.id );
    	var decimalPrecision = !Ext.isEmpty( variable ) ? variable.decimalPrecision : this.AMOUNT_DECIMAL_PRECISION;
    	
    	return this.buildDecimalItem( element, decimalPrecision );
    },
    buildAmountItem: function( element ) {
    	return this.buildDecimalItem( element, this.AMOUNT_DECIMAL_PRECISION );
    },
    buildDecimalItem: function( element, decimalPrecision ) {
    	var baseConfig = this.buildItemBaseConfig( element );
    	baseConfig = Ext.apply( baseConfig, {
    		decimalSeparator: Ext.getCmp( 'main_panel' ).getSystemDecimalSeparator(),
    		decimalPrecision: decimalPrecision,
    		setValue : function( v ) {
    	    	this.setFormattedValue( v, false );
    	    },
    	    setFormattedValue: function( v, useDecimalSeparator ) {
    	    	v = Ext.isNumber( v ) ? v : parseFloat( String( v ).replace( this.decimalSeparator, '.' ) );
    	        v = this.fixPrecision( v );
    	        v = isNaN( v ) ? '' : String( v );
    	        v = useDecimalSeparator ? v.replace( '.', this.decimalSeparator ) : v;
    	        return Ext.form.NumberField.superclass.setValue.call( this, v );
    	    },
            listeners: {
            	scope: this,
            	focus: this.onDecimalItemFocus
            }
    	} );

        return new Ext.form.NumberField( baseConfig );
    },
    onDecimalItemFocus: function( field ) {
    	var v = field.parseValue( field.getRawValue() );
        
        if ( !Ext.isEmpty( v ) ) {
        	field.setFormattedValue( v, true );
        }
    },
    buildDateItem: function( element ) {
    	var baseConfig = this.buildItemBaseConfig( element );
    	baseConfig = Ext.apply( baseConfig, {
    		format: 'Y-m-d'
    	} );

        return new Ext.form.DateField( baseConfig );
    },
    buildDateTimeItem: function( element ) {
    	var baseConfig = this.buildItemBaseConfig( element );
    	baseConfig = Ext.apply( baseConfig, {
    		triggerClass: 'dvnt-icon-time',
    		format: 'Y-m-d H:i:s',
            onTriggerClick: function() {
                return false;
            },
            listeners: {
            	scope: this,
            	afterrender: this.onDateTimeItemAfterRender
            }
    	} );

        return new Ext.form.DateField( baseConfig );
    },
    onDateTimeItemAfterRender: function( item ) {
        Calendar.setup( {
            inputField: item.getId(),
            button: item.getEl().up( '.x-form-field-wrap', true ).down( '.dvnt-icon-time' ).id,
            ifFormat: '%Y-%m-%d %H:%M:%S',
            singleClick: true,
            showsTime: true,
            timeFormat: '24',
            onSelect: function onSelect( calendar ) {
            	item.setValue( calendar.date );

                if ( calendar.params.singleClick && calendar.dateClicked ) {
                    calendar.callCloseHandler();
                }
            },
            onClose: function( calendar ) {
                calendar.hide();
            }
        } );
    },
    buildRadioButtonItem: function( activityNode, element ) {
    	var baseConfig = this.buildRadioCheckboxGroupItemBaseConfig( activityNode, element );
    	
    	return new Ext.form.RadioGroup( baseConfig );
    },
    buildCheckboxItem: function( activityNode, element ) {
    	var baseConfig = this.buildRadioCheckboxGroupItemBaseConfig( activityNode, element );
    	
    	return new Ext.form.CheckboxGroup( baseConfig );
    },
    buildRadioCheckboxGroupItemBaseConfig: function( activityNode, element ) {
    	var items = new Array();
    	var variable = this.getVariable( activityNode, element.id );
    	
    	if ( !( Ext.isEmpty( variable ) || Ext.isEmpty( variable.valuesList ) ) ) {
    		Ext.each( variable.valuesList, function( value, index, values ) {
    			items.push( {
    				name: element.id,
    				boxLabel: value.value,
    				inputValue: value.value
    			} );
    		} );
    	}
    	
    	var baseConfig = this.buildItemBaseConfig( element );
    	baseConfig = Ext.apply( baseConfig, {
    		items: items
    	} );
    	
    	return baseConfig;
    },
    buildBooleanItem: function( element ) {
    	var baseConfig = this.buildItemBaseConfig( element );
    	baseConfig = Ext.apply( baseConfig, {
    		inputValue: 'true'
    	} );
    	
    	return new Ext.form.Checkbox( baseConfig );
    },
    buildListBoxItem: function( activityNode, element ) {
    	var data = new Array();
    	var variable = this.getVariable( activityNode, element.id );
    	
    	if ( !( Ext.isEmpty( variable ) || Ext.isEmpty( variable.valuesList ) ) ) {
    		Ext.each( variable.valuesList, function( value, index, values ) {
    			data.push( {
    				value: value.value
    			} );
    		} );
    	}
    	
    	var store = new Ext.data.Store( {
			data: data,
			reader: new Ext.data.JsonReader( {
				fields: Ext.data.Record.create( [ {
					name: 'value',
					type: 'string'
				} ] )
			} )
		} );
    	
    	var tpl = new Ext.XTemplate( '<table width="100%">',
    			'<tr style="height: 15px; background-color: #F0F0F0; font-weight: bold; border-bottom: 2px solid #DDDDDD;">',
    			'<td style="text-align: center; padding:0 5px 0 5px;">', element.name, '</td>', '</tr>',
    			'<tpl for=".">', '<tr class="x-Module-comboTemplateItem" style="height: 15px; background-color: #FFFFFF;">',
    			'<td style="text-align: center; padding:0 5px 0 5px;">', '{value}', '</td>', '</tr></tpl></table>' );
    	
    	var baseConfig = this.buildItemBaseConfig( element );
    	baseConfig = Ext.apply( baseConfig, {
    		triggerAction: 'all',
			mode: 'local',
			store: store,
			tpl: tpl.compile(),
			itemSelector: 'tr.x-Module-comboTemplateItem',
			valueField: 'value',
			displayField: 'value',
			resizable: true
    	} );
    	
    	return new Ext.form.ComboBox( baseConfig );
    },
    buildUserListItem: function( element ) {
    	var record = Ext.data.Record.create( [ {
            name: 'userId',
            type: 'string'
        }, {
            name: 'firstName',
            type: 'string'
        }, {
            name: 'lastName',
            type: 'string'
        } ] );

        var store = new Ext.data.JsonStore( {
            proxy: new Ext.data.HttpProxy( {
                method: 'GET',
                url: Suncode.context( 'pwe' ).pluginContextPath + '/api/user/get',
                listeners: {
                	exception: function( proxy, type, action, options, response, arg ) {
                		showServerFailure( response );
                	}
                }
            } ),
            reader: new Ext.data.JsonReader( {
                fields: record
            } ),
            autoDestroy: true,
            batch: true,
            fields: record,
            root: 'data',
            totalProperty: 'total',
            baseParams: {
                start: 0,
                limit: 20
            }
        } );

        var tpl = new Ext.XTemplate( '<table width="100%">',
    			'<tr style="height: 15px; background-color: #F0F0F0; font-weight: bold; border-bottom: 2px solid #DDDDDD;">',
    			'<td style="text-align: center; padding:0 5px 0 5px;">', getTranslation( 'Nazwisko' ), '</td>',
    			'<td style="text-align: center; padding:0 5px 0 5px;">', getTranslation( 'Imię' ), '</td>', '</tr>',
    			'<tpl for=".">', '<tr class="x-Module-comboTemplateItem" style="height: 15px; background-color: #FFFFFF;">',
    			'<td style="text-align: center; padding:0 5px 0 5px;">', '{lastName}', '</td>',
    			'<td style="text-align: center; padding:0 5px 0 5px;">', '{firstName}', '</td>', '</tr></tpl></table>' );
    	
        var baseConfig = this.buildItemBaseConfig( element );
        baseConfig = Ext.apply( baseConfig, {
    		triggerAction: 'all',
            mode: 'remote',
            tpl: tpl.compile(),
            itemSelector: 'tr.x-Module-comboTemplateItem',
            minChars: 0,
            store: store,
            displayField: 'userId',
            valueField: 'userId',
            resizable: true,
            pageSize: 20
    	} );
    	
    	return new Ext.form.ComboBox( baseConfig );
    },
    buildVariableSetItem: function( activityNode, element ) {
    	var storeFields = new Array();
    	var columns = new Array();
    	columns.push( new Ext.grid.RowNumberer() );
    	
    	if ( !Ext.isEmpty( element.definition.columns ) ) {
    		Ext.each( element.definition.columns, function( column, index, allColumns ) {
    			var columnId = column.varId;
    			var variable = this.getVariable( activityNode, columnId );
    			var header = !Ext.isEmpty( variable ) ? variable.name : columnId;
    			var customWidth = !( Ext.isEmpty( variable ) || Ext.isEmpty( variable.dtSize ) ) ? variable.dtSize : undefined;
    			var editor = !Ext.isEmpty( variable ) ? this.buildItem( activityNode, {
    				id: variable.id,
    	    		name: variable.name,
    	    		type: variable.type,
    	    		definition: variable
    			} ) : new Ext.form.TextField();
    			var fieldType = 'string';
    			
    			columns.push( {
    				id: columnId,
    	            header: header,
    	            dataIndex: columnId,
    	            customWidth: customWidth,
    	            editor: editor,
    	            renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
    	            	if ( Ext.isDate( value ) ) {
    	            		return Ext.util.Format.date( value, 'Y-m-d' );
    	            	} else {
    	            		return value;
    	            	}
    	            }
    			} );
    			
    			if ( !Ext.isEmpty( variable ) ) {
    				if ( variable.type == 'DATE' || variable.type == 'DATETIME' ) {
    					fieldType = 'date';
    				}
    			}
    			
    			storeFields.push( {
    				name: columnId,
					type: fieldType,
					dateFormat: 'Y-m-d'
    			} );
    		}, this );
    	}
    	
    	var baseConfig = {
            title: element.name,
            height: 350,
            hideBorders: true,
            frame: false,
            header: true,
			cls: 'variable-set-grid',
            collapsible: true,
            style: {
                marginBottom: '10px'
            },
            store: new Ext.data.Store( {
    			reader: new Ext.data.JsonReader( {
    				fields: Ext.data.Record.create( storeFields )
    			} )
    		} ),
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: false,
                    menuDisabled: true
                },
                columns: columns
            } ),
            selModel: new Ext.grid.CellSelectionModel( {
            	listeners: {
            		scope: this,
            		selectionchange: this.onVariableSetSelectionChange
            	}
            } ),
            view: new Ext.grid.GridView( {
                autoFill: true
            } ),
            columnLines: true,
            bbar: new Ext.Toolbar( {
                buttons: [ {
					cls: 'x-btn-text-icon',
                    iconCls: 'dvnt-icon-plus-circle',
                    icon: Suncode.context( 'pwe' ).contextPath + '/style/img/fam/add.png',
                    text: getTranslation( 'Dodaj wiersz' ),
                    tooltip: getTranslation( 'Dodaje jeden pusty wiersz' ),
                    ref: 'addRowButton',
                    handler: this.addVariableSetRow
                }, {
					cls: 'x-btn-text-icon',
					iconCls: 'dvnt-icon-minus-circle',
                    icon: Suncode.context( 'pwe' ).contextPath + '/style/img/fam/delete.png',
                    text: getTranslation( 'Usuń wiersz' ),
                    tooltip: getTranslation( 'Usuwa aktualnie wybrany wiersz' ),
                    disabled: true,
                    ref: 'deleteRowButton',
                    handler: this.deleteVariableSetRow
                }, {
					cls: 'x-btn-text-icon',
					iconCls: 'dvnt-icon-copy',
                    icon: Suncode.context( 'pwe' ).contextPath + '/style/img/fam/page_copy.png',
                    text: getTranslation( 'Kopiuj wiersz' ),
                    tooltip: getTranslation( 'Kopiuje aktualnie wybrany wiersz i dodaje go' ),
                    disabled: true,
                    ref: 'copyRowButton',
                    handler: this.copyVariableSetRow
                } ]
            } ),
            listeners: {
                afteredit: function( e ) {
                    e.record.commit();
                }
            }
    	};
    	
    	return new Ext.grid.EditorGridPanel( baseConfig );
    },
    onVariableSetSelectionChange: function( selModel, selection ) {
    	var grid = selModel.grid;
    	var toolbar = grid.getBottomToolbar();
        var deleteRowButton = toolbar.deleteRowButton;
        var copyRowButton = toolbar.copyRowButton;
        var buttons = [ deleteRowButton, copyRowButton ];

        if ( Ext.isEmpty( selection ) ) {
            Ext.each( buttons, function( button, index, allButtons ) {
            	button.disable();
            } );
        } else {
            Ext.each( buttons, function( button, index, allButtons ) {
            	button.enable();
            } );
        }
    },
    addVariableSetRow: function( button, e ) {
    	var grid = this.ownerCt.ownerCt;
    	var store = grid.getStore();
    	var recordType = store.recordType;
        var record = new recordType( {} );
    	store.add( record );
    	store.commitChanges();
    	grid.startEditing( store.getCount() - 1, 1 );
    },
    deleteVariableSetRow: function( button, e ) {
    	var grid = this.ownerCt.ownerCt;
    	grid.stopEditing();
    	var selModel = grid.getSelectionModel();
        var selectedCell = selModel.getSelectedCell();

        if ( !Ext.isEmpty( selectedCell ) ) {
        	var store = grid.getStore();
        	var rowIndex = selectedCell[0];
            var record = store.getAt( rowIndex );
            store.remove( record );
            store.commitChanges();
            grid.getView().refresh();
        }
    },
    copyVariableSetRow: function( button, e ) {
    	var grid = this.ownerCt.ownerCt;
    	grid.stopEditing();
    	var selModel = grid.getSelectionModel();
        var selectedCell = selModel.getSelectedCell();

        if ( !Ext.isEmpty( selectedCell ) ) {
        	var store = grid.getStore();
        	var rowIndex = selectedCell[0];
            var record = store.getAt( rowIndex );
            var newId = Ext.data.Record.id( record );
            var copy = record.copy( newId );
            store.add( copy );
            store.commitChanges();
            grid.getView().refresh();
        }
    },
    buildItemBaseConfig: function( element ) {
    	return {
    		width: Ext.ux.suncode.Constants.FIELD_DEFAULT_WIDTH,
    		name: element.id,
    		fieldLabel: element.name
    	};
    },
    getVariable: function( activityNode, id ) {
    	var processNode = activityNode.parentNode;
    	
    	return processNode.findVariable( id );
    },
    showPreview: function() {
    	var activityNode = this.initialConfig.activityNode;
    	var formElements = this.initialConfig.formElements;
    	var variablesValues = this.getVariablesValues();
    	var devMode = this.devModeItem.getValue();
    	
    	Ext.ux.suncode.FormPreviewService.showPreview( activityNode, formElements, variablesValues, devMode );
    },
    getVariablesValues: function() {
    	var form = this.getForm();
    	var values = form.getValues();
    	var grids = this.findByType( 'editorgrid' );
    	
    	if ( !Ext.isEmpty( grids ) ) {
    		Ext.each( grids, function( grid, gridIndex, allGrids ) {
    			var colModel = grid.getColumnModel();
    			var columns = colModel.getColumnsBy( function( column ) {
    				return !Ext.isEmpty( column.dataIndex );
    			} );
    			
    			if ( !Ext.isEmpty( columns ) ) {
    				Ext.each( columns, function( column, columnIndex, allColumns ) {
    					var dataIndex = column.dataIndex;
                        values[dataIndex] = this.getVariableSetValue( grid, dataIndex );
        			}, this );
    			}
    		}, this );
    	}
    	
    	return values;
    },
    getVariableSetValue: function( grid, variableId ) {
    	var value = new Array();
    	var store = grid.getStore();

        store.each( function( record ) {
            var cellValue = this.getVariableSetCellValue( record, variableId );

            value.push( cellValue );
        }, this );

        return value.join( this.VARIABLE_SET_VALUE_SPLITTER );
    },
    getVariableSetCellValue: function( record, dataIndex ) {
        var value = record.get( dataIndex );

        if ( Ext.isDate( value ) ) {
            return Ext.util.Format.date( value, 'Y-m-d' );
        } else {
            return Ext.isEmpty( value ) ? '' : value;
        }
    },
    showDataSets: function() {
    	var win = new Ext.ux.suncode.ActivityFormPreviewDataSetsWindow( {
    		activityNode: this.initialConfig.activityNode,
    		variablesValues: this.getVariablesValues(),
    		variablesPanel: this
    	} );
    	win.show();
    },
    clearForm: function() {
    	var form = this.getForm();
    	form.items.each( function( field ) {
    		if ( field.getXType() === 'checkboxgroup' ) {
    			field.setValue( field.getName(), false );
    		} else if ( Ext.isFunction( field.setValue ) ) {
    			field.setValue( '' );
    		}
        } );
    	
    	var grids = this.findByType( 'editorgrid' );
    	
    	if ( !Ext.isEmpty( grids ) ) {
    		Ext.each( grids, function( grid, gridIndex, allGrids ) {
    			var store = grid.getStore();
				store.removeAll();
    			store.commitChanges();
    		} );
    	}
    },
    loadDataSet: function( dataSet ) {
    	var variablesValues = dataSet.variablesValues;
    	var form = this.getForm();
    	form.setValues( variablesValues );
    	var grids = this.findByType( 'editorgrid' );
    	
    	if ( !Ext.isEmpty( grids ) ) {
    		Ext.each( grids, function( grid, gridIndex, allGrids ) {
    			var storeData = this.buildStoreData( variablesValues, grid );
    			
    			if ( !Ext.isEmpty( storeData ) ) {
    				var store = grid.getStore();
    				store.loadData( storeData );
        			store.commitChanges();
    			}
    		}, this );
    	}
    },
    buildStoreData: function( variablesValues, grid ) {
    	var storeData = new Array();
		var colModel = grid.getColumnModel();
		var columns = colModel.getColumnsBy( function( column ) {
			return !Ext.isEmpty( column.dataIndex );
		} );
		
		if ( !Ext.isEmpty( columns ) ) {
			var values = new Object();
			var longestValue = 0;
			
			Ext.each( columns, function( column, columnIndex, allColumns ) {
				var dataIndex = column.dataIndex;
				var value = variablesValues[dataIndex];
				
				if ( !Ext.isEmpty( value ) ) {
					var array = value.split( this.VARIABLE_SET_VALUE_SPLITTER );
					longestValue = array.length;
					values[dataIndex] = array;
				} else {
					values[dataIndex] = '';
				}
			}, this );
			
			for ( var i = 0; i < longestValue; i++ ) {
				storeData.push( this.buildStoreDatum( values, columns, i ) );
			}
		}
		
		return storeData;
    },
    buildStoreDatum: function( values, columns, index ) {
    	var storeDatum = new Object();
		
		Ext.each( columns, function( column, columnIndex, allColumns ) {
			var dataIndex = column.dataIndex;
			var value = values[dataIndex][index];
			value = value ? value : '';
			storeDatum[dataIndex] = value;
		} );
		
		return storeDatum;
    }
} );


Ext.ux.suncode.ActivityFormPreviewDataSetsWindow = function( config ) {
    var viewSize = Ext.getBody().getViewSize();

    config = Ext.apply( {
        modal: true,
        width: viewSize.width * 0.6,
        height: viewSize.height * 0.6,
        title: getTranslation( 'Zestawy danych' ),
        layout: 'fit',
        items: [ new Ext.ux.suncode.ActivityFormPreviewDataSetsPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'load' ),
                tooltip: getTranslation( 'Załaduj' ),
                handler: this.loadDataSet,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.ActivityFormPreviewDataSetsWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormPreviewDataSetsWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormPreviewDataSetsWindow.superclass.initComponent.call( this );
    },
    loadDataSet: function() {
    	this.dataSetsPanel.loadDataSet();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ActivityFormPreviewDataSetsPanel = function( config ) {
	var activityNode = config.activityNode;
	var processNode = activityNode.parentNode;
	
	var store = new Ext.data.Store( {
        data: processNode.attributes.formPreview.dataSets,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'id',
                type: 'string'
            }, {
                name: 'name',
                type: 'string'
            }, {
                name: 'description',
                type: 'string'
            }, {
                name: 'isDefault',
                type: 'boolean'
            } ] )
        } ),
        sortInfo: {
            field: 'name',
            direction: 'ASC'
        }
    } );
	
    config = Ext.apply( {
    	ref: 'dataSetsPanel',
        store: store,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        border: false,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'id',
                dataIndex: 'id',
                hidden: true,
                hideable: false
            }, {
                id: 'name',
                header: getTranslation( 'Nazwa' ),
                dataIndex: 'name',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                id: 'description',
                header: getTranslation( 'Opis' ),
                dataIndex: 'description',
                align: 'left',
                renderer: wrapColumnValue
            }, {
                id: 'isDefault',
                header: getTranslation( 'Domyślny' ),
                dataIndex: 'isDefault',
                align: 'center',
                renderer: tickCrossValue
            } ]
        } ),
        viewConfig: new Ext.ux.suncode.StandardGridView( {
            emptyText: getTranslation( 'Brak zestawów danych' )
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'tick' ),
                tooltip: getTranslation( 'Ustaw jako domyślny' ),
                handler: this.setAsDefaultDataSet,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj zestaw danych' ),
                handler: this.addDataSet,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'edit' ),
                tooltip: getTranslation( 'Edytuj zestaw danych' ),
                handler: this.editDataSet,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń zestaw danych' ),
                handler: this.removeDataSet,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.ActivityFormPreviewDataSetsPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormPreviewDataSetsPanel, Ext.grid.GridPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormPreviewDataSetsPanel.superclass.initComponent.call( this );
    },
    loadDataSet: function() {
    	var dataSet = this.getSelectedDataSet();
        if ( !dataSet ) {
            return;
        }
        
        var variablesPanel = this.initialConfig.variablesPanel;
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var name = dataSet.get( 'name' );
        var dataSetDef = processNode.findFormPreviewDataSet( name );
    	this.ownerCt.closeWindow();
    	variablesPanel.loadDataSet( dataSetDef );
    },
    setAsDefaultDataSet: function() {
    	var dataSet = this.getSelectedDataSet();
        if ( !dataSet ) {
            return;
        }
        
        var activityNode = this.initialConfig.activityNode;
    	var processNode = activityNode.parentNode;
    	var name = dataSet.get( 'name' );
    	var store = this.getStore();
    	store.each( function( rec ) {
    		if ( rec.get( 'name' ) !== name && rec.get( 'isDefault' ) ) {
    			rec.set( 'isDefault', false );
    			rec.commit();
    		}
    	} );
    	
    	dataSet.set( 'isDefault', !dataSet.get( 'isDefault' ) );
    	dataSet.commit();
    	
    	processNode.setAsDefaultFormPreviewDataSet( name );
    },
    addDataSet: function() {
    	var win = new Ext.ux.suncode.ActivityFormPreviewDataSetWindow ( {
    		activityNode: this.initialConfig.activityNode,
    		variablesValues: this.initialConfig.variablesValues,
    		saveTo: this,
    		varRecord: this.getStore().recordType
    	} );
    	win.show();
    },
    editDataSet: function() {
    	var dataSet = this.getSelectedDataSet();
        if ( !dataSet ) {
            return;
        }
        
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var name = dataSet.get( 'name' );
        var win = new Ext.ux.suncode.ActivityFormPreviewDataSetWindow ( {
        	dataSet: processNode.findFormPreviewDataSet( name ),
    		activityNode: this.initialConfig.activityNode,
    		variablesValues: this.initialConfig.variablesValues,
    		saveTo: this,
    		varRecord: dataSet
    	} );
    	win.show();
    },
    removeDataSet: function() {
        var dataSet = this.getSelectedDataSet();
        if ( !dataSet ) {
            return;
        }
        
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var name = dataSet.get( 'name' );
        processNode.removeFormPreviewDataSet( name );
        removeRowAndMarkNext( this, dataSet );
    },
    getSelectedDataSet: function() {
        var dataSet = this.getSelectionModel().getSelected();
        if ( !dataSet ) {
            showWarn( getTranslation( 'Wybierz zestaw danych.' ) );
            return null;
        }
        return dataSet;
    }
} );

Ext.ux.suncode.ActivityFormPreviewDataSetWindow = function( config ) {
    var windowWidth = Ext.getBody().getViewSize().width * 0.4;
    var dataSet = config.dataSet;
    var winTitle = dataSet ? getTranslation( 'Definicja zestawu danych' ) + ' ' + dataSet.name
                    : getTranslation( 'Kreator zestawu danych' );

    config = Ext.apply( {
        modal: true,
        width: windowWidth,
        title: winTitle,
        items: [ new Ext.ux.suncode.ActivityFormPreviewDataSetPanel( config ) ],
        closable: true,
        tbar: new Ext.Toolbar( {
            buttons: [ {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'save' ),
                tooltip: getTranslation( 'Zapisz' ),
                handler: this.saveForm,
                scope: this
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'close' ),
                tooltip: getTranslation( 'Zamknij' ),
                handler: this.closeWindow,
                scope: this
            } ]
        } )
    }, config );

    Ext.ux.suncode.ActivityFormPreviewDataSetWindow.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormPreviewDataSetWindow, Ext.Window, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormPreviewDataSetWindow.superclass.initComponent.call( this );
    },
    saveForm: function() {
        this.dataSetPanel.saveForm();
    },
    closeWindow: function() {
        this.close();
    }
} );

Ext.ux.suncode.ActivityFormPreviewDataSetPanel = function( config ) {
	var dataSet = config.dataSet;
	
    config = Ext.apply( {
        labelWidth: Ext.ux.suncode.Constants.FIELD_DEFAULT_LABEL_WIDTH,
        autoHeight: true,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        ref: 'dataSetPanel',
        items: [ {
            xtype: 'textfield',
            name: 'name',
            anchor: '100%',
            fieldLabel: getTranslation( 'Nazwa' ),
            allowBlank: false,
            blankText: getTranslation( 'Pole jest wymagane' ),
            validator: this.validateName
        }, {
        	xtype: 'checkbox',
            fieldLabel: getTranslation( 'Domyślny' ),
            name: 'isDefault',
            inputValue: 'true'
        }, {
            xtype: 'fieldset',
            title: getTranslation( 'Opis' ),
            layout: 'fit',
            items: [ {
                xtype: 'textarea',
                name: 'description',
                anchor: '100%',
                height: 100
            } ]
        } ]
    }, config );

    Ext.ux.suncode.ActivityFormPreviewDataSetPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.ActivityFormPreviewDataSetPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.ActivityFormPreviewDataSetPanel.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    onAfterRender: function() {
        var dataSet = this.initialConfig.dataSet;

        if ( !Ext.isEmpty( dataSet ) ) {
            this.getForm().setValues( dataSet );
        }
    },
    validateName: function( value ) {
        var panel = this.ownerCt;
        var activityNode = panel.activityNode;
        var processNode = activityNode.parentNode;
        var dataSet = panel.dataSet;

        if ( !Ext.isEmpty( dataSet ) && dataSet.name === value ) {
            return true;
        } else {
            var object = processNode.findFormPreviewDataSet( value );

            if ( !Ext.isEmpty( object ) ) {
                return getTranslation( 'Zestaw danych już istnieje.' );
            } else {
                return true;
            }
        }
    },
    saveForm: function() {
        var form = this.getForm();

        if ( form.isValid() ) {
        	var activityNode = this.initialConfig.activityNode;
        	var processNode = activityNode.parentNode;
        	var saveToObj = this.initialConfig.saveTo;
            var varRecord = this.initialConfig.varRecord;
            var dataSet = this.initialConfig.dataSet;
            var def = form.getValues();
            if ( Ext.isEmpty( def.isDefault ) ) {
                def = Ext.apply( {
                	isDefault: false
                }, def );
            }
            def = Ext.apply( {
            	variablesValues: this.initialConfig.variablesValues
            }, def );
        	
            if ( saveToObj && varRecord ) {
                if ( dataSet ) {
                    varRecord.set( 'name', def.name );
                    varRecord.set( 'description', def.description );
                    varRecord.set( 'isDefault', def.isDefault );
                    varRecord.commit();
                } else {
                    var store = saveToObj.getStore();
                    store.add( new varRecord( {
                        name: def.name,
                        description: def.description,
                        isDefault: def.isDefault
                    } ) );
                    store.commitChanges();
                }
            }

            if ( dataSet ) {
            	processNode.updateFormPreviewDataSet( dataSet.name, def );
            } else {
            	processNode.addFormPreviewDataSet( def );
            }

            this.ownerCt.closeWindow();
        }
    }
} );