Ext.ux.suncode.FormVariableDefPanel = function( config ) {
    var component = config.component;
    var forceHidden = component.forceHidden;
    var objectDef = component.definition.objectDef;
    var activityNode = config.activityNode;
    var processNode = activityNode.parentNode;
    var variables = processNode.attributes.variables;
    var autoUpdates = objectDef.autoUpdates;
    var drawingPanel = Ext.getCmp( 'drawing_panel' );
    var mainPanel = Ext.getCmp( 'main_panel' );
    var formActionsCategories = mainPanel.getFormActionsIntegrationComponentCategories();
    var eventTypes = mainPanel.getEventTypesForVariable();
    var eventActionsCategories = mainPanel.getEventActionsCategories();
    var compatibilityMode = mainPanel.getCompatibilityMode();

    var acceptedTypes = new Array();
    acceptedTypes.push( component.type );

    var vChooserContainerItems = new Array();
    vChooserContainerItems.push( new Ext.ux.suncode.AllVariablesChooser( {
        variables: variables,
        startWith: component.idAssigned ? objectDef.varId : '',
        acceptedTypes: acceptedTypes,
        acceptedPlacement: 'form',
        readOnly: component.isVariable,
        listeners: {
            scope: this,
            select: this.onSelectVariable
        }
    } ) );

    if ( !component.isVariable ) {
        vChooserContainerItems.push( {
            xtype: 'button',
            cls: 'x-btn-icon',
            icon: getPluginImgPath( 'variable_add' ),
            tooltip: getTranslation( 'Dodaj zmienną procesu' ),
            flex: 0,
            handler: this.addProcessVariable,
            scope: this
        } );
    }

    vChooserContainerItems.push( {
        xtype: 'button',
        cls: 'x-btn-icon',
        icon: getPluginImgPath( 'edit' ),
        tooltip: getTranslation( 'Edytuj zmienną procesu' ),
        flex: 0,
        handler: this.editProcessVariable,
        scope: this
    } );

    var additionalItems = new Array();
    switch ( component.type ) {
        case 'TEXTAREA':
            additionalItems.push( {
                xtype: 'numberfield',
                fieldLabel: getTranslation( 'Wysokość' ),
                anchor: '100%',
                ref: 'heightItem',
                emptyText: getTranslation( 'Domyślna' ),
                value: objectDef.height
            } );
            break;
        case 'ROLEUSERS':
        case 'ROLEUSERS_NO_FILTER':
            additionalItems.push( new Ext.ux.suncode.RoleusersFiltersGrid( config ) );
            break;
        default:
            break;
    }

    var autoUpdatesStore = new Ext.data.Store( {
        data: autoUpdates,
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'taskNameType',
                type: 'string'
            }, {
                name: 'taskName',
                type: 'string'
            }, {
                name: 'eventType',
                type: 'string'
            }, {
                name: 'id',
                type: 'string'
            } ] )
        } )
    } );
    
    var autoUpdateTypesChooser = new Ext.ux.suncode.AutoUpdateTypesChooser( {} );
    var autoUpdateEventTypesChooser = new Ext.ux.suncode.AutoUpdateEventTypesChooser( {} );
    var specification = component.idAssigned ? Ext.ux.suncode.DocumentationService.getFormVariableSpecification( activityNode, objectDef.varId )
                    : new Object();
    
    var autoUpdatesPanel = new Array();
    if ( compatibilityMode.showFormVariableActions( autoUpdates ) ) {
    	autoUpdatesPanel.push( {
            xtype: 'grid',
            hidden: !config.AV,
            title: addTooltipToField( getTranslation( 'Akcje' ), null, null, true ),
            store: autoUpdatesStore,
            enableColumnResize: true,
            columnLines: true,
            autoScroll: true,
            border: false,
            layout: 'fit',
            ref: 'autoUpdatesPanel',
            autoUpdates: autoUpdates,
            colModel: new Ext.grid.ColumnModel( {
                defaults: {
                    sortable: false,
                    menuDisabled: false
                },
                columns: [ {
                    id: 'taskNameType',
                    header: getTranslation( 'Typ' ),
                    dataIndex: 'taskNameType',
                    align: 'left',
                    renderer: Ext.util.Format.ComboBoxRenderer( autoUpdateTypesChooser )
                }, {
                    id: 'taskName',
                    header: getTranslation( 'Nazwa akcji' ),
                    dataIndex: 'taskName',
                    align: 'left'
                }, {
                    id: 'eventType',
                    header: getTranslation( 'Typ zdarzenia' ),
                    dataIndex: 'eventType',
                    align: 'left',
                    renderer: Ext.util.Format.ComboBoxRenderer( autoUpdateEventTypesChooser )
                }, {
                    id: 'id',
                    header: 'id',
                    dataIndex: 'id',
                    align: 'left',
                    hidden: true,
                    hideable: false
                } ]
            } ),
            viewConfig: new Ext.ux.suncode.StandardGridView( {
                emptyText: getTranslation( 'Brak akcji' )
            } ),
            sm: new Ext.grid.RowSelectionModel( {
                singleSelect: true
            } ),
            tbar: new Ext.Toolbar( {
                items: [ '->', {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'add' ),
                    tooltip: getTranslation( 'Dodaj akcję' ),
                    handler: this.addAutoUpdate,
                    scope: this
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'edit' ),
                    tooltip: getTranslation( 'Edytuj akcję' ),
                    handler: this.editAutoUpdate,
                    scope: this
                }, {
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'delete' ),
                    tooltip: getTranslation( 'Usuń akcję' ),
                    handler: this.removeAutoUpdate,
                    scope: this
                } ]
            } ),
            listeners: {
                scope: this,
                rowdblclick: function( grid, rowIndex, e ) {
                    this.editAutoUpdate();
                }
            },
            getAutoUpdate: function( id ) {
                var autoUpdates = this.autoUpdates;
                for ( var i = 0; i < autoUpdates.length; i++ ) {
                    if ( autoUpdates[i].id == id ) {
                        return autoUpdates[i];
                    }
                }
                return null;
            },
            addAutoUpdate: function( def ) {
                this.autoUpdates.push( def );
            },
            editAutoUpdate: function( autoUpdate, def ) {
                var autoUpdates = this.autoUpdates;
                for ( var i = 0; i < autoUpdates.length; i++ ) {
                    if ( autoUpdates[i].id == autoUpdate.id ) {
                        autoUpdates[i] = def;
                        break;
                    }
                }
            },
            removeAutoUpdate: function( id ) {
                var autoUpdates = this.autoUpdates;
                for ( var i = 0; i < autoUpdates.length; i++ ) {
                    if ( autoUpdates[i].id == id ) {
                        autoUpdates.splice( i, 1 );
                        break;
                    }
                }
            }
        } );
    }

    config = Ext.apply( {
        activeTab: 0,
        autoHeight: true,
        enableTabScroll: true,
        border: false,
        defaults: {
            layoutConfig: {
                trackLabels: true
            },
            labelWidth: 250,
            boxMinHeight: config.panelHeight,
            boxMaxHeight: config.panelHeight
        },
        ref: 'variableDefPanel',
        items: [ {
            xtype: 'form',
            title: getTranslation( 'Definicja' ),
            frame: false,
            bodyCssClass: 'x-Module-container-padding',
            ref: 'variableDefPanel',
            items: [ {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Dodaj/Edytuj we wszystkich zadaniach' ),
                anchor: '100%',
                ref: 'duplicateItem',
                checked: objectDef.duplicateVariable,
                inputValue: 'true'
            }, {
                xtype: 'box',
                autoEl: {
                    tag: 'div',
                    html: '<hr ' + getHRLineStyle() + '>',
                    style: 'padding-bottom: 10px'
                }
            }, new Ext.ux.suncode.TypesChooser( {
                utilization: 'form',
                label: getTranslation( 'Typ' ),
                typeItemValue: component.type,
                readOnly: true
            } ), {
                xtype: 'compositefield',
                anchor: '100%',
                ref: 'vChooserContainer',
                fieldLabel: getTranslation( 'Nazwa zmiennej procesu' ),
                items: vChooserContainerItems
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Ukryta' ),
                anchor: '100%',
                ref: 'hiddenItem',
                checked: objectDef.hidden,
                disabled: forceHidden,
                inputValue: 'true',
                listeners: {
                	scope: this,
                	check: function( field, checked ) {
                		var editableItem = this.variableDefPanel.editableItem;
                		
                		if ( checked ) {
                			editableItem.setValue( true );
                			editableItem.disable();
                		} else {
                			editableItem.enable();
                		}
                	}
                }
            }, {
                xtype: 'checkbox',
                fieldLabel: getTranslation( 'Edytowalna' ),
                anchor: '100%',
                ref: 'editableItem',
                checked: objectDef.editable,
                disabled: objectDef.hidden,
                inputValue: 'true'
            }, {
                xtype: 'numberfield',
                fieldLabel: getTranslation( 'Szerokość' ),
                anchor: '100%',
                ref: 'widthItem',
                allowNegative: false,
                minValue: this.MIN_WIDTH,
                minText: getTranslation( 'Minimalna wartość dla tego pola to' ) + ' {0}',
                emptyText: getTranslation( 'Domyślna' ),
                value: component.definition.width
            }, additionalItems, new Ext.ux.suncode.SpecificationDescriptionArea( {
                processNode: processNode,
                description: specification.description
            } ) ]
        }, {
            xtype: 'form',
            title: getTranslation( 'Etykieta' ),
            frame: false,
            bodyCssClass: 'x-Module-container-padding',
            ref: 'labelPanel',
            items: [ new Ext.ux.suncode.LabelAlignmentsChooser( {
                ref: 'alignmentItem',
                value: component.definition.labelAlign
            } ), {
                xtype: 'numberfield',
                fieldLabel: getTranslation( 'Długość etykiety' ),
                anchor: '100%',
                ref: 'widthItem',
                emptyText: getTranslation( 'Domyślna' ),
                allowDecimals: false,
                allowNegative: false,
                value: component.definition.labelWidth
            }, {
                xtype: 'textfield',
                inputType: 'text',
                fieldLabel: getTranslation( 'Separator etykiety' ),
                anchor: '100%',
                ref: 'separatorItem',
                emptyText: getTranslation( 'Domyślny' ),
                value: component.definition.labelSeparator
            }, {
                xtype: 'numberfield',
                fieldLabel: getTranslation( 'Rozmiar czcionki' ),
                anchor: '100%',
                ref: 'fontSizeItem',
                emptyText: getTranslation( 'Domyślny' ),
                allowDecimals: false,
                allowNegative: false,
                value: component.definition.labelFontSize
            }, {
                xtype: 'compositefield',
                anchor: '100%',
                ref: 'colorItem',
                fieldLabel: getTranslation( 'Kolor' ),
                items: [ {
                    xtype: 'textfield',
                    emptyText: getTranslation( 'Domyślny' ),
                    flex: 1,
                    isFormField: true,
                    style: 'background: ' + component.definition.labelColor + ';',
                    color: component.definition.labelColor,
                    readOnly: true,
                    value: !Ext.isEmpty( component.definition.labelColor ) ? ' ' : ''
                }, {
                    xtype: 'button',
                    cls: 'x-btn-icon',
                    icon: getPluginImgPath( 'color_wheel' ),
                    tooltip: getTranslation( 'Wybierz kolor' ),
                    flex: 0,
                    handler: this.chooseLabelColor,
                    scope: this
                }, {
                  xtype: 'button',
                  cls: 'x-btn-icon',
                  icon: getPluginImgPath( 'clear' ),
                  tooltip: getTranslation( 'Przywróć domyślny' ),
                  flex: 0,
                  handler: this.restoreDefaultLabelColor,
                  scope: this
                } ]
            }, new Ext.ux.suncode.TextDecorationsChooser( {
                ref: 'textDecorationItem',
                value: component.definition.textDecoration
            } ) ]
        }, autoUpdatesPanel, new Ext.ux.suncode.IntegrationComponentTable( {
            ref: 'formActionsGrid',
            title: getTranslation( 'Akcje formularza' ),
            border: false,
            boxMinHeight: config.panelHeight,
            boxMaxHeight: config.panelHeight,
            components: objectDef.formActions,
            filteredCategories: Ext.ux.suncode.IntegrationComponentService.filterCategoriesByDestination(
                formActionsCategories, Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION, false ),
            allCategories: formActionsCategories,
            processNode: processNode,
            pasteComponentsValidation: {
                func: function( variableId ) {
                    var presentVariableIds = this.getPresentVariableIds();

                    return presentVariableIds.includes( variableId );
                },
                scope: drawingPanel,
                invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
            },
            enableCopyPasteMenu: true,
            conditionalExecutionEnabled: true,
            inactiveEnabled: true,
            parametersWindowTitlePrefix: getTranslation( 'Parametry akcji formularza' ),
            availableVariables: config.availableVariables,
            missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: config.missingVariablesValidatorScope,
            systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
            getBindToFunction: function( component ) {
                var variableDestination = Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION;
                var destination = Ext.ux.suncode.IntegrationComponentService.getDestination( component, variableDestination );

                return !Ext.isEmpty( destination ) ? {
                    id: destination.bindTo,
                    value: this.variableDefPanel.vChooserContainer.items.first().getValue()
                } : null;
            },
            getBindToScope: this,
            getComponentRegistrationFunction: function( id ) {
            	return Ext.ux.suncode.IntegrationComponentService.getFormActionRegistration( id );
            },
            getComponentRegistrationScope: this,
            copyComponentsFunction: function( components ) {
            	Ext.ux.suncode.Clipboard.setIntegrationComponentFormActions( components );
            },
            copyComponentsScope: this,
            handleCopiedComponentsFunction: function( func, scope ) {
              Ext.ux.suncode.Clipboard.getIntegrationComponentFormActions( function( formActions ) {
                if ( Ext.isFunction( func ) ) {
                  var components = new Array();

                  if ( !Ext.isEmpty( formActions ) ) {
                    var service = Ext.ux.suncode.IntegrationComponentService;
                    var categories = Ext.getCmp( 'main_panel' ).getFormActionsIntegrationComponentCategories();

                    Ext.each( formActions, function( component, index, allComponents ) {
                      var componentDef = service.getIntegrationComponent( categories, component.id );

                      if ( !Ext.isEmpty( componentDef ) && service.hasDestination( componentDef, service.VARIABLE_DESTINATION, false ) ) {
                        components.push( component );
                      }
                    } );
                  }

                  scope = !Ext.isEmpty( scope ) ? scope : window;
                  func.apply( scope, [ components ] );
                }
              }, this );
            },
            handleCopiedComponentsScope: this,
            pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentFormActionsMessageType,
            validateFieldFunction: config.validateIntegrationComponentFieldFunction,
            validateFieldScope: config.validateIntegrationComponentFieldScope,
            validateRowFunction: drawingPanel.validateVariablesInIntegrationComponent,
            validateRowScope: drawingPanel,
            destinationType: Ext.ux.suncode.IntegrationComponentService.VARIABLE_DESTINATION,
            modifyGlobalDefinitionFunction: function( globalId, condition, values, extraConfig ) {
              var vChooser = this.variableDefPanel.vChooserContainer.items.first();
              var varId = vChooser.getValue();
              var formActionUpdate = {
                customDescription: extraConfig.customDescription,
                condition: condition,
                inactive: extraConfig.inactive,
                parameters: values
              };

              Ext.each( objectDef.formActions, function( formAction, index, formActions ) {
                if ( formAction.globalId == globalId ) {
                  Ext.apply( formAction, formActionUpdate );
                }
              } );

              processNode.updateVariableFormAction( varId, globalId, formActionUpdate );
            },
            modifyGlobalDefinitionScope: this
        } ), new Ext.ux.suncode.IntegrationComponentTable( {
            ref: 'eventActionsGrid',
            title: getTranslation( 'Zdarzenia' ),
            border: false,
            boxMinHeight: config.panelHeight,
            boxMaxHeight: config.panelHeight,
            eventMode: true,
            eventTypes: eventTypes,
            components: objectDef.eventActions,
            filteredCategories: eventActionsCategories,
            allCategories: eventActionsCategories,
            processNode: processNode,
            pasteComponentsValidation: {
              func: function( variableId ) {
                var presentVariableIds = this.getPresentVariableIds();

                return presentVariableIds.includes( variableId );
              },
              scope: drawingPanel,
              invalidMessagePart: getTranslation( 'niewystępujących na formularzu' )
            },
            enableCopyPasteMenu: true,
            conditionalExecutionEnabled: true,
            inactiveEnabled: true,
            parametersWindowTitlePrefix: getTranslation( 'Parametry zdarzenia' ),
            availableVariables: config.availableVariables,
            missingVariablesValidatorFunction: config.missingVariablesValidatorFunction,
            missingVariablesValidatorScope: config.missingVariablesValidatorScope,
            systemFunctionsAccessibility: Ext.ux.suncode.IntegrationComponentService.BROWSER_ACCESSIBILITY,
            getComponentRegistrationFunction: function( id ) {
              return Ext.ux.suncode.IntegrationComponentService.getEventActionRegistration( id );
            },
            getComponentRegistrationScope: this,
            copyComponentsFunction: function( components ) {
              Ext.ux.suncode.Clipboard.setIntegrationComponentEventActions( components );
            },
            copyComponentsScope: this,
            handleCopiedComponentsFunction: function( func, scope ) {
              Ext.ux.suncode.Clipboard.getIntegrationComponentEventActions( function( eventActions ) {
                if ( Ext.isFunction( func ) ) {
                  scope = !Ext.isEmpty( scope ) ? scope : window;
                  func.apply( scope, [ eventActions ] );
                }
              }, this );
            },
            handleCopiedComponentsScope: this,
            pasteSpecialMessageType: Ext.ux.suncode.Clipboard.integrationComponentEventActionsMessageType,
            validateFieldFunction: config.validateIntegrationComponentFieldFunction,
            validateFieldScope: config.validateIntegrationComponentFieldScope,
            validateRowFunction: drawingPanel.validateVariablesInIntegrationComponent,
            validateRowScope: drawingPanel,
            modifyGlobalDefinitionFunction: function( globalId, condition, values, extraConfig ) {
              var vChooser = this.variableDefPanel.vChooserContainer.items.first();
              var varId = vChooser.getValue();
              var eventActionUpdate = {
                customDescription: extraConfig.customDescription,
                condition: condition,
                inactive: extraConfig.inactive,
                parameters: values
              };

              Ext.each( this.eventActions, function( eventAction, index, eventActions ) {
                if ( eventAction.globalId == globalId ) {
                  Ext.apply( eventAction, eventActionUpdate );
                }
              } );

              processNode.updateVariableEventAction( varId, globalId, eventActionUpdate );
            },
            modifyGlobalDefinitionScope: this
        } ) ]
    }, config );

    Ext.ux.suncode.FormVariableDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.FormVariableDefPanel, Ext.TabPanel, {
    initComponent: function() {
        Ext.ux.suncode.FormVariableDefPanel.superclass.initComponent.call( this );
    },
    MIN_WIDTH: 50,
    addProcessVariable: function() {
        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var vChooser = this.variableDefPanel.vChooserContainer.items.first();
        var record = vChooser.getStore().recordType;

        var win = new Ext.ux.suncode.VariableDefWindow( {
            forcedType: this.initialConfig.component.type,
            processNode: processNode,
            saveTo: vChooser,
            varRecord: record,
            setToObj: vChooser,
            forcedPlacement: 'form'
        } );
        win.show();
    },
    editProcessVariable: function() {
        var varId = this.getChoosenVariable();
        if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return;
        }

        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var variable = processNode.findVariable( varId );

        if ( !Ext.ux.suncode.IntegrationComponentService.validateVariableEdit( variable ) ) {
          showWarn( getTranslation( 'Komponent dynamicznej listy o identyfikatorze' )
              + ' ' + variable.definition.id + ' ' + getTranslation( 'nie istnieje' ) + '.' );
          return;
        }

        var win = new Ext.ux.suncode.VariableDefWindow( {
            forcedType: this.initialConfig.component.type,
            forcedId: true,
            variable: variable,
            processNode: processNode,
            forcedPlacement: variable.placement,
            afterSaveFunction: function( newVariable ) {
            	Ext.apply( this.initialConfig.component, {
            		type: newVariable.type
            	} );
            	Ext.apply( this.initialConfig.component.definition.objectDef, {
            		type: newVariable.type
            	} );
              var newFormActions = deepObjectCopy( newVariable.formActions );
              var newEventActions = deepObjectCopy( newVariable.eventActions );

              Ext.each( this.initialConfig.component.definition.objectDef.formActions, function( formAction, index, formActions ) {
                if ( Ext.isEmpty( formAction.globalId ) ) {
                  newFormActions.push( formAction );
                }
              } );

              Ext.each( this.initialConfig.component.definition.objectDef.eventActions, function( eventAction, index, eventActions ) {
                if ( Ext.isEmpty( eventAction.globalId ) ) {
                  newEventActions.push( eventAction );
                }
              } );

              Ext.apply( this.initialConfig.component.definition.objectDef, {
                formActions: newFormActions,
                eventActions: newEventActions
              } );
              this.formActionsGrid.removeAllComponents();
              this.formActionsGrid.appendComponents( newFormActions );
              this.eventActionsGrid.removeAllComponents();
              this.eventActionsGrid.appendComponents( newEventActions );
            	this.variableDefPanel.typeItem.setValue( newVariable.type );
            },
            afterSaveScope: this
        } );
        win.show();
    },
    onSelectVariable: function( combo, record, index ) {
      this.editBindTo();

      var activityNode = this.initialConfig.activityNode;
      var processNode = activityNode.parentNode;
      var variableId = combo.getValue();
      var variable = processNode.findVariable( variableId );
      this.formActionsGrid.appendComponents( variable.formActions );
      this.eventActionsGrid.appendComponents( variable.eventActions );
    },
    editBindTo: function() {
        this.formActionsGrid.editBindToParameter();
        this.eventActionsGrid.editBindToParameter();
    },
    addAutoUpdate: function() {
        var varId = this.getChoosenVariable();
        if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return;
        }

        var win = new Ext.ux.suncode.AutoUpdateWindow( {
            saveTo: this.autoUpdatesPanel,
            varRecord: this.autoUpdatesPanel.getStore().recordType,
            activityNode: this.initialConfig.activityNode,
            formVariableId: varId
        } );
        win.show();
    },
    editAutoUpdate: function() {
        var varId = this.getChoosenVariable();
        if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return;
        }
        var record = this.getSelectedAutoUpdate();
        if ( !record ) {
            return;
        }

        var store = this.autoUpdatesPanel.getStore();
        var index = store.indexOf( record );
        var autoUpdate = this.autoUpdatesPanel.autoUpdates[index];
        var win = new Ext.ux.suncode.AutoUpdateWindow( {
            saveTo: this.autoUpdatesPanel,
            varRecord: record,
            autoUpdate: autoUpdate,
            index: index,
            activityNode: this.initialConfig.activityNode,
            formVariableId: varId
        } );
        win.show();
    },
    removeAutoUpdate: function() {
        var varId = this.getChoosenVariable();
        if ( Ext.isEmpty( varId ) ) {
            showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return;
        }
        var record = this.getSelectedAutoUpdate();
        if ( !record ) {
            return;
        }

        var id = record.get( 'id' );
        this.autoUpdatesPanel.removeAutoUpdate( id );
        removeRowAndMarkNext( this.autoUpdatesPanel, record );
        Ext.ux.suncode.DocumentationService.deleteAutoUpdateSpecification( this.initialConfig.activityNode, varId, id );
    },
    getChoosenVariable: function() {
        var vChooser = this.variableDefPanel.vChooserContainer.items.first();

        return vChooser.getValue();
    },
    getSelectedAutoUpdate: function() {
        var record = this.autoUpdatesPanel.getSelectionModel().getSelected();
        if ( !record ) {
            showWarn( getTranslation( 'Wybierz akcję.' ) );
            return null;
        }
        return record;
    },
    editFormVariable: function() {
        var component = this.initialConfig.component;
        var varDef = this.readDef();
        if ( !varDef ) {
            return;
        }

        var activityNode = this.initialConfig.activityNode;
        var processNode = activityNode.parentNode;
        var processVariablesCopy = [].concat( activityNode.parentNode.attributes.variables );

        var item = new Object();
        item = Ext.apply( {
            id: varDef.varId,
            type: component.type,
            labelAlign: varDef.labelAlign,
            labelWidth: varDef.labelWidth,
            labelSeparator: varDef.labelSeparator,
            labelFontSize: varDef.labelFontSize,
            labelColor: varDef.labelColor,
            textDecoration: varDef.textDecoration,
            width: varDef.width
        }, item );

        if ( !Ext.isEmpty( varDef.height ) ) {
            item = Ext.apply( {
                height: varDef.height
            }, item );
        }

        var newComponent = {
            processVariables: processVariablesCopy,
            item: item
        };

        var drawingPanel = Ext.getCmp( 'drawing_panel' );
        var componentContainer = component.ownerCt;
        var index = componentContainer.items.indexOf( component );
        componentContainer.suspendEvents();
        componentContainer.remove( component );
        componentContainer.resumeEvents();
        componentContainer.insert( index, drawingPanel.createFormVariable( newComponent, false, false, false, true, varDef ) );
        componentContainer.doLayout();

        var variable = processNode.findVariable( varDef.varId );
        var variablesTree = drawingPanel.ownerCt.variablesTree;
        variablesTree.markAsUsed( variable );

        Ext.ux.suncode.DocumentationService.editFormVariableSpecification( activityNode, varDef.varId, varDef.varId, varDef.specification );

        this.ownerCt.closeDefWindow();
    },
    readDef: function() {
        var varDef = new Object();
        var vChooser = this.variableDefPanel.vChooserContainer.items.first();
        var varId = vChooser.getValue();
        var width = this.variableDefPanel.widthItem.getValue();
        var labelAlign = this.labelPanel.alignmentItem.getValue();
        var labelWidth = this.labelPanel.widthItem.getValue();
        var labelFontSize = this.labelPanel.fontSizeItem.getValue();
        var textDecoration = this.labelPanel.textDecorationItem.getValue();

        if ( Ext.isEmpty( varId ) ) {
            this.activate( this.variableDefPanel );
            showWarn( getTranslation( 'Wybierz zmienną procesu.' ) );
            return null;
        } else if ( this.checkDuplication( varId ) ) {
            this.activate( this.variableDefPanel );
            showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
            return null;
        } else if ( !Ext.isEmpty( width ) && width < this.MIN_WIDTH ) {
            this.activate( this.variableDefPanel );
            showWarn( getTranslation( 'Szerokość pola nie może być mniejsza niż' ) + ' ' + this.MIN_WIDTH + '.' );
            return null;
        }

        if ( this.initialConfig.component.type == 'ROLEUSERS' || this.initialConfig.component.type == 'ROLEUSERS_NO_FILTER' ) {
            var roleusersFilters = this.readRoleusersFiltersGrid();

            if ( Ext.isEmpty( roleusersFilters ) ) {
                this.activate( this.variableDefPanel );
                showWarn( getTranslation( 'Uzupełnij poprawnie filtry.' ) );
                return null;
            }

            varDef = Ext.apply( {
                roleusersFilters: roleusersFilters,
                roleusersConjunction: this.readRoleusersConjunction()
            }, varDef );
        }

        varDef = Ext.apply( {
            varId: varId,
            name: vChooser.getRawValue(),
            type: this.initialConfig.component.type,
            hidden: this.variableDefPanel.hiddenItem.getValue(),
            editable: this.variableDefPanel.editableItem.getValue(),
            width: width,
            labelAlign: labelAlign,
            labelWidth: labelWidth,
            labelSeparator: this.labelPanel.separatorItem.getValue(),
            labelFontSize: labelFontSize,
            labelColor: this.labelPanel.colorItem.items.first().color,
            textDecoration: textDecoration,
            height: this.getAdditionalItemValue( this.variableDefPanel.heightItem ),
            formActions: this.formActionsGrid.readComponents(),
            eventActions: this.eventActionsGrid.readComponents(),
            autoUpdates: !Ext.isEmpty( this.autoUpdatesPanel ) ? this.autoUpdatesPanel.autoUpdates : new Array(),
            genre: 'VARIABLE',
            duplicateVariable: this.variableDefPanel.duplicateItem.getValue(),
            specification: this.readSpecification( varId )
        }, varDef );

        return varDef;
    },
    checkDuplication: function( varId ) {
        var component = this.initialConfig.component;

        if ( component.idAssigned && component.definition.objectDef.varId == varId ) {
            return false;
        } else {
            var drawingPanel = Ext.getCmp( 'drawing_panel' );
            var isDuplicated = false;

            drawingPanel.items.each( function( item ) {
                item.items.each( function( subitem ) {
                    var definition = subitem.definition;
                    var objectDef = definition.objectDef;

                    switch ( objectDef.genre ) {
                        case 'VARIABLE':
                            if ( subitem.idAssigned && objectDef.varId == varId ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'VARIABLE_SET':
                            if ( subitem.idAssigned ) {
                                if ( objectDef.varId == varId ) {
                                    isDuplicated = true;
                                    return false;
                                } else {
                                    var columns = objectDef.columns;

                                    for ( var i = 0; i < columns.length; i++ ) {
                                        var column = columns[i];

                                        if ( column.varId == varId ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                    
                                    var dtButtons = objectDef.DTButtons;

                                    for ( var i = 0; i < dtButtons.length; i++ ) {
                                        var dtButton = dtButtons[i];

                                        if ( dtButton.buttonId == varId ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                }
                            }
                            break;
                        case 'LABEL':
                            if ( subitem.idAssigned && objectDef.id == varId ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'HTTP_LINK':
                        case 'ACTION_ACCEPT_BUTTON':
                        case 'GENERATE_PDF_BUTTON':
                        case 'ADD_FILE_BUTTON':
                        case 'BARCODE_PRINT':
                            if ( subitem.idAssigned &&
                            		( objectDef.actionName == varId || objectDef.actionName + '_button' == varId ) ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        default:
                            break;
                    }
                } );

                if ( isDuplicated ) {
                    return false;
                }
            } );

            return isDuplicated;
        }
    },
    getAdditionalItemValue: function( item ) {
        if ( item ) {
            return item.getValue();
        }
        return null;
    },
    chooseLabelColor: function( button, e ) {
        closeColorChooser();

        var me = this;
        var labelColorField = this.labelPanel.colorItem.items.first();
        var colorChooser = new Ext.ux.suncode.ColorChooser( {
            title: getTranslation( 'Kolor etykiety' ),
            e: e,
            color: labelColorField.color,
            saveFunction: function( choosenColor ) {
                labelColorField.getEl().setStyle( 'background', choosenColor );
                labelColorField.color = choosenColor;
                labelColorField.setValue(' ');
                me.storeParentWindowAsUnsaved();
            }
        } );
        colorChooser.show();
    },
    restoreDefaultLabelColor: function() {
      var labelColorField = this.labelPanel.colorItem.items.first();
      labelColorField.getEl().setStyle( 'background', '' );
      labelColorField.color = '';
      labelColorField.setValue('');
      this.storeParentWindowAsUnsaved();
    },
    readRoleusersFiltersGrid: function() {
        var filters = new Array();
        var store = this.variableDefPanel.roleusersFiltersGrid.getStore();

        store.each( function( rec ) {
            var type = rec.get( 'type' );
            var value = rec.get( 'value' );

            if ( !Ext.isEmpty( type ) && !Ext.isEmpty( value ) ) {
                filters.push( {
                    type: type,
                    value: value
                } );
            }
        } );

        return filters;
    },
    readRoleusersConjunction: function() {
        return this.variableDefPanel.roleusersFiltersGrid.getTopToolbar().conjunctionItem.getValue();
    },
    readSpecification: function( varId ) {
        var activityNode = this.initialConfig.activityNode;
        var currentSpecification = Ext.ux.suncode.DocumentationService.getFormVariableSpecification( activityNode, varId );
        var specification = new Object();
        specification = Ext.apply( {
            description: this.variableDefPanel.specificationDescriptionItem.getSpecificationDescription(),
            autoUpdateSpecifications: currentSpecification.autoUpdateSpecifications
        }, specification );

        return specification;
    }
} );

Ext.ux.suncode.RoleusersFiltersGrid = function( config ) {
    var component = config.component;
    var roleusersFilters = component.definition.objectDef.roleusersFilters;
    var roleusersConjunction = component.definition.objectDef.roleusersConjunction;

    var store = new Ext.data.Store( {
        reader: new Ext.data.JsonReader( {
            fields: Ext.data.Record.create( [ {
                name: 'type',
                type: 'string'
            }, {
                name: 'value',
                type: 'string'
            } ] )
        } )
    } );

    if ( !Ext.isEmpty( roleusersFilters ) ) {
        store.loadData( roleusersFilters );
        store.commitChanges();
    }

    var filtersChooser = new Ext.ux.suncode.RoleusersFilterTypesChooser();

    config = Ext.apply( {
        title: getTranslation( 'Filtry' ),
        ref: 'roleusersFiltersGrid',
        store: store,
        height: 200,
        frame: false,
        enableColumnResize: true,
        columnLines: true,
        autoScroll: true,
        colModel: new Ext.grid.ColumnModel( {
            defaults: {
                sortable: true,
                menuDisabled: false
            },
            columns: [ {
                id: 'type',
                header: getTranslation( 'Typ' ),
                dataIndex: 'type',
                align: 'left',
                editor: filtersChooser,
                renderer: Ext.util.Format.ComboBoxRenderer( filtersChooser )
            }, {
                id: 'value',
                header: getTranslation( 'Wartość' ),
                dataIndex: 'value',
                align: 'left',
                editor: new Ext.form.TextField( {
                    inputType: 'text'
                } )
            } ]
        } ),
        viewConfig: new Ext.grid.GridView( {
            forceFit: true
        } ),
        sm: new Ext.grid.RowSelectionModel( {
            singleSelect: true
        } ),
        tbar: new Ext.Toolbar( {
            items: [ '<b>' + getTranslation( 'Spełnij wszystkie warunki:' ) + '</b>', {
              xtype: 'tbspacer'
            }, {
              xtype: 'checkbox',
              ref: 'conjunctionItem',
              checked: roleusersConjunction,
              inputValue: 'true'
            }, '->', {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'add' ),
                tooltip: getTranslation( 'Dodaj' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var store = grid.getStore();
                    var v = store.recordType;
                    var rec = new v( {
                        type: '',
                        value: ''
                    } );
                    grid.stopEditing();
                    store.add( rec );
                    store.commitChanges();
                    grid.startEditing( store.getCount() - 1, 0 );
                }
            }, {
                cls: 'x-btn-icon',
                icon: getPluginImgPath( 'delete' ),
                tooltip: getTranslation( 'Usuń' ),
                handler: function() {
                    var grid = this.ownerCt.ownerCt;
                    var selModel = grid.getSelectionModel();
                    var rows = selModel.getSelections();
                    if ( rows.length == 0 ) {
                        showWarn( getTranslation( 'Wybierz filtr do usunięcia.' ) );
                        return;
                    }
                    removeRowAndMarkNext( grid, rows[0] );
                    grid.getView().refresh();
                }
            } ]
        } ),
        listeners: {
            afteredit: function( e ) {
                e.grid.getStore().commitChanges();
            }
        }
    }, config );

    Ext.ux.suncode.RoleusersFiltersGrid.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.RoleusersFiltersGrid, Ext.grid.EditorGridPanel, {
    initComponent: function() {
        Ext.ux.suncode.RoleusersFiltersGrid.superclass.initComponent.call( this );
    }
} );