Ext.ux.suncode.AddFileButtonDefPanel = function( config ) {
    var component = config.component;
    var objectDef = component.definition.objectDef;
    var packageNode = Ext.getCmp( 'package_panel' ).getRootNode();
	var packageId = packageNode.attributes.packageId;
    var activityNode = config.activityNode;
    var activityDefId = activityNode.attributes.activityDefId;
    var processNode = activityNode.parentNode;
    var processDefId = processNode.attributes.processDefId;
    var mainPanel = Ext.getCmp( 'main_panel' );
    var animationsOn = mainPanel.getAnimationsOn();
    var iconLabel = addTooltipToField( getTranslation( 'Ikona' ), getTranslation( 'Zalecana ikona' ) + ': ' + 'folder_page_white' );
    var nameTranslationKey = 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId +
		')_ADDFILEBUTTON(' + Ext.ux.suncode.I18NService.replaceAddFileButtonId( objectDef.docClassName ) +')';

    config = Ext.apply( {
        layoutConfig: {
            trackLabels: true
        },
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        labelWidth: 250,
        autoHeight: true,
        ref: 'buttonDefPanel',
        items: [ {
            xtype: 'textfield',
            inputType: 'text',
            fieldLabel: getTranslation( 'Nazwa akcji' ),
            anchor: '100%',
            ref: 'actionNameItem',
            value: objectDef.actionName,
            hidden: true
        }, new Ext.ux.suncode.I18NTranslatedField( {
        	fieldLabel: getTranslation( 'Nazwa przycisku' ),
        	anchor: '100%',
            ref: 'buttonNameItem',
        	field: {
                xtype: 'textfield',
                value: objectDef.buttonName,
                listeners: {
                    scope: this,
                    blur: function( field ) {
                        var actionName = generateId( field.getValue() );
                        this.actionNameItem.setValue( actionName );
                    }
                }
            },
            getIdFieldFunction: function() {
            	return this.docClassesChooser;
            },
            getIdFieldScope: this,
            emptyIdMessage: getTranslation( 'Podaj nazwę przycisku.' ),
            windowTitle: getTranslation( 'Tłumaczenia nazwy przycisku' ),
            keyPrefix: 'PACK(' + packageId + ')_PROC(' + processDefId + ')_ACTIVITY(' + activityDefId + ')_ADDFILEBUTTON(',
            keyPostfix: ')',
            saveToCache: true,
            cache: !Ext.isEmpty( objectDef.translations[nameTranslationKey] ) ? {
    			key: nameTranslationKey,
    			translations: objectDef.translations[nameTranslationKey]
    		} : new Object(),
            initialId: ( component.idAssigned && !Ext.isEmpty( objectDef.docClassName ) )
            	? Ext.ux.suncode.I18NService.replaceAddFileButtonId( objectDef.docClassName ) : null,
            idReplacementStrategy: Ext.ux.suncode.I18NService.replaceAddFileButtonId
        } ), new Ext.ux.suncode.SystemIconsChooser( {
        	fieldLabel: iconLabel,
            icon: objectDef.icon
        } ), new Ext.ux.suncode.SystemColorsChooser( {
          color: objectDef.color
        } ), new Ext.ux.suncode.SystemDocumentClassesChooser( {
            docClassName: objectDef.docClassName
        } ) ]
    }, config );

    Ext.ux.suncode.AddFileButtonDefPanel.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.AddFileButtonDefPanel, Ext.FormPanel, {
    initComponent: function() {
        Ext.ux.suncode.AddFileButtonDefPanel.superclass.initComponent.call( this );
    },
    editFormButton: function() {
        var btnDef = this.readDef();
        if ( !btnDef ) {
            return;
        }

        var component = this.initialConfig.component;
        var item = component.items.first();
        var objectDef = component.definition.objectDef;
        Ext.apply( objectDef, btnDef );

        item.setText( objectDef.buttonName );
        item.setIconClass( Ext.ux.suncode.UtilService.resolveIconCls( objectDef.icon ) );

        Ext.ux.suncode.UtilService.resolveFormButtonColor(item, objectDef.color);

        component.idAssigned = true;

        this.ownerCt.closeDefWindow();
    },
    readDef: function() {
        var btnDef = new Object();
        var actionName = this.actionNameItem.getValue();
        var buttonName = this.buttonNameItem.getValue();
        var docClassName = this.docClassesChooser.getValue();

        if ( Ext.isEmpty( actionName ) || Ext.isEmpty( buttonName ) ) {
            showWarn( getTranslation( 'Podaj nazwę przycisku.' ) );
            return null;
        } else if ( Ext.isEmpty( docClassName ) ) {
            showWarn( getTranslation( 'Wybierz klasę dokumentów.' ) );
            return null;
        } else if ( this.checkDuplication( actionName, docClassName ) ) {
            showWarn( getTranslation( 'Zmienna procesu/tabela dynamiczna/etykieta/przycisk o tym samym identyfikatorze został już dodany do formularza.' ) );
            return null;
        }

        btnDef = Ext.apply( {
            actionName: actionName,
            buttonName: buttonName,
            icon: this.iconsChooser.getValue(),
            color: this.colorsChooser.getValue(),
            docClassName: docClassName,
            checkForm: false,
            sourceName: 'addFile',
            translations: Ext.ux.suncode.I18NService.getPackageTranslationsFromCaches( [ this.buttonNameItem ] ),
            genre: 'ADD_FILE_BUTTON'
        }, btnDef );

        return btnDef;
    },
    checkDuplication: function( actionName, docClassName ) {
        var component = this.initialConfig.component;
        var initialActionName = component.definition.objectDef.actionName;

        if ( component.idAssigned && initialActionName == actionName ) {
        	if ( component.definition.objectDef.docClassName == docClassName ) {
        		return false;
        	} else {
        		var drawingPanel = Ext.getCmp( 'drawing_panel' );
                var isDuplicated = false;
                
        		drawingPanel.items.each( function( item ) {
                    item.items.each( function( subitem ) {
                    	var definition = subitem.definition;
                        var objectDef = definition.objectDef;

                        switch ( objectDef.genre ) {
                            case 'ADD_FILE_BUTTON':
                            	if ( subitem.idAssigned &&
                            			( objectDef.actionName != initialActionName && objectDef.docClassName == docClassName ) ) {
                                    isDuplicated = true;
                                    return false;
                                }
                                break;
                            default:
                                break;
                        }
                    } );

                    if ( isDuplicated ) {
                        return false;
                    }
                } );
        		
        		return isDuplicated;
        	}
        } else {
            var drawingPanel = Ext.getCmp( 'drawing_panel' );
            var isDuplicated = false;

            drawingPanel.items.each( function( item ) {
                item.items.each( function( subitem ) {
                	var definition = subitem.definition;
                    var objectDef = definition.objectDef;

                    switch ( objectDef.genre ) {
	                    case 'VARIABLE':
	                        if ( subitem.idAssigned &&
	                        		( objectDef.varId == actionName || objectDef.varId == actionName + '_button' ) ) {
	                            isDuplicated = true;
	                            return false;
	                        }
	                        break;
                        case 'VARIABLE_SET':
                        	if ( subitem.idAssigned ) {
                        		if ( objectDef.varId == actionName || objectDef.varId == actionName + '_button' ) {
                                    isDuplicated = true;
                                    return false;
                                } else {
                                    var columns = objectDef.columns;

                                    for ( var i = 0; i < columns.length; i++ ) {
                                        var column = columns[i];

                                        if ( column.varId == actionName || column.varId == actionName + '_button' ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                    
                                    var dtButtons = objectDef.DTButtons;

                                    for ( var i = 0; i < dtButtons.length; i++ ) {
                                        var dtButton = dtButtons[i];

                                        if ( dtButton.buttonId == actionName || dtButton.buttonId == actionName + '_button' ) {
                                            isDuplicated = true;
                                            return false;
                                        }
                                    }
                                }
                            }
                        	break;
                        case 'LABEL':
                            if ( subitem.idAssigned && objectDef.id == actionName + '_button' ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'HTTP_LINK':
                        case 'ACTION_ACCEPT_BUTTON':
                        case 'GENERATE_PDF_BUTTON':
                        case 'BARCODE_PRINT':
                            if ( subitem.idAssigned && objectDef.actionName == actionName ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        case 'ADD_FILE_BUTTON':
                        	if ( subitem.idAssigned &&
                        			( objectDef.actionName == actionName ||
                        					( objectDef.actionName != initialActionName && objectDef.docClassName == docClassName ) ) ) {
                                isDuplicated = true;
                                return false;
                            }
                            break;
                        default:
                            break;
                    }
                } );

                if ( isDuplicated ) {
                    return false;
                }
            } );

            return isDuplicated;
        }
    }
} );