Ext.ux.suncode.CustomForm = function( config ) {
    var processNode = config.processNode;
    var customForm = config.customForm;
    var information = config.information;
    var availableVariables = config.availableVariables;
    var missingVariablesValidatorFunction = config.missingVariablesValidatorFunction;
    var missingVariablesValidatorScope = config.missingVariablesValidatorScope;
    var systemFunctionsAccessibility = config.systemFunctionsAccessibility;
    var validateFieldFunction = config.validateFieldFunction;
    var validateFieldScope = config.validateFieldScope;
    var customFormConfig = config.customFormConfig;
    var items = new Array();
    
    if ( !Ext.isEmpty( information ) ) {
    	if ( information.deprecated ) {
    		items.push( {
        		xtype: 'label',
        		anchor: '100%',
        		cls: 'x-Module-deprecated',
                text: !Ext.isEmpty( information.replacement ) ? information.replacementMessage
                		+ ': ' + information.replacement : information.deprecatedMessage
            } );

          if ( !Ext.isEmpty( information.deprecationDescription ) ) {
            items.push( {
                xtype: 'label',
                anchor: '100%',
                cls: 'x-Module-deprecated',
                text: information.deprecationDescription
            } );
          }
        }
    	
    	if ( !Ext.isEmpty( information.nameChooser ) ) {
    		items.push( information.nameChooser );
    	} else {
    		items.push( {
                xtype: 'displayfield',
                fieldLabel: getTranslation( 'Nazwa' ),
                value: information.nameValue
            } );
    	}

    	var description = information.descriptionValue;

    	if ( !Ext.isEmpty( information.documentationLink ) ) {
        description += ' <a class="x-Module-link" href="';
        description += information.documentationLink;
        description += '" target="_blank">';
        description += getTranslation( 'Czytaj więcej...' );
        description += '</a>';
      }

    	items.push( {
            xtype: 'displayfield',
            fieldLabel: getTranslation( 'Opis' ),
            value: description
        } );
    }
    
    if ( config.customDescriptionEnabled ) {
	    items.push( {
	        xtype: 'textarea',
	        anchor: '100%',
	        height: 100,
	        fieldLabel: getTranslation( 'Opis własny' ),
	        ref: 'customDescriptionItem',
	        value: config.customDescription
	    } );
    }

    if ( config.inactiveEnabled ) {
      items.push( {
        xtype: 'checkbox',
        fieldLabel: getTranslation( 'Nieaktywny' ),
        ref: 'inactiveItem',
        inputValue: 'true',
        checked: config.inactive
      } );
    }

    if ( config.conditionalExecutionEnabled ) {
        var condition = config.condition;
        var hasCondition = Ext.isEmpty( condition ) ? false : true;
        var negation = false;

        if ( hasCondition && condition.type === this.FUNCTION_FIELD_TYPE && condition.value.name === this.NEGATION_FUNCTION_NAME
                        && !Ext.isEmpty( condition.value.parameters ) ) {
            condition = condition.value.parameters[0];
            negation = true;
        }

        items.push( {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Wykonanie warunkowe' ),
            ref: 'conditionalExecutionItem',
            inputValue: 'true',
            checked: hasCondition,
            listeners: {
                scope: this,
                check: this.onConditionalExecutionCheck
            }
        } );
        items.push( new Ext.ux.suncode.CustomField( {
            name: getTranslation( 'Warunek' ),
            type: this.FUNCTION_FIELD_TYPE,
            processNode: processNode,
            availableVariables: availableVariables,
            missingVariablesValidatorFunction: missingVariablesValidatorFunction,
            missingVariablesValidatorScope: missingVariablesValidatorScope,
            systemFunctionsAccessibility: systemFunctionsAccessibility,
            validateFieldFunction: validateFieldFunction,
            validateFieldScope: validateFieldScope,
            typeVisible: customFormConfig.typesVisible,
            functionPrettyFormat: customFormConfig.functionPrettyFormat,
            customValue: hasCondition ? condition : undefined,
            ref: 'conditionItem',
            hidden: !hasCondition,
            emptyErrorMessage: getTranslation( 'Określ warunek.' )
        } ) );
        items.push( {
            xtype: 'checkbox',
            fieldLabel: getTranslation( 'Negacja' ),
            ref: 'negationItem',
            inputValue: 'true',
            checked: negation,
            hidden: !hasCondition
        } );
    }
    
    if ( config.confirmationConfigurationEnabled ) {
    	var confirmation = config.confirmation;
        var hasConfirmation = Ext.isEmpty( confirmation ) ? false : true;
    		
        items.push( new Ext.ux.suncode.CustomField( {
            name: getTranslation( 'Tytuł komunikatu potwierdzenia' ),
            type: this.STRING_FIELD_TYPE,
            processNode: processNode,
            availableVariables: availableVariables,
            missingVariablesValidatorFunction: missingVariablesValidatorFunction,
            missingVariablesValidatorScope: missingVariablesValidatorScope,
            systemFunctionsAccessibility: systemFunctionsAccessibility,
            validateFieldFunction: validateFieldFunction,
            validateFieldScope: validateFieldScope,
            typeVisible: customFormConfig.typesVisible,
            functionPrettyFormat: customFormConfig.functionPrettyFormat,
            customValue: hasConfirmation ? confirmation.title : undefined,
            ref: 'confirmationTitleItem'
        } ) );
    	items.push( new Ext.ux.suncode.CustomField( {
            name: getTranslation( 'Treść komunikatu potwierdzenia' ),
            type: this.STRING_FIELD_TYPE,
            processNode: processNode,
            availableVariables: availableVariables,
            missingVariablesValidatorFunction: missingVariablesValidatorFunction,
            missingVariablesValidatorScope: missingVariablesValidatorScope,
            systemFunctionsAccessibility: systemFunctionsAccessibility,
            validateFieldFunction: validateFieldFunction,
            validateFieldScope: validateFieldScope,
            typeVisible: customFormConfig.typesVisible,
            functionPrettyFormat: customFormConfig.functionPrettyFormat,
            customValue: hasConfirmation ? confirmation.message : undefined,
            ref: 'confirmationMessageItem'
        } ) );
    }
    
    if ( config.errorConfigurationEnabled ) {
    	var error = config.error;
        var hasError = Ext.isEmpty( error ) ? false : true;
    		
    	items.push( new Ext.ux.suncode.CustomField( {
            name: getTranslation( 'Treść komunikatu błędu' ),
            type: this.STRING_FIELD_TYPE,
            processNode: processNode,
            availableVariables: availableVariables,
            missingVariablesValidatorFunction: missingVariablesValidatorFunction,
            missingVariablesValidatorScope: missingVariablesValidatorScope,
            systemFunctionsAccessibility: systemFunctionsAccessibility,
            validateFieldFunction: validateFieldFunction,
            validateFieldScope: validateFieldScope,
            typeVisible: customFormConfig.typesVisible,
            functionPrettyFormat: customFormConfig.functionPrettyFormat,
            customValue: hasError ? error.message : undefined,
            ref: 'errorMessageItem'
        } ) );
    }
    
    if ( !Ext.isEmpty( information ) || config.customDescriptionEnabled || config.conditionalExecutionEnabled
    		|| config.confirmationConfigurationEnabled || config.errorConfigurationEnabled || config.inactiveEnabled ) {
    	items.push( {
            xtype: 'box',
            parametersSeparator: !config.errorHandlingEnabled,
            autoEl: {
                tag: 'div',
                html: '<hr ' + getHRLineStyle() + '>',
                style: 'padding-bottom: 10px'
            }
        } );
    }
    
    if ( config.errorHandlingEnabled ) {
    	var errorHandling = config.errorHandling;
        var errorHandlingType = !Ext.isEmpty( errorHandling ) ? errorHandling.type : 'STOP';
    		
    	items.push( {
    		xtype: 'combo',
    		anchor: '100%',
            fieldLabel: addTooltipToField( getTranslation( 'Typ obsługi błędu' ), getTranslation( 
            		'Parametr określający, co ma się wydarzyć w przypadku, gdy wykonanie zadania automatycznego się nie powiedzie. ' + 
            		'W przypadku przerwania akceptacji proces wróci do zadania ręcznego, które było akceptowane przez użytkownika. ' +
            		'Można wtedy w poniższych polach określić wiadomość, jaka wyświetli się użytkownikowi oraz dodać stosowny komentarz. ' +
            		'W przypadku kontynuacji akceptacji proces pójdzie dalej zgodnie ze ścieżką na mapie. ' + 
            		'Ścieżką można sterować ustawiając poniżej odpowiednie wartości pod zmienne. ' + 
            		'Dodatkowo można dodać stosowny komentarz do zadania.' ) ),
            triggerAction: 'all',
			mode: 'local',
			store: new Ext.data.Store( {
				data: [ {
					id: 'STOP',
					name: getTranslation( 'Przerwanie akceptacji' )
				}, {
					id: 'CONTINUE',
					name: getTranslation( 'Kontynuacja akceptacji' )
				} ],
				reader: new Ext.data.JsonReader( {
					fields: Ext.data.Record.create( [ {
						name: 'id',
						type: 'string'
					}, {
						name: 'name',
						type: 'string'
					} ] )
				} )
			} ),
			valueField: 'id',
			displayField: 'name',
			forceSelection: true,
			resizable: true,
			editable: false,
			value: errorHandlingType,
			ref: 'errorHandlingTypeItem',
			listeners: {
				scope: this,
				select: this.onErrorHandlingTypeSelect
			}
        } );
    	
    	items = items.concat( this.buildErrorHandlingAdditionalItems( errorHandling, config ) );
    	items.push( {
            xtype: 'box',
            parametersSeparator: true,
            autoEl: {
                tag: 'div',
                html: '<hr ' + getHRLineStyle() + '>',
                style: 'padding-bottom: 10px'
            }
        } );
    }
    
    if ( Ext.isArray( config.dtButtons ) ) {
    	var systemIconsChooser = new Ext.ux.suncode.SystemIconsChooser();
    	
    	items.push( {
	        xtype: 'editorgrid',
	        ref: 'dtButtonsItem',
	        title: getTranslation( 'Przyciski tabeli dynamicznej' ),
	        store: new Ext.data.Store( {
	    		data: config.dtButtons,
	            reader: new Ext.data.JsonReader( {
	                fields: Ext.data.Record.create( [ {
                      name: 'id',
                      type: 'string'
                  }, {
	                    name: 'name',
	                    type: 'string'
	                }, {
	                    name: 'icon',
	                    type: 'string'
	                }, {
	                    name: 'tooltip',
	                    type: 'string'
	                }, {
	                    name: 'disabled',
	                    type: 'boolean'
	                } ] )
	            } )
	        } ),
          autoHeight: true,
	        frame: false,
	        enableColumnResize: true,
	        columnLines: true,
	        style: {
	            marginBottom: '5px'
          },
	        colModel: new Ext.grid.ColumnModel( {
	            defaults: {
	                sortable: true,
	                menuDisabled: false
	            },
	            columns: [ {
                  id: 'id_column',
                  header: getTranslation( 'Identyfikator' ),
                  dataIndex: 'id',
                  align: 'left',
                  editor: new Ext.form.TextField( {
                    inputType: 'text'
                  } )
              }, {
	                id: 'name',
	                header: getTranslation( 'Nazwa' ),
	                dataIndex: 'name',
	                align: 'left',
	                editor: new Ext.form.TextField( {
	                    inputType: 'text'
	                } )
	            }, {
	                id: 'icon',
	                header: getTranslation( 'Ikona' ),
	                dataIndex: 'icon',
	                align: 'center',
	                width: 50,
	                editor: systemIconsChooser,
	                renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
	                    if ( !Ext.isEmpty( value ) ) {
	                    	var imgPath = Suncode.context( 'pwe' ).contextPath + '/' + value;
	                        return '<img src=\"' + imgPath + '\" width="16" height="16">';
	                    } else {
	                        return '';
	                    }
	                }
	            }, {
	                id: 'tooltip',
	                header: getTranslation( 'Tooltip' ),
	                dataIndex: 'tooltip',
	                align: 'left',
	                editor: new Ext.form.TextField( {
	                    inputType: 'text'
	                } )
	            }, {
	                id: 'disabled',
	                header: getTranslation( 'Zablokowany' ),
	                dataIndex: 'disabled',
	                align: 'center',
                    width: 40,
                    renderer: tickCrossValue
	            } ]
	        } ),
	        viewConfig: new Ext.grid.GridView( {
	            forceFit: true
	        } ),
	        sm: new Ext.grid.RowSelectionModel( {
	            singleSelect: true
	        } ),
	        listeners: {
	            afteredit: function( e ) {
	                e.grid.getStore().commitChanges();
	            },
	            cellclick: function( grid, rowIndex, columnIndex, e ) {
                    var store = grid.getStore();
                    var colId = grid.getColumnModel().getColumnId( columnIndex );

                    if ( colId == 'disabled' ) {
                        var record = store.getAt( rowIndex );
                        record.set( 'disabled', !record.get( 'disabled' ) );
                        store.commitChanges();
                    }
                }
	        }
	    } );
    	
    	items.push( {
            xtype: 'box',
            parametersSeparator: true,
            autoEl: {
                tag: 'div',
                html: '<hr ' + getHRLineStyle() + '>',
                style: 'padding-bottom: 10px'
            }
        } );
    }
    
    if ( !Ext.isEmpty( customForm ) && !Ext.isEmpty( customForm.fields ) && !Ext.isFunction( customForm.buildForm )
    		&& !config.preventBuildFields ) {
    	  var bindTo = config.bindTo;
        var onFieldEnterTask = config.onFieldEnterTask;
        var contextVariables = config.contextVariables;
        var tableVariableAllowed = config.tableVariableAllowed;
        var columnCheckboxEnabled = config.columnCheckboxEnabled;
        var previous = null;

        Ext.each( customForm.fields, function( customFormField, index, customFormFields ) {
            var field = this.buildField( customForm, customFormField, {
            	isParameterField: true,
            	processNode: processNode,
            	bindTo: bindTo,
            	onFieldEnterTask: onFieldEnterTask,
            	contextVariables: contextVariables,
            	availableVariables: availableVariables,
              missingVariablesValidatorFunction: missingVariablesValidatorFunction,
              missingVariablesValidatorScope: missingVariablesValidatorScope,
            	systemFunctionsAccessibility: systemFunctionsAccessibility,
              validateFieldFunction: validateFieldFunction,
              validateFieldScope: validateFieldScope,
            	recommendedSystemFunctions: customFormField.recommendedFunctions,
            	typesVisible: customFormConfig.typesVisible,
            	tableVariableAllowed: tableVariableAllowed,
              functionPrettyFormat: customFormConfig.functionPrettyFormat,
            	columnCheckboxEnabled: columnCheckboxEnabled,
            	previousWindow: config.previousWindow
            } );

            if ( !Ext.isEmpty( previous ) ) {
                field = Ext.apply( field, {
                    previous: previous
                } );

                previous = Ext.apply( previous, {
                    next: field
                } );
            }

            items.push( field );
            previous = field;
        }, this );

        var dependentEventsItem = this.tryBuildDependentEventsItem(
            config.eventTypesEnabled, config.eventTypes, config.eventTypesTag );

        if ( !Ext.isEmpty( dependentEventsItem ) ) {
          items.push( dependentEventsItem );
        }
    }

    config = Ext.apply( {
        layout: 'form',
        layoutConfig: {
            trackLabels: true
        },
        labelWidth: 250,
        frame: false,
        border: false,
        bodyCssClass: 'x-Module-container-padding',
        typesVisible: customFormConfig.typesVisible,
        functionPrettyFormat: customFormConfig.functionPrettyFormat,
        rebuildParametersActive: false,
        items: items
    }, config );

    Ext.ux.suncode.CustomForm.superclass.constructor.call( this, config );
};

Ext.extend( Ext.ux.suncode.CustomForm, Ext.Panel, {
    initComponent: function() {
        Ext.ux.suncode.CustomForm.superclass.initComponent.call( this );

        this.on( 'afterrender', this.onAfterRender, this );
    },
    FUNCTION_FIELD_TYPE: 'function',
    STRING_FIELD_TYPE: 'string',
    BOOLEAN_FIELD_TYPE: 'boolean',
    VARIABLE_FIELD_TYPE: 'variable',
    NEGATION_FUNCTION_NAME: 'not',
    NEGATION_FUNCTION_PARAMETER_TYPES: [ {
    	type: 'boolean',
    	array: false
    } ],
    FOCUS_FIELD_DELAY: 300,
    DEFAULT_API_VERSION: 1,
    DEFAULT_COMBOBOX_PAGE_SIZE: 25,
    DEFAULT_COMBOBOX_MIN_CHARS: 0,
    COMBOBOX_MIN_LIST_WIDTH: 300,
    onAfterRender: function() {
    	this.tryBuildWithCustomFunction();
    },
    rebuildParameters: function() {
    	if ( this.rebuildParametersActive ) {
    		var items = this.items.items;
            var startRemove = false;
            var itemsToRemove = new Array();

            Ext.each( items, function( item, index, items ) {
                if ( startRemove ) {
                    itemsToRemove.push( item );
                }

                if ( item.parametersSeparator ) {
                    startRemove = true;
                }
            } );

            Ext.each( itemsToRemove, function( item, index, allItemsToRemove ) {
                this.remove( item );
            }, this );

            this.doLayout();
            this.tryBuildWithCustomFunction();
    	}
    },
    tryBuildWithCustomFunction: function() {
      var customForm = this.initialConfig.customForm;

      if ( !Ext.isEmpty( customForm ) ) {
        var buildFormFunction = customForm.buildForm;

        if ( Ext.isFunction( buildFormFunction ) ) {
          var api = this.buildApi();
          var options = new Object();
          options = Ext.apply( options, {
            destination: this.initialConfig.destinationType,
            acceptButton: this.initialConfig.acceptButton,
            tableId: this.initialConfig.tableId,
            buttonId: this.initialConfig.buttonId
          } );

          try {
            buildFormFunction.apply( window, [ api, options ] );
          } catch ( e ) {
            logError( e );

            var task = new Ext.util.DelayedTask( function() {
              showWarn( getTranslation( 'Wystąpił błąd budowania formularza. Sprawdź, czy zainstalowana jest najnowsza ' +
                  'wersja wtyczki.' ) );
            } );
            task.delay( 10 );
          }

          var dependentEventsItem = this.tryBuildDependentEventsItem(
              this.initialConfig.eventTypesEnabled, this.initialConfig.eventTypes, this.initialConfig.eventTypesTag );

          if ( !Ext.isEmpty( dependentEventsItem ) ) {
            this.add( dependentEventsItem );
            this.doLayout();
          }
        }
      }

      if ( this.initialConfig.focusFirstParameter ) {
        this.focusFirstParameterField();
      }
    },
    tryBuildDependentEventsItem: function( eventTypesEnabled, eventTypes, eventTypesTag ) {
      if ( eventTypesEnabled && !Ext.isEmpty( eventTypes ) ) {
        var eventTypeItems = new Array();
        eventTypeItems.push( {
          xtype: 'displayfield',
          anchor: '100%',
          fieldLabel: getTranslation( 'Tag' ),
          value: eventTypesTag
        } );

        Ext.each( eventTypes, function( eventType, index, eventTypes ) {
          if ( eventType.added ) {
            eventTypeItems.push( {
              xtype: 'displayfield',
              anchor: '100%',
              fieldLabel: eventType.name,
              value: getTranslation( 'Zdarzenie zostało już dodane' )
            } );
          } else {
            eventTypeItems.push( {
              xtype: 'compositefield',
              fieldLabel: eventType.name,
              items: [ {
                xtype: 'button',
                isFormField: true,
                cls: 'x-btn-text',
                text: getTranslation( 'Dodaj zdarzenie' ),
                eventType: eventType,
                handler: this.onAddEventType,
                scope: this
              } ]
            } );
          }
        }, this );

        return {
          xtype: 'fieldset',
          title: getTranslation( 'Zdarzenia zależne' ),
          items: eventTypeItems
        };
      } else {
        return null;
      }
    },
    buildApi: function() {
    	var customForm = this.initialConfig.customForm;
    	var apiVersion = !Ext.isEmpty( customForm.apiVersion ) ? customForm.apiVersion : this.DEFAULT_API_VERSION;
    	
    	switch( apiVersion ) {
			case 2:
				return this.getApiVersion2();
			default:
				return this;
		}
    },
    focusFirstParameterField: function() {
      var task = new Ext.util.DelayedTask( this.executeFocusFirstParameterField, this );
      task.delay( this.FOCUS_FIELD_DELAY );
    },
    executeFocusFirstParameterField: function() {
      var field = this.getFirstEditableParameterField();

      if ( !Ext.isEmpty( field ) ) {
        field.focusField();
      }
    },
    isEditableParameterField: function( field ) {
    	return ( ( field.isParameterField || field.isTableField ) && !field.isReadOnly() && !field.isColorPicker );
    },
    getFirstEditableParameterField: function() {
        var field = null;
        var items = this.items.items;

        if ( !Ext.isEmpty( items ) ) {
            Ext.each( items, function( item, index, allItems ) {
                if ( this.isEditableParameterField( item ) ) {
                    field = item;
                    return false;
                }
            }, this );
        }

        return field;
    },
    getLastEditableParameterField: function() {
        var field = null;
        var items = this.items.items;
        
        if ( !Ext.isEmpty( items ) ) {
            Ext.each( items, function( item, index, allItems ) {
                if ( this.isEditableParameterField( item ) ) {
                    field = item;
                }
            }, this );
        }

        return field;
    },
    getPreviousEditableParameterField: function( current ) {
        var field = null;
        var items = this.items.items;
        var currentFound = false;
        
        if ( !Ext.isEmpty( items ) ) {
            Ext.each( items, function( item, index, allItems ) {
                if ( item.isParameterField ) {
                    if ( item.getFieldId() == current.getFieldId() ) {
                    	currentFound = true;
                    	return false;
                    }
                    
                    if ( !item.isReadOnly() ) {
                    	field = item;
                    }
                } else if ( item.isTableField || item.isRow ) {
                	item.items.each( function( panel ) {
                		var fieldInLine = panel.items.first();
                		
                        if ( fieldInLine.isParameterField ) {
                            if ( fieldInLine.getFieldId() == current.getFieldId() ) {
                            	currentFound = true;
                            	return false;
                            }
                            
                            if ( !fieldInLine.isReadOnly() ) {
                            	field = fieldInLine;
                            }
                        }
                	} );
                } else if ( item.isFieldSet ) {
                	var panel = item.items.first();
                	field = panel.getPreviousEditableParameterField( current );
                	
                	if ( !Ext.isEmpty( field ) ) {
                		currentFound = true;
                    	return false;
                	}
                }
            }, this );
            
            if ( this.initialConfig.isRow && !currentFound ) {
            	var owner = this.ownerCt;
            	field = owner.getPreviousEditableParameterField( current );
            }
        }

        return field;
    },
    getNextEditableParameterField: function( current ) {
        var field = null;
        var items = this.items.items;
        var currentFound = false;
        
        if ( !Ext.isEmpty( items ) ) {
            Ext.each( items, function( item, index, allItems ) {
                if ( item.isParameterField ) {
                	if ( currentFound && !item.isReadOnly() ) {
                		field = item;
                		return false;
                	}
                    
                    if ( !currentFound && item.getFieldId() == current.getFieldId() ) {
                    	currentFound = true;
                    }
                } else if ( item.isTableField || item.isRow ) {
                	item.items.each( function( panel ) {
                		var fieldInLine = panel.items.first();
                		
                        if ( fieldInLine.isParameterField ) {
                        	if ( currentFound && !fieldInLine.isReadOnly() ) {
                        		field = fieldInLine;
                        		return false;
                        	}
                            
                            if ( !currentFound && fieldInLine.getFieldId() == current.getFieldId() ) {
                            	currentFound = true;
                            }
                        }
                	} );
                } else if ( item.isFieldSet ) {
                	var panel = item.items.first();
                	field = panel.getNextEditableParameterField( current );
                	
                	if ( !Ext.isEmpty( field ) ) {
                		currentFound = true;
                    	return false;
                	}
                }
            } );
            
            if ( this.initialConfig.isRow && !currentFound ) {
            	var owner = this.ownerCt;
            	field = owner.getNextEditableParameterField( current );
            }
        }

        return field;
    },
    onConditionalExecutionCheck: function( field, checked ) {
        if ( checked ) {
            this.conditionItem.show();
            this.negationItem.show();
        } else {
            this.conditionItem.hide();
            this.negationItem.hide();
        }
    },
    onErrorHandlingTypeSelect: function( combo, record, index ) {
    	var type = combo.getValue();
    	
    	if ( !Ext.isEmpty( type ) && combo.isValid() ) {
    		this.handleErrorHandlingType( combo, {
    			type: type
    		} );
    	}
    },
    handleErrorHandlingType: function( typeItem, errorHandling ) {
    	this.removeErrorHandlingFields();
		var position = this.items.indexOf( typeItem );
		var items = this.buildErrorHandlingAdditionalItems( errorHandling, {
			processNode: this.initialConfig.processNode,
			systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
			onFieldEnterTask: this.initialConfig.onFieldEnterTask,
		 	contextVariables: this.initialConfig.contextVariables
		} );

		Ext.each( items, function( item, index, allItems ) {
			this.insert( position + 1 + index, item );
		}, this );
		
		this.doLayout();
    },
    buildErrorHandlingAdditionalItems: function( errorHandling, config ) {
    	var processNode = config.processNode;
    	var availableVariables = config.availableVariables;
      var missingVariablesValidatorFunction = config.missingVariablesValidatorFunction;
      var missingVariablesValidatorScope = config.missingVariablesValidatorScope;
		var systemFunctionsAccessibility = config.systemFunctionsAccessibility;
      var validateFieldFunction = config.validateFieldFunction;
      var validateFieldScope = config.validateFieldScope;
		var onFieldEnterTask = config.onFieldEnterTask;
		var contextVariables = config.contextVariables;
		var type = !Ext.isEmpty( errorHandling ) ? errorHandling.type : 'STOP';

    	var items = new Array();
    	items.push( new Ext.ux.suncode.CustomField( {
            name: getTranslation( 'Komentarz' ),
            description: getTranslation( 'Komentarz jaki zostanie dodany do zadania w przypadku błędu w zadaniu automatycznym. ' +
            		'Jeżeli zadanie automatyczne rozpoczyna proces, to komentarz nie zostanie dodany, ' +
            		'gdyż w przypadku błędu nie jest w ogóle tworzony proces.' ),
            type: this.STRING_FIELD_TYPE,
            processNode: processNode,
            optional: true,
            availableVariables: availableVariables,
            missingVariablesValidatorFunction: missingVariablesValidatorFunction,
            missingVariablesValidatorScope: missingVariablesValidatorScope,
            systemFunctionsAccessibility: systemFunctionsAccessibility,
            validateFieldFunction: validateFieldFunction,
            validateFieldScope: validateFieldScope,
            typeVisible: this.typesVisible,
            functionPrettyFormat: this.functionPrettyFormat,
            customValue: !Ext.isEmpty( errorHandling ) ? errorHandling.comment : undefined,
            ref: 'errorHandlingCommentItem'
        } ) );
    	items.push( new Ext.ux.suncode.CustomField( {
            name: getTranslation( 'Dodaj do komentarza informacje o błędzie' ),
            type: this.BOOLEAN_FIELD_TYPE,
            processNode: processNode,
            optional: true,
            availableVariables: availableVariables,
            missingVariablesValidatorFunction: missingVariablesValidatorFunction,
            missingVariablesValidatorScope: missingVariablesValidatorScope,
            systemFunctionsAccessibility: systemFunctionsAccessibility,
            validateFieldFunction: validateFieldFunction,
            validateFieldScope: validateFieldScope,
            typeVisible: this.typesVisible,
            functionPrettyFormat: this.functionPrettyFormat,
            customValue: !Ext.isEmpty( errorHandling ) ? errorHandling.addErrorToComment : undefined,
            ref: 'errorHandlingAddErrorToCommentItem'
        } ) );
    	
    	switch ( type ) {
			case 'STOP':
				items.push( new Ext.ux.suncode.CustomField( {
	                name: getTranslation( 'Komunikat dla użytkownika' ),
	                description: getTranslation( 'Komunikat, jaki pojawi się użytkownikowi w przypadku błędu w zadaniu automatycznym. ' +
	                        'Komunikat ten jest obsługiwany tylko w przypadku, gdy poprzedzające zadanie ręczne nie jest akceptowane równolegle.'),
	                type: this.STRING_FIELD_TYPE,
	                processNode: processNode,
	                optional: true,
	                availableVariables: availableVariables,
                  missingVariablesValidatorFunction: missingVariablesValidatorFunction,
                  missingVariablesValidatorScope: missingVariablesValidatorScope,
	                systemFunctionsAccessibility: systemFunctionsAccessibility,
                  validateFieldFunction: validateFieldFunction,
                  validateFieldScope: validateFieldScope,
	                typeVisible: this.typesVisible,
                  functionPrettyFormat: this.functionPrettyFormat,
	                customValue: !Ext.isEmpty( errorHandling ) ? errorHandling.userMessage : undefined,
	                ref: 'errorHandlingStatementForUserItem'
	            } ) );
				break;
			case 'CONTINUE':
				items.push( new Ext.ux.suncode.TableCustomField( {
    				fieldLabel: addTooltipToField( getTranslation( 'Przypisanie zmiennych' ),
    						getTranslation( 'Ustawienie zmiennych podanymi wartościami w przypadku błędu w zadaniu automatycznym. ' +
    								'Wszystkie wartości muszą być podane jako wartości tekstowe, dlatego dla zmiennych nietabelarycznych ' +
    								'z typem innym niż tekstowy należy skorzystać z funkcji toString. ' +
    								'Jeżeli dla zmiennej tabelarycznej chcemy przypisać kilka wartości, to muszą być one rozdzielone średnikiem.' +
    								'Można wtedy również skorzystać z funkcji join(tabela, ;).' ) ),
    	    	    fields: [ new Ext.ux.suncode.ArrayCustomField( {
                		name: getTranslation( 'Nazwa zmiennej' ),
                		isParameterField: true,
                		optional: true,
                    arrayMinLength: 0,
             	        customValues: ( !Ext.isEmpty( errorHandling ) && !Ext.isEmpty( errorHandling.setters ) ) ?
             	        		errorHandling.setters.variables : undefined,
                	    customFieldDef: {
                	    	type: this.VARIABLE_FIELD_TYPE,
                	    	processNode: processNode,
                	        onEnterTask: onFieldEnterTask,
                	        optional: true,
                	        availableVariables: availableVariables,
                          validateFieldFunction: validateFieldFunction,
                          validateFieldScope: validateFieldScope,
                          missingVariablesValidatorFunction: missingVariablesValidatorFunction,
                          missingVariablesValidatorScope: missingVariablesValidatorScope,
                          typeVisible: this.typesVisible,
                          functionPrettyFormat: this.functionPrettyFormat
                	    },
                	    ref: '../errorHandlingSettersVariableNameItem'
                	} ), new Ext.ux.suncode.ArrayCustomField( {
                		name: getTranslation( 'Wartość zmiennej' ),
                		isParameterField: true,
                		optional: true,
                    arrayMinLength: 0,
                		customValues: ( !Ext.isEmpty( errorHandling ) && !Ext.isEmpty( errorHandling.setters ) ) ?
             	        		errorHandling.setters.values : undefined,
                	    customFieldDef: {
                	    	type: this.STRING_FIELD_TYPE,
                	    	processNode: processNode,
                	        onEnterTask: onFieldEnterTask,
                	        contextVariables: contextVariables,
                	        optional: true,
                	        availableVariables: availableVariables,
                          missingVariablesValidatorFunction: missingVariablesValidatorFunction,
                          missingVariablesValidatorScope: missingVariablesValidatorScope,
            	            systemFunctionsAccessibility: systemFunctionsAccessibility,
                          validateFieldFunction: validateFieldFunction,
                          validateFieldScope: validateFieldScope,
            	            typeVisible: this.typesVisible,
                          functionPrettyFormat: this.functionPrettyFormat
                	    },
                	    ref: '../errorHandlingSettersVariableValueItem'
                	} ) ],
                	ref: 'errorHandlingSettersItem'
    	    	} ) );
				break;
			default:
				break;
		}
    	
    	return items;
    },
    removeErrorHandlingFields: function() {
    	var fields = [ this.errorHandlingCommentItem, this.errorHandlingAddErrorToCommentItem,
    	               this.errorHandlingStatementForUserItem, this.errorHandlingSettersItem ];
    	
    	Ext.each( fields, function( field, index, allFields ) {
    		this.removeErrorHandlingField( field );
    	}, this );
    	
    	this.doLayout();
    },
    removeErrorHandlingField: function( field ) {
    	if ( !Ext.isEmpty( field ) ) {
    		this.remove( field );
    	}
    },
    onAddEventType: function( button, e ) {
      var addEventTypeFunction = this.initialConfig.addEventTypeFunction;

      if ( Ext.isFunction( addEventTypeFunction ) ) {
        var addEventTypeScope = !Ext.isEmpty( this.initialConfig.addEventTypeScope ) ? this.initialConfig.addEventTypeScope : window;
        var eventType = button.eventType;
        var eventTypesTag = this.initialConfig.eventTypesTag;
        addEventTypeFunction.apply( addEventTypeScope, [ eventType, eventTypesTag ] );
      }
    },
    getParametersValues: function( options ) {
        if ( this.isFormValid( options ) ) {
            return this.getParametersValuesWithoutValidation();
        } else {
            return null;
        }
    },
    getParametersValuesWithoutValidation: function() {
      var values = new Object();

      Ext.each( this.items.items, function( item, index, items ) {
        if ( item.isParameterField ) {
          var id = item.getFieldId();
          var value = item.getFieldValue();

          values[id] = value;
        } else if ( item.isTableField || item.isRow ) {
          values = Ext.apply( values, item.getParametersValues() );
        } else if ( item.isRowWrapper ) {
          var wrappedItem = item.items.first();

          if ( wrappedItem.isParameterField ) {
            var id = wrappedItem.getFieldId();
            var value = wrappedItem.getFieldValue();

            values[id] = value;
          }
        } else if ( item.isFieldSet ) {
          var panel = item.items.first();
          values = Ext.apply( values, panel.getParametersValuesWithoutValidation() );
        }
      } );

      return values;
    },
    getParametersValuesAsArray: function( options ) {
      var skipValidation = Ext.isObject( options ) ? options.skipValidation : false;

    	if ( skipValidation || this.isFormValid( options ) ) {
	    	return this.getParametersValuesAsArrayWithoutValidation();
    	} else {
    		return null;
    	}
    },
    getParametersValuesAsArrayWithoutValidation: function() {
      var values = new Array();

      Ext.each( this.items.items, function( item, index, items ) {
        if ( item.isParameterField ) {
          values.push( item.getFieldValue() );
        } else if ( item.isTableField || item.isRow ) {
          values = values.concat( item.getParametersValuesAsArray() );
        } else if ( item.isRowWrapper ) {
          var wrappedItem = item.items.first();

          if ( wrappedItem.isParameterField ) {
            values.push( wrappedItem.getFieldValue() );
          }
        } else if ( item.isFieldSet ) {
          var panel = item.items.first();
          values = values.concat( panel.getParametersValuesAsArrayWithoutValidation() );
        }
      } );

      return values;
    },
    getExtraConfig: function() {
    	return {
    		customDescription: this.getCustomDescription(),
    		confirmation: this.getConfirmationConfiguration(),
    		error: this.getErrorConfiguration(),
    		errorHandling: this.getErrorHandling(),
    		dtButtons: this.getDtButtons(),
    		inactive: this.getInactive()
    	};
    },
    getCustomDescription: function() {
    	if ( this.initialConfig.customDescriptionEnabled ) {
    		return this.customDescriptionItem.getValue();
    	}
    	
    	return null;
    },
    getConfirmationConfiguration: function() {
    	if ( this.initialConfig.confirmationConfigurationEnabled ) {
            return {
            	title: this.confirmationTitleItem.getFieldValue(),
            	message: this.confirmationMessageItem.getFieldValue()
            };
        }

        return null;
    },
    getErrorConfiguration: function() {
    	if ( this.initialConfig.errorConfigurationEnabled ) {
            return {
            	message: this.errorMessageItem.getFieldValue()
            };
        }

        return null;
    },
    getErrorHandling: function() {
    	if ( this.initialConfig.errorHandlingEnabled ) {
    		var type = this.errorHandlingTypeItem.getValue();
    		
    		switch ( type ) {
				case 'STOP':
					return {
						type: type,
						comment: this.errorHandlingCommentItem.getFieldValue(),
						addErrorToComment: this.errorHandlingAddErrorToCommentItem.getFieldValue(),
						userMessage: this.errorHandlingStatementForUserItem.getFieldValue()
		            };
				case 'CONTINUE':
					var settersItem = this.errorHandlingSettersItem;
					
					return {
						type: type,
						comment: this.errorHandlingCommentItem.getFieldValue(),
						addErrorToComment: this.errorHandlingAddErrorToCommentItem.getFieldValue(),
						setters: {
							variables: settersItem.errorHandlingSettersVariableNameItem.getFieldValue(),
							values: settersItem.errorHandlingSettersVariableValueItem.getFieldValue()
						}
		            };
				default:
					return null;
			}
        }

        return null;
    },
    getDtButtons: function() {
    	if ( Ext.isArray( this.initialConfig.dtButtons ) ) {
	    	var dtButtons = new Array();
	    	var store = this.dtButtonsItem.getStore();
			
			store.each( function( record ) {
				dtButtons.push( {
          id: record.get( 'id' ),
					name: record.get( 'name' ),
					icon: record.get( 'icon' ),
					tooltip: record.get( 'tooltip' ),
					disabled: record.get( 'disabled' )
				} );
			} );
	    	
	    	return dtButtons
    	} else {
    		return null;
    	}
    },
    getInactive: function() {
    	if ( this.initialConfig.inactiveEnabled ) {
    		return this.inactiveItem.getValue();
    	} else {
    		return false;
    	}
    },
    isFormValid: function( options ) {
        var valid = true;
        var conditionValidationResult = this.validateCondition();

        if ( conditionValidationResult.valid === false ) {
        	  this.conditionItem.markError();
            showWarn( conditionValidationResult.errorMessage );
            valid = false;
        } else if ( !this.areDtButtonsValid() ) {
        	  showWarn( getTranslation( 'Określ przyciski tabeli dynamicznej.' ) );
            valid = false;
        } else {
            valid = this.validateFormItems( this );
        }
        
        var customForm = this.initialConfig.customForm;
        var validateFormFunction = customForm.validateForm;
        
        if ( valid && Ext.isFunction( validateFormFunction ) ) {
        	var api = this.getValidationApi();
        	var validationResult = validateFormFunction.apply( window, [ api ] );

        	if ( Ext.isObject( validationResult ) ) {
        	  if ( validationResult.confirm === true ) {
        	    var title = !Ext.isEmpty( validationResult.title ) ?
                  validationResult.title : getTranslation( 'Uwaga' );

              Ext.Msg.show( {
                title: '<font color="#E16E6E" weight="bold">' + title + '</font>',
                msg: validationResult.message,
                buttons: {
                  yes: getTranslation( 'Tak' ),
                  no: getTranslation( 'Nie' )
                },
                fn: function( buttonId ) {
                  if ( buttonId == 'yes' && !Ext.isEmpty( options ) ) {
                    var callbackFunction = options.callbackFunction;

                    if ( Ext.isFunction( callbackFunction ) ) {
                      var values = this.getParametersValuesWithoutValidation();
                      var callbackScope = !Ext.isEmpty( options.callbackScope ) ? options.callbackScope : window;
                      var callbackParameters = !Ext.isEmpty( options.callbackParameters ) ? options.callbackParameters : [];
                      callbackParameters.push( values );

                      callbackFunction.apply( callbackScope, callbackParameters );
                    }
                  }
                },
                icon: Ext.Msg.QUESTION,
                scope: this
              } );

              valid = false;
            }
          }
        	
        	if ( validationResult === false ) {
        		valid = false;
        	}
        }

        return valid;
    },
    validateCondition: function() {
      if ( this.initialConfig.conditionalExecutionEnabled && this.conditionalExecutionItem.getValue() ) {
        var result = this.conditionItem.validateField();

        if ( result.valid ) {
          var conditionItem = this.conditionItem;
          var condition = conditionItem.getFieldValue();
          var mainPanel = Ext.getCmp( 'main_panel' );
          var systemFunction = mainPanel.getSystemFunction( condition.value.name, condition.value.parameterTypes );

          if ( !Ext.isEmpty( systemFunction ) && systemFunction.returnType !== this.BOOLEAN_FIELD_TYPE ) {
            return {
              valid: false,
              errorMessage: getTranslation( 'Warunek wykorzystuje funkcję zwracającą typ inny niż logiczny.' )
            };
          }
        }

        return result;
      } else {
        return {
          valid: true
        };
      }
    },
    areDtButtonsValid: function() {
    	if ( Ext.isArray( this.initialConfig.dtButtons ) ) {
    		var valid = true;
    		var store = this.dtButtonsItem.getStore();
    		
    		store.each( function( record ) {
          var id = record.get( 'id' );
    			var name = record.get( 'name' );
    			var icon = record.get( 'icon' );
    			
    			if ( Ext.isEmpty( id ) || ( Ext.isEmpty( name ) && Ext.isEmpty( icon ) ) ) {
    				valid = false;
    			}
    		} );
    		
    		return valid;
    	} else {
    		return true;
    	}
    },
    validateFormItems: function( form ) {
      var valid = true;

      Ext.each( form.items.items, function( customField, index, customFields ) {
        if ( customField.isParameterField ) {
          var validationResult = customField.validateField();

          if ( validationResult.valid === false ) {
            if ( !validationResult.preventGlobalMarkError ) {
              customField.markError();
            }

            showWarn( validationResult.errorMessage );
            valid = false;
            return false;
          }
        } else if ( customField.isTableField ) {
          var validationResult = customField.validateField();

          if ( validationResult.valid === false ) {
            valid = false;
            return false;
          }
        } else if ( customField.isFieldSet ) {
          var panel = customField.items.first();

          if ( !panel.validateFormItems( panel ) ) {
            valid = false;
            return false;
          }
        }
      } );

      return valid;
    },
    getCondition: function() {
        if ( this.initialConfig.conditionalExecutionEnabled && this.conditionalExecutionItem.getValue() ) {
            var conditionItem = this.conditionItem;
            var condition = conditionItem.getFieldValue();
            var negation = this.negationItem.getValue();

            if ( negation ) {
                condition = {
                    type: this.FUNCTION_FIELD_TYPE,
                    value: {
                        name: this.NEGATION_FUNCTION_NAME,
                        parameters: [ condition ],
                        parameterTypes: this.NEGATION_FUNCTION_PARAMETER_TYPES
                    }
                };
            }

            return condition;
        }

        return null;
    },
    areTypesVisible: function() {
    	return this.typesVisible;
    },
    showTypes: function() {
        this.toggleTypesVisibility( true );
    },
    hideTypes: function() {
        this.toggleTypesVisibility( false );
    },
    toggleTypesVisibility: function( visible ) {
    	this.typesVisible = visible;
    	
    	Ext.each( this.items.items, function( item, index, items ) {
    		var func = visible ? item.showType : item.hideType;
    		
    		if ( item.isRow ) {
    			item.toggleTypesVisibility( visible );
    		} else if ( item.isRowWrapper ) {
            	var wrappedItem = item.items.first();
            	var wrappedItemFunc = visible ? wrappedItem.showType : wrappedItem.hideType;
            	
            	if ( Ext.isFunction( wrappedItemFunc ) ) {
            		wrappedItemFunc.apply( wrappedItem, [] );
            	}
            } else if ( item.isFieldSet ) {
            	var panel = item.items.first();
            	panel.toggleTypesVisibility( visible );
            } else if ( Ext.isFunction( func ) ) {
    			func.apply( item, [] );
    		}
        } );
    },
    areFunctionsPrettyFormatted: function() {
      return this.functionPrettyFormat;
    },
    switchOnFunctionPrettyFormat: function() {
      this.toggleFunctionPrettyFormat( true );
    },
    switchOffFunctionPrettyFormat: function() {
      this.toggleFunctionPrettyFormat( false );
    },
    toggleFunctionPrettyFormat: function( prettyFormat ) {
      this.functionPrettyFormat = prettyFormat;

      Ext.each( this.items.items, function( item, index, items ) {
        var func = prettyFormat ? item.prettyFormatFunction : item.unformatFunction;

        if ( item.isRow ) {
          item.toggleFunctionPrettyFormat( prettyFormat );
        } else if ( item.isRowWrapper ) {
          var wrappedItem = item.items.first();
          var wrappedItemFunc = prettyFormat ? wrappedItem.prettyFormatFunction : wrappedItem.unformatFunction;

          if ( Ext.isFunction( wrappedItemFunc ) ) {
            wrappedItemFunc.apply( wrappedItem, [] );
          }
        } else if ( item.isFieldSet ) {
          var panel = item.items.first();
          panel.toggleFunctionPrettyFormat( visible );
        } else if ( Ext.isFunction( func ) ) {
          func.apply( item, [] );
        }
      } );
    },
    updateCustomFormConfig: function() {
    	var mainPanel = Ext.getCmp( 'main_panel' );
    	mainPanel.setCustomFormConfig( this.getCustomFormConfig() );
    },
    getCustomFormConfig: function() {
    	return {
    		typesVisible: this.typesVisible,
        functionPrettyFormat: this.functionPrettyFormat
    	};
    },
    getFieldDefinition: function( fieldId ) {
    	var field = null;
    	var customForm = this.initialConfig.customForm;
    	
    	Ext.each( customForm.fields, function( customFormField, index, customFormFields ) {
    		if ( customFormField.id === fieldId ) {
    			field = customFormField;
    			return false;
    		}
        } );
    	
    	return field;
    },
    buildField: function( customForm, customFormField, extraConfig ) {
    	var processNode = extraConfig.processNode;
    	var bindTo = extraConfig.bindTo;
    	var onFieldEnterTask = extraConfig.onFieldEnterTask;
    	var contextVariables = extraConfig.contextVariables;
    	var name = Ext.isDefined( extraConfig.name ) ? extraConfig.name : customFormField.name;
    	var description = Ext.isDefined( extraConfig.description ) ? extraConfig.description : customFormField.description;
    	var optional = Ext.isDefined( extraConfig.optional ) ? extraConfig.optional : customFormField.optional;
    	var notEmpty = Ext.isDefined( extraConfig.notEmpty ) ? extraConfig.notEmpty : false;
      var arrayMinLength = this.buildArrayMinLength( extraConfig.arrayMinLength, customFormField.arrayMinLength );
    	var hidden = extraConfig.hidden;
      var disabled = extraConfig.disabled;
    	var readOnly = extraConfig.readOnly;
    	var hideLabel = extraConfig.hideLabel;
      var onAfterRenderFunction = extraConfig.onAfterRender;
    	var onChangeFunction = extraConfig.onChange;
    	var onBlurFunction = extraConfig.onBlur;
    	var onSelectFunction = extraConfig.onSelect;
    	var onAddFieldFunction = extraConfig.onAddField;
    	var binded = ( !Ext.isEmpty( bindTo ) && bindTo.id === customFormField.id );
    	var array = customFormField.array || extraConfig.isArrayCombobox;
    	var defaultValue = binded ? this.buildFieldBindedCustomValue( array, bindTo.value ) :
    		this.buildFieldDefaultValue( customForm, customFormField, extraConfig );
    	var isCombobox = extraConfig.isCombobox || extraConfig.isArrayCombobox;
    	var values = Ext.isDefined( extraConfig.values ) ? extraConfig.values : new Array();
    	var comboboxConfig = extraConfig.comboboxConfig;
    	var isParameterField = extraConfig.isParameterField;
    	var typeVisible = extraConfig.typesVisible;
      var functionPrettyFormat = extraConfig.functionPrettyFormat;
    	var tableVariableAllowed = extraConfig.tableVariableAllowed;
    	var columnCheckboxEnabled = extraConfig.columnCheckboxEnabled;
    	var isColorPicker = extraConfig.isColorPicker;
    	var disableVariableDuplication = Ext.isDefined( extraConfig.disableVariableDuplication ) ?
    			extraConfig.disableVariableDuplication : false;
    	var availableVariables = extraConfig.availableVariables;
      var systemFunctionsAccessibility = extraConfig.systemFunctionsAccessibility;
      var missingVariablesValidatorFunction = extraConfig.missingVariablesValidatorFunction;
      var missingVariablesValidatorScope = extraConfig.missingVariablesValidatorScope;
      var validateFieldFunction = extraConfig.validateFieldFunction;
      var validateFieldScope = extraConfig.validateFieldScope;
    	var previousWindow = extraConfig.previousWindow;
    	
        return array ? new Ext.ux.suncode.ArrayCustomField( {
            fieldId: customFormField.id,
            name: name,
            description: description,
            hidden: hidden,
            disabled: disabled,
            hideLabel: hideLabel,
            notEmpty: notEmpty,
            optional: optional,
            arrayMinLength: arrayMinLength,
            isParameterField: isParameterField,
            binded: binded,
            customValues: defaultValue,
            onAddFieldFunction: onAddFieldFunction,
            customFieldDef: {
                type: customFormField.type,
                processNode: processNode,
                onEnterTask: onFieldEnterTask,
                binded: binded,
                contextVariables: contextVariables,
                optional: optional,
                notEmpty: notEmpty,
                readOnly: readOnly,
                disableVariableDuplication: disableVariableDuplication,
                onAfterRenderFunction: onAfterRenderFunction,
                onChangeFunction: onChangeFunction,
                onBlurFunction: onBlurFunction,
                onSelectFunction: onSelectFunction,
                isCombobox: isCombobox,
                values: values,
                comboboxConfig: comboboxConfig,
                availableVariables: availableVariables,
                missingVariablesValidatorFunction: missingVariablesValidatorFunction,
                missingVariablesValidatorScope: missingVariablesValidatorScope,
                systemFunctionsAccessibility: systemFunctionsAccessibility,
                validateFieldFunction: validateFieldFunction,
                validateFieldScope: validateFieldScope,
                recommendedSystemFunctions: customFormField.recommendedFunctions,
                typeVisible: typeVisible,
                functionPrettyFormat: functionPrettyFormat,
                columnCheckboxEnabled: columnCheckboxEnabled,
                isColorPicker: isColorPicker,
                previousWindow: previousWindow
            }
        } ) : new Ext.ux.suncode.CustomField( {
            fieldId: customFormField.id,
            name: name,
            description: description,
            type: customFormField.type,
            hidden: hidden,
            disabled: disabled,
            readOnly: readOnly,
            hideLabel: hideLabel,
            disableVariableDuplication: disableVariableDuplication,
            isParameterField: isParameterField,
            processNode: processNode,
            onEnterTask: onFieldEnterTask,
            binded: binded,
            contextVariables: contextVariables,
            optional: optional,
            notEmpty: notEmpty,
            onAfterRenderFunction: onAfterRenderFunction,
            onChangeFunction: onChangeFunction,
            onBlurFunction: onBlurFunction,
            onSelectFunction: onSelectFunction,
            isCombobox: isCombobox,
            comboboxConfig: comboboxConfig,
            availableVariables: availableVariables,
            missingVariablesValidatorFunction: missingVariablesValidatorFunction,
            missingVariablesValidatorScope: missingVariablesValidatorScope,
            systemFunctionsAccessibility: systemFunctionsAccessibility,
            validateFieldFunction: validateFieldFunction,
            validateFieldScope: validateFieldScope,
            recommendedSystemFunctions: customFormField.recommendedFunctions,
            typeVisible: typeVisible,
            functionPrettyFormat: functionPrettyFormat,
            tableVariableAllowed: tableVariableAllowed,
            isColorPicker: isColorPicker,
            previousWindow: previousWindow,
            customValue: defaultValue
        } );
    },
    buildArrayMinLength: function( extraConfigArrayMinLength, customFormFieldArrayMinLength ) {
      if ( Ext.isNumber( extraConfigArrayMinLength ) ) {
        return extraConfigArrayMinLength;
      } else if ( Ext.isNumber( customFormFieldArrayMinLength ) ) {
        return customFormFieldArrayMinLength;
      } else {
        return 0;
      }
    },
    buildFieldBindedCustomValue: function( array, value ) {
    	if ( array ) {
			var customValue = new Array();
			customValue.push( {
	            type: 'variable',
	            value: value
	        } );
			
			return customValue;
		} else {
			return {
	            type: 'variable',
	            value: value
	        };
		}
    },
    buildFieldDefaultValue: function( customForm, customFormField, extraConfig ) {
    	var fieldId = customFormField.id;
    	
    	if ( !Ext.isEmpty( customForm.values ) && Ext.isDefined( customForm.values[fieldId] ) ) {
    		var value = customForm.values[fieldId];
    		
    		if ( extraConfig.isColorPicker && !Ext.isEmpty( value.value ) && !value.value.startsWith( '#' ) ) {
    			Ext.apply( value, {
    				value: '#' + value.value
    			} );
    		}
    		
    		return value;
        } else if ( this.isMeaningfulValue( extraConfig.value ) ) {
        	return this.buildFieldCustomValue( customFormField, extraConfig.value );
        } else if ( this.isMeaningfulValue( customFormField.defaultValue ) ) {
        	return this.buildFieldCustomValue( customFormField, customFormField.defaultValue );
        } else {
        	return undefined;
        }
    },
    isMeaningfulValue: function( value ) {
    	return ( Ext.isDefined( value ) && value != null );
    },
    buildFieldCustomValue: function( customFormField, value ) {
    	if ( Ext.isArray( value ) ) {
			var customValue = new Array();
			
			Ext.each( value, function( subValue, index, subValues ) {
				customValue.push( {
					type: customFormField.type,
                    value: subValue
                } );
			} );
			
			return customValue;
		} else {
			return {
				type: customFormField.type,
                value: value
			};
		}
    },
    recalculateTableWidths: function() {
      var me = this;

      window.setTimeout( function() {
        Ext.each( me.items.items, function( item, index, items ) {
          if ( item.isTableField ) {
            item.recalculateWidths();

            window.setTimeout( function() {
              item.previewHeightAdjustmentBlocked = false;
              item.adjustPreviewHeights();
            }, 100 );
          }
        } );
      }, 100 );
    },
    getField: function( fieldId ) {
    	var field = null;
    	
    	if ( !Ext.isEmpty( fieldId ) ) {
    		Ext.each( this.items.items, function( item, index, items ) {
                if ( item.isParameterField && item.getFieldId() === fieldId ) {
                	field = item;
                    return false;
                } else if ( item.isTableField ) {
                	if ( item.getFieldId() === fieldId ) {
                		field = item;
                        return false;
                	} else {
                		field = item.getField( fieldId );
                    	
                    	if ( !Ext.isEmpty( field ) ) {
                    		return false;
                    	}
                	}
                } else if ( this.initialConfig.isRow ) {
                	if ( this.initialConfig.rowId === fieldId ) {
                		field = item;
                        return false;
                	} else {
                		Ext.each( this.items.items, function( wrapper, wrapperIndex, wrappers ) {
                			var firstItem = wrapper.items.first();
                			
                			if ( firstItem.isParameterField && firstItem.getFieldId() === fieldId ) {
                				field = firstItem;
                                return false;
                			}
                		} );
                		
                		if ( !Ext.isEmpty( field ) ) {
                            return false;
                		}
                	}
                } else if ( item.isFieldSet ) {
                	if ( item.getFieldId() === fieldId ) {
                		field = item;
                        return false;
                	} else {
                		var panel = item.items.first();
                    	field = panel.getField( fieldId );
                		
                		if ( !Ext.isEmpty( field ) ) {
                            return false;
                		}
                	}
                } else if ( Ext.isFunction( item.getFieldId ) && item.getFieldId() === fieldId ) {
                	field = item;
                    return false;
                }
            }, this );
    		
    		if ( this.initialConfig.isRow && Ext.isEmpty( field ) ) {
    			var owner = this.ownerCt;
    			field = owner.getField( fieldId );
    		}
    	}
    	
    	return field;
    },
    bindPreviousNextOnInsert: function( field ) {
    	var previous = this.getPreviousEditableParameterField( field );
		var next = this.getNextEditableParameterField( field );
		
		if ( !Ext.isEmpty( previous ) ) {
			field = Ext.apply( field, {
				previous: previous
            } );
			previous = Ext.apply( previous, {
                next: field
            } );
		}
		
		if ( !Ext.isEmpty( next ) ) {
			field = Ext.apply( field, {
				next: next
            } );
			next = Ext.apply( next, {
				previous: field
            } );
		}
    },
    bindPreviousNextOnRemoval: function( field ) {
    	var previous = this.getPreviousEditableParameterField( field );
		var next = this.getNextEditableParameterField( field );
		
		if ( !Ext.isEmpty( previous ) ) {
			previous = Ext.apply( previous, {
                next: next
            } );
		}
		
		if ( !Ext.isEmpty( next ) ) {
			next = Ext.apply( next, {
				previous: previous
            } );
		}
    },
    bindPreviousNextOnShow: function( field ) {
    	var previous = this.getPreviousEditableParameterField( field );
		var next = this.getNextEditableParameterField( field );
		
		if ( !Ext.isEmpty( previous ) ) {
			previous = Ext.apply( previous, {
                next: field
            } );
		}
		
		if ( !Ext.isEmpty( next ) ) {
			next = Ext.apply( next, {
				previous: field
            } );
		}
    },
    bindPreviousNextOnHide: function( field ) {
    	this.bindPreviousNextOnRemoval( field );
    },
    addField: function( definition ) {
    	this.insertField( this.items.getCount(), definition );
    },
    insertField: function( position, definition ) {
    	var customFormField = null;
    	var isObjectDef = false;
    	var fieldId = null;
    	var isParameterField = false;
    	
    	if ( Ext.isString( definition ) ) {
    		customFormField = this.getFieldDefinition( definition );
    		fieldId = definition;
    	} else if ( Ext.isObject( definition ) && !Ext.isEmpty( definition.id ) ) {
    		customFormField = this.getFieldDefinition( definition.id );
    		isObjectDef = true;
    		fieldId = definition.id;
    	}
    	
    	var field = this.getField( fieldId );
    	
    	if ( Ext.isEmpty( customFormField ) ) {
    		customFormField = this.initCustomFormField( definition );
    	} else {
    		isParameterField = true;
    	}
		
    	if ( Ext.isEmpty( field ) ) {
    		this.insertFieldFromCustomFromField( position, customFormField, {
    			isParameterField: isParameterField,
    			name: isObjectDef && Ext.isDefined( definition.name ) ? definition.name : customFormField.name,
    			description: isObjectDef && Ext.isDefined( definition.description ) ? definition.description :
    				customFormField.description,
            	optional: isObjectDef && Ext.isDefined( definition.optional ) ? definition.optional : customFormField.optional,
            	notEmpty: isObjectDef && Ext.isDefined( definition.notEmpty ) ? definition.notEmpty : false,
            	hidden: isObjectDef ? definition.hidden : false,
              disabled: isObjectDef ? definition.disabled : false,
            	readOnly: isObjectDef ? definition.readOnly : false,
            	hideLabel: isObjectDef ? definition.hideLabel : false,
            	disableVariableDuplication: isObjectDef ? definition.disableVariableDuplication : false,
            	value: isObjectDef ? definition.value : null,
              onAfterRender: isObjectDef ? definition.onAfterRender : null,
            	onChange: isObjectDef ? definition.onChange : null,
            	onBlur: isObjectDef ? definition.onBlur : null,
            	onAddField: isObjectDef ? definition.onAddField : null
            } );
    	}
    },
    initCustomFormField: function( definition ) {
    	return {
    		id: definition.id,
			type: definition.type,
			name: definition.name,
			description: definition.description,
			array: definition.array
		};
    },
    insertFieldFromCustomFromField: function( position, customFormField, extraConfig ) {
    	extraConfig = Ext.apply( extraConfig, {
    		processNode: this.initialConfig.processNode,
        	bindTo: this.initialConfig.bindTo,
        	onFieldEnterTask: this.initialConfig.onFieldEnterTask,
        	contextVariables: this.initialConfig.contextVariables,
        	availableVariables: this.initialConfig.availableVariables,
          missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
          missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
        	systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
          validateFieldFunction: this.initialConfig.validateFieldFunction,
          validateFieldScope: this.initialConfig.validateFieldScope,
        	recommendedSystemFunctions: customFormField.recommendedFunctions,
        	typesVisible: this.typesVisible,
          functionPrettyFormat: this.functionPrettyFormat,
        	tableVariableAllowed: this.tableVariableAllowed,
        	columnCheckboxEnabled: this.columnCheckboxEnabled,
        	previousWindow: this.initialConfig.previousWindow
    	} );
    	var customForm = this.initialConfig.customForm;
		var field = this.buildField( customForm, customFormField, extraConfig );
		
		if ( this.initialConfig.isRow ) {
			this.insert( position, this.buildRowWrapper( position, field, false, extraConfig.hidden ) );
		} else {
			this.insert( position, field );
		}
		
		this.doLayout();
		this.bindPreviousNextOnInsert( field );
		
		return field;
    },
    removeField: function( fieldId ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) ) {
    		this.bindPreviousNextOnRemoval( field );
    		if ( !Ext.isEmpty( field.table ) ) {
    			field.table.remove( field.ownerCt );
    			field.table.recalculateWidths();
    		} else if ( !Ext.isEmpty( field.row ) ) {
    			field.row.remove( field.ownerCt );
    			field.row.doLayout();
    		} else {
    			this.remove( field );
    		}
    		this.doLayout();
    	}
    },
    showField: function( fieldId ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) ) {
    		this.bindPreviousNextOnShow( field );
        field.show();
    		if ( !Ext.isEmpty( field.table ) ) {
    			field.ownerCt.show();
          field.table.setMenuButtonsVisibility();
    			field.table.recalculateWidths();
          field.table.adjustPreviewHeights();
    		} else if ( !Ext.isEmpty( field.row ) && field.isArrayField ) {
    			field.ownerCt.show();
    			field.row.doLayout();
    		}
    		if ( Ext.isEmpty( field.row ) && field.isArrayField ) {
    			field.items.each( function( item ) {
    				item.show();
    			} );
    		}
    		if ( field.isTableField ) {
    			field.items.each( function( item ) {
    				item.doLayout();
    			} );
    			field.recalculateWidths();
    		}
    		if (field.isFieldSet) {
          field.doLayout();
        }
    	}
    },
    hideField: function( fieldId ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) ) {
    		this.bindPreviousNextOnHide( field );
    		if ( !Ext.isEmpty( field.table ) ) {
    			field.ownerCt.hide();
          field.table.setMenuButtonsVisibility();
          field.table.recalculateWidths();
          field.table.adjustPreviewHeights();
    		} else if ( !Ext.isEmpty( field.row ) && field.isArrayField ) {
    			field.ownerCt.hide();
    			field.row.doLayout();
    		}
    		field.hide();
    	}
    },
    focusField: function( fieldId ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) ) {
    		field.focusField();
    	}
    },
    addLabel: function( text ) {
    	this.insertLabel( this.items.getCount(), text );
    },
    insertLabel: function( position, text ) {
    	this.insert( position, {
            xtype: 'label',
            html: text
        } );
		this.doLayout();
    },
    addCheckbox: function( definition ) {
    	this.insertCheckbox( this.items.getCount(), definition );
    },
    insertCheckbox: function( position, definition ) {
    	if ( Ext.isObject( definition ) ) {
    		var field = this.getField( definition.id );
    		
    		if ( Ext.isEmpty( field ) ) {
    			this.insert( position, {
                    xtype: 'checkbox',
                    fieldId: definition.id,
                    fieldLabel: Ext.isEmpty( definition.description ) ? definition.text :
    					addTooltipToField( definition.text, definition.description ),
                    hideLabel: definition.hideLabel,
                    checked: this.buildCheckboxDefaultValue( definition.bindedFieldId ),
                    bindedFieldId: definition.bindedFieldId,
                    getFieldId: function() {
                    	return this.fieldId;
                    },
                    setFieldValue: function( value ) {
                    	this.setValue( value );
                    },
                    getSimpleFieldValue: function() {
                    	return this.getValue();
                    },
                    listeners: {
                    	scope: this,
                    	check: function( field, checked ) {
                    		this.handleCheckboxBindedField( definition.bindedFieldId, checked );

                    		var onChangeFunction = definition.onChange;
                    		
                    		if ( Ext.isFunction( onChangeFunction ) ) {
                    			onChangeFunction.apply( field, [ checked ] );
                    		}
                    	}
                    }
                } );
        		this.doLayout();
    		}
    	}
    },
    buildCheckboxDefaultValue: function( bindedFieldId ) {
    	var customForm = this.initialConfig.customForm;
    	
		if ( !Ext.isEmpty( bindedFieldId ) ) {
    		return ( !Ext.isEmpty( customForm.values ) && customForm.values[bindedFieldId] === true )
    			|| this.getFieldValue( bindedFieldId ) === true;
        } else {
        	return false;
        }
    },
    handleCheckboxBindedField: function( bindedFieldId, checked ) {
    	var field = this.getField( bindedFieldId );
    	
    	if ( !Ext.isEmpty( field ) && Ext.isFunction( field.isBooleanEditor ) && field.isBooleanEditor() ) {
    		field.setFieldValue( checked );
    	}
    },
    handleCheckboxBindedFields: function( fieldId, checked ) {
    	if ( !Ext.isEmpty( fieldId ) ) {
    		Ext.each( this.items.items, function( customField, index, customFields ) {
        		if ( customField.bindedFieldId === fieldId ) {
        			customField.setValue( checked );
        		}
            }, this );
    	}
    },
    addCombobox: function( definition ) {
    	return this.insertCombobox( this.items.getCount(), definition );
    },
    insertCombobox: function( position, definition ) {
    	if ( Ext.isObject( definition ) && !Ext.isEmpty( definition.id ) ) {
    		var customFormField = this.getFieldDefinition( definition.id );
    		var field = this.getField( definition.id );
    		var component = null;
    		
    		if ( !Ext.isEmpty( field ) ) {
    			return null;
			}
    		
    		if ( !Ext.isEmpty( customFormField ) && customFormField.type === Ext.ux.suncode.IntegrationComponentService.STRING_TYPE  ) {
    			return this.insertFieldFromCustomFromField( position, customFormField, {
    				isParameterField: true,
                	optional: Ext.isDefined( definition.optional ) ? definition.optional : customFormField.optional,
                	notEmpty: Ext.isDefined( definition.notEmpty ) ? definition.notEmpty : false,
                	hidden: definition.hidden,
                	readOnly: definition.readOnly,
                	hideLabel: definition.hideLabel,
                	disableVariableDuplication: definition.disableVariableDuplication,
                	value: definition.value,
                  onAfterRender: definition.onAfterRender,
                	onChange: definition.onChange,
                	onBlur: definition.onBlur,
                	onSelect: definition.onSelect,
                	onAddField: definition.onAddField,
                	isCombobox: true,
                	comboboxConfig: this.buildComboboxConfig( definition )
                } );
    		} else {
    			var combobox = definition.remote ? this.buildRemoteCombobox( definition ) : this.buildLocalCombobox( definition );
    			component = this.insert( position, combobox  );
        		this.doLayout();
        		
        		return component;
    		}
    	} else {
    		return null;
    	}
    },
    buildComboboxConfig: function( definition ) {
    	var values = Ext.isDefined( definition.values ) ? definition.values : new Array();
		var fields = Ext.isDefined( definition.fields ) ? definition.fields : new Array();
		var pageSize = ( Ext.isNumber( definition.pageSize ) && definition.pageSize > 0 ) ? definition.pageSize :
			this.DEFAULT_COMBOBOX_PAGE_SIZE;
		
		return {
    		remote: definition.remote,
    		values: values,
    		minChars: !Ext.isEmpty( definition.minChars ) ? definition.minChars : this.DEFAULT_COMBOBOX_MIN_CHARS,
    		forceSelection: !Ext.isEmpty( definition.forceSelection ) ? definition.forceSelection : true,
    		url: definition.url,
    		fields: fields,
    		valueField: definition.valueField,
        	displayField: definition.displayField,
        	remoteSort: definition.remoteSort,
        	pageSize: pageSize,
        	template: definition.template,
        	sort: definition.sort,
        	value: definition.value
    	};
    },
    buildRemoteCombobox: function( definition ) {
    	var fields = Ext.isDefined( definition.fields ) ? definition.fields : new Array();
		var pageSize = ( Ext.isNumber( definition.pageSize ) && definition.pageSize > 0 ) ? definition.pageSize :
			this.DEFAULT_COMBOBOX_PAGE_SIZE;
    	var record = Ext.data.Record.create( fields );
    	var store = new Ext.data.JsonStore( {
            proxy: new Ext.data.HttpProxy( {
                method: 'GET',
                url: Suncode.context( 'pwe' ).contextPath + '/' + definition.url
            } ),
            reader: new Ext.data.JsonReader( {
                fields: record
            } ),
            autoDestroy: true,
            batch: true,
            fields: record,
            root: 'data',
            totalProperty: 'total',
            baseParams: {
                start: 0,
                limit: pageSize
            },
            remoteSort: definition.remoteSort,
            sortInfo: definition.sort
        } );
    	
    	var combobox = {
    		xtype: 'combo',
            anchor: '100%',
            fieldId: definition.id,
            fieldLabel: this.buildComboboxLabel( definition.text, definition.description ),
            hideLabel: definition.hideLabel,
        	  triggerAction: 'all',
            mode: 'remote',
            minChars: !Ext.isEmpty( definition.minChars ) ? definition.minChars : this.DEFAULT_COMBOBOX_MIN_CHARS,
            store: store,
            valueField: definition.valueField,
            displayField: definition.displayField,
            forceSelection: !Ext.isEmpty( definition.forceSelection ) ? definition.forceSelection : true,
            resizable: true,
            minListWidth: this.COMBOBOX_MIN_LIST_WIDTH,
            pageSize: pageSize,
            value: definition.value,
            isCombobox: true,
            getFieldId: function() {
            	return this.fieldId;
            },
            focusField: function() {
            	this.focus();
            },
            setFieldValue: function( value ) {
            	this.setValue( value );
            },
            getSimpleFieldValue: function() {
            	return this.getValue();
            },
            listeners: {
              afterrender: function( combo ) {
                if ( definition.hidden ) {
                  var task = new Ext.util.DelayedTask( combo.hide );
                  task.delay( 1 );
                }
              },
              select: function( combo, record, index ) {
                var value = combo.getValue();
                var onChangeFunction = definition.onChange;
                var onSelectFunction = definition.onSelect;

                if ( Ext.isFunction( onChangeFunction ) ) {
                  onChangeFunction.apply( combo, [ value ] );
                }

                if ( Ext.isFunction( onSelectFunction ) ) {
                  onSelectFunction.apply( combo, [ value ] );
                }
              }
            }
        };
    	
    	if ( Ext.isArray( definition.template ) ) {
    		var tpl = '<tpl for="."><div class="x-Module-comboTemplateItem">';
    		
    		Ext.each( definition.template, function( item, index, items ) {
    			tpl += '<div><font ';
    			tpl += getTemplateStyle();
    			tpl += '><b>';
    			tpl += item.label;
    			tpl += ': ';
    			tpl += '</b></font><span>{';
    			tpl += item.field;
    			tpl += '}</span></div>';
    		} );
    		
    		tpl += '</div><tpl if="xindex !== xcount"><hr ';
    		tpl += getHRLineStyle();
    		tpl += '></tpl></tpl>';
    		
    		combobox = Ext.apply( combobox, {
                tpl: new Ext.XTemplate( tpl ).compile(),
                itemSelector: 'div.x-Module-comboTemplateItem'
        	} );
    	}
    	
    	return combobox;
    },
    buildLocalCombobox: function( definition ) {
    	var me = this;
    	
    	return {
            xtype: 'combo',
            anchor: '100%',
            fieldId: definition.id,
            fieldLabel: this.buildComboboxLabel( definition.text, definition.description ),
            hideLabel: definition.hideLabel,
            triggerAction: 'all',
			mode: 'local',
			minChars: !Ext.isEmpty( definition.minChars ) ? definition.minChars : this.DEFAULT_COMBOBOX_MIN_CHARS,
			store: new Ext.data.Store( {
				data: definition.values,
				reader: new Ext.data.JsonReader( {
					fields: Ext.data.Record.create( [ {
						name: 'id',
						type: 'string'
					}, {
						name: 'display',
						type: 'string'
					}, {
						name: 'description',
						type: 'string'
					} ] )
				} )
			} ),
			valueField: 'id',
			displayField: 'display',
			forceSelection: true,
			tpl: new Ext.XTemplate( '<tpl for=".">', '<div class="x-Module-comboTemplateItem">', '<div><font '
				+ getTemplateStyle() + '><b>' + getTranslation( 'Wartość' ) + ': '
				+ '</b></font><span>{display}</span></div>', '<div><font ' + getTemplateStyle() + '><b>'
				+ getTranslation( 'Opis' ) + ': ' + '</b></font><span>{description}</span></div></div>',
				'<tpl if="xindex !== xcount">', '<hr ' + getHRLineStyle() + '>', '</tpl>', '</tpl>' ).compile(),
			itemSelector: 'div.x-Module-comboTemplateItem',
			resizable: true,
			minListWidth: this.COMBOBOX_MIN_LIST_WIDTH,
			value: definition.value,
			isCombobox: true,
			getFieldId: function() {
            	return this.fieldId;
            },
            focusField: function() {
            	this.focus();
            },
            setFieldValue: function( value ) {
            	this.setValue( value );
            },
            getSimpleFieldValue: function() {
            	return this.getValue();
            },
            listeners: {
            	afterrender: function( combo ) {
            		if ( definition.hidden ) {
            			var task = new Ext.util.DelayedTask( combo.hide );
            	        task.delay( 1 );
            		}
            	},
            	select: function( combo, record, index ) {
            		var value = combo.getValue();
            		var onChangeFunction = definition.onChange;
            		var onSelectFunction = definition.onSelect;
            		
            		if ( Ext.isFunction( onChangeFunction ) ) {
            			onChangeFunction.apply( combo, [ value ] );
            		}
            		
            		if ( Ext.isFunction( onSelectFunction ) ) {
            			onSelectFunction.apply( combo, [ value ] );
            		}
            	}
            },
            getComboboxApi: function() {
            	return me.getComboboxApi( this );
            }
        };
    },
    buildComboboxLabel: function( name, description ) {
      if ( !Ext.isEmpty( description ) ) {
        return addTooltipToField( name, description );
      } else {
        return name;
      }
    },
    addFieldToArray: function( fieldId ) {
    	var array = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( array ) && array.isArrayField && Ext.isEmpty( array.table ) ) {
    		var field = array.items.last();
    		array.addField( field );
    	}
    },
    removeFieldFromArray: function( fieldId, position ) {
    	var array = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( array ) && array.isArrayField && Ext.isEmpty( array.table ) && Ext.isNumber( position ) ) {
    		var field = array.items.itemAt( position );
    		
    		if ( !Ext.isEmpty( field ) ) {
    			array.removeField( field );
    		}
    	}
    },
    getFieldValue: function( fieldId, asString ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) && !field.isTableField ) {
    		return field.getSimpleFieldValue( asString );
    	} else {
    		return null;
    	}
    },
    setFieldValue: function( fieldId, value ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) && !field.isTableField ) {
    		field.setFieldValue( value );
    	}
    },
    setFieldValueInArray: function( fieldId, position, value ) {
    	var array = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( array ) && array.isArrayField ) {
    		var field = array.items.itemAt( position );
    		
    		if ( !Ext.isEmpty( field ) ) {
    			field.setFieldValue( value );
    		}
    	}
    },
    resetFieldValue: function( fieldId, silent ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) ) {
    		if ( Ext.isFunction( field.resetFieldValue ) ) {
				field.resetFieldValue( silent );
			} else {
				field.setValue( null );
			}
    	}
    },
    showFieldHint: function( fieldId, hint, type ) {
      var field = this.getField( fieldId );

      if ( !Ext.isEmpty( field ) && Ext.isFunction( field.showFieldHint ) ) {
        field.showFieldHint( hint, type );
      }
    },
    showFieldHintInArray: function( fieldId, position, hint, type ) {
      var array = this.getField( fieldId );

      if ( !Ext.isEmpty( array ) && array.isArrayField ) {
        var field = array.items.itemAt( position );

        if ( !Ext.isEmpty( field ) && Ext.isFunction( field.showFieldHint ) ) {
          field.showFieldHint( hint, type );
        }
      }
    },
    hideFieldHint: function( fieldId ) {
      var field = this.getField( fieldId );

      if ( !Ext.isEmpty( field ) && Ext.isFunction( field.hideFieldHint ) ) {
        field.hideFieldHint();
      }
    },
    hideFieldHintInArray: function( fieldId, position ) {
      var array = this.getField( fieldId );

      if ( !Ext.isEmpty( array ) && array.isArrayField ) {
        var field = array.items.itemAt( position );

        if ( !Ext.isEmpty( field ) && Ext.isFunction( field.hideFieldHint ) ) {
          field.hideFieldHint();
        }
      }
    },
    getArraySize: function( fieldId ) {
    	var array = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( array ) && array.isArrayField && !array.items.first().arrayInitializer ) {
    		return array.items.getCount();
    	} else {
    		return 0;
    	}
    },
    resetArray: function( fieldId ) {
    	var array = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( array ) && array.isArrayField ) {
    		array.resetFields();
    	}
    },
    getFieldPosition: function( fieldId ) {
    	var position = -1;
    	
    	Ext.each( this.items.items, function( customField, index, customFields ) {
            if ( customField.isTableField && customField.hasField( fieldId ) ) {
            	if ( customField.tableId === fieldId ) {
            		position = index;
                    return false;
            	} else if ( customField.hasField( fieldId ) ) {
            		position = customField.getFieldPosition( fieldId );
                    return false;
            	}
            } else if ( Ext.isFunction( customField.getFieldId ) && customField.getFieldId() === fieldId ) {
            	position = index;
                return false;
            }
        }, this );
    	
    	return position;
    },
    addButton: function( definition ) {
    	this.insertButton( this.items.getCount(), definition );
    },
    insertButton: function( position, definition ) {
      definition = !Ext.isEmpty( definition ) ? definition : new Object();
      var handler = definition.handler;
      var scope = definition.scope;
      var button = new Ext.Button( {
        id: definition.id,
        style: {
          marginBottom: '5px'
        },
        text: definition.text,
        iconCls: definition.iconCls,
        tooltip: definition.tooltip,
        isButton: true,
        handler: Ext.isFunction( handler ) ? handler : Ext.emptyFn,
        scope: !Ext.isEmpty( scope ) ? scope : window
      } );

      if ( this.initialConfig.isRow ) {
        this.insert( position, this.buildRowWrapper( position, button, true, false ) );
      } else {
        this.insert( position, button );
      }

      this.doLayout();
    },
    buildRowWrapper: function( position, element, isButton, hidden ) {
    	element = Ext.apply( element, {
    		row: this
    	} );
    	var fieldSpace = !Ext.isEmpty( this.initialConfig.fieldSpace ) ? this.initialConfig.fieldSpace : 2;
		var config = {
			layout: 'form',
			frame: false,
		    border: false,
		    hidden: hidden,
		    isRowWrapper: true,
		    style: ( position != 0 ) ? 'padding-left: ' + fieldSpace + 'px;' : '',
		    flex: isButton ? 0 : 1,
			items: [ element ]
		};
		
		return new Ext.Panel( config );
    },
    hideButton: function( buttonId ) {
      var button = this.getButton( buttonId );

      if ( !Ext.isEmpty( button ) ) {
        if ( !Ext.isEmpty( button.row ) ) {
          button.ownerCt.hide();
          button.row.doLayout();
        }
        button.hide();
      }
    },
    showButton: function( buttonId ) {
      var button = this.getButton( buttonId );

      if ( !Ext.isEmpty( button ) ) {
        if ( !Ext.isEmpty( button.row ) ) {
          button.ownerCt.show();
          button.row.doLayout();
        }
        button.show();
        var buttonEl = button.getEl();
        buttonEl.setStyle( 'display', '' );
      }
    },
    getButton: function( buttonId ) {
      var button = null;

      if ( !Ext.isEmpty( buttonId ) ) {
        Ext.each( this.items.items, function( item, index, items ) {
          if ( item.isButton && item.getId() === buttonId ) {
            button = item;
            return false;
          } else if ( this.initialConfig.isRow ) {
            Ext.each( this.items.items, function( wrapper, wrapperIndex, wrappers ) {
              var firstItem = wrapper.items.first();

              if ( firstItem.isButton && firstItem.getId() === buttonId ) {
                button = firstItem;
                return false;
              }
            } );

            if ( !Ext.isEmpty( button ) ) {
              return false;
            }
          } else if ( item.isFieldSet ) {
            var panel = item.items.first();
            button = panel.getButton( buttonId );

            if ( !Ext.isEmpty( button ) ) {
              return false;
            }
          }
        }, this );
      }

      return button;
    },
    addTable: function( definitions, config ) {
    	this.insertTable( this.items.getCount(), definitions, config );
    },
    insertTable: function( position, definitions, config ) {
    	if ( Ext.isArray( definitions ) ) {
    		config = Ext.isObject( config ) ? config : new Object();
    		var fields = this.getArrayFields( definitions );
    		
    		if ( !Ext.isEmpty( fields ) ) {
    			var table = new Ext.ux.suncode.TableCustomField( {
    				tableId: config.tableId,
    				fieldLabel: Ext.isEmpty( config.description ) ? config.name : addTooltipToField( config.name, config.description ),
    	    	    hidden: config.hidden,
                disabled: config.disabled,
    	    	    fields: fields
    	    	} );
    			this.insert( position, table );
        		this.doLayout();
        		
        		Ext.each( fields, function( field, index, allFields ) {
        			this.bindPreviousNextOnInsert( field );
        		}, this );
    		}
    	}
    },
    getArrayFields: function( definitions ) {
    	var fields = new Array();
		var fieldDefs = new Array();
		var customForm = this.initialConfig.customForm;
		var processNode = this.initialConfig.processNode;
		var bindTo = this.initialConfig.bindTo;
		var onFieldEnterTask = this.initialConfig.onFieldEnterTask;
		var contextVariables = this.initialConfig.contextVariables;
		
		Ext.each( definitions, function( definition, index, allDefinitions ) {
			var customFormField = null;
			var isObjectDef = false;
	    	var fieldId = null;
	    	var isParameterField = false;
	    	
	    	if ( Ext.isString( definition ) ) {
	    		customFormField = this.getFieldDefinition( definition );
	    		fieldId = definition;
	    	} else if ( Ext.isObject( definition ) && !Ext.isEmpty( definition.id ) ) {
	    		customFormField = this.getFieldDefinition( definition.id );
	    		isObjectDef = true;
	    		fieldId = definition.id;
	    	}
	    	
	    	var field = this.getField( fieldId );
	    	
	    	if ( Ext.isEmpty( customFormField ) ) {
	    		customFormField = this.initCustomFormField( definition );
	    	} else {
	    		isParameterField = true;
	    	}
			
	    	if ( Ext.isEmpty( field ) && ( ( customFormField.array || ( isParameterField && definition.isArrayCombobox &&
	    			customFormField.type === Ext.ux.suncode.IntegrationComponentService.STRING_TYPE ) ) ||
	    			( !isParameterField && definition.isArrayCombobox ) ) ) {
	    		fieldDefs.push( {
	    			isObjectDef: isObjectDef,
	    			definition: definition,
	    			customFormField: customFormField,
	    			isParameterField: isParameterField
	    		} );
	    	}
		}, this );
		
		if ( !Ext.isEmpty( fieldDefs ) ) {
			var maxValueLength = 0;
			
			if ( !Ext.isEmpty( customForm.values ) ) {
				Ext.each( fieldDefs, function( fieldDef, index, allFieldDefs ) {
					var customFormField = fieldDef.customFormField;
					
					if ( !Ext.isEmpty( customFormField ) ) {
						var fieldId = customFormField.id;
	    	    		var fieldValue = customForm.values[fieldId];
	    	    		
	    	    		if ( Ext.isArray( fieldValue ) && maxValueLength < fieldValue.length ) {
	    	    			maxValueLength = fieldValue.length;
	    	    		}
					}
				} );
	        }

			Ext.each( fieldDefs, function( fieldDef, index, allFieldDefs ) {
				var field = null;
    			var isObjectDef = fieldDef.isObjectDef;
    			var definition = fieldDef.definition;
    			var customFormField = fieldDef.customFormField;
    			var isParameterField = fieldDef.isParameterField;
    			
    			if ( !Ext.isEmpty( customFormField ) && !Ext.isEmpty( customForm.values ) ) {
    				var fieldId = customFormField.id;
    	    		var fieldValue = customForm.values[fieldId];
    	    		var currentValueLength = 0;
    	    		
    	    		if ( Ext.isArray( fieldValue ) ) {
    	    			currentValueLength = fieldValue.length;
    	    		} else {
    	    			fieldValue = new Array();
    	    		}

    	    		for ( var i = currentValueLength; i < maxValueLength; i++ ) {
    	    			fieldValue.push( {
    	    				type: customFormField.type,
    	    				value: null
    	    			} );
    	    		}
    	    		
    	    		customForm.values[fieldId] = fieldValue;
    	        }
    			
    			if ( isParameterField ) {
    				field = this.buildField( customForm, customFormField, {
    					isParameterField: isParameterField,
                name: isObjectDef && Ext.isDefined( definition.text ) ? definition.text : customFormField.name,
    	    			optional: isObjectDef && Ext.isDefined( definition.optional ) ? definition.optional : customFormField.optional,
    	    			notEmpty: isObjectDef && Ext.isDefined( definition.notEmpty ) ? definition.notEmpty : false,
              arrayMinLength: isObjectDef && Ext.isDefined( definition.arrayMinLength ) ? definition.arrayMinLength : null,
    	    	        hidden: isObjectDef ? definition.hidden : false,
    	    	        readOnly: isObjectDef ? definition.readOnly : false,
    	    	        hideLabel: isObjectDef ? definition.hideLabel : false,
    	    	        disableVariableDuplication: isObjectDef ? definition.disableVariableDuplication : false,
    	    	        value: isObjectDef ? definition.value : null,
                    onAfterRender: isObjectDef ? definition.onAfterRender : null,
    	    	        onChange: isObjectDef ? definition.onChange : null,
    	    	        onBlur: isObjectDef ? definition.onBlur : null,
    	    	        onSelect: isObjectDef ? definition.onSelect : null,
    	    	        onAddField: isObjectDef ? definition.onAddField : null,
    	    	        isArrayCombobox: definition.isArrayCombobox,
    	    	        comboboxConfig: definition.isArrayCombobox ? this.buildComboboxConfig( definition ) : null,
    	    	    	processNode: processNode,
    	    	      	bindTo: bindTo,
    	    	       	onFieldEnterTask: onFieldEnterTask,
    	    	       	contextVariables: contextVariables,
    	    	       	availableVariables: this.initialConfig.availableVariables,
                    missingVariablesValidatorFunction: this.initialConfig.missingVariablesValidatorFunction,
                    missingVariablesValidatorScope: this.initialConfig.missingVariablesValidatorScope,
    	    	       	systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
                    validateFieldFunction: this.initialConfig.validateFieldFunction,
                    validateFieldScope: this.initialConfig.validateFieldScope,
    	    	       	typesVisible: this.typesVisible,
                    functionPrettyFormat: this.functionPrettyFormat,
    	    	       	tableVariableAllowed: this.tableVariableAllowed,
    	    	       	columnCheckboxEnabled: this.columnCheckboxEnabled,
    	    	       	isColorPicker: isObjectDef ? definition.isColorPicker : false,
    	    	       	previousWindow: this.initialConfig.previousWindow
    	    	    } );
    			} else {
            field = new Ext.ux.suncode.ArrayCustomField( {
              fieldId: isObjectDef ? definition.id : definition,
              name: isObjectDef ? definition.text : '',
              description: isObjectDef ? definition.description : '',
              hidden: isObjectDef ? definition.hidden : false,
              hideLabel: isObjectDef ? definition.hideLabel : false,
              arrayMinLength: isObjectDef ? this.buildArrayMinLength( definition.arrayMinLength, 0 ) : 0,
              customValues: isObjectDef ? definition.defaultValue : new Array(),
              customFieldDef: {
                processNode: processNode,
                onEnterTask: onFieldEnterTask,
                contextVariables: contextVariables,
                optional: true,
                notEmpty: false,
                readOnly: isObjectDef ? definition.readOnly : false,
                onAfterRenderFunction: isObjectDef ? definition.onAfterRender : null,
                onChangeFunction: isObjectDef ? definition.onChange : null,
                onBlurFunction: isObjectDef ? definition.onBlur : null,
                onSelectFunction: isObjectDef ? definition.onSelect : null,
                onAddFunction: isObjectDef ? definition.onAddField : null,
                isCombobox: isObjectDef ? definition.isArrayCombobox : false,
                comboboxConfig: ( isObjectDef && definition.isArrayCombobox ) ? this.buildComboboxConfig( definition )
                    : null,
                systemFunctionsAccessibility: this.initialConfig.systemFunctionsAccessibility,
                typeVisible: this.typesVisible,
                functionPrettyFormat: this.functionPrettyFormat,
                columnCheckboxEnabled: this.columnCheckboxEnabled
              }
            } );
          }
	    		
	    		fields.push( field );
    		}, this );
		}
		
		return fields;
    },
    addDataChooserMapping: function( mapping ) {
    	var mappingsItem = this.initialConfig.dataChooserMappingsTable;
    	
    	if ( !Ext.isEmpty( mappingsItem ) && Ext.isFunction( mappingsItem.addMapping ) ) {
    		mappingsItem.addMapping( mapping );
    	}
    },
    updateDataChooserMapping: function( id, mapping ) {
      var mappingsItem = this.initialConfig.dataChooserMappingsTable;

      if ( !Ext.isEmpty( mappingsItem ) && Ext.isFunction( mappingsItem.addMapping ) ) {
        mappingsItem.updateMapping( id, mapping );
      }
    },
    removeDataChooserMapping: function( id ) {
      var mappingsItem = this.initialConfig.dataChooserMappingsTable;

      if ( !Ext.isEmpty( mappingsItem ) && Ext.isFunction( mappingsItem.removeMapping ) ) {
        mappingsItem.removeMapping( id );
      }
    },
    changeDataChooserMappingPosition: function( id, newPosition ) {
      var mappingsItem = this.initialConfig.dataChooserMappingsTable;

      if ( !Ext.isEmpty( mappingsItem ) && Ext.isFunction( mappingsItem.changeMappingPosition ) ) {
        mappingsItem.changeMappingPosition( id, newPosition );
      }
    },
    getAllDataChooserMappings: function() {
      var mappingsItem = this.initialConfig.dataChooserMappingsTable;

      if ( !Ext.isEmpty( mappingsItem ) && Ext.isFunction( mappingsItem.getAllMappings ) ) {
        return mappingsItem.getAllMappings();
      } else {
        return new Array();
      }
    },
    resetDataChooserMappings: function() {
    	var mappingsItem = this.initialConfig.dataChooserMappingsTable;
    	
    	if ( !Ext.isEmpty( mappingsItem ) && Ext.isFunction( mappingsItem.removeMappings ) ) {
    		mappingsItem.removeMappings();
    	}
    },
    disableField: function( fieldId ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) ) {
    		if ( field.isRow ) {
    			field.items.each( function( panel ) {
    				var firstField = panel.items.first();
    				
    				if ( firstField.isParameterField ) {
    					firstField.disableField();
    				}
        		} );
    		} else {
    			field.disableField();
    		}
    	}
    },
    enableField: function( fieldId ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) ) {
    		if ( field.isRow ) {
    			field.items.each( function( panel ) {
    				var firstField = panel.items.first();
    				
    				if ( firstField.isParameterField ) {
    					firstField.enableField();
    				}
        		} );
    		} else {
    			field.enableField();
    		}
    	}
    },
    setNotEmpty: function( fieldId, notEmpty ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) && Ext.isFunction( field.setNotEmpty ) ) {
    		field.setNotEmpty( notEmpty );
    	}
    },
    hasVariableValue: function( fieldId, position ) {
    	return this.hasValueOfType( fieldId, position, this.VARIABLE_FIELD_TYPE, false );
    },
    hasVariableArrayValue: function( fieldId, position ) {
    	return this.hasValueOfType( fieldId, position, this.VARIABLE_FIELD_TYPE, true );
    },
    hasFunctionValue: function( fieldId, position ) {
    	return this.hasValueOfType( fieldId, position, this.FUNCTION_FIELD_TYPE, false );
    },
    hasValueOfType: function( fieldId, position, typeOfValue, array ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) && Ext.isFunction( field.hasValueOfType ) ) {
    		return field.hasValueOfType( typeOfValue, array, position );
    	} else {
    		return false;
    	}
    },
    getFunctionReturnType: function( fieldId, position ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) && Ext.isFunction( field.getFunctionReturnType ) ) {
    		return field.getFunctionReturnType( position );
    	} else {
    		return null;
    	}
    },
    getVariableType: function( fieldId, position ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) && Ext.isFunction( field.getVariableType ) ) {
    		return field.getVariableType( position );
    	} else {
    		return null;
    	}
    },
    setErrorHandling: function( errorHandling ) {
		var errorHandlingTypeItem = this.errorHandlingTypeItem;
		
		if ( !Ext.isEmpty( errorHandling ) && !Ext.isEmpty( errorHandling.type ) && !Ext.isEmpty( errorHandlingTypeItem ) ) {
			switch( errorHandling.type ) {
				case 'STOP':
				case 'CONTINUE':
					errorHandling = Ext.apply( errorHandling, {
						comment: this.wrapValueIfNecessary( this.STRING_FIELD_TYPE, errorHandling.comment ),
						userMessage: this.wrapValueIfNecessary( this.STRING_FIELD_TYPE, errorHandling.userMessage ),
						addErrorToComment: this.wrapValueIfNecessary( this.BOOLEAN_FIELD_TYPE, errorHandling.addErrorToComment ),
						setters: {
							variables: !Ext.isEmpty( errorHandling.setters ) ?
									this.wrapArrayValues( this.VARIABLE_FIELD_TYPE, errorHandling.setters.variables ) : new Array(),
							values: !Ext.isEmpty( errorHandling.setters ) ?
									this.wrapArrayValues( this.STRING_FIELD_TYPE, errorHandling.setters.variables ) : new Array()
						}
					} );
					
					errorHandlingTypeItem.setValue( errorHandling.type );
					this.handleErrorHandlingType( errorHandlingTypeItem, errorHandling );
					break;
				default:
					break;
			}
		}
    },
    wrapValueIfNecessary: function( type, value ) {
    	if ( Ext.isObject( value ) ) {
    		return value;
    	} else {
    		return {
        		type: type,
                value: value
            };
    	}
    },
    wrapArrayValues: function( type, values ) {
    	if ( Ext.isArray( values ) ) {
    		var array = new Array();
    		
    		Ext.each( values, function( value, index, allValues ) {
    			array.push( this.wrapValueIfNecessary( type, value ) );
    		}, this );
    		
    		return array;
    	} else {
    		return new Array();
    	}
    },
    markError: function( fieldId, position ) {
    	var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) ) {
    		field.markError( position );
    	}
    },
    showErrorMessage: function( errorMessage ) {
    	showWarn( errorMessage );
	},
	setTableVariableAllowed: function( tableVariableAllowed ) {
		this.tableVariableAllowed = tableVariableAllowed;
		
		Ext.each( this.items.items, function( item, index, items ) {
			if ( ( item.isParameterField || item.isRow || item.isFieldSet )
					&& Ext.isFunction( item.setTableVariableAllowed ) ) {
				item.setTableVariableAllowed( tableVariableAllowed );
            } else if ( item.isRowWrapper ) {
            	var wrappedItem = item.items.first();
            	
            	if ( wrappedItem.isParameterField && Ext.isFunction( wrappedItem.setTableVariableAllowed ) ) {
            		wrappedItem.setTableVariableAllowed( tableVariableAllowed );
            	}
            }
        } );
	},
	setColumnCheckboxEnabled: function( columnCheckboxEnabled ) {
		this.columnCheckboxEnabled = columnCheckboxEnabled;
		
		Ext.each( this.items.items, function( item, index, items ) {
			if ( ( item.isParameterField || item.isRow || item.isFieldSet )
					&& Ext.isFunction( item.setColumnCheckboxEnabled ) ) {
				item.setColumnCheckboxEnabled( columnCheckboxEnabled );
            } else if ( item.isRowWrapper ) {
            	var wrappedItem = item.items.first();
            	
            	if ( wrappedItem.isParameterField && Ext.isFunction( wrappedItem.setColumnCheckboxEnabled ) ) {
            		wrappedItem.setColumnCheckboxEnabled( columnCheckboxEnabled );
            	}
            }
        } );
	},
	setBlocked: function( fieldId, blocked ) {
		var field = this.getField( fieldId );
    	
    	if ( !Ext.isEmpty( field ) && Ext.isFunction( field.setBlocked ) ) {
    		field.setBlocked( blocked );
    	}
	},
	setRebuildParametersActive: function( rebuildParametersActive ) {
		this.rebuildParametersActive = rebuildParametersActive;
	},
	insertEmptyLine: function( position ) {
		this.insert( position, {
            xtype: 'box',
            autoEl: {
                tag: 'br'
            }
        } );
		this.doLayout();
	},
	rebuildFieldDefinition: function( definition ) {
		if ( Ext.isEmpty( definition ) ) {
			return new Object();
		} else if ( Ext.isString( definition ) ) {
			return {
				id: definition
			};
		} else {
			return definition;
		}
	},
	insertColorPicker: function( position, definition ) {
		if ( Ext.isObject( definition ) && !Ext.isEmpty( definition.id ) ) {
    		var customFormField = this.getFieldDefinition( definition.id );
    		var field = this.getField( definition.id );
    		
    		if ( Ext.isEmpty( field ) && !Ext.isEmpty( customFormField ) &&
    				customFormField.type === Ext.ux.suncode.IntegrationComponentService.STRING_TYPE  ) {
    			return this.insertFieldFromCustomFromField( position, customFormField, {
    				isParameterField: true,
                	optional: Ext.isDefined( definition.optional ) ? definition.optional : customFormField.optional,
                	notEmpty: Ext.isDefined( definition.notEmpty ) ? definition.notEmpty : false,
                	hidden: definition.hidden,
                	readOnly: definition.readOnly,
                	hideLabel: definition.hideLabel,
                	disableVariableDuplication: definition.disableVariableDuplication,
                	value: definition.value,
                  onAfterRender: definition.onAfterRender,
                	onChange: definition.onChange,
                	onBlur: definition.onBlur,
                	onAddField: definition.onAddField,
                	isColorPicker: true
                } );
    		}
    	}
	},
	collapseFieldSet: function( fieldSetId ) {
		var fieldSet = this.getField( fieldSetId );
		
		if ( !Ext.isEmpty( fieldSet ) ) {
			fieldSet.collapse();
		}
	},
	expandFieldSet: function( fieldSetId ) {
		var fieldSet = this.getField( fieldSetId );
		
		if ( !Ext.isEmpty( fieldSet ) ) {
			fieldSet.expand();
		}
	},
	toggleFieldSet: function( fieldSetId ) {
		var fieldSet = this.getField( fieldSetId );
		
		if ( !Ext.isEmpty( fieldSet ) ) {
			fieldSet.toggleCollapse();
		}
	},
    getApiVersion2: function() {
    	var me = this;
    	
    	return {
    		addField: function( definition, position ) {
    			definition = me.rebuildFieldDefinition( definition );
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var listeners = definition.listeners;
    			definition = Ext.apply( definition, {
            onAfterRender: !Ext.isEmpty( listeners ) ? listeners.afterrender : null,
    				onChange: !Ext.isEmpty( listeners ) ? listeners.change : null,
    				onBlur: !Ext.isEmpty( listeners ) ? listeners.blur : null,
    				onAddField: !Ext.isEmpty( listeners ) ? listeners.addfield : null		
    			} );
    			
    			me.insertField( position, definition );
    		},
    		addRow: function( definition, position ) {
    			definition = me.rebuildFieldDefinition( definition );
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var row = new Ext.ux.suncode.CustomForm( {
    				rowId: definition.id,
    				bodyCssClass: '',
    				layout: 'hbox',
    				isRow: true,
    				preventBuildFields: true,
    				fieldSpace: definition.fieldSpace,
    				customForm: {
    					fields: me.initialConfig.customForm.fields,
    					values: me.initialConfig.customForm.values
    				},
                    processNode: me.initialConfig.processNode,
                    contextVariables: me.initialConfig.contextVariables,
                    systemFunctionsAccessibility: me.initialConfig.systemFunctionsAccessibility,
                    customFormConfig: me.getCustomFormConfig(),
                    tableVariableAllowed: me.tableVariableAllowed,
                    columnCheckboxEnabled: me.columnCheckboxEnabled
    			} );
    			me.insert( position, row );
    			me.doLayout();
    			
    			return row.getApiVersion2();
    		},
    		removeField: function( fieldId ) {
    			me.removeField( fieldId );
    		},
    		hide: function( fieldId ) {
    			me.hideField( fieldId );
    		},
    		show: function( fieldId ) {
    			me.showField( fieldId );
    		},
    		focusField: function( fieldId ) {
    			me.focusField( fieldId );
    		},
    		addLabel: function( text, position ) {
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			
    			me.insertLabel( position, text );
    		},
    		addCheckbox: function( definition, position ) {
    			definition = !Ext.isEmpty( definition ) ? definition : new Object();
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var listeners = definition.listeners;
    			definition = Ext.apply( definition, {
    				text: definition.name,
            onAfterRender: !Ext.isEmpty( listeners ) ? listeners.afterrender : null,
    				onChange: !Ext.isEmpty( listeners ) ? listeners.change : null
    			} );
    			
    			me.insertCheckbox( position, definition );
    		},
    		addCombobox: function( definition, position ) {
    			definition = !Ext.isEmpty( definition ) ? definition : new Object();
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var listeners = definition.listeners;
    			var remote = definition.remote;
    			var sort = new Object();
    			if ( Ext.isArray( definition.sort ) && !Ext.isEmpty( definition.sort ) ) {
    				var sortInfo = definition.sort[0];
    				sort = Ext.apply( sort, {
    					field: sortInfo.property,
						direction: sortInfo.direction
    				} );
    			} else if ( Ext.isObject( definition.sort ) ) {
    				var sortInfo = definition.sort;
    				sort = Ext.apply( sort, {
    					field: sortInfo.property,
						direction: sortInfo.direction
    				} );
    			}
    			definition = Ext.apply( definition, {
    				text: definition.name,
    				remote: !Ext.isEmpty( remote ),
    				url: !Ext.isEmpty( remote ) ? remote.url : null,
    				fields: !Ext.isEmpty( remote ) ? remote.fields : null,
    				remoteSort: !Ext.isEmpty( remote ) ? remote.remoteSort : null,
    				pageSize: !Ext.isEmpty( remote ) ? remote.pageSize : null,
    				sort: sort,
            onAfterRender: !Ext.isEmpty( listeners ) ? listeners.afterrender : null,
    				onChange: !Ext.isEmpty( listeners ) ? listeners.change : null,
    	    		onBlur: !Ext.isEmpty( listeners ) ? listeners.blur : null,
    	    		onSelect: !Ext.isEmpty( listeners ) ? listeners.select : null,
    	    		onAddField: !Ext.isEmpty( listeners ) ? listeners.addfield : null
    			} );
    			
    			var combobox = me.insertCombobox( position, definition );
    			
    			return combobox.getComboboxApi();
    		},
    		getFieldPosition: function( fieldId ) {
    			return me.getFieldPosition( fieldId );
    		},
    		getValue: function( fieldId, asString ) {
    			return me.getFieldValue( fieldId, asString );
    		},
    		setValue: function( fieldId, value ) {
    			me.setFieldValue( fieldId, value );
    		},
    		resetValue: function( fieldId, silent ) {
    			me.resetFieldValue( fieldId, silent );
    		},
        showHint: function( fieldId, hint, type ) {
          me.showFieldHint( fieldId, hint, type );
        },
        showHintInArray: function( fieldId, position, hint, type ) {
          me.showFieldHintInArray( fieldId, position, hint, type );
        },
        hideHint: function( fieldId ) {
          me.hideFieldHint( fieldId );
        },
        hideHintInArray: function( fieldId, position ) {
          me.hideFieldHintInArray( fieldId, position );
        },
    		addButton: function( definition, position ) {
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			
    			me.insertButton( position, definition );
    		},
        hideButton: function( buttonId ) {
          me.hideButton( buttonId );
        },
        showButton: function( buttonId ) {
          me.showButton( buttonId );
        },
    		addFieldToArray: function( fieldId ) {
    			me.addFieldToArray( fieldId );
    		},
    		removeFieldFromArray: function( fieldId, position ) {
    			me.removeFieldFromArray( fieldId, position );
    		},
    		setFieldValueInArray: function( fieldId, position, value ) {
    			me.setFieldValueInArray( fieldId, position, value );
    		},
    		getArraySize: function( fieldId ) {
    			return me.getArraySize( fieldId );
    		},
    		resetArray: function( fieldId ) {
    			me.resetArray( fieldId );
    		},
    		addTable: function( definition, position ) {
    			definition = me.rebuildFieldDefinition( definition );
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var table = new Ext.ux.suncode.TableCustomField( {
    				tableId: definition.id,
    				fieldLabel: Ext.isEmpty( definition.description ) ? definition.name :
    					addTooltipToField( definition.name, definition.description ),
    	    	    hidden: definition.hidden,
    	    	    blocked: definition.blocked,
    	    	    notEmpty: definition.notEmpty
    	    	} );
    			me.insert( position, table );
    			me.doLayout();
        		
        		return table.getApiVersion2();
    		},
    		addFieldSet: function( definition, position ) {
    			definition = !Ext.isEmpty( definition ) ? definition : new Object();
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var panel = new Ext.ux.suncode.CustomForm( {
    				bodyCssClass: '',
    				preventBuildFields: true,
    				customForm: {
    					fields: me.initialConfig.customForm.fields,
    					values: me.initialConfig.customForm.values
    				},
                    processNode: me.initialConfig.processNode,
                    contextVariables: me.initialConfig.contextVariables,
                    systemFunctionsAccessibility: me.initialConfig.systemFunctionsAccessibility,
                    customFormConfig: me.getCustomFormConfig(),
                    tableVariableAllowed: me.tableVariableAllowed,
                    columnCheckboxEnabled: me.columnCheckboxEnabled
    			} );
    			
    			var fieldSet = new Ext.form.FieldSet( {
    				fieldSetId: definition.id,
    				title: definition.title,
    				isFieldSet: true,
    				collapsible: definition.collapsible,
    				collapsed: definition.collapsed,
    				items: [ panel ],
    				getFieldId: function() {
    					return this.fieldSetId;
    				}
    			} );
    			
    			me.insert( position, fieldSet );
    			me.doLayout();
    			
    			return panel.getApiVersion2();
    		},
    		collapseFieldSet: function( fieldSetId ) {
    			me.collapseFieldSet( fieldSetId );
    		},
    		expandFieldSet: function( fieldSetId ) {
    			me.expandFieldSet( fieldSetId );
    		},
    		toggleFieldSet: function( fieldSetId ) {
    			me.toggleFieldSet( fieldSetId );
    		},
    		addDataChooserMapping: function( mapping ) {
    			me.addDataChooserMapping( mapping );
    		},
        updateDataChooserMapping: function( id, mapping ) {
          me.updateDataChooserMapping( id, mapping );
        },
        removeDataChooserMapping: function( id ) {
          me.removeDataChooserMapping( id );
        },
        changeDataChooserMappingPosition: function( id, newPosition ) {
          me.changeDataChooserMappingPosition( id, newPosition );
        },
        getAllDataChooserMappings: function() {
          return me.getAllDataChooserMappings();
        },
    		resetDataChooserMappings: function() {
    			me.resetDataChooserMappings();
    		},
    		disable: function( fieldId ) {
    			me.disableField( fieldId );
    		},
    		enable: function( fieldId ) {
    			me.enableField( fieldId );
    		},
    		setNotEmpty: function( fieldId, notEmpty ) {
    			me.setNotEmpty( fieldId, notEmpty );
    		},
    		hasVariableValue: function( fieldId, position ) {
    			return me.hasVariableValue( fieldId, position );
    		},
    		hasFunctionValue: function( fieldId, position ) {
    			return me.hasFunctionValue( fieldId, position );
    		},
    		setErrorHandling: function( errorHandling ) {
    			me.setErrorHandling( errorHandling );
    		},
    		block: function( fieldId ) {
    			me.setBlocked( fieldId, true );
    		},
    		unblock: function( fieldId ) {
    			me.setBlocked( fieldId, false );
    		},
    		addEmptyLine: function( position ) {
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			
    			me.insertEmptyLine( position );
    		},
    		addColorPicker: function( definition, position ) {
    			definition = me.rebuildFieldDefinition( definition );
    			position = !Ext.isEmpty( position ) ? position : me.items.getCount();
    			var listeners = definition.listeners;
    			definition = Ext.apply( definition, {
            onAfterRender: !Ext.isEmpty( listeners ) ? listeners.afterrender : null,
    				onChange: !Ext.isEmpty( listeners ) ? listeners.change : null,
    				onBlur: !Ext.isEmpty( listeners ) ? listeners.blur : null,
    	    		onAddField: !Ext.isEmpty( listeners ) ? listeners.addfield : null
    			} );
    			
    			me.insertColorPicker( position, definition );
    		},
    		isDataChooserInTable: function( id ) {
    			var isDataChooserInTableFunction = me.initialConfig.isDataChooserInTableFunction;
    			
    			if ( Ext.isFunction( isDataChooserInTableFunction ) ) {
    				var isDataChooserInTableScope = !Ext.isEmpty( me.initialConfig.isDataChooserInTableScope ) ?
    						me.initialConfig.isDataChooserInTableScope : window;
    				return isDataChooserInTableFunction.apply( isDataChooserInTableScope, [] );
    			} else {
    				var processNode = me.initialConfig.processNode;
        			var variable = processNode.findVariable( id );
        			
        			return ( !Ext.isEmpty( variable ) && variable.type === 'DATA_CHOOSER' && variable.placement === 'table' );
    			} 
    		},
    		activateRebuildParameters: function() {
    			me.setRebuildParametersActive( true );
    		},
    		deactivateRebuildParameters: function() {
    			me.setRebuildParametersActive( false );
    		},
    		showMessage: function( config ) {
    			Ext.Msg.show( {
                    title: config.title,
                    msg: config.message,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.INFO
                } );
    		},
        getAllTasks: function () {
    		  var tasks = new Array();
          var processNode = me.initialConfig.processNode;

          if ( processNode.hasChildNodes() ) {
            processNode.eachChild( function ( activityNode ) {
              tasks.push( {
                id: activityNode.attributes.activityDefId,
                name: activityNode.attributes.activityName
              } );
            } );
          }

          return tasks;
        },
        getAllRoles: function() {
          var roles = new Array();
          var processNode = me.initialConfig.processNode;

          Ext.each( processNode.attributes.participants, function( participant, index, participants ) {
            roles.push( {
              id: participant.roleId,
              name: participant.roleName
            } );
          } );

          return roles;
        },
        getAllVariables: function() {
          var variables = new Array();
          var processNode = me.initialConfig.processNode;

          Ext.each( processNode.attributes.variables, function( variable, index, allVariables ) {
            variables.push( {
              id: variable.id,
              name: variable.name,
              type: variable.type,
              destination: variable.placement
            } );
          } );

          return variables;
        },
        getAllGlobalTables: function() {
    		  var tables = new Array();
          var processNode = me.initialConfig.processNode;

          Ext.each( processNode.attributes.tables, function( table, tableIndex, allTables ) {
            var columns = new Array();
            Ext.each( table.columns, function( column, columnIndex, allColumns ) {
              columns.push( column.varId );
            } );

            tables.push( {
              id: table.id,
              name: table.name,
              columns: columns
            } );
          } );

    		  return tables;
        },
        getGlobalTable: function( tableId ) {
          var processNode = me.initialConfig.processNode;
          var table = processNode.findTable( tableId );

          if ( !Ext.isEmpty( table ) ) {
            var columns = new Array();
            Ext.each( table.columns, function( column, columnIndex, allColumns ) {
              columns.push( column.varId );
            } );

            return {
              id: table.id,
              name: table.name,
              columns: columns
            };
          } else {
            return null;
          }
        },
        getValidatorConfirmationTitle( asString ) {
          if ( me.confirmationConfigurationEnabled ) {
            return me.confirmationTitleItem.getSimpleFieldValue( asString );
          } else {
            return null;
          }
        },
        getValidatorConfirmationMessage( asString ) {
          if ( me.confirmationConfigurationEnabled ) {
            return me.confirmationMessageItem.getSimpleFieldValue( asString );
          } else {
            return null;
          }
        },
        getValidatorErrorMessage( asString ) {
          if ( me.errorConfigurationEnabled ) {
            return me.errorMessageItem.getSimpleFieldValue( asString );
          } else {
            return null;
          }
        }
    	};
    },
    getComboboxApi: function( combobox ) {
    	return {
    		addValues: function( values ) {
    			if ( combobox.mode !== 'local' ) {
    				return;
    			}
    			
    			if ( Ext.isArray( values ) || Ext.isObject( values ) ) {
    				values = Ext.isArray( values ) ? values : [ values ]; 
        			var store = combobox.getStore();
        			
        			this._addValuesToStore( store, values );
    			}
    		},
    		setValues: function( values ) {
    			if ( combobox.mode !== 'local' ) {
    				return;
    			}
    			
    			if ( Ext.isArray( values ) || Ext.isObject( values ) ) {
    				values = Ext.isArray( values ) ? values : [ values ]; 
        			var store = combobox.getStore();
        			store.removeAll();
        			
        			this._addValuesToStore( store, values );
    			}
    		},
    		setUrl: function( url ) {
    			if ( Ext.isString( url ) && combobox.mode === 'remote' ) {
    				var store = combobox.getStore();
    				var proxy = store.proxy;
    				proxy.setUrl( Suncode.context( 'pwe' ).contextPath + '/' + url, true );
    				store.reload();
    			}
    		},
    		setForceSelection: function( forceSelection ) {
    			if ( Ext.isBoolean( forceSelection ) ) {
    				combobox.forceSelection = forceSelection;
    			}
    		},
    		_addValuesToStore: function( store, values ) {
    			var recordType = store.recordType;
    			var records = new Array();
    			
    			Ext.each( values, function( value, index, allValues ) {
    				var record = new recordType( value );
    				records.push( record );
    			} );
                
    			store.add( records );
                store.commitChanges();
                
                if ( !Ext.isEmpty( combobox.view ) ) {
                	combobox.view.refresh();
                }
    		}
    	}
    },
    getValidationApi: function() {
    	var me = this;
    	
    	return {
    		getFieldPosition: function( fieldId ) {
    			return me.getFieldPosition( fieldId );
    		},
    		getValue: function( fieldId, asString ) {
    			return me.getFieldValue( fieldId, asString );
    		},
    		getArraySize: function( fieldId ) {
    			return me.getArraySize( fieldId );
    		},
    		hasVariableValue: function( fieldId, position ) {
    			return me.hasVariableValue( fieldId, position );
    		},
    		hasFunctionValue: function( fieldId, position ) {
    			return me.hasFunctionValue( fieldId, position );
    		},
    		hasVariableArrayValue: function( fieldId, position ) {
    			return me.hasVariableArrayValue( fieldId, position );
    		},
    		getFunctionReturnType: function( fieldId, position ) {
    			return me.getFunctionReturnType( fieldId, position );
    		},
    		getVariableType: function( fieldId, position ) {
    			return me.getVariableType( fieldId, position );
    		},
    		markError: function( fieldId, position ) {
    			me.markError( fieldId, position );
    		},
    		showErrorMessage: function( errorMessage ) {
    			me.showErrorMessage( errorMessage );
    		},
        showHint: function( fieldId, hint, type ) {
          me.showFieldHint( fieldId, hint, type );
        },
        showHintInArray: function( fieldId, position, hint, type ) {
          me.showFieldHintInArray( fieldId, position, hint, type );
        },
        hideHint: function( fieldId ) {
          me.hideFieldHint( fieldId );
        },
        hideHintInArray: function( fieldId, position ) {
          me.hideFieldHintInArray( fieldId, position );
        }
    	};
    }
} );