/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.xpdl.builder;

import com.suncode.plugin.pwe.service.packageinfo.PackageInfoService;
import com.suncode.plugin.pwe.util.PweUtils;
import com.suncode.plugin.pwe.web.support.dto.packageinfo.PackageInfoDto;
import com.suncode.plugin.pwe.web.support.dto.xpdl.XpdlHistoryDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.repositorypersistence.data.XPDLHistoryDO;
import org.enhydra.shark.repositorypersistence.data.XPDLHistoryDataDO;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XpdlHistoryDtoBuilder {
    public static Logger log = Logger.getLogger(XpdlHistoryDtoBuilder.class);
    private static final Integer NO_PROCESSES = 0;
    @Autowired
    private PackageInfoService packageInfoService;

    public List<XpdlHistoryDto> build(XPDLHistoryDO[] xpdlsHistory) {
        ArrayList<XpdlHistoryDto> dtos = new ArrayList<XpdlHistoryDto>();
        if (ArrayUtils.isNotEmpty((Object[])xpdlsHistory)) {
            for (XPDLHistoryDO xpdlHistory : xpdlsHistory) {
                dtos.add(this.build(xpdlHistory));
            }
        }
        return dtos;
    }

    public XpdlHistoryDto build(XPDLHistoryDO xpdlHistory) {
        XpdlHistoryDto dto = new XpdlHistoryDto();
        try {
            dto.setId(xpdlHistory.getXPDLId());
            dto.setVersion(xpdlHistory.getXPDLVersion());
            dto.setUploadTime(PweUtils.buildFormattedDate(xpdlHistory.getXPDLUploadTime(), "yyyy-MM-dd HH:mm:ss"));
            dto.setHistoryUploadTime(PweUtils.buildFormattedDate(xpdlHistory.getXPDLHistoryUploadTime(), "yyyy-MM-dd HH:mm:ss"));
            XPDLHistoryDataDO xpdlHistoryData = xpdlHistory.getXPDLHistoryDataDO();
            if (xpdlHistoryData != null) {
                Package pack = PweUtils.getPackage(xpdlHistoryData.getXPDLContent(), false);
                dto.setName(pack.getName());
                dto.setAuthor(PweUtils.getPackageAuthor(pack));
                dto.setCreationTime(pack.getPackageHeader().getCreated());
                dto.setNoOfProcesses(pack.getWorkflowProcesses().size());
            } else {
                dto.setNoOfProcesses(NO_PROCESSES);
            }
            PackageInfoDto packageInfoDto = this.packageInfoService.getForPackageVersion(xpdlHistory.getXPDLId(), xpdlHistory.getXPDLVersion());
            if (packageInfoDto != null) {
                dto.setDescription(packageInfoDto.getPackageInfo());
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return dto;
    }
}

