/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.template.builder;

import com.suncode.plugin.pwe.web.support.dto.template.TemplateDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class TemplateDtoBuilder {
    public static final String NAME_POSTFIX = ".name";
    public static final String DESCRIPTION_POSTFIX = ".description";

    public List<TemplateDto> build(List<Resource> resources, Properties translationProperties) {
        ArrayList<TemplateDto> dtos = new ArrayList<TemplateDto>();
        if (CollectionUtils.isNotEmpty(resources)) {
            for (Resource resource : resources) {
                dtos.add(this.build(resource, translationProperties));
            }
        }
        return dtos;
    }

    public TemplateDto build(Resource resource, Properties translationProperties) {
        String id = resource.getFilename();
        TemplateDto dto = new TemplateDto();
        dto.setId(id);
        dto.setName(this.buildName(id, translationProperties));
        dto.setDescription(this.buildDescription(id, translationProperties));
        return dto;
    }

    private String buildName(String id, Properties translationProperties) {
        return this.buildFromTranslationProperties(id, NAME_POSTFIX, translationProperties);
    }

    private String buildDescription(String id, Properties translationProperties) {
        return this.buildFromTranslationProperties(id, NAME_POSTFIX, translationProperties);
    }

    private String buildFromTranslationProperties(String id, String postfix, Properties translationProperties) {
        return translationProperties.getProperty(StringUtils.join((Object[])new String[]{id, postfix}), id);
    }
}

