/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.standardautoupdate.builder;

import com.plusmpm.util.form.autoupdate.DataSource;
import com.plusmpm.util.form.autoupdate.Definition;
import com.plusmpm.util.form.autoupdate.Destination;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.DataSourceDto;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.DestinationDto;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.StandardAutoUpdateDefinitionDto;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.StandardAutoUpdateDto;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.builder.DataSourceDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.builder.DestinationDtoBuilder;
import com.suncode.plugin.pwe.web.support.dto.standardautoupdate.builder.StandardAutoUpdateDefinitionDtoBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StandardAutoUpdateDtoBuilder {
    @Autowired
    private StandardAutoUpdateDefinitionDtoBuilder definitionDtoBuilder;
    @Autowired
    private DataSourceDtoBuilder dataSourceDtoBuilder;
    @Autowired
    private DestinationDtoBuilder destinationDtoBuilder;

    public StandardAutoUpdateDto build(Long id, Definition definition, List<DataSource> dataSources, List<Destination> destinations) {
        StandardAutoUpdateDto dto = new StandardAutoUpdateDto();
        dto.setId(id);
        dto.setDefinition(this.buildDefinition(id, definition));
        dto.setDataSources(this.buildDataSources(dataSources));
        dto.setDestinations(this.buildDestinations(destinations));
        return dto;
    }

    private StandardAutoUpdateDefinitionDto buildDefinition(Long id, Definition definition) {
        return this.definitionDtoBuilder.build(id, definition);
    }

    private List<DataSourceDto> buildDataSources(List<DataSource> dataSources) {
        ArrayList<DataSourceDto> dtos = new ArrayList<DataSourceDto>();
        if (CollectionUtils.isNotEmpty(dataSources)) {
            for (DataSource dataSource : dataSources) {
                dtos.add(this.buildDataSource(dataSource));
            }
        }
        return dtos;
    }

    private DataSourceDto buildDataSource(DataSource dataSource) {
        return this.dataSourceDtoBuilder.build(dataSource);
    }

    private List<DestinationDto> buildDestinations(List<Destination> destinations) {
        ArrayList<DestinationDto> dtos = new ArrayList<DestinationDto>();
        if (CollectionUtils.isNotEmpty(destinations)) {
            for (Destination destination : destinations) {
                dtos.add(this.buildDestination(destination));
            }
        }
        return dtos;
    }

    private DestinationDto buildDestination(Destination destination) {
        return this.destinationDtoBuilder.build(destination);
    }
}

