/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.support.dto.history.builder;

import com.plusmpm.util.HistoryVariable;
import com.suncode.plugin.pwe.web.support.dto.history.ActivityHistoryDto;
import com.suncode.pwfl.language.LanguageUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.springframework.stereotype.Component;

@Component
public class ActivityHistoryDtoBuilder {
    public static Logger log = Logger.getLogger(ActivityHistoryDtoBuilder.class);
    private static final String DEFAULT_ACTIVITY_USER_ID = "system";
    private static final String DEFAULT_ACTIVITY_PERFORMER = "System";
    private static final String STATE_CLOSED_COMPLETED = "1000007";
    private static final String STATE_OPEN_NOT_RUNNING_NOT_STARTED = "1000003";
    private static final String STATE_OPEN_RUNNING = "1000001";

    public List<ActivityHistoryDto> build(HistoryVariable[] historyVariables) {
        ArrayList<ActivityHistoryDto> dtos = new ArrayList<ActivityHistoryDto>();
        if (ArrayUtils.isNotEmpty((Object[])historyVariables)) {
            long currentTime = System.currentTimeMillis();
            for (HistoryVariable historyVariable : historyVariables) {
                try {
                    dtos.add(this.build(historyVariable, currentTime));
                }
                catch (BaseException exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return dtos;
    }

    public ActivityHistoryDto build(HistoryVariable historyVariable, long currentTime) throws BaseException {
        String activityState = historyVariable.getActivityState();
        ActivityHistoryDto dto = new ActivityHistoryDto();
        dto.setProcessId(historyVariable.getProcessKey());
        dto.setProcessDefId(historyVariable.getProcessDefId());
        dto.setActivityId(historyVariable.getActivityKey());
        dto.setActivityDefId(historyVariable.getActivityDefId());
        dto.setActivityName(historyVariable.getActivityName());
        dto.setActivityState(this.buildTranslatedActivityState(activityState));
        dto.setActivityUserId(StringUtils.defaultString((String)historyVariable.getUser(), (String)DEFAULT_ACTIVITY_USER_ID));
        dto.setActivityPerformer(StringUtils.defaultString((String)historyVariable.getActivityPerformer(), (String)DEFAULT_ACTIVITY_PERFORMER));
        dto.setActivityCreated(StringUtils.defaultString((String)historyVariable.getActivityCreateTime()));
        dto.setActivityStarted(StringUtils.defaultString((String)historyVariable.getActivityStartTime()));
        dto.setActivityFinished(StringUtils.defaultString((String)historyVariable.getActivityFinishTime()));
        dto.setActivityDuration(this.buildActivityDuration(historyVariable, currentTime, activityState));
        return dto;
    }

    private String buildTranslatedActivityState(String activityState) {
        try {
            int stateAsInteger = Integer.valueOf(activityState);
            return LanguageUtils.changeStateName((int)stateAsInteger, (boolean)false);
        }
        catch (NumberFormatException exception) {
            return LanguageUtils.changeStateName((String)activityState, (boolean)false);
        }
    }

    private long buildActivityDuration(HistoryVariable historyVariable, long currentTime, String activityState) {
        if (StringUtils.isBlank((CharSequence)historyVariable.getUser()) && (StringUtils.equalsIgnoreCase((CharSequence)activityState, (CharSequence)STATE_CLOSED_COMPLETED) || StringUtils.equalsIgnoreCase((CharSequence)activityState, (CharSequence)"closed.completed"))) {
            return new Long(1L);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)activityState, (CharSequence)STATE_OPEN_NOT_RUNNING_NOT_STARTED) || StringUtils.equalsIgnoreCase((CharSequence)activityState, (CharSequence)"open.not_running.not_started")) {
            return new Long(0L);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)activityState, (CharSequence)STATE_OPEN_RUNNING) || StringUtils.equalsIgnoreCase((CharSequence)activityState, (CharSequence)"open.running")) {
            return currentTime - historyVariable.getActlaststatetime();
        }
        return historyVariable.getActlaststatetime() - historyVariable.getActendtime();
    }
}

