/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.processmapimage.ProcessMapImageService;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/processmapimage"})
public class ProcessMapImageController {
    @Autowired
    private ProcessMapImageService processMapImageService;

    @RequestMapping(value={"generate"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generate(HttpServletRequest request, @RequestParam String processMapImage, @RequestParam String fileName) {
        String userId = RestUtils.getUserIdFromSession(request);
        String filename = this.buildFilename(fileName);
        byte[] bytes = this.processMapImageService.generate(userId, filename, processMapImage);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, filename);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private String buildFilename(String fileName) {
        StringBuilder filename = new StringBuilder();
        filename.append(fileName);
        filename.append(".png");
        return filename.toString();
    }

    private HttpHeaders buildHeaders(byte[] bytes, String fileName) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.IMAGE_PNG);
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", fileName);
        return responseHeaders;
    }
}

