/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.help.HelpService;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/help"})
public class HelpController {
    @Autowired
    private HelpService helpService;

    @RequestMapping(value={"get"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> get(@RequestParam String section) {
        byte[] bytes = this.helpService.getHelpFileBytes(section);
        HttpHeaders responseHeaders = this.buildHeaders(bytes);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private HttpHeaders buildHeaders(byte[] bytes) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.set("Content-Disposition", "filename=\"help.pdf\"");
        return responseHeaders;
    }
}

