/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.web.rest;

import com.suncode.plugin.pwe.service.documentation.DocumentationService;
import com.suncode.plugin.pwe.web.support.dto.documentation.AddDocumentationAttachmentDto;
import com.suncode.plugin.pwe.web.support.form.AddDocumentationAttachmentForm;
import com.suncode.plugin.pwe.web.support.form.ChangeCardForm;
import com.suncode.plugin.pwe.web.support.form.DocumentationForm;
import com.suncode.plugin.pwe.web.support.util.RestUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/documentation"})
public class DocumentationController {
    private static final String HTML_CONTENT_TYPE = "text/html";
    private static final String ZIP_CONTENT_TYPE = "application/zip";
    private static final String WORD_CONTENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    private static final String ATTACHMENT_CONTENT_TYPE = "application/octet-stream";
    @Autowired
    private DocumentationService documentationService;

    @RequestMapping(value={"generate"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generate(HttpServletRequest request, DocumentationForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        byte[] bytes = this.documentationService.generate(userId, form);
        String documentationFileName = this.buildZipFilename(form.getFileName());
        HttpHeaders responseHeaders = this.buildHeaders(bytes, ZIP_CONTENT_TYPE, documentationFileName);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"generateChangeCard"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> generateChangeCard(HttpServletRequest request, ChangeCardForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        byte[] bytes = this.documentationService.generateChangeCard(userId, form);
        String changeCardFileName = this.buildChangeCardFilename(form.getFileName());
        HttpHeaders responseHeaders = this.buildHeaders(bytes, WORD_CONTENT_TYPE, changeCardFileName);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"addAttachment"}, method={RequestMethod.POST})
    public ResponseEntity<AddDocumentationAttachmentDto> addAttachment(HttpServletRequest request, AddDocumentationAttachmentForm form) {
        String userId = RestUtils.getUserIdFromSession(request);
        AddDocumentationAttachmentDto dto = this.documentationService.addAttachment(userId, form);
        return this.buildHtmlResponse(dto);
    }

    @RequestMapping(value={"downloadAttachment"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> downloadAttachment(HttpServletRequest request, @RequestParam String attachmentDirectory, @RequestParam String fileName) throws IOException {
        String userId = RestUtils.getUserIdFromSession(request);
        byte[] bytes = this.documentationService.downloadAttachment(userId, attachmentDirectory, fileName);
        HttpHeaders responseHeaders = this.buildHeaders(bytes, ATTACHMENT_CONTENT_TYPE, fileName);
        return new ResponseEntity((Object)bytes, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"deleteAttachment"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean deleteAttachment(HttpServletRequest request, @RequestParam String attachmentDirectory, @RequestParam String fileName) {
        String userId = RestUtils.getUserIdFromSession(request);
        return this.documentationService.deleteAttachment(userId, attachmentDirectory, fileName);
    }

    private String buildZipFilename(String fileName) {
        StringBuilder filename = new StringBuilder();
        filename.append(fileName);
        filename.append(".zip");
        return filename.toString();
    }

    private String buildChangeCardFilename(String fileName) {
        StringBuilder filename = new StringBuilder();
        filename.append(fileName);
        filename.append(".docx");
        return filename.toString();
    }

    private HttpHeaders buildHeaders(byte[] bytes, String contentType, String filename) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)bytes));
        responseHeaders.setContentDispositionFormData("attachment", filename);
        return responseHeaders;
    }

    private <T> ResponseEntity<T> buildHtmlResponse(T dto) {
        HttpHeaders responseHeaders = this.buildHeaders(HTML_CONTENT_TYPE);
        return new ResponseEntity(dto, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private HttpHeaders buildHeaders(String contentType) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.parseMediaType((String)contentType));
        return responseHeaders;
    }
}

