/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.util;

import com.suncode.plugin.pwe.util.ExtAttrUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;

public enum VariableType {
    STRING("java.lang.String"),
    INTEGER("java.lang.Long"),
    FLOAT("java.lang.Double"),
    AMOUNT("java.lang.Double"),
    DATE("java.lang.String"),
    DATETIME("java.util.Date"),
    BOOLEAN("java.lang.Boolean"),
    TEXTAREA("java.lang.String"),
    CHECKBOX("java.lang.String"),
    RADIOBUTTON("java.lang.String"),
    LISTBOX("java.lang.String"),
    LISTBOX_EDIT("java.lang.String"),
    LISTBOX_NO_FILTER("java.lang.String"),
    LISTBOX_NO_FILTER_EDIT("java.lang.String"),
    LISTBOX_EDIT_NO_FILTER("java.lang.String"),
    LISTBOX_NO_LAZY("java.lang.String"),
    LISTBOX_NO_FILTER_NO_LAZY("java.lang.String"),
    LISTBOX_NO_LAZY_NO_FILTER("java.lang.String"),
    USERLIST("java.lang.String"),
    DATA_CHOOSER("java.lang.String"),
    USERLISTLISTBOX("java.lang.String"),
    ROLEUSERS("java.lang.String"),
    ROLEUSERS_NO_FILTER("java.lang.String"),
    UNKNOWN("");

    private static final String TABLE_PLACEMENT = "table";
    private static final String DATA_CHOOSER_EXT_ATTR_NAME = "DATA_CHOOSER";
    private static final String SUBTYPE_EXT_ATTR_NAME = "SUBTYPE";
    private static final String VALUES_EXT_ATTR_NAME = "VALUES";
    private static final String USERLIST_VALUES_EXT_ATTR_VALUE = "USERLIST";
    private static final String ROLEUSERS_VALUES_EXT_ATTR_VALUE = "ROLEUSERS";
    private static final String ROLEUSERS_NO_FILTER_VALUES_EXT_ATTR_VALUE = "ROLEUSERS_NO_FILTER";
    private static final String DECIMAL_PRECISION_EXT_ATTR_NAME = "DECIMAL_PRECISION";
    private static final String AMOUNT_DECIMAL_PRECISION_EXT_ATTR_VALUE = "2";
    private String classTypeName;

    private VariableType(String classTypeName) {
        this.classTypeName = classTypeName;
    }

    public String getClassTypeName() {
        return this.classTypeName;
    }

    public static VariableType getType(String type, String placement) {
        VariableType variableType = VariableType.valueOf(type);
        if (VariableType.shouldCheckPlacement(variableType) && StringUtils.equals((CharSequence)placement, (CharSequence)TABLE_PLACEMENT)) {
            return STRING;
        }
        return variableType;
    }

    private static boolean shouldCheckPlacement(VariableType variableType) {
        return variableType.equals((Object)INTEGER) || variableType.equals((Object)FLOAT) || variableType.equals((Object)AMOUNT);
    }

    public static VariableType getType(DataField dataField) {
        try {
            ExtendedAttributes extAttrs = dataField.getExtendedAttributes();
            if (ExtAttrUtils.hasExtAttr(extAttrs, DATA_CHOOSER_EXT_ATTR_NAME)) {
                return DATA_CHOOSER;
            }
            if (ExtAttrUtils.hasExtAttr(extAttrs, SUBTYPE_EXT_ATTR_NAME)) {
                if (ExtAttrUtils.hasExtAttr(extAttrs, VALUES_EXT_ATTR_NAME, USERLIST_VALUES_EXT_ATTR_VALUE)) {
                    return USERLISTLISTBOX;
                }
                if (ExtAttrUtils.hasExtAttr(extAttrs, VALUES_EXT_ATTR_NAME, ROLEUSERS_VALUES_EXT_ATTR_VALUE)) {
                    return ROLEUSERS;
                }
                if (ExtAttrUtils.hasExtAttr(extAttrs, VALUES_EXT_ATTR_NAME, ROLEUSERS_NO_FILTER_VALUES_EXT_ATTR_VALUE)) {
                    return ROLEUSERS_NO_FILTER;
                }
                String subtype = ExtAttrUtils.getExtAttrValue(extAttrs, SUBTYPE_EXT_ATTR_NAME);
                if (VariableType.isAmountVariableType(subtype, extAttrs)) {
                    return AMOUNT;
                }
                return VariableType.valueOf(subtype);
            }
            String type = dataField.getDataType().getDataTypes().getBasicType().getType();
            return VariableType.valueOf(type);
        }
        catch (Exception exception) {
            return UNKNOWN;
        }
    }

    private static boolean isAmountVariableType(String subtype, ExtendedAttributes extAttrs) {
        VariableType variableType = VariableType.valueOf(subtype);
        return variableType.equals((Object)FLOAT) && VariableType.isAmountDecimalPrecision(extAttrs);
    }

    private static boolean isAmountDecimalPrecision(ExtendedAttributes extAttrs) {
        String decimalPrecision = ExtAttrUtils.getExtAttrValue(extAttrs, DECIMAL_PRECISION_EXT_ATTR_NAME);
        return StringUtils.equals((CharSequence)decimalPrecision, (CharSequence)AMOUNT_DECIMAL_PRECISION_EXT_ATTR_VALUE);
    }
}

