/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.util;

import com.lutris.appserver.server.sql.DBTransaction;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.dods.DODS;
import org.enhydra.shark.repositorypersistence.data.XPDLDO;
import org.enhydra.shark.repositorypersistence.data.XPDLQuery;
import org.enhydra.shark.xpdl.XMLInterfaceForJDK13;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.RedefinableHeader;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;

public final class PweUtils {
    public static Logger log = Logger.getLogger(PweUtils.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String FILE_NAME_DATE_TIME_FORMAT = "yyyy-MM-dd HH_mm_ss";

    public static String getLanguage() {
        Locale locale = LocaleContextHolder.getLocale();
        return locale.getLanguage();
    }

    public static Package getPackage(byte[] xpdlBytes, boolean initCaches) throws TransformerException, UnsupportedEncodingException {
        return PweUtils.getPackage(new String(xpdlBytes, "UTF-8"), initCaches);
    }

    public static Package getPackage(String xpdlText, boolean initCaches) throws TransformerException {
        XMLInterfaceForJDK13 xmlInterface = new XMLInterfaceForJDK13();
        Package pack = xmlInterface.parseDocument(xpdlText, false);
        pack.setReadOnly(true);
        if (initCaches) {
            pack.initCaches();
        }
        return pack;
    }

    public static String buildFormattedDate(LocalDateTime localDateTime, String format) {
        if (localDateTime != null) {
            return localDateTime.format(DateTimeFormatter.ofPattern(format));
        }
        return "";
    }

    public static String buildFormattedDate(Timestamp timestamp, String format) {
        if (timestamp != null) {
            return PweUtils.buildFormattedDate(timestamp.getTime(), format);
        }
        return "";
    }

    public static String buildFormattedDate(long miliseconds, String format) {
        Date date = new Date(miliseconds);
        return PweUtils.buildFormattedDate(date, format);
    }

    public static String buildFormattedDate(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static boolean doesClassExistInClasspath(String qualifiedName) {
        try {
            Class.forName(qualifiedName);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResourceAsString(Resource resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String string = new String(bytes, "UTF-8");
            return string;
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            String string = "";
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPackageUploadTime(Package pack) {
        String uploadTime = "";
        DBTransaction transaction = null;
        try {
            transaction = DODS.getDatabaseManager().createTransaction();
            XPDLQuery query = new XPDLQuery(transaction);
            query.setQueryXPDLId(pack.getId());
            query.setQueryXPDLVersion(pack.getInternalVersion());
            query.requireUniqueInstance();
            XPDLDO xpdlDO = query.getNextDO();
            if (xpdlDO != null) {
                uploadTime = PweUtils.buildFormattedDate(xpdlDO.getXPDLUploadTime(), DATE_TIME_FORMAT);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            try {
                if (transaction != null) {
                    transaction.rollback();
                }
            }
            catch (SQLException sqlException) {
                log.error((Object)sqlException.getMessage(), (Throwable)sqlException);
            }
        }
        finally {
            if (transaction != null) {
                transaction.release();
            }
        }
        return uploadTime;
    }

    public static String getPackageAuthor(Package pack) {
        return Optional.ofNullable(pack.getRedefinableHeader()).map(RedefinableHeader::getAuthor).orElse("");
    }

    public static String buildSafePatternValue(String value) {
        String safeValue = StringUtils.replaceAll((String)value, (String)"\\\\", (String)"/");
        safeValue = StringUtils.replaceAll((String)safeValue, (String)"\\[", (String)"\\\\[");
        return StringUtils.replaceAll((String)safeValue, (String)"\\]", (String)"\\\\]");
    }

    private PweUtils() {
    }
}

