/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.upgrader;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.plugin.pwe.configuration.PluginSpringContext;
import com.suncode.plugin.pwe.service.formpreview.ProcessGlobalSettingsServiceImpl;
import com.suncode.plugin.pwe.upgrader.UpgraderUtils;
import com.suncode.plugin.pwe.util.FormVariableLabel;
import com.suncode.plugin.pwe.util.ProcessGlobalSettings;
import com.suncode.plugin.pwe.util.VariableSetFont;
import com.suncode.plugin.pwe.util.constant.DefaultStyles;
import com.suncode.plugin.pwe.util.exception.UpgraderException;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ResetGlobalDefaultStylesChange
implements CustomTaskChange {
    public static Logger log = Logger.getLogger(ResetGlobalDefaultStylesChange.class);

    public void execute(Database database) throws CustomChangeException {
        ProcessGlobalSettingsServiceImpl processGlobalSettingsService = PluginSpringContext.getBean(ProcessGlobalSettingsServiceImpl.class);
        ResetGlobalDefaultStylesChange.resetGlobalDefaultStylesForLoadedToSystem(processGlobalSettingsService);
        ResetGlobalDefaultStylesChange.resetGlobalDefaultStylesForStored(processGlobalSettingsService, "xpdl/saved");
        ResetGlobalDefaultStylesChange.resetGlobalDefaultStylesForStored(processGlobalSettingsService, "xpdl/autosaved");
        ResetGlobalDefaultStylesChange.resetGlobalDefaultStylesForStored(processGlobalSettingsService, "xpdl/uploaded");
    }

    private static void resetGlobalDefaultStylesForLoadedToSystem(ProcessGlobalSettingsServiceImpl processGlobalSettingsService) {
        XpdlPackageManager.getInstance().getPackageIds().forEach(packageId -> ResetGlobalDefaultStylesChange.resetGlobalDefaultStylesForLoadedToSystem(processGlobalSettingsService, packageId));
    }

    private static void resetGlobalDefaultStylesForLoadedToSystem(ProcessGlobalSettingsServiceImpl processGlobalSettingsService, String packageId) {
        XpdlPackageManager.getInstance().getPackageVersions(packageId).stream().map(String::valueOf).map(packageVersion -> processGlobalSettingsService.getForPackage(packageId, (String)packageVersion)).flatMap(Collection::stream).forEach(file -> ResetGlobalDefaultStylesChange.resetGlobalDefaultStyles(processGlobalSettingsService, file));
    }

    private static void resetGlobalDefaultStylesForStored(ProcessGlobalSettingsServiceImpl processGlobalSettingsService, String locationPrefix) {
        processGlobalSettingsService.getFromStored(locationPrefix).forEach(file -> ResetGlobalDefaultStylesChange.resetGlobalDefaultStyles(processGlobalSettingsService, file));
    }

    private static void resetGlobalDefaultStyles(ProcessGlobalSettingsServiceImpl processGlobalSettingsService, File file) {
        block14: {
            try {
                log.info((Object)("Analizowany plik: " + file.getAbsolutePath()));
                if (file.exists()) {
                    ProcessGlobalSettings processGlobalSettings = (ProcessGlobalSettings)processGlobalSettingsService.get(file.getAbsolutePath());
                    FormVariableLabel formVariableLabel = processGlobalSettings.getFormVariableLabel();
                    VariableSetFont variableSetFont = processGlobalSettings.getVariableSetFont();
                    if (formVariableLabel != null) {
                        if (ResetGlobalDefaultStylesChange.isEqualToDefaultValue(formVariableLabel.getLabelAlign(), "left")) {
                            formVariableLabel.setLabelAlign(null);
                        }
                        if (formVariableLabel.getLabelWidth() != null && ResetGlobalDefaultStylesChange.isEqualToDefaultValue(formVariableLabel.getLabelWidth().toString(), "200")) {
                            formVariableLabel.setLabelWidth(null);
                        }
                        if (ResetGlobalDefaultStylesChange.isEqualToDefaultValue(formVariableLabel.getLabelSeparator(), "")) {
                            formVariableLabel.setLabelSeparator(null);
                        }
                        if (formVariableLabel.getLabelFontSize() != null && ResetGlobalDefaultStylesChange.isEqualToDefaultValue(formVariableLabel.getLabelFontSize().toString(), DefaultStyles.LABEL_FONT_SIZE_VALUES)) {
                            formVariableLabel.setLabelFontSize(null);
                        }
                        if (ResetGlobalDefaultStylesChange.isEqualToDefaultValue(formVariableLabel.getLabelColor(), "#333333")) {
                            formVariableLabel.setLabelColor(null);
                        }
                        if (ResetGlobalDefaultStylesChange.isEqualToDefaultValue(formVariableLabel.getTextDecoration(), "none")) {
                            formVariableLabel.setTextDecoration(null);
                        }
                        processGlobalSettings.setFormVariableLabel(formVariableLabel);
                    }
                    if (variableSetFont != null) {
                        if (variableSetFont.getHeaderFontSize() != null && ResetGlobalDefaultStylesChange.isEqualToDefaultValue(variableSetFont.getHeaderFontSize().toString(), "13")) {
                            variableSetFont.setHeaderFontSize(null);
                        }
                        if (variableSetFont.getCellFontSize() != null && ResetGlobalDefaultStylesChange.isEqualToDefaultValue(variableSetFont.getCellFontSize().toString(), "13")) {
                            variableSetFont.setCellFontSize(null);
                        }
                        processGlobalSettings.setVariableSetFont(variableSetFont);
                    }
                    processGlobalSettingsService.loadToSystem(file, processGlobalSettings);
                } else {
                    log.info((Object)("Plik nie istnieje w lokalizacji: " + file.getAbsolutePath()));
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
                if (!UpgraderUtils.shouldStopMigration(exception)) break block14;
                throw new UpgraderException(exception);
            }
        }
    }

    private static boolean isEqualToDefaultValue(String value, String defaultValue) {
        return ResetGlobalDefaultStylesChange.isEqualToDefaultValue(value, Collections.singletonList(defaultValue));
    }

    private static boolean isEqualToDefaultValue(String value, List<String> defaultValues) {
        return defaultValues.stream().anyMatch(defaultValue -> StringUtils.equals((CharSequence)value, (CharSequence)defaultValue));
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

