/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.translator;

import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class TranslatorService {
    private static final String DOCUMENTATION_MESSAGE_FOR_TEXT_PREFIX = "pwe.documentation.text.";
    @Autowired
    private MessageSource messageSource;

    public String translateMessage(String key) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(key, null, key, locale);
    }

    public String translateDocumentationMessageForText(String text) {
        StringBuilder key = new StringBuilder();
        key.append(DOCUMENTATION_MESSAGE_FOR_TEXT_PREFIX);
        key.append(text);
        return this.translateMessage(key.toString());
    }

    public String translateDocumentationChapterTitle(String key) {
        return this.translateMessage(key);
    }

    public String translateDocumentationChapterTitle(int chapterNo, String key) {
        StringBuilder title = new StringBuilder();
        title.append(chapterNo);
        title.append(". ");
        title.append(this.translateMessage(key));
        return title.toString();
    }

    public String translateDocumentationSubchapterTitle(int subchapterNo, String key) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(this.translateMessage(key));
        return title.toString();
    }

    public String translateDocumentationSubchapterTitle(int chapterNo, int subchapterNo, String key) {
        StringBuilder title = new StringBuilder();
        title.append(chapterNo);
        title.append(".");
        title.append(subchapterNo);
        title.append(". ");
        title.append(this.translateMessage(key));
        return title.toString();
    }
}

