/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.service.jscode;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.plugin.pwe.dao.jscode.JsCodeDao;
import com.suncode.plugin.pwe.model.jscode.JsCode;
import com.suncode.plugin.pwe.service.jscode.JsCodeService;
import com.suncode.plugin.pwe.service.jscode.JsCodeTemplateService;
import com.suncode.plugin.pwe.service.zip.ZipService;
import com.suncode.plugin.pwe.util.AuditType;
import com.suncode.plugin.pwe.web.support.dto.jscode.JsCodeDto;
import com.suncode.plugin.pwe.web.support.dto.jscode.builder.JsCodeDtoBuilder;
import com.suncode.plugin.pwe.web.support.form.JsCodeForm;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Provides(value={JsCodeService.class})
public class JsCodeServiceImpl
implements JsCodeService {
    public static Logger log = Logger.getLogger(JsCodeServiceImpl.class);
    private static final String ENTER = System.getProperty("line.separator");
    private static final String CUF_PREFIX = "CUF";
    @Autowired
    private JsCodeDao jsCodeDao;
    @Autowired
    private JsCodeDtoBuilder jsCodeDtoBuilder;
    @Autowired
    private JsCodeTemplateService jsCodeTemplateService;
    @Autowired
    private ZipService zipService;

    @Override
    public JsCodeDto get(String userId, JsCodeForm form) {
        JsCode jsCode = this.jsCodeDao.getByFunctionName(form.getFunctionName());
        if (jsCode != null) {
            return this.jsCodeDtoBuilder.build(jsCode);
        }
        String sourceCode = this.jsCodeTemplateService.generateEmptySourceCode(form);
        return this.jsCodeDtoBuilder.build(userId, form.getFunctionName(), sourceCode);
    }

    @Override
    @Transactional
    public boolean set(JsCodeDto dto) {
        JsCode jsCode = this.jsCodeDao.getByFunctionName(dto.getFunctionName());
        if (jsCode != null) {
            jsCode.setSourceCode(dto.getSourceCode());
            this.jsCodeDao.update(jsCode);
            return true;
        }
        jsCode = this.jsCodeDtoBuilder.extract(dto);
        Long id = (Long)this.jsCodeDao.save(jsCode);
        return id != null;
    }

    @Override
    @Transactional
    public boolean set(String userId, JsCodeDto dto) {
        JsCode jsCode = this.jsCodeDao.getByFunctionName(dto.getFunctionName());
        if (jsCode != null) {
            jsCode.setSourceCode(dto.getSourceCode());
            this.jsCodeDao.update(jsCode);
            return true;
        }
        jsCode = this.jsCodeDtoBuilder.extract(userId, dto);
        Long id = (Long)this.jsCodeDao.save(jsCode);
        return id != null;
    }

    @Override
    @Transactional
    public boolean delete(String functionName) {
        JsCode jsCode = this.jsCodeDao.getByFunctionName(functionName);
        if (jsCode != null) {
            this.jsCodeDao.delete(jsCode);
            return true;
        }
        return false;
    }

    @Override
    public String getSourceCodeFromTemplate(JsCodeForm form) {
        return this.jsCodeTemplateService.generateSourceCode(form);
    }

    @Override
    public byte[] generate(String userId, String customJs) {
        Date started = new Date();
        ArrayList<String> functionNames = new ArrayList<String>();
        byte[] bytes = this.generate(customJs, functionNames);
        this.logGenerateScriptsAudit(userId, started, true, functionNames);
        return bytes;
    }

    private byte[] generate(String customJs, List<String> functionNames) {
        ArrayList<JsCode> jsCodes = new ArrayList<JsCode>();
        List forms = (List)new Gson().fromJson(customJs, new TypeToken<List<JsCodeForm>>(){}.getType());
        if (CollectionUtils.isNotEmpty((Collection)forms)) {
            String functionName;
            HashMap<String, JsCodeForm> functionsMap = new HashMap<String, JsCodeForm>();
            for (JsCodeForm form : forms) {
                functionName = form.getFunctionName();
                if (!this.isNotForbiddenFunctionName(functionName)) continue;
                functionNames.add(functionName);
                functionsMap.put(functionName, form);
            }
            if (CollectionUtils.isNotEmpty(functionNames)) {
                jsCodes.addAll(this.jsCodeDao.getAllByFunctionName(functionNames));
            }
            for (JsCode jsCode : jsCodes) {
                functionName = jsCode.getFunctionName();
                functionsMap.remove(functionName);
            }
            for (String functionName2 : functionsMap.keySet()) {
                JsCodeForm form = (JsCodeForm)functionsMap.get(functionName2);
                JsCode jsCode = new JsCode();
                jsCode.setFunctionName(form.getFunctionName());
                jsCode.setSourceCode(this.jsCodeTemplateService.generateEmptySourceCode(form));
                jsCodes.add(jsCode);
            }
        }
        StringBuilder body = new StringBuilder();
        if (CollectionUtils.isNotEmpty(jsCodes)) {
            for (JsCode jsCode : jsCodes) {
                body.append(jsCode.getSourceCode());
                body.append(ENTER);
                body.append(ENTER);
            }
        }
        return body.toString().getBytes(Charset.forName("UTF-8"));
    }

    private void logGenerateScriptsAudit(String userId, Date started, boolean success, List<String> functionNames) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pwe.audit.generate.scripts.param.functionnames", StringUtils.joinWith((String)", ", (Object[])new Object[]{functionNames}));
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_GENERATE_SCRIPTS.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private boolean isNotForbiddenFunctionName(String functionName) {
        return !StringUtils.startsWith((CharSequence)functionName, (CharSequence)CUF_PREFIX);
    }

    @Override
    public void addToZip(ZipOutputStream zipOutputStream, String packageId, String customJs) throws IOException {
        String fileName = this.buildCustomJsFileName(packageId);
        ArrayList<String> functionNames = new ArrayList<String>();
        byte[] bytes = this.generate(customJs, functionNames);
        this.zipService.addToZip(zipOutputStream, fileName, bytes);
    }

    private String buildCustomJsFileName(String packageId) {
        StringBuilder fileName = new StringBuilder();
        fileName.append("suncodescripts_");
        fileName.append(packageId);
        fileName.append(".js");
        return fileName.toString();
    }
}

