/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.paragraph.builder;

import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TextValue;
import com.suncode.plugin.pwe.documentation.enumeration.DefinedVariable;
import com.suncode.plugin.pwe.documentation.enumeration.Operator;
import com.suncode.plugin.pwe.documentation.object.AcceptButton;
import com.suncode.plugin.pwe.documentation.object.AcceptButtonAction;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.TransitionCondition;
import com.suncode.plugin.pwe.documentation.object.builder.TransitionConditionBuilder;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentsUtils;
import com.suncode.plugin.pwe.documentation.util.TextUtils;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.documentation.util.TransitionConditionUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransitionConditionParagraphContentsBuilder {
    private static final String CONJUNCTION_SIGN = "&&";
    private static final String AND = "pwe.documentation.text.and";
    private static final String DISJUNCTION_SIGN = "||";
    private static final String OR = "pwe.documentation.text.or";
    private static final String ACTION_FORMAL_PARAMETER_ID = "Action";
    private static final String ACTION_BUTTON_CLICK = "pwe.documentation.text.actionbuttonclick";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private TransitionConditionBuilder transitionConditionBuilder;

    public ParagraphContents build(WorkflowProcess process, String condition, ActivityForm activityForm) {
        if (TransitionConditionUtils.isCustomTransitionCondition(condition)) {
            return ParagraphContentsUtils.build(this.translateSigns(condition));
        }
        ParagraphContents contents = new ParagraphContents();
        String joinSign = TransitionConditionUtils.getSubconditionsJoinSign(condition);
        List<TransitionCondition> transitionConditions = this.buildTransitionConditions(condition, joinSign);
        if (CollectionUtils.isNotEmpty(transitionConditions)) {
            int transitionConditionsSize = CollectionUtils.size(transitionConditions);
            int counter = 1;
            for (TransitionCondition transitionCondition : transitionConditions) {
                AcceptButton acceptButton;
                if (this.isActionButtonClickCondition(transitionCondition, acceptButton = this.getAcceptButtonForCondition(transitionCondition, activityForm))) {
                    ParagraphContent actionButtonClickContent;
                    if (transitionConditionsSize == counter) {
                        actionButtonClickContent = this.buildBasicContent(this.buildActionButtonClickText(transitionCondition, acceptButton));
                        contents.addContent(actionButtonClickContent);
                    } else {
                        actionButtonClickContent = this.buildBasicContent(this.buildActionButtonClickText(transitionCondition, joinSign, acceptButton));
                        contents.addContent(actionButtonClickContent);
                    }
                } else {
                    contents.addContent(this.buildBookmarkContent(process, transitionCondition.getVariableId()));
                    if (transitionConditionsSize == counter) {
                        contents.addContent(this.buildBasicContent(this.buildOperatorText(transitionCondition)));
                        contents.addContent(this.buildBookmarkContent(process, transitionCondition.getValue()));
                    } else {
                        contents.addContent(this.buildBasicContent(this.buildOperatorText(transitionCondition)));
                        contents.addContent(this.buildBookmarkContent(process, transitionCondition.getValue()));
                        contents.addContent(this.buildBasicContent(this.buildJoinSignText(joinSign)));
                    }
                }
                ++counter;
            }
        }
        return contents;
    }

    private String translateSigns(String text) {
        text = StringUtils.replace((String)text, (String)CONJUNCTION_SIGN, (String)this.translatorService.translateMessage(AND));
        text = StringUtils.replace((String)text, (String)DISJUNCTION_SIGN, (String)this.translatorService.translateMessage(OR));
        return text;
    }

    private List<TransitionCondition> buildTransitionConditions(String condition, String joinSign) {
        return this.transitionConditionBuilder.build(condition, joinSign);
    }

    private AcceptButton getAcceptButtonForCondition(TransitionCondition transitionCondition, ActivityForm activityForm) {
        if (CollectionUtils.isNotEmpty(activityForm.getAcceptButtons())) {
            String actionName = transitionCondition.getValue();
            for (AcceptButton acceptButton : activityForm.getAcceptButtons()) {
                if (!StringUtils.equals((CharSequence)acceptButton.getActionName(), (CharSequence)actionName)) continue;
                return acceptButton;
            }
        }
        return null;
    }

    private boolean isActionButtonClickCondition(TransitionCondition transitionCondition, AcceptButton acceptButton) {
        if (this.isActionFormalParameterEqualCondition(transitionCondition)) {
            return this.hasActionFormalParameterEqualConditionAction(acceptButton);
        }
        return false;
    }

    private boolean isActionFormalParameterEqualCondition(TransitionCondition transitionCondition) {
        return StringUtils.equalsIgnoreCase((CharSequence)transitionCondition.getVariableId(), (CharSequence)ACTION_FORMAL_PARAMETER_ID) && transitionCondition.getOperator().equals((Object)Operator.EQUAL);
    }

    private boolean hasActionFormalParameterEqualConditionAction(AcceptButton acceptButton) {
        if (acceptButton != null && CollectionUtils.isNotEmpty(acceptButton.getActions())) {
            for (AcceptButtonAction action : acceptButton.getActions()) {
                if (!StringUtils.equals((CharSequence)action.getId(), (CharSequence)ACTION_FORMAL_PARAMETER_ID)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private String buildActionButtonClickText(TransitionCondition transitionCondition, AcceptButton acceptButton) {
        StringBuilder text = new StringBuilder();
        text.append(this.translatorService.translateMessage(ACTION_BUTTON_CLICK));
        text.append(": ");
        text.append(this.buildActionButtonName(transitionCondition, acceptButton));
        return text.toString();
    }

    private String buildActionButtonName(TransitionCondition transitionCondition, AcceptButton acceptButton) {
        if (acceptButton != null) {
            return acceptButton.getButtonName();
        }
        return transitionCondition.getValue();
    }

    private String buildActionButtonClickText(TransitionCondition transitionCondition, String joinSign, AcceptButton acceptButton) {
        StringBuilder text = new StringBuilder();
        text.append(this.buildActionButtonClickText(transitionCondition, acceptButton));
        text.append(" ");
        text.append(this.translateSigns(joinSign));
        text.append(" ");
        return text.toString();
    }

    private ParagraphContent buildBasicContent(String text) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildBasicTextValue(text));
        return content;
    }

    private ParagraphContent buildBookmarkContent(WorkflowProcess process, String text) {
        ParagraphContent content = new ParagraphContent();
        if (this.isDefinedVariable(text)) {
            content.setTextValue(this.buildBasicTextValue(this.buildDefinedVariableText(text)));
        } else if (process.getDataFields().containsElement(text)) {
            DataField dataField = process.getDataField(text);
            content.setTextValue(this.buildBookmarkTextValue(dataField));
        } else {
            content.setTextValue(this.buildBasicTextValue(text));
        }
        return content;
    }

    private boolean isDefinedVariable(String value) {
        switch (DefinedVariable.getByName(value)) {
            case UNKNOWN: {
                return false;
            }
        }
        return true;
    }

    private String buildDefinedVariableText(String value) {
        return this.translatorService.translateDocumentationMessageForText(TextUtils.generateTranslationText(value));
    }

    private TextValue buildBookmarkTextValue(DataField dataField) {
        TextValue textValue = new TextValue();
        textValue.setBookmarkHyperlink(true);
        textValue.setBookmarkName(this.buildBookmarkName(dataField.getId()));
        textValue.setText(dataField.getName());
        return textValue;
    }

    private String buildBookmarkName(String id) {
        return BookmarkNameUtils.getNameForProcessVariable(id);
    }

    private TextValue buildBasicTextValue(String text) {
        return TextValueUtils.build(text);
    }

    private String buildOperatorText(TransitionCondition transitionCondition) {
        StringBuilder text = new StringBuilder();
        text.append(" ");
        text.append(this.translatorService.translateMessage(transitionCondition.getOperator().getBundleKey()));
        text.append(" ");
        return text.toString();
    }

    private String buildJoinSignText(String joinSign) {
        StringBuilder text = new StringBuilder();
        text.append(" ");
        text.append(this.translateSigns(joinSign));
        text.append(" ");
        return text.toString();
    }
}

