/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.object.ToolParameter;
import com.suncode.plugin.pwe.documentation.object.ToolParameters;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.ActualParameter;
import org.enhydra.shark.xpdl.elements.ActualParameters;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.FormalParameter;
import org.enhydra.shark.xpdl.elements.FormalParameters;
import org.enhydra.shark.xpdl.elements.Tool;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.stereotype.Component;

@Component
public class ToolParametersBuilder {
    public ToolParameters build(WorkflowProcess process, Application application, Tool tool) {
        ToolParameters parameters = new ToolParameters();
        ArrayList<ToolParameter> inputParameters = new ArrayList<ToolParameter>();
        ArrayList<ToolParameter> outputParameters = new ArrayList<ToolParameter>();
        FormalParameters formalParameters = application.getApplicationTypes().getFormalParameters();
        ActualParameters actualParameters = tool.getActualParameters();
        if (!actualParameters.isEmpty()) {
            for (int i = 0; i < actualParameters.size(); ++i) {
                ActualParameter actualParameter = (ActualParameter)actualParameters.get(i);
                FormalParameter formalParameter = (FormalParameter)formalParameters.get(i);
                if (this.isInputParameter(formalParameter)) {
                    inputParameters.add(this.buildToolParameter(process, actualParameter));
                }
                if (!this.isOutputParameter(formalParameter)) continue;
                outputParameters.add(this.buildToolParameter(process, actualParameter));
            }
        }
        parameters.setInputParameters(inputParameters);
        parameters.setOutputParameters(outputParameters);
        return parameters;
    }

    private boolean isInputParameter(FormalParameter formalParameter) {
        String mode = formalParameter.getMode();
        return StringUtils.equals((CharSequence)mode, (CharSequence)"IN") || StringUtils.equals((CharSequence)mode, (CharSequence)"INOUT");
    }

    private boolean isOutputParameter(FormalParameter formalParameter) {
        String mode = formalParameter.getMode();
        return StringUtils.equals((CharSequence)mode, (CharSequence)"OUT") || StringUtils.equals((CharSequence)mode, (CharSequence)"INOUT");
    }

    private ToolParameter buildToolParameter(WorkflowProcess process, ActualParameter actualParameter) {
        ToolParameter parameter = new ToolParameter();
        parameter.setId(actualParameter.toValue());
        return parameter;
    }
}

