/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.TextValue;
import com.suncode.plugin.pwe.documentation.enumeration.AssignmentConfig;
import com.suncode.plugin.pwe.documentation.enumeration.DefinedVariable;
import com.suncode.plugin.pwe.documentation.util.ActivityUtils;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParticipantUtils;
import com.suncode.plugin.pwe.documentation.util.TextUtils;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.documentation.util.VariableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityPerformerParagraphContentsBuilder {
    private static final String SET_ASSIGNMENT_EXT_ATTR_NAME = "SET_ASSIGNMENT";
    private static final String ASSIGNMENT_BY_LOGIN_IN_VARIABLE = "pwe.documentation.text.assignmentbylogininvariable";
    private static final String ASSIGNMENT_BY_LOGIN_SUPERIOR_IN_VARIABLE = "pwe.documentation.text.assignmentbyloginsuperiorinvariable";
    private static final String AND_LOGIN_SUPERIOR_IN_VARIABLE = "pwe.documentation.text.andloginsuperiorinvariable";
    private static final String ASSIGNMENT_BY_ROLE = "pwe.documentation.text.assignmentbyrole";
    private static final String SYSTEM = "pwe.documentation.text.system";
    private static final String UNKNOWN = "pwe.documentation.text.unknown";
    private static final String PARTICIPANT_ID_EXT_ATTR_NAME = "JaWE_GRAPH_PARTICIPANT_ID";
    @Autowired
    private TranslatorService translatorService;

    public ParagraphContents build(WorkflowProcess process, Activity activity) {
        ExtendedAttributes extAttrs = activity.getExtendedAttributes();
        if (ExtAttrUtils.hasExtAttr(extAttrs, SET_ASSIGNMENT_EXT_ATTR_NAME)) {
            return this.buildAssignmentByVariableValueContents(process, activity, extAttrs);
        }
        return this.buildAssignmentByRoleContents(process, activity);
    }

    private ParagraphContents buildAssignmentByVariableValueContents(WorkflowProcess process, Activity activity, ExtendedAttributes extAttrs) {
        String setAssignment = ExtAttrUtils.getExtAttrValue(extAttrs, SET_ASSIGNMENT_EXT_ATTR_NAME);
        String[] configs = setAssignment.split("\n");
        String[] config = configs[0].split("=");
        switch (AssignmentConfig.getByName(config[0])) {
            case newAssignment: {
                return this.buildAssignmentByLoginInVariableContents(process, config);
            }
            case superior: {
                return this.buildAssignmentByLoginSuperiorInVariableContents(process, config);
            }
            case superior_role: {
                return this.buildAssignmentByRoleAndLoginSuperiorInVariableContents(process, activity, config);
            }
        }
        return this.buildUnknownAssignmentContents();
    }

    private ParagraphContents buildAssignmentByLoginInVariableContents(WorkflowProcess process, String[] config) {
        return this.buildAssignmentByVariableContents(process, config, ASSIGNMENT_BY_LOGIN_IN_VARIABLE);
    }

    private ParagraphContents buildAssignmentByLoginSuperiorInVariableContents(WorkflowProcess process, String[] config) {
        return this.buildAssignmentByVariableContents(process, config, ASSIGNMENT_BY_LOGIN_SUPERIOR_IN_VARIABLE);
    }

    private ParagraphContents buildAssignmentByVariableContents(WorkflowProcess process, String[] config, String prefixKey) {
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(this.buildPrefixContent(prefixKey));
        contents.addContent(this.buildAssignmentVariableNameContent(process, config));
        return contents;
    }

    private ParagraphContent buildPrefixContent(String prefixKey) {
        String text = this.buildPrefixText(prefixKey);
        return this.buildBasicContent(text);
    }

    private String buildPrefixText(String prefixKey) {
        StringBuilder text = new StringBuilder();
        text.append(this.translatorService.translateMessage(prefixKey));
        text.append(": ");
        return text.toString();
    }

    private ParagraphContent buildBasicContent(String text) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildBasicTextValue(text));
        return content;
    }

    private TextValue buildBasicTextValue(String text) {
        return TextValueUtils.build(text);
    }

    private ParagraphContent buildAssignmentVariableNameContent(WorkflowProcess process, String[] config) {
        String variableId = null;
        variableId = config.length > 1 ? config[1] : config[0];
        if (this.isDefinedVariable(variableId)) {
            return this.buildBasicContent(this.buildDefinedVariableText(variableId));
        }
        if (process.getDataFields().containsElement(variableId)) {
            return this.buildVariableBookmarkContent(process, variableId);
        }
        return this.buildBasicContent(VariableUtils.getName(process, variableId));
    }

    private boolean isDefinedVariable(String value) {
        switch (DefinedVariable.getByName(value)) {
            case UNKNOWN: {
                return false;
            }
        }
        return true;
    }

    private String buildDefinedVariableText(String value) {
        return this.translatorService.translateDocumentationMessageForText(TextUtils.generateTranslationText(value));
    }

    private ParagraphContent buildVariableBookmarkContent(WorkflowProcess process, String variableId) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildVariableBookmarkTextValue(process, variableId));
        return content;
    }

    private TextValue buildVariableBookmarkTextValue(WorkflowProcess process, String variableId) {
        TextValue textValue = new TextValue();
        textValue.setBookmarkHyperlink(true);
        textValue.setBookmarkName(this.buildVariableBookmarkName(variableId));
        textValue.setText(VariableUtils.getName(process, variableId));
        return textValue;
    }

    private String buildVariableBookmarkName(String id) {
        return BookmarkNameUtils.getNameForProcessVariable(id);
    }

    private ParagraphContents buildAssignmentByRoleAndLoginSuperiorInVariableContents(WorkflowProcess process, Activity activity, String[] config) {
        ParagraphContents contents = new ParagraphContents();
        contents.addContents(this.buildAssignmentByRoleContents(process, activity));
        contents.addContent(this.buildBasicContent(" "));
        contents.addContent(this.buildPrefixContent(AND_LOGIN_SUPERIOR_IN_VARIABLE));
        contents.addContent(this.buildAssignmentVariableNameContent(process, config));
        return contents;
    }

    private ParagraphContents buildAssignmentByRoleContents(WorkflowProcess process, Activity activity) {
        ParagraphContents contents = new ParagraphContents();
        if (ActivityUtils.isRoute(activity)) {
            contents.addContent(this.buildBasicContent(this.buildSystemPerformerText()));
        } else {
            contents.addContent(this.buildPrefixContent(ASSIGNMENT_BY_ROLE));
            contents.addContent(this.buildParticipantContent(process, activity));
        }
        return contents;
    }

    private String buildSystemPerformerText() {
        return this.translatorService.translateMessage(SYSTEM);
    }

    private ParagraphContent buildParticipantContent(WorkflowProcess process, Activity activity) {
        ExtendedAttributes extAttrs = activity.getExtendedAttributes();
        String participantId = ExtAttrUtils.getExtAttrValue(extAttrs, PARTICIPANT_ID_EXT_ATTR_NAME);
        Participant participant = ParticipantUtils.getParticipant(process, participantId);
        if (participant != null) {
            return this.buildParticipantBookmarkContent(participant);
        }
        return this.buildBasicContent(this.buildUnknownText());
    }

    private ParagraphContent buildParticipantBookmarkContent(Participant participant) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildParticipantBookmarkTextValue(participant));
        return content;
    }

    private TextValue buildParticipantBookmarkTextValue(Participant participant) {
        TextValue textValue = new TextValue();
        textValue.setBookmarkHyperlink(true);
        textValue.setBookmarkName(this.buildParticipantBookmarkName(participant.getId()));
        textValue.setText(participant.getName());
        return textValue;
    }

    private String buildParticipantBookmarkName(String id) {
        return BookmarkNameUtils.getNameForParticipant(id);
    }

    private ParagraphContents buildUnknownAssignmentContents() {
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(this.buildUnknownAssignmentContent());
        return contents;
    }

    private ParagraphContent buildUnknownAssignmentContent() {
        return this.buildBasicContent(this.buildUnknownText());
    }

    private String buildUnknownText() {
        return this.translatorService.translateMessage(UNKNOWN);
    }
}

