/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.object.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.util.ImageUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Activity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityFormImageAdder {
    public static Logger log = Logger.getLogger(ActivityFormImageAdder.class);
    private static final String ACTIVITY_FORM = "pwe.documentation.text.activityform";
    @Autowired
    private TranslatorService translatorService;

    public void add(Documentation documentation, Activity activity, ActivitySpecification activitySpecification) {
        try {
            byte[] bytes = ImageUtils.getBase64EncodedBytes(activitySpecification.getFormImage());
            String fileNameHint = this.buildFileNameHint(activity);
            documentation.addImage(bytes, fileNameHint);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private String buildFileNameHint(Activity activity) {
        String pattern = this.translatorService.translateMessage(ACTIVITY_FORM);
        return MessageFormat.format(pattern, activity.getName());
    }
}

