/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.comparator.subcomparator.ProcessSpecificationSubcomparator;
import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.specification.ProjectExclusionSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectExclusionSpecificationsSubcomparator")
public class ProjectExclusionSpecificationsSubcomparatorImpl
implements ProcessSpecificationSubcomparator<List<ProjectExclusionSpecification>> {
    private static final String CONTENTS_MODIFIED = "pwe.documentation.changecard.modified.projectexclusioncontents";
    private static final String PROCESS_EXCLUSION_ADDED = "pwe.documentation.changecard.added.projectexclusion";
    private static final String PROCESS_EXCLUSION_DELETED = "pwe.documentation.changecard.deleted.projectexclusion";
    @Autowired
    private DifferenceBuilder differenceBuilder;

    @Override
    public List<Difference> compare(WorkflowProcess baseProcess, List<ProjectExclusionSpecification> base, WorkflowProcess comparedProcess, List<ProjectExclusionSpecification> compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, ProjectExclusionSpecification> baseMap = this.convertToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (ProjectExclusionSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getName())) {
                    ProjectExclusionSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                    differences.addAll(this.compare(comparedSpecification.getName(), baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(PROCESS_EXCLUSION_ADDED, comparedSpecification.getName()));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (ProjectExclusionSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(PROCESS_EXCLUSION_DELETED, baseSpecification.getName()));
            }
        }
        return differences;
    }

    private Map<String, ProjectExclusionSpecification> convertToMap(List<ProjectExclusionSpecification> list) {
        HashMap<String, ProjectExclusionSpecification> map = new HashMap<String, ProjectExclusionSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ProjectExclusionSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compare(String name, ProjectExclusionSpecification base, ProjectExclusionSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getContents(), (CharSequence)compared.getContents())) {
            differences.add(this.differenceBuilder.build(CONTENTS_MODIFIED, name, base.getContents(), compared.getContents()));
        }
        return differences;
    }
}

