/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.comparator.subcomparator;

import com.suncode.plugin.pwe.documentation.object.Difference;
import com.suncode.plugin.pwe.documentation.object.builder.DifferenceBuilder;
import com.suncode.plugin.pwe.documentation.specification.ParameterSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParameterSpecificationsSubcomparator {
    @Autowired
    private DifferenceBuilder differenceBuilder;

    public List<Difference> compare(String containerName, String descriptionModifiedKey, String addedKey, String deletedKey, List<ParameterSpecification> base, List<ParameterSpecification> compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, ParameterSpecification> baseMap = this.convertParametersToMap(base);
        if (CollectionUtils.isNotEmpty(compared)) {
            for (ParameterSpecification comparedSpecification : compared) {
                if (baseMap.containsKey(comparedSpecification.getName())) {
                    ParameterSpecification baseSpecification = baseMap.remove(comparedSpecification.getName());
                    differences.addAll(this.compare(containerName, comparedSpecification.getName(), descriptionModifiedKey, baseSpecification, comparedSpecification));
                    continue;
                }
                differences.add(this.differenceBuilder.build(addedKey, comparedSpecification.getName(), containerName));
            }
        }
        if (MapUtils.isNotEmpty(baseMap)) {
            for (ParameterSpecification baseSpecification : baseMap.values()) {
                differences.add(this.differenceBuilder.build(deletedKey, baseSpecification.getName(), containerName));
            }
        }
        return differences;
    }

    private Map<String, ParameterSpecification> convertParametersToMap(List<ParameterSpecification> list) {
        HashMap<String, ParameterSpecification> map = new HashMap<String, ParameterSpecification>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ParameterSpecification element : list) {
                map.put(element.getName(), element);
            }
        }
        return map;
    }

    private List<Difference> compare(String containerName, String name, String descriptionModifiedKey, ParameterSpecification base, ParameterSpecification compared) {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)base.getDescription(), (CharSequence)compared.getDescription())) {
            differences.add(this.differenceBuilder.build(descriptionModifiedKey, name, containerName, base.getDescription(), compared.getDescription()));
        }
        return differences;
    }
}

