/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.Table;
import com.suncode.plugin.pwe.documentation.TableCell;
import com.suncode.plugin.pwe.documentation.TableHeader;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecord;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.object.DtButton;
import com.suncode.plugin.pwe.documentation.object.VariableSet;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.DtButtonSpecification;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.documentation.util.TableUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VariableSetDtButtonsPointBuilder {
    private static final String NAME_TABLE_COLUMN_ID = "name";
    private static final String NAME_TABLE_HEADER = "pwe.documentation.table.header.name";
    private static final String ACTION_TABLE_COLUMN_ID = "action";
    private static final String ACTION_TABLE_HEADER = "pwe.documentation.table.header.action";
    private static final String DESCRIPTION_TABLE_COLUMN_ID = "description";
    private static final String DESCRIPTION_TABLE_HEADER = "pwe.documentation.table.header.description";
    private static final String NO_NAME_VALUE = "-";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;

    public Table build(WorkflowProcess process, ActivitySpecification activitySpecification, VariableSet variableSet) {
        TableHeaders headers = this.buildTableHeaders();
        TableRecords records = new TableRecords();
        for (DtButton dtButton : variableSet.getDtButtons()) {
            DtButtonSpecification dtBbuttonSpecification = this.getDtButtonSpecification(activitySpecification, dtButton);
            records.add(this.buildTableRecord(process, dtButton, dtBbuttonSpecification));
        }
        Table table = new Table();
        table.setHeaders(headers);
        table.setRecords(records);
        return table;
    }

    private TableHeaders buildTableHeaders() {
        TableHeaders headers = new TableHeaders();
        headers.add(this.buildTableNameHeader());
        headers.add(this.buildTableActionHeader());
        headers.add(this.buildTableDescriptionHeader());
        return headers;
    }

    private TableHeader buildTableNameHeader() {
        return TableUtils.buildTableHeader(NAME_TABLE_COLUMN_ID, this.translatorService.translateMessage(NAME_TABLE_HEADER));
    }

    private TableHeader buildTableActionHeader() {
        return TableUtils.buildTableHeader(ACTION_TABLE_COLUMN_ID, this.translatorService.translateMessage(ACTION_TABLE_HEADER));
    }

    private TableHeader buildTableDescriptionHeader() {
        return TableUtils.buildTableHeader(DESCRIPTION_TABLE_COLUMN_ID, this.translatorService.translateMessage(DESCRIPTION_TABLE_HEADER));
    }

    private DtButtonSpecification getDtButtonSpecification(ActivitySpecification activitySpecification, DtButton dtButton) {
        String id = dtButton.getId();
        if (MapUtils.isNotEmpty(activitySpecification.getDtButtonSpecifications()) && activitySpecification.getDtButtonSpecifications().containsKey(id)) {
            return activitySpecification.getDtButtonSpecifications().get(id);
        }
        return new DtButtonSpecification();
    }

    private TableRecord buildTableRecord(WorkflowProcess process, DtButton dtButton, DtButtonSpecification dtBbuttonSpecification) {
        TableRecord record = new TableRecord();
        record.addCell(NAME_TABLE_COLUMN_ID, this.buildTableRecordNameCell(dtButton));
        record.addCell(ACTION_TABLE_COLUMN_ID, this.buildTableRecordActionCell(dtButton));
        record.addCell(DESCRIPTION_TABLE_COLUMN_ID, this.buildTableRecordDescriptionCell(process, dtBbuttonSpecification));
        return record;
    }

    private TableCell buildTableRecordNameCell(DtButton dtButton) {
        String text = (String)StringUtils.defaultIfBlank((CharSequence)dtButton.getName(), (CharSequence)NO_NAME_VALUE);
        return this.buildTableCell(text);
    }

    private TableCell buildTableCell(String text) {
        return TableUtils.buildTableCell(text);
    }

    private TableCell buildTableRecordActionCell(DtButton dtButton) {
        String text = dtButton.getHandler();
        return this.buildTableCell(text);
    }

    private TableCell buildTableRecordDescriptionCell(WorkflowProcess process, DtButtonSpecification dtBbuttonSpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, dtBbuttonSpecification.getDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(0));
        return this.buildTableCell(contents);
    }

    private TableCell buildTableCell(ParagraphContents contents) {
        return TableUtils.buildTableCell(contents);
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, description);
    }
}

