/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.Table;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.TextValue;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.IntegrationComponentParametersPointBuilder;
import com.suncode.plugin.pwe.documentation.object.IntegrationComponent;
import com.suncode.plugin.pwe.documentation.paragraph.builder.IntegrationComponentConditionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntegrationComponentsPointBuilder<T extends IntegrationComponent> {
    private static final String CONDITION_POINT_TITLE = "pwe.documentation.point.title.condition";
    private static final String PARAMETERS_POINT_TITLE = "pwe.documentation.point.title.parameters";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private IntegrationComponentConditionParagraphContentsBuilder integrationComponentConditionParagraphContentsBuilder;
    @Autowired
    private IntegrationComponentParametersPointBuilder integrationComponentParametersPointBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    public void build(Documentation documentation, WorkflowProcess process, List<T> integrationComponents, String pointTitleKey, int leftIndents) {
        this.buildTitle(documentation, pointTitleKey, leftIndents);
        for (IntegrationComponent integrationComponent : integrationComponents) {
            this.buildPoints(documentation, process, integrationComponent, leftIndents);
        }
    }

    private void buildTitle(Documentation documentation, String pointTitleKey, int leftIndents) {
        String title = this.buildTitle(pointTitleKey);
        this.buildPoint(documentation, title, leftIndents);
    }

    private String buildTitle(String pointTitleKey) {
        StringBuilder title = new StringBuilder();
        title.append(this.translatorService.translateMessage(pointTitleKey));
        title.append(":");
        return title.toString();
    }

    private void buildPoints(Documentation documentation, WorkflowProcess process, IntegrationComponent integrationComponent, int leftIndents) {
        this.buildNamePoint(documentation, integrationComponent, leftIndents);
        if (integrationComponent.getCondition() != null) {
            this.buildConditionPoint(documentation, process, integrationComponent, leftIndents);
        }
        if (CollectionUtils.isNotEmpty(integrationComponent.getParameters())) {
            this.buildParametersPoint(documentation, process, integrationComponent, leftIndents);
        }
    }

    private void buildNamePoint(Documentation documentation, IntegrationComponent integrationComponent, int leftIndents) {
        ParagraphContents contents = this.buildNameContents(integrationComponent);
        contents.setIndents(ParagraphIndentsUtils.buildLeft(leftIndents + 1));
        this.buildPoint(documentation, contents);
    }

    private ParagraphContents buildNameContents(IntegrationComponent integrationComponent) {
        ParagraphContents contents = new ParagraphContents();
        contents.add(this.buildNameContent(integrationComponent));
        return contents;
    }

    private ParagraphContent buildNameContent(IntegrationComponent integrationComponent) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(this.buildTextValue(integrationComponent.getName()));
        content.setBold(true);
        return content;
    }

    private TextValue buildTextValue(String text) {
        TextValue textValue = new TextValue();
        textValue.setText(text);
        return textValue;
    }

    private void buildConditionPoint(Documentation documentation, WorkflowProcess process, IntegrationComponent integrationComponent, int leftIndents) {
        ParagraphContents contents = this.integrationComponentConditionParagraphContentsBuilder.build(process, integrationComponent.getContextVariables(), integrationComponent.getCondition());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(leftIndents + 2));
        this.buildPoint(documentation, CONDITION_POINT_TITLE, leftIndents + 2, contents);
    }

    private void buildParametersPoint(Documentation documentation, WorkflowProcess process, IntegrationComponent integrationComponent, int leftIndents) {
        Table table = this.integrationComponentParametersPointBuilder.build(process, integrationComponent);
        this.buildPoint(documentation, PARAMETERS_POINT_TITLE, table.getHeaders(), table.getRecords(), leftIndents + 2);
    }

    private void buildPoint(Documentation documentation, String title, int leftIndents) {
        this.subchapterBuilder.build(documentation, title, leftIndents);
    }

    private void buildPoint(Documentation documentation, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, contents);
    }

    private void buildPoint(Documentation documentation, String titleKey, int leftIndents, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, leftIndents, contents);
    }

    private void buildPoint(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records, int leftIndents) {
        this.subchapterBuilder.build(documentation, titleKey, leftIndents, headers, records);
    }
}

