/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.IntegrationComponentsPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.FormAction;
import com.suncode.plugin.pwe.documentation.object.FormButton;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ButtonSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.LeftIndents;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityFormButtonsPointBuilder")
public class ActivityFormButtonsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String BUTTON_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.buttondescription";
    private static final String ACTION_POINT_TITLE = "pwe.documentation.point.title.action";
    private static final String FORM_ACTIONS_POINT_TITLE = "pwe.documentation.point.title.formactions";
    @Autowired
    private IntegrationComponentsPointBuilder<FormAction> formActionsIntegrationComponentsPointBuilder;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        for (FormButton formButton : activityForm.getFormButtons()) {
            this.buildPoints(documentation, process, activitySpecification, formButton);
        }
    }

    private void buildPoints(Documentation documentation, WorkflowProcess process, ActivitySpecification activitySpecification, FormButton formButton) {
        ButtonSpecification buttonSpecification = this.getButtonSpecification(activitySpecification, formButton);
        this.buildTitlePoint(documentation, formButton);
        if (StringUtils.isNotBlank((CharSequence)buttonSpecification.getDescription())) {
            this.buildDescriptionPoint(documentation, process, buttonSpecification);
        }
        if (StringUtils.isNotBlank((CharSequence)formButton.getHandler())) {
            this.buildActionPoint(documentation, formButton);
        }
        if (CollectionUtils.isNotEmpty(formButton.getFormActions())) {
            this.buildFormActionsPoint(documentation, process, formButton);
        }
        documentation.addNewLine();
    }

    private ButtonSpecification getButtonSpecification(ActivitySpecification activitySpecification, FormButton formButton) {
        String id = formButton.getActionName();
        if (MapUtils.isNotEmpty(activitySpecification.getButtonSpecifications()) && activitySpecification.getButtonSpecifications().containsKey(id)) {
            return activitySpecification.getButtonSpecifications().get(id);
        }
        return new ButtonSpecification();
    }

    private void buildTitlePoint(Documentation documentation, FormButton formButton) {
        this.buildPoint(documentation, formButton.getButtonName());
    }

    private void buildDescriptionPoint(Documentation documentation, WorkflowProcess process, ButtonSpecification buttonSpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, buttonSpecification.getDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(3));
        this.buildPoint(documentation, BUTTON_DESCRIPTION_POINT_TITLE, contents);
    }

    private void buildActionPoint(Documentation documentation, FormButton formButton) {
        this.buildPoint(documentation, ACTION_POINT_TITLE, formButton.getHandler());
    }

    private void buildFormActionsPoint(Documentation documentation, WorkflowProcess process, FormButton formButton) {
        this.formActionsIntegrationComponentsPointBuilder.build(documentation, process, formButton.getFormActions(), FORM_ACTIONS_POINT_TITLE, 3);
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, description);
    }

    private void buildPoint(Documentation documentation, String title) {
        this.subchapterBuilder.build(documentation, title, 2);
    }

    private void buildPoint(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, 3, contents);
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text, new LeftIndents(3));
    }
}

