/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.point.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.Table;
import com.suncode.plugin.pwe.documentation.TableHeaders;
import com.suncode.plugin.pwe.documentation.TableRecords;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.AcceptButtonActionsPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.IntegrationComponentsPointBuilder;
import com.suncode.plugin.pwe.documentation.object.AcceptButton;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.FormAction;
import com.suncode.plugin.pwe.documentation.paragraph.builder.SpecificationDescriptionParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ButtonSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.LeftIndents;
import com.suncode.plugin.pwe.documentation.util.ParagraphIndentsUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="activityAcceptButtonsPointBuilder")
public class ActivityAcceptButtonsPointBuilderImpl
implements ActivityPointBuilder {
    private static final String BUTTON_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.buttondescription";
    private static final String CHECK_FORM_POINT_TITLE = "pwe.documentation.point.title.checkform";
    private static final String YES = "pwe.documentation.text.yes";
    private static final String NO = "pwe.documentation.text.no";
    private static final String VARIABLE_VALUES_SETTING = "pwe.documentation.point.title.variablevaluessetting";
    private static final String FORM_ACTIONS_POINT_TITLE = "pwe.documentation.point.title.formactions";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private AcceptButtonActionsPointBuilder acceptButtonActionsPointBuilder;
    @Autowired
    private IntegrationComponentsPointBuilder<FormAction> formActionsIntegrationComponentsPointBuilder;
    @Autowired
    private SpecificationDescriptionParagraphContentsBuilder specificationDescriptionParagraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        for (AcceptButton acceptButton : activityForm.getAcceptButtons()) {
            this.buildPoints(documentation, process, activitySpecification, acceptButton);
        }
    }

    private void buildPoints(Documentation documentation, WorkflowProcess process, ActivitySpecification activitySpecification, AcceptButton acceptButton) {
        ButtonSpecification buttonSpecification = this.getButtonSpecification(activitySpecification, acceptButton);
        this.buildTitlePoint(documentation, acceptButton);
        if (StringUtils.isNotBlank((CharSequence)buttonSpecification.getDescription())) {
            this.buildDescriptionPoint(documentation, process, buttonSpecification);
        }
        this.buildCheckFormPoint(documentation, acceptButton);
        if (CollectionUtils.isNotEmpty(acceptButton.getActions())) {
            this.buildVariableValuesSettingPoint(documentation, process, acceptButton);
        }
        if (CollectionUtils.isNotEmpty(acceptButton.getFormActions())) {
            this.buildFormActionsPoint(documentation, process, acceptButton);
        }
        documentation.addNewLine();
    }

    private ButtonSpecification getButtonSpecification(ActivitySpecification activitySpecification, AcceptButton acceptButton) {
        String id = acceptButton.getActionName();
        if (MapUtils.isNotEmpty(activitySpecification.getButtonSpecifications()) && activitySpecification.getButtonSpecifications().containsKey(id)) {
            return activitySpecification.getButtonSpecifications().get(id);
        }
        return new ButtonSpecification();
    }

    private void buildTitlePoint(Documentation documentation, AcceptButton acceptButton) {
        this.buildPoint(documentation, acceptButton.getButtonName());
    }

    private void buildDescriptionPoint(Documentation documentation, WorkflowProcess process, ButtonSpecification buttonSpecification) {
        ParagraphContents contents = this.buildSpecificationDescriptionParagraphContents(process, buttonSpecification.getDescription());
        contents.setIndents(ParagraphIndentsUtils.buildLeft(3));
        this.buildPoint(documentation, BUTTON_DESCRIPTION_POINT_TITLE, contents);
    }

    private void buildCheckFormPoint(Documentation documentation, AcceptButton acceptButton) {
        String text = this.buildCheckForm(acceptButton);
        this.buildPoint(documentation, CHECK_FORM_POINT_TITLE, text);
    }

    private String buildCheckForm(AcceptButton acceptButton) {
        if (acceptButton.isCheckForm()) {
            return this.translatorService.translateMessage(YES);
        }
        return this.translatorService.translateMessage(NO);
    }

    private void buildVariableValuesSettingPoint(Documentation documentation, WorkflowProcess process, AcceptButton acceptButton) {
        Table table = this.acceptButtonActionsPointBuilder.build(process, acceptButton);
        this.buildPoint(documentation, VARIABLE_VALUES_SETTING, table.getHeaders(), table.getRecords());
    }

    private void buildFormActionsPoint(Documentation documentation, WorkflowProcess process, AcceptButton acceptButton) {
        this.formActionsIntegrationComponentsPointBuilder.build(documentation, process, acceptButton.getFormActions(), FORM_ACTIONS_POINT_TITLE, 3);
    }

    private ParagraphContents buildSpecificationDescriptionParagraphContents(WorkflowProcess process, String description) {
        return this.specificationDescriptionParagraphContentsBuilder.build(process, description);
    }

    private void buildPoint(Documentation documentation, String title) {
        this.buildPoint(documentation, title, 2);
    }

    private void buildPoint(Documentation documentation, String titleKey, ParagraphContents contents) {
        this.subchapterBuilder.build(documentation, titleKey, 3, contents);
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text, new LeftIndents(3));
    }

    private void buildPoint(Documentation documentation, String titleKey, TableHeaders headers, TableRecords records) {
        this.subchapterBuilder.build(documentation, titleKey, 3, headers, records);
    }

    private void buildPoint(Documentation documentation, String title, int leftIndents) {
        this.subchapterBuilder.build(documentation, title, leftIndents);
    }
}

