/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContent;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.DocumentLinkSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.documentation.util.TextValueUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="documentLinksListChapterBuilder")
public class DocumentLinksListChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.documentlinkslist";
    @Autowired
    private TranslatorService translatorService;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, processSpecification);
    }

    private void buildSubchapters(Documentation documentation, ProcessSpecification processSpecification) {
        List<DocumentLinkSpecification> documentLinkSpecifications = processSpecification.getDocumentLinkSpecifications();
        if (CollectionUtils.isNotEmpty(documentLinkSpecifications)) {
            Counter subchapterNo = new Counter(1);
            for (DocumentLinkSpecification documentLinkSpecification : documentLinkSpecifications) {
                this.buildSubchapter(documentation, documentLinkSpecification, subchapterNo.getCountAndIncrement());
            }
        }
    }

    private void buildSubchapter(Documentation documentation, DocumentLinkSpecification documentLinkSpecification, int subchapterNo) {
        String title = this.buildSubchapterTitle(documentLinkSpecification, subchapterNo);
        documentation.addSubchapter(title);
        if (StringUtils.isNotBlank((CharSequence)documentLinkSpecification.getDescription())) {
            this.buildDescription(documentation, documentLinkSpecification);
        }
    }

    private String buildSubchapterTitle(DocumentLinkSpecification documentLinkSpecification, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(documentLinkSpecification.getName());
        return title.toString();
    }

    private void buildDescription(Documentation documentation, DocumentLinkSpecification documentLinkSpecification) {
        documentation.addParagraph(this.buildDescriptionContents(documentLinkSpecification));
        documentation.addNewLine();
    }

    private ParagraphContents buildDescriptionContents(DocumentLinkSpecification documentLinkSpecification) {
        ParagraphContents contents = new ParagraphContents();
        contents.addContent(this.buildDescriptionContent(documentLinkSpecification));
        return contents;
    }

    private ParagraphContent buildDescriptionContent(DocumentLinkSpecification documentLinkSpecification) {
        ParagraphContent content = new ParagraphContent();
        content.setTextValue(TextValueUtils.build(documentLinkSpecification.getDescription()));
        return content;
    }
}

