/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.specification.DocumentClassSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.ParagraphContentUtils;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="documentClassesListChapterBuilder")
public class DocumentClassesListChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.documentclasseslist";
    @Autowired
    private TranslatorService translatorService;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildDocumentClassesList(documentation, processSpecification);
    }

    private void buildDocumentClassesList(Documentation documentation, ProcessSpecification processSpecification) {
        List<DocumentClassSpecification> documentClassSpecifications = processSpecification.getDocumentClassSpecifications();
        if (CollectionUtils.isNotEmpty(documentClassSpecifications)) {
            documentation.addNumberedList(this.buildSubPoints(documentClassSpecifications));
        }
    }

    private List<ParagraphContents> buildSubPoints(List<DocumentClassSpecification> documentClassSpecifications) {
        ArrayList<ParagraphContents> subPoints = new ArrayList<ParagraphContents>();
        for (DocumentClassSpecification documentClassSpecification : documentClassSpecifications) {
            subPoints.add(this.buildSubPoint(documentClassSpecification));
        }
        return subPoints;
    }

    private ParagraphContents buildSubPoint(DocumentClassSpecification documentClassSpecification) {
        String text = documentClassSpecification.getName();
        String bookmarkName = this.buildBookmarkName(documentClassSpecification);
        ParagraphContents paragraphContents = new ParagraphContents();
        paragraphContents.addContent(ParagraphContentUtils.build(text, bookmarkName));
        if (StringUtils.isNotBlank((CharSequence)documentClassSpecification.getDescription())) {
            paragraphContents.addContent(ParagraphContentUtils.build(" - " + documentClassSpecification.getDescription()));
        }
        return paragraphContents;
    }

    private String buildBookmarkName(DocumentClassSpecification documentClassSpecification) {
        return BookmarkNameUtils.getNameForDocumentClass(documentClassSpecification.getName());
    }
}

