/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pwe.documentation.chapter.builder;

import com.suncode.plugin.pwe.documentation.Documentation;
import com.suncode.plugin.pwe.documentation.NumberedPoint;
import com.suncode.plugin.pwe.documentation.NumberedPoints;
import com.suncode.plugin.pwe.documentation.ParagraphContents;
import com.suncode.plugin.pwe.documentation.chapter.builder.ChapterBuilder;
import com.suncode.plugin.pwe.documentation.chapter.point.builder.ActivityPointBuilder;
import com.suncode.plugin.pwe.documentation.object.ActivityForm;
import com.suncode.plugin.pwe.documentation.object.ToolParameter;
import com.suncode.plugin.pwe.documentation.object.ToolParameters;
import com.suncode.plugin.pwe.documentation.object.builder.ActivityFormBuilder;
import com.suncode.plugin.pwe.documentation.object.builder.ToolParametersBuilder;
import com.suncode.plugin.pwe.documentation.paragraph.builder.ParagraphContentsBuilder;
import com.suncode.plugin.pwe.documentation.specification.ActivitySpecification;
import com.suncode.plugin.pwe.documentation.specification.ApplicationSpecification;
import com.suncode.plugin.pwe.documentation.specification.ProcessSpecification;
import com.suncode.plugin.pwe.documentation.subchapter.builder.SubchapterBuilder;
import com.suncode.plugin.pwe.documentation.util.ActivityUtils;
import com.suncode.plugin.pwe.documentation.util.ApplicationUtils;
import com.suncode.plugin.pwe.documentation.util.BookmarkNameUtils;
import com.suncode.plugin.pwe.documentation.util.Counter;
import com.suncode.plugin.pwe.service.translator.TranslatorService;
import com.suncode.plugin.pwe.util.ExtAttrUtils;
import com.suncode.plugin.pwe.web.support.dto.documentationconfig.DocumentationConfigDto;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Implementation;
import org.enhydra.shark.xpdl.elements.Tool;
import org.enhydra.shark.xpdl.elements.Tools;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="automaticTasksChapterBuilder")
public class AutomaticTasksChapterBuilderImpl
implements ChapterBuilder {
    private static final String CHAPTER_TITLE = "pwe.documentation.chapter.title.automatictasks";
    private static final String INPUT_PARAMETERS_POINT_TITLE = "pwe.documentation.point.title.inputparameters";
    private static final String NO_INPUT_PARAMETERS = "pwe.documentation.text.noinputparameters";
    private static final String OUTPUT_PARAMETERS_POINT_TITLE = "pwe.documentation.point.title.outputparameters";
    private static final String NO_OUTPUT_PARAMETERS = "pwe.documentation.text.nooutputparameters";
    private static final String EXECUTED_CLASS_SCRIPT_POINT_TITLE = "pwe.documentation.point.title.executedclassscript";
    private static final String APP_NAME_EXT_ATTR_NAME = "AppName";
    private static final String SCRIPT_EXT_ATTR_NAME = "Script";
    private static final String ALGORITHM_DESCRIPTION_POINT_TITLE = "pwe.documentation.point.title.algorithmdescription";
    private static final String NO_APPLICATIONS = "pwe.documentation.text.noapplications";
    @Autowired
    private TranslatorService translatorService;
    @Autowired
    private ToolParametersBuilder toolParametersBuilder;
    @Autowired
    private ActivityFormBuilder activityFormBuilder;
    @Autowired
    @Qualifier(value="activityGeneralDescriptionPointBuilder")
    private ActivityPointBuilder activityGeneralDescriptionPointBuilder;
    @Autowired
    @Qualifier(value="activityGeneratedDocumentsPointBuilder")
    private ActivityPointBuilder activityGeneratedDocumentsPointBuilder;
    @Autowired
    @Qualifier(value="activityTransitionsPointBuilder")
    private ActivityPointBuilder activityTransitionsPointBuilder;
    @Autowired
    private ParagraphContentsBuilder paragraphContentsBuilder;
    @Autowired
    private SubchapterBuilder subchapterBuilder;

    @Override
    public void build(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, DocumentationConfigDto documentationConfig) {
        documentation.addChapter(this.translatorService.translateDocumentationChapterTitle(CHAPTER_TITLE));
        this.buildSubchapters(documentation, process, processSpecification);
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification) {
        Activities activities = process.getActivities();
        if (!activities.isEmpty()) {
            Counter subchapterNo = new Counter(1);
            for (int i = 0; i < activities.size(); ++i) {
                Activity activity = (Activity)activities.get(i);
                if (!ActivityUtils.isTool(process, activity)) continue;
                this.buildSubchapter(documentation, process, processSpecification, activity, subchapterNo);
            }
        }
    }

    private void buildSubchapter(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, Activity activity, Counter subchapterNo) {
        Implementation implementation = (Implementation)activity.getActivityTypes().getChoosen();
        XMLElement implementationType = implementation.getImplementationTypes().getChoosen();
        if (this.shouldBuildSubchapters(implementationType)) {
            Tools tools = (Tools)implementationType;
            this.buildSubchapters(documentation, process, processSpecification, activity, tools, subchapterNo);
        } else {
            this.addSubchapter(documentation, activity, subchapterNo);
        }
    }

    private boolean shouldBuildSubchapters(XMLElement implementationType) {
        return implementationType instanceof Tools && !((Tools)implementationType).isEmpty();
    }

    private void buildSubchapters(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, Activity activity, Tools tools, Counter subchapterNo) {
        for (int i = 0; i < tools.size(); ++i) {
            Tool tool = (Tool)tools.get(i);
            this.buildSubchapter(documentation, process, processSpecification, activity, tool, subchapterNo);
        }
    }

    private void buildSubchapter(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, Activity activity, Tool tool, Counter subchapterNo) {
        Application application = this.getApplication(process, tool);
        String title = this.buildSubchapterTitle(activity, application, subchapterNo.getCountAndIncrement());
        String bookmarkName = this.buildBookmarkName(activity);
        ToolParameters toolParameters = this.buildToolParameters(process, application, tool);
        ApplicationSpecification applicationSpecification = this.getApplicationSpecification(processSpecification, application);
        ActivitySpecification activitySpecification = this.getActivitySpecification(activity, processSpecification);
        ActivityForm activityForm = this.buildActivityForm(process, activity);
        documentation.addBookmarkedSubchapter(title, bookmarkName);
        this.buildGeneralActivityDescriptionPoint(documentation, process, activity, activitySpecification, activityForm);
        this.buildInputParametersPoint(documentation, process, toolParameters);
        this.buildOutputParametersPoint(documentation, process, toolParameters);
        this.buildGeneratedDocumentsPoint(documentation, process, activity, activitySpecification, activityForm);
        this.buildExecutorPoint(documentation, application);
        this.buildAlgorithmDescriptionPoint(documentation, applicationSpecification);
        this.buildTransitionsPoint(documentation, process, processSpecification, activity, activitySpecification, activityForm);
        documentation.addNewLine();
    }

    private Application getApplication(WorkflowProcess process, Tool tool) {
        return ApplicationUtils.getApplication(tool.getId(), process);
    }

    private String buildSubchapterTitle(Activity activity, Application application, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(activity.getName());
        title.append(" - ");
        title.append(application.getName());
        return title.toString();
    }

    private String buildBookmarkName(Activity activity) {
        return BookmarkNameUtils.getNameForActivity(activity.getId());
    }

    private ToolParameters buildToolParameters(WorkflowProcess process, Application application, Tool tool) {
        return this.toolParametersBuilder.build(process, application, tool);
    }

    private ApplicationSpecification getApplicationSpecification(ProcessSpecification processSpecification, Application application) {
        String id = application.getId();
        if (MapUtils.isNotEmpty(processSpecification.getApplicationSpecifications()) && processSpecification.getApplicationSpecifications().containsKey(id)) {
            return processSpecification.getApplicationSpecifications().get(id);
        }
        return new ApplicationSpecification();
    }

    private ActivitySpecification getActivitySpecification(Activity activity, ProcessSpecification processSpecification) {
        String activityDefId = activity.getId();
        if (MapUtils.isNotEmpty(processSpecification.getActivitySpecifications()) && processSpecification.getActivitySpecifications().containsKey(activityDefId)) {
            return processSpecification.getActivitySpecifications().get(activityDefId);
        }
        return new ActivitySpecification();
    }

    private ActivityForm buildActivityForm(WorkflowProcess process, Activity activity) {
        return this.activityFormBuilder.build(process, activity);
    }

    private void buildGeneralActivityDescriptionPoint(Documentation documentation, WorkflowProcess process, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        this.activityGeneralDescriptionPointBuilder.build(documentation, process, activity, activitySpecification, activityForm);
    }

    private void buildInputParametersPoint(Documentation documentation, WorkflowProcess process, ToolParameters toolParameters) {
        this.buildParametersPoint(documentation, process, INPUT_PARAMETERS_POINT_TITLE, NO_INPUT_PARAMETERS, toolParameters.getInputParameters());
    }

    private void buildOutputParametersPoint(Documentation documentation, WorkflowProcess process, ToolParameters toolParameters) {
        this.buildParametersPoint(documentation, process, OUTPUT_PARAMETERS_POINT_TITLE, NO_OUTPUT_PARAMETERS, toolParameters.getOutputParameters());
    }

    private void buildParametersPoint(Documentation documentation, WorkflowProcess process, String titleKey, String noParametersKey, List<ToolParameter> parameters) {
        if (CollectionUtils.isNotEmpty(parameters)) {
            NumberedPoints points = this.buildParametersNumberedPoints(process, titleKey, parameters);
            this.buildPoint(documentation, points);
        } else {
            this.buildPoint(documentation, titleKey, this.translatorService.translateMessage(noParametersKey));
        }
    }

    private NumberedPoints buildParametersNumberedPoints(WorkflowProcess process, String titleKey, List<ToolParameter> parameters) {
        NumberedPoints points = new NumberedPoints();
        points.addPoint(this.buildNumberedPoint(process, titleKey, this.buildParametersIds(parameters)));
        return points;
    }

    private List<String> buildParametersIds(List<ToolParameter> parameters) {
        ArrayList<String> ids = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(parameters)) {
            for (ToolParameter parameter : parameters) {
                ids.add(parameter.getId());
            }
        }
        return ids;
    }

    private NumberedPoint buildNumberedPoint(WorkflowProcess process, String titleKey, List<String> values) {
        NumberedPoint point = new NumberedPoint();
        point.setTitle(this.translatorService.translateMessage(titleKey));
        point.setSubPoints(this.buildSubPoints(process, values));
        return point;
    }

    private List<ParagraphContents> buildSubPoints(WorkflowProcess process, List<String> values) {
        return this.paragraphContentsBuilder.build(process, values);
    }

    private void buildGeneratedDocumentsPoint(Documentation documentation, WorkflowProcess process, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        this.activityGeneratedDocumentsPointBuilder.build(documentation, process, activity, activitySpecification, activityForm);
    }

    private void buildExecutorPoint(Documentation documentation, Application application) {
        String text = this.buildExecutor(application);
        this.buildPoint(documentation, EXECUTED_CLASS_SCRIPT_POINT_TITLE, text);
    }

    private String buildExecutor(Application application) {
        ExtendedAttributes extAttrs = application.getExtendedAttributes();
        if (ExtAttrUtils.hasExtAttr(extAttrs, APP_NAME_EXT_ATTR_NAME)) {
            return ExtAttrUtils.getExtAttrValue(extAttrs, APP_NAME_EXT_ATTR_NAME);
        }
        if (ExtAttrUtils.hasExtAttr(extAttrs, SCRIPT_EXT_ATTR_NAME)) {
            return ExtAttrUtils.getExtAttrValue(extAttrs, SCRIPT_EXT_ATTR_NAME);
        }
        return "";
    }

    private void buildAlgorithmDescriptionPoint(Documentation documentation, ApplicationSpecification applicationSpecification) {
        this.buildPoint(documentation, ALGORITHM_DESCRIPTION_POINT_TITLE, applicationSpecification.getDescription());
    }

    private void buildTransitionsPoint(Documentation documentation, WorkflowProcess process, ProcessSpecification processSpecification, Activity activity, ActivitySpecification activitySpecification, ActivityForm activityForm) {
        this.activityTransitionsPointBuilder.build(documentation, process, activity, activitySpecification, activityForm);
    }

    private void addSubchapter(Documentation documentation, Activity activity, Counter subchapterNo) {
        String title = this.buildSubchapterTitle(activity, subchapterNo.getCountAndIncrement());
        String bookmarkName = this.buildBookmarkName(activity);
        documentation.addBookmarkedSubchapter(title, bookmarkName);
        this.buildNoApplicationsPoint(documentation);
        documentation.addNewLine();
    }

    private String buildSubchapterTitle(Activity activity, int subchapterNo) {
        StringBuilder title = new StringBuilder();
        title.append(subchapterNo);
        title.append(". ");
        title.append(activity.getName());
        return title.toString();
    }

    private void buildNoApplicationsPoint(Documentation documentation) {
        String title = this.buildNoApplicationsPointTitle();
        this.buildPoint(documentation, title);
    }

    private String buildNoApplicationsPointTitle() {
        return this.translatorService.translateMessage(NO_APPLICATIONS);
    }

    private void buildPoint(Documentation documentation, NumberedPoints points) {
        this.subchapterBuilder.build(documentation, points);
    }

    private void buildPoint(Documentation documentation, String titleKey, String text) {
        this.subchapterBuilder.build(documentation, titleKey, text);
    }

    private void buildPoint(Documentation documentation, String title) {
        this.subchapterBuilder.build(documentation, title, 1);
    }
}

